/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.photon.OS;
import org.eclipse.swt.internal.photon.PtFileSelectionInfo_t;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Shell;

public class FileDialog
extends Dialog {
    String[] filterNames = new String[0];
    String[] filterExtensions = new String[0];
    String filterPath = "";
    String fileName = "";
    int filterIndex = -1;
    boolean overwrite = false;
    static final String FILTER = "*";

    public FileDialog(Shell parent) {
        this(parent, 65536);
    }

    public FileDialog(Shell parent, int style) {
        super(parent, FileDialog.checkStyle(parent, style));
        this.checkSubclass();
    }

    public String getFileName() {
        return this.fileName;
    }

    public String[] getFileNames() {
        if (this.fileName.length() == 0) {
            return new String[0];
        }
        return new String[]{this.fileName};
    }

    public String[] getFilterExtensions() {
        return this.filterExtensions;
    }

    public int getFilterIndex() {
        return this.filterIndex;
    }

    public String[] getFilterNames() {
        return this.filterNames;
    }

    public String getFilterPath() {
        return this.filterPath;
    }

    public boolean getOverwrite() {
        return this.overwrite;
    }

    public String open() {
        int parentHandle = 0;
        if (this.parent != null && OS.PtWidgetIsRealized(this.parent.shellHandle)) {
            parentHandle = this.parent.shellHandle;
        }
        byte[] title = null;
        if (this.title != null) {
            title = Converter.wcsToMbcs(null, this.title, true);
        }
        byte[] root_dir = null;
        if (this.filterPath != null) {
            root_dir = Converter.wcsToMbcs(null, this.filterPath, true);
        }
        String mask = FILTER;
        if (this.filterNames == null) {
            this.filterNames = new String[0];
        }
        if (this.filterExtensions == null) {
            this.filterExtensions = new String[0];
        }
        if (this.filterExtensions.length > 0) {
            String comma;
            mask = comma = ",";
            int i = 0;
            while (i < this.filterExtensions.length) {
                int end;
                String ext = this.filterExtensions[i];
                int length = ext.length();
                int start = 0;
                do {
                    String subExt;
                    if ((end = ext.indexOf(59, start)) < 0) {
                        end = length;
                    }
                    if ((subExt = ext.substring(start, end).trim()).length() > 0) {
                        subExt = String.valueOf(subExt) + comma;
                        if (mask.indexOf(String.valueOf(comma) + subExt) == -1) {
                            mask = String.valueOf(mask) + subExt;
                        }
                    }
                    start = end + 1;
                } while (end < length);
                ++i;
            }
            mask = mask.substring(1, Math.max(1, mask.length() - 1));
        }
        byte[] file_spec = Converter.wcsToMbcs(null, mask, true);
        byte[] btn1_text = null;
        if ((this.style & 0x2000) != 0) {
            btn1_text = Converter.wcsToMbcs(null, SWT.getMessage("SWT_Save"), true);
        }
        int flags = 256;
        PtFileSelectionInfo_t info = new PtFileSelectionInfo_t();
        OS.PtFileSelection(parentHandle, null, title, root_dir, file_spec, btn1_text, null, null, info, flags);
        if (info.ret == 2) {
            return null;
        }
        int length = 0;
        while (length < info.path.length && info.path[length] != 0) {
            ++length;
        }
        byte[] path = new byte[length];
        System.arraycopy(info.path, 0, path, 0, length);
        String fullPath = new String(Converter.mbcsToWcs(null, path));
        length = fullPath.length();
        if (length != 0) {
            int index = length - 1;
            while (index >= 0 && fullPath.charAt(index) != '/') {
                --index;
            }
            this.fileName = fullPath.substring(index + 1, length);
            this.filterPath = fullPath.substring(0, index);
            this.filterIndex = this.filterExtensions == null || this.filterExtensions.length == 0 ? -1 : 0;
        }
        return fullPath;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public void setFilterExtensions(String[] extensions) {
        this.filterExtensions = extensions;
    }

    public void setFilterIndex(int index) {
        this.filterIndex = index;
    }

    public void setFilterNames(String[] names) {
        this.filterNames = names;
    }

    public void setFilterPath(String string) {
        this.filterPath = string;
    }

    public void setOverwrite(boolean overwrite) {
    }
}

