/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.photon.OS;
import org.eclipse.swt.internal.photon.PhArea_t;
import org.eclipse.swt.internal.photon.PhDim_t;
import org.eclipse.swt.internal.photon.PhKeyEvent_t;
import org.eclipse.swt.internal.photon.PhRect_t;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class Label
extends Control {
    String text = "";
    Image image;

    public Label(Composite parent, int style) {
        super(parent, Label.checkStyle(style));
    }

    static int checkStyle(int style) {
        if (((style |= 0x80000) & 2) != 0) {
            style = Label.checkBits(style, 512, 256, 0, 0, 0, 0);
            return Label.checkBits(style, 8, 4, 32, 0, 0, 0);
        }
        return Label.checkBits(style, 16384, 0x1000000, 131072, 0, 0, 0);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            int border = this.getBorderWidth();
            int width = border * 2;
            int height = border * 2;
            if ((this.style & 0x100) != 0) {
                width += 64;
                height += 3;
            } else {
                width += 3;
                height += 64;
            }
            if (wHint != -1) {
                width = wHint + border * 2;
            }
            if (hHint != -1) {
                height = hHint + border * 2;
            }
            return new Point(width, height);
        }
        if ((this.style & 0x40) != 0) {
            int[] nArray = new int[27];
            nArray[0] = 3003;
            nArray[3] = 3010;
            nArray[6] = 3021;
            nArray[9] = 2005;
            nArray[12] = 2004;
            nArray[15] = 3005;
            nArray[18] = 3006;
            nArray[21] = 3007;
            nArray[24] = 3004;
            int[] args = nArray;
            OS.PtGetResources(this.handle, args.length / 3, args);
            if (args[1] == 1) {
                int width = wHint;
                int height = hHint;
                if (wHint == -1 || hHint == -1) {
                    int length = OS.strlen(args[4]);
                    byte[] font = new byte[length + 1];
                    OS.memmove(font, args[4], length);
                    String string = this.text;
                    if (wHint != -1) {
                        string = this.display.wrapText(this.text, font, wHint);
                    }
                    byte[] buffer = Converter.wcsToMbcs(null, string, false);
                    PhRect_t rect = new PhRect_t();
                    OS.PgExtentMultiText(rect, null, font, buffer, buffer.length, args[7]);
                    if (wHint == -1) {
                        width = rect.lr_x - rect.ul_x + 1;
                    }
                    if (hHint == -1) {
                        height = rect.lr_y - rect.ul_y + 1;
                    }
                }
                PhArea_t area = new PhArea_t();
                PhRect_t rect = new PhRect_t();
                OS.PtSetAreaFromWidgetCanvas(this.handle, rect, area);
                return new Point(width += area.size_w - 1 + args[10] * 2 + args[16] + args[19], height += area.size_h - 1 + args[13] * 2 + args[22] + args[25]);
            }
        }
        PhDim_t dim = new PhDim_t();
        if (!OS.PtWidgetIsRealized(this.handle)) {
            OS.PtExtentWidget(this.handle);
        }
        OS.PtWidgetPreferredSize(this.handle, dim);
        int width = dim.w;
        int height = dim.h;
        if (wHint != -1 || hHint != -1) {
            int[] nArray = new int[18];
            nArray[0] = 2005;
            nArray[3] = 2004;
            nArray[6] = 3005;
            nArray[9] = 3006;
            nArray[12] = 3007;
            nArray[15] = 3004;
            int[] args = nArray;
            OS.PtGetResources(this.handle, args.length / 3, args);
            PhRect_t rect = new PhRect_t();
            PhArea_t area = new PhArea_t();
            rect.lr_x = (short)(wHint - 1);
            rect.lr_y = (short)(hHint - 1);
            OS.PtSetAreaFromWidgetCanvas(this.handle, rect, area);
            if (wHint != -1) {
                width = area.size_w + args[1] * 2 + args[7] + args[10];
            }
            if (hHint != -1) {
                height = area.size_h + args[4] * 2 + args[13] + args[16];
            }
        }
        return new Point(width, height);
    }

    void createHandle(int index) {
        this.state |= 8;
        int parentHandle = this.parent.parentingHandle();
        if ((this.style & 2) != 0) {
            int clazz = this.display.PtSeparator;
            int orientation = (this.style & 0x100) != 0 ? 1 : 0;
            int type = 4;
            if ((this.style & 8) != 0) {
                type = 5;
            }
            int[] nArray = new int[12];
            nArray[0] = 30000;
            nArray[1] = orientation;
            nArray[2] = 1;
            nArray[3] = 30002;
            nArray[4] = type;
            nArray[6] = 2002;
            nArray[7] = this.display.WIDGET_BACKGROUND;
            nArray[9] = 1008;
            nArray[11] = 0x3F00000;
            int[] args = nArray;
            this.handle = OS.PtCreateWidget(clazz, parentHandle, args.length / 3, args);
            if (this.handle == 0) {
                Label.error(2);
            }
            return;
        }
        int clazz = this.display.PtLabel;
        int alignment = 0;
        if ((this.style & 0x1000000) != 0) {
            alignment = 2;
        }
        if ((this.style & 0x20000) != 0) {
            alignment = 1;
        }
        int verticalAlign = (this.style & 0x40) != 0 ? 0 : 2;
        boolean hasBorder = (this.style & 0x800) != 0;
        int[] nArray = new int[15];
        nArray[0] = 1006;
        nArray[1] = hasBorder ? 256 : 0;
        nArray[2] = 256;
        nArray[3] = 3000;
        nArray[4] = alignment;
        nArray[6] = 3015;
        nArray[7] = verticalAlign;
        nArray[9] = 2002;
        nArray[10] = this.display.WIDGET_BACKGROUND;
        nArray[12] = 1008;
        nArray[14] = 0x3F00000;
        int[] args = nArray;
        this.handle = OS.PtCreateWidget(clazz, parentHandle, args.length / 3, args);
        if (this.handle == 0) {
            Label.error(2);
        }
    }

    public int getAlignment() {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return 0;
        }
        if ((this.style & 0x4000) != 0) {
            return 16384;
        }
        if ((this.style & 0x1000000) != 0) {
            return 0x1000000;
        }
        if ((this.style & 0x20000) != 0) {
            return 131072;
        }
        return 16384;
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    String getNameText() {
        return this.getText();
    }

    public String getText() {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return "";
        }
        return this.text;
    }

    int hotkeyProc(int widget, int data, int info) {
        Composite control = this.parent;
        while (control != null) {
            Control[] children = control._getChildren();
            int index = 0;
            while (index < children.length) {
                if (children[index] == this) break;
                ++index;
            }
            if (++index < children.length && children[index].setFocus()) {
                return 0;
            }
            control = control.parent;
        }
        return 0;
    }

    void releaseWidget() {
        super.releaseWidget();
        this.image = null;
        this.text = null;
    }

    public void setAlignment(int alignment) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        if ((alignment & 0x1024000) == 0) {
            return;
        }
        this.style &= 0xFEFDBFFF;
        this.style |= alignment & 0x1024000;
        int align = 0;
        if ((this.style & 0x1000000) != 0) {
            align = 2;
        }
        if ((this.style & 0x20000) != 0) {
            align = 1;
        }
        OS.PtSetResource(this.handle, 3000, align, 0);
    }

    int setBounds(int x, int y, int width, int height, boolean move, boolean resize, boolean events) {
        int result = super.setBounds(x, y, width, height, move, resize, events);
        if ((result & 0x40) != 0 && (this.style & 0x40) != 0) {
            this.setText(this.text);
        }
        return result;
    }

    public void setFont(Font font) {
        super.setFont(font);
        if ((this.style & 0x40) != 0) {
            this.setText(this.text);
        }
    }

    public void setImage(Image image) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        this.image = image;
        int imageHandle = 0;
        if (image != null) {
            if (image.isDisposed()) {
                Label.error(5);
            }
            imageHandle = this.copyPhImage(image.handle);
        }
        int[] nArray = new int[6];
        nArray[0] = 3001;
        nArray[1] = imageHandle;
        nArray[3] = 3003;
        nArray[4] = 4;
        int[] args = nArray;
        OS.PtSetResources(this.handle, args.length / 3, args);
        if (imageHandle != 0) {
            OS.free(imageHandle);
        }
    }

    public void setText(String string) {
        byte[] buffer;
        this.checkWidget();
        if (string == null) {
            Label.error(4);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        this.text = string;
        char[] text = new char[string.length()];
        string.getChars(0, text.length, text, 0);
        char mnemonic = this.fixMnemonic(text);
        if ((this.style & 0x40) != 0) {
            int[] nArray = new int[15];
            nArray[0] = 3010;
            nArray[3] = 1023;
            nArray[6] = 2005;
            nArray[9] = 3005;
            nArray[12] = 3006;
            int[] args = nArray;
            OS.PtGetResources(this.handle, args.length / 3, args);
            int length = OS.strlen(args[1]);
            byte[] font = new byte[length + 1];
            OS.memmove(font, args[1], length);
            int border = 0;
            if ((this.style & 0x800) != 0) {
                border = 2;
            }
            int width = args[4];
            string = this.display.wrapText(new String(text), font, width -= args[7] * 2 + args[10] + args[13] + border * 2);
            buffer = Converter.wcsToMbcs(null, string, true);
        } else {
            buffer = Converter.wcsToMbcs(null, text, true);
        }
        int ptr1 = OS.malloc(buffer.length);
        OS.memmove(ptr1, buffer, buffer.length);
        int ptr2 = 0;
        if (mnemonic != '\u0000') {
            byte[] buffer2 = Converter.wcsToMbcs(null, new char[]{mnemonic}, true);
            ptr2 = OS.malloc(buffer2.length);
            OS.memmove(ptr2, buffer2, buffer2.length);
        }
        this.replaceMnemonic(mnemonic, true, true);
        int[] nArray = new int[9];
        nArray[0] = 3011;
        nArray[1] = ptr1;
        nArray[3] = 3003;
        nArray[4] = 1;
        nArray[6] = 3018;
        nArray[7] = ptr2;
        int[] args = nArray;
        OS.PtSetResources(this.handle, args.length / 3, args);
        OS.free(ptr1);
        OS.free(ptr2);
    }

    int traversalCode(int key_sym, PhKeyEvent_t ke) {
        return 0;
    }

    int widgetClass() {
        if ((this.style & 2) != 0) {
            return OS.PtSeparator();
        }
        return OS.PtLabel();
    }
}

