/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.e4.compatibility;

import java.util.Iterator;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.EditorActionBars;
import org.eclipse.ui.internal.EditorReference;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPartReference;
import org.eclipse.ui.internal.e4.compatibility.CompatibilityPart;
import org.eclipse.ui.internal.registry.EditorDescriptor;

public class CompatibilityEditor
extends CompatibilityPart {
    private EditorReference reference;

    @Inject
    CompatibilityEditor(MPart part, EditorReference ref) {
        super(part);
        this.reference = ref;
        if (!part.getTags().contains("removeOnHide")) {
            part.getTags().add("removeOnHide");
        }
    }

    protected void createPartControl(IWorkbenchPart legacyPart, Composite parent) {
        String iconURI;
        IConfigurationElement element;
        super.createPartControl(legacyPart, parent);
        EditorDescriptor descriptor = this.reference.getDescriptor();
        if (descriptor != null && (element = descriptor.getConfigurationElement()) != null && (iconURI = element.getAttribute("icon")) != null) {
            StringBuilder builder = new StringBuilder("platform:/plugin/");
            builder.append(element.getNamespaceIdentifier()).append('/');
            if (iconURI.startsWith("$nl$")) {
                iconURI = iconURI.substring(4);
            }
            builder.append(iconURI);
            this.part.setIconURI(builder.toString());
        }
    }

    public IEditorPart getEditor() {
        return (IEditorPart)this.getPart();
    }

    public WorkbenchPartReference getReference() {
        return this.reference;
    }

    @PreDestroy
    void preDestroy() {
        WorkbenchPartReference reference = this.getReference();
        WorkbenchPage page = (WorkbenchPage)reference.getPage();
        Iterator<EditorReference> it = page.getInternalEditorReferences().iterator();
        while (it.hasNext()) {
            IEditorReference ref = it.next();
            if (ref != reference) continue;
            it.remove();
        }
    }

    void disposeSite() {
        EditorActionBars bars = (EditorActionBars)((IEditorSite)((Object)this.getReference().getSite())).getActionBars();
        EditorReference.disposeEditorActionBars(bars);
        super.disposeSite();
    }
}

