/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.util.ULocale;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Locale;

public class MessageFormat
extends Format {
    static final long serialVersionUID = 1L;
    public final java.text.MessageFormat messageFormat;
    private static Object sfsbai;
    private static Object sfbai;
    private static Object gfbai;
    private static final Object missing;
    private static final char SINGLE_QUOTE = '\'';
    private static final char CURLY_BRACE_LEFT = '{';
    private static final char CURLY_BRACE_RIGHT = '}';
    private static final int STATE_INITIAL = 0;
    private static final int STATE_SINGLE_QUOTE = 1;
    private static final int STATE_IN_QUOTE = 2;
    private static final int STATE_MSG_ELEMENT = 3;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        missing = new Object();
    }

    public MessageFormat(java.text.MessageFormat delegate) {
        this.messageFormat = delegate;
    }

    public MessageFormat(String pattern) {
        this(new java.text.MessageFormat(pattern));
    }

    public MessageFormat(String pattern, Locale locale) {
        this(new java.text.MessageFormat(pattern));
    }

    public MessageFormat(String pattern, ULocale locale) {
        this(pattern);
    }

    public void setLocale(Locale locale) {
        this.messageFormat.setLocale(locale);
    }

    public void setLocale(ULocale locale) {
        this.messageFormat.setLocale(locale.toLocale());
    }

    public Locale getLocale() {
        return this.messageFormat.getLocale();
    }

    public ULocale getULocale() {
        return ULocale.forLocale(this.messageFormat.getLocale());
    }

    public void applyPattern(String pattern) {
        this.messageFormat.applyPattern(pattern);
    }

    public String toPattern() {
        return this.messageFormat.toPattern();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFormatsByArgumentIndex(Format[] newFormats) {
        if (sfsbai == null) {
            Object object = missing;
            synchronized (object) {
                try {
                    Class[] classArray = new Class[1];
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("[Ljava.text.Format;");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    classArray[0] = clazz;
                    Class[] params = classArray;
                    Class<?> clazz2 = class$1;
                    if (clazz2 == null) {
                        try {
                            clazz2 = class$1 = Class.forName("java.text.MessageFormat");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    sfsbai = clazz2.getMethod("setFormatsByArgumentIndex", params);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    sfsbai = missing;
                }
            }
        }
        if (sfsbai != missing) {
            try {
                Format[] unwrapped = new Format[newFormats.length];
                int i = 0;
                while (i < newFormats.length) {
                    unwrapped[i] = MessageFormat.unwrap(newFormats[i]);
                    ++i;
                }
                Object[] args = new Object[]{unwrapped};
                ((Method)sfsbai).invoke((Object)this.messageFormat, args);
                return;
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        }
        throw new UnsupportedOperationException();
    }

    public void setFormats(Format[] newFormats) {
        this.messageFormat.setFormats(newFormats);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFormatByArgumentIndex(int argumentIndex, Format newFormat) {
        if (sfbai == null) {
            Object object = missing;
            synchronized (object) {
                try {
                    Class[] classArray = new Class[2];
                    classArray[0] = Integer.TYPE;
                    Class<?> clazz = class$2;
                    if (clazz == null) {
                        try {
                            clazz = class$2 = Class.forName("java.text.Format");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    classArray[1] = clazz;
                    Class[] params = classArray;
                    Class<?> clazz2 = class$1;
                    if (clazz2 == null) {
                        try {
                            clazz2 = class$1 = Class.forName("java.text.MessageFormat");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    sfbai = clazz2.getMethod("setFormatByArgumentIndex", params);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    sfbai = missing;
                }
            }
        }
        if (sfbai != missing) {
            try {
                Object[] args = new Object[]{new Integer(argumentIndex), newFormat};
                ((Method)sfbai).invoke((Object)this.messageFormat, args);
                return;
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        }
        throw new UnsupportedOperationException();
    }

    public void setFormat(int formatElementIndex, Format newFormat) {
        this.messageFormat.setFormat(formatElementIndex, MessageFormat.unwrap(newFormat));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Format[] getFormatsByArgumentIndex() {
        if (gfbai == null) {
            Object object = missing;
            synchronized (object) {
                try {
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = class$1 = Class.forName("java.text.MessageFormat");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    gfbai = clazz.getMethod("getFormatsByArgumentIndex", null);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    gfbai = missing;
                }
            }
        }
        if (gfbai != missing) {
            try {
                Format[] result = (Format[])((Method)gfbai).invoke((Object)this.messageFormat, null);
                int i = 0;
                while (i < result.length) {
                    result[i] = MessageFormat.wrap(result[i]);
                    ++i;
                }
                return result;
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        }
        throw new UnsupportedOperationException();
    }

    public Format[] getFormats() {
        Format[] result = this.messageFormat.getFormats();
        int i = 0;
        while (i < result.length) {
            result[i] = MessageFormat.wrap(result[i]);
            ++i;
        }
        return result;
    }

    public final StringBuffer format(Object[] arguments, StringBuffer result, FieldPosition pos) {
        return this.messageFormat.format(arguments, result, pos);
    }

    public static String format(String pattern, Object[] arguments) {
        return java.text.MessageFormat.format(pattern, arguments);
    }

    public final StringBuffer format(Object arguments, StringBuffer result, FieldPosition pos) {
        return this.messageFormat.format(arguments, result, pos);
    }

    public Object[] parse(String source, ParsePosition pos) {
        return this.messageFormat.parse(source, pos);
    }

    public Object[] parse(String source) throws ParseException {
        return this.messageFormat.parse(source);
    }

    public Object parseObject(String source, ParsePosition pos) {
        return this.messageFormat.parse(source, pos);
    }

    public static String autoQuoteApostrophe(String pattern) {
        StringBuffer buf = new StringBuffer(pattern.length() * 2);
        int state = 0;
        int braceCount = 0;
        int i = 0;
        int j = pattern.length();
        while (i < j) {
            char c = pattern.charAt(i);
            block0 : switch (state) {
                case 0: {
                    switch (c) {
                        case '\'': {
                            state = 1;
                            break;
                        }
                        case '{': {
                            state = 3;
                            ++braceCount;
                        }
                    }
                    break;
                }
                case 1: {
                    switch (c) {
                        case '\'': {
                            state = 0;
                            break block0;
                        }
                        case '{': 
                        case '}': {
                            state = 2;
                            break block0;
                        }
                    }
                    buf.append('\'');
                    state = 0;
                    break;
                }
                case 2: {
                    switch (c) {
                        case '\'': {
                            state = 0;
                        }
                    }
                    break;
                }
                case 3: {
                    switch (c) {
                        case '{': {
                            ++braceCount;
                            break;
                        }
                        case '}': {
                            if (--braceCount != 0) break;
                            state = 0;
                        }
                    }
                    break;
                }
            }
            buf.append(c);
            ++i;
        }
        if (state == 1 || state == 2) {
            buf.append('\'');
        }
        return new String(buf);
    }

    public Object clone() {
        return new MessageFormat((java.text.MessageFormat)this.messageFormat.clone());
    }

    public boolean equals(Object obj) {
        try {
            return this.messageFormat.equals(((MessageFormat)obj).messageFormat);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public int hashCode() {
        return this.messageFormat.hashCode();
    }

    public String toString() {
        return this.messageFormat.toPattern();
    }

    private static Format unwrap(Format f) {
        if (f instanceof DateFormat) {
            return ((DateFormat)f).dateFormat;
        }
        if (f instanceof NumberFormat) {
            return ((NumberFormat)f).numberFormat;
        }
        if (f instanceof MessageFormat) {
            return ((MessageFormat)f).messageFormat;
        }
        return f;
    }

    private static Format wrap(Format f) {
        if (f instanceof java.text.DateFormat) {
            return new DateFormat((java.text.DateFormat)f);
        }
        if (f instanceof java.text.DecimalFormat) {
            return new DecimalFormat((java.text.DecimalFormat)f);
        }
        if (f instanceof java.text.MessageFormat) {
            return new MessageFormat((java.text.MessageFormat)f);
        }
        return f;
    }
}

