/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.bind;

import java.io.PrintStream;
import java.io.PrintWriter;

public class JAXBException
extends Exception {
    private String errorCode;
    private Throwable linkedException;

    public JAXBException(String pMessage) {
        super(pMessage);
    }

    private static String formatMessage(String pErrorCode, String pMessage, Throwable pThr) {
        String msg = null;
        if (pMessage == null) {
            if (pThr != null && (msg = pThr.getMessage()) == null) {
                msg = pThr.getClass().getName();
            }
        } else {
            msg = pMessage;
        }
        if (pErrorCode == null) {
            return msg;
        }
        if (msg == null) {
            return pErrorCode;
        }
        return pErrorCode + ": " + msg;
    }

    public JAXBException(String pMessage, String pErrorCode) {
        this(pMessage, pErrorCode, null);
    }

    public JAXBException(Throwable pLinkedException) {
        this(null, null, pLinkedException);
    }

    public JAXBException(String pMessage, Throwable pLinkedException) {
        this(pMessage, null, pLinkedException);
    }

    public JAXBException(String pMessage, String pErrorCode, Throwable pLinkedException) {
        super(JAXBException.formatMessage(pErrorCode, pMessage, pLinkedException));
        this.errorCode = pErrorCode;
        this.linkedException = pLinkedException;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public Throwable getLinkedException() {
        return this.linkedException;
    }

    public void setLinkedException(Throwable pLinkedException) {
        this.linkedException = pLinkedException;
    }

    public String toString() {
        if (this.errorCode == null || this.errorCode.length() == 0) {
            return super.toString();
        }
        return this.errorCode + ": " + super.toString();
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public void printStackTrace(PrintStream pStream) {
        super.printStackTrace(pStream);
        Throwable t = this.getLinkedException();
        if (t != null) {
            pStream.println("Caused by:");
            t.printStackTrace(pStream);
        }
    }

    public void printStackTrace(PrintWriter pWriter) {
        super.printStackTrace(pWriter);
        Throwable t = this.getLinkedException();
        if (t != null) {
            pWriter.println("Caused by:");
            t.printStackTrace(pWriter);
        }
    }
}

