/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.renderers.swt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.internal.workbench.ContributionsAnalyzer;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MRenderedToolBar;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarContribution;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarElement;
import org.eclipse.e4.ui.workbench.IPresentationEngine;
import org.eclipse.e4.ui.workbench.modeling.ExpressionContext;
import org.eclipse.e4.ui.workbench.renderers.swt.SWTPartRenderer;
import org.eclipse.e4.ui.workbench.renderers.swt.ToolBarRenderer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenderedToolBarRenderer
extends SWTPartRenderer {
    public static final String TAG_VIEW_MENU = "ViewMenu";
    private MApplication application;
    @Inject
    IPresentationEngine renderer;
    HashMap<MToolBar, ArrayList<ArrayList<MToolBarElement>>> pendingCleanup = new HashMap();
    private Image viewMenuImage;

    @Override
    public void init(IEclipseContext context) {
        super.init(context);
        this.application = (MApplication)context.get(MApplication.class);
    }

    public Object createWidget(MUIElement element, Object parent) {
        if (!(element instanceof MRenderedToolBar) || !(parent instanceof Composite)) {
            return null;
        }
        final MRenderedToolBar toolBar = (MRenderedToolBar)element;
        if (!(toolBar.getContributionManager() instanceof ToolBarManager)) {
            return null;
        }
        ToolBarManager tbm = (ToolBarManager)toolBar.getContributionManager();
        ToolBar tb = tbm.createControl((Composite)parent);
        if (tb.getParent() != parent) {
            tb.setParent((Composite)parent);
            tb.setVisible(true);
        }
        tbm.update(true);
        tb.setData(ToolBarManager.class.getName(), (Object)tbm);
        tb.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                RenderedToolBarRenderer.this.cleanUp(toolBar);
            }
        });
        tb.getParent().layout(true);
        return tb;
    }

    protected void cleanUp(MRenderedToolBar element) {
        ArrayList<ArrayList<MToolBarElement>> lists = this.pendingCleanup.remove(element);
        if (lists == null) {
            return;
        }
        for (ArrayList<MToolBarElement> list : lists) {
            for (MToolBarElement child : list) {
                element.getChildren().remove(child);
            }
        }
    }

    public void hideChild(MElementContainer<MUIElement> parentElement, MUIElement child) {
        super.hideChild(parentElement, child);
        Widget widget = (Widget)child.getWidget();
        if (widget != null && !widget.isDisposed()) {
            widget.dispose();
        }
    }

    @Override
    public void processContents(MElementContainer<MUIElement> container) {
        IEclipseContext ctx = this.getContext((MUIElement)container);
        ExpressionContext eContext = new ExpressionContext(ctx);
        ArrayList<MToolBarContribution> toContribute = new ArrayList<MToolBarContribution>();
        MElementContainer<MUIElement> toolbarObj = container;
        MToolBar toolbarModel = (MToolBar)toolbarObj;
        ContributionsAnalyzer.gatherToolBarContributions((MToolBar)toolbarModel, (List)this.application.getToolBarContributions(), (String)toolbarModel.getElementId(), toContribute, (ExpressionContext)eContext);
        ToolBarRenderer.addToolBarContributions(toolbarModel, toContribute, ctx, eContext, this.pendingCleanup);
    }

    public void postProcess(MUIElement element) {
        MPart part;
        MMenu viewMenu;
        ToolBar tb = (ToolBar)element.getWidget();
        if (((EObject)element).eContainer() instanceof MPart && (viewMenu = this.getViewMenu(part = (MPart)((EObject)element).eContainer())) != null) {
            this.addMenuButton(part, tb, viewMenu);
        }
        tb.pack();
        tb.setVisible(true);
        super.postProcess(element);
    }

    @Override
    public void disposeWidget(MUIElement element) {
        ToolBar tb = (ToolBar)element.getWidget();
        tb.setVisible(false);
        this.unbindWidget(element);
        tb.setData("modelElement", (Object)element);
    }

    private void addMenuButton(MPart part, ToolBar tb, MMenu menu) {
        ToolItem ti = new ToolItem(tb, 8);
        ti.setImage(this.getViewMenuImage());
        ti.setHotImage(null);
        ti.setToolTipText("View Menu");
        ti.setData("theMenu", (Object)menu);
        ti.setData("thePart", (Object)part);
        ti.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                RenderedToolBarRenderer.this.showMenu((ToolItem)e.widget);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                RenderedToolBarRenderer.this.showMenu((ToolItem)e.widget);
            }
        });
    }

    protected void showMenu(ToolItem item) {
        MMenu menuModel = (MMenu)item.getData("theMenu");
        MPart part = (MPart)item.getData("thePart");
        Control ctrl = (Control)part.getWidget();
        Menu menu = (Menu)this.renderer.createGui((MUIElement)menuModel, (Object)ctrl.getShell(), part.getContext());
        Rectangle ib = item.getBounds();
        Point displayAt = item.getParent().toDisplay(ib.x, ib.y + ib.height);
        menu.setLocation(displayAt);
        menu.setVisible(true);
        Display display = Display.getCurrent();
        while (!menu.isDisposed() && menu.isVisible()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        menu.dispose();
    }

    private Image getViewMenuImage() {
        if (this.viewMenuImage == null) {
            Display d = Display.getCurrent();
            Image viewMenu = new Image((Device)d, 16, 16);
            Image viewMenuMask = new Image((Device)d, 16, 16);
            Display display = Display.getCurrent();
            GC gc = new GC((Drawable)viewMenu);
            GC maskgc = new GC((Drawable)viewMenuMask);
            gc.setForeground(display.getSystemColor(17));
            gc.setBackground(display.getSystemColor(25));
            int[] shapeArray = new int[]{6, 1, 15, 1, 11, 5, 10, 5};
            gc.fillPolygon(shapeArray);
            gc.drawPolygon(shapeArray);
            Color black = display.getSystemColor(2);
            Color white = display.getSystemColor(1);
            maskgc.setBackground(black);
            maskgc.fillRectangle(0, 0, 16, 16);
            maskgc.setBackground(white);
            maskgc.setForeground(white);
            maskgc.fillPolygon(shapeArray);
            maskgc.drawPolygon(shapeArray);
            gc.dispose();
            maskgc.dispose();
            ImageData data = viewMenu.getImageData();
            data.transparentPixel = data.getPixel(0, 0);
            this.viewMenuImage = new Image((Device)d, viewMenu.getImageData(), viewMenuMask.getImageData());
            viewMenu.dispose();
            viewMenuMask.dispose();
        }
        return this.viewMenuImage;
    }

    private MMenu getViewMenu(MPart part) {
        if (part.getMenus() == null) {
            return null;
        }
        for (MMenu menu : part.getMenus()) {
            if (!menu.getTags().contains(TAG_VIEW_MENU)) continue;
            return menu;
        }
        return null;
    }
}

