/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.jmx.internal;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.equinox.jmx.common.ContributionNotificationEvent;
import org.eclipse.equinox.jmx.server.Contribution;
import org.eclipse.osgi.jmx.internal.Activator;
import org.eclipse.osgi.jmx.internal.BundleContributionMessages;
import org.eclipse.osgi.jmx.internal.BundleContributionProvider;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;

public class BundleContribution
extends Contribution
implements BundleListener {
    private static final long serialVersionUID = 1180032465513448129L;
    private static final String BUNDLE_IMG_PATH = "icons/bundles/bundle.gif";
    private static final Map stateStrings = new HashMap();
    private ServiceReference service;
    private long id;
    private long lastModified;
    private int state;
    private Version version;
    private String symbolicName;
    private String vendor;
    private String description;
    private String docURL;
    private String contactAddress;
    private String location;
    private Bundle bundle;

    static {
        stateStrings.put(new Integer(32), "ACTIVE");
        stateStrings.put(new Integer(2), "INSTALLED");
        stateStrings.put(new Integer(4), "RESOLVED");
        stateStrings.put(new Integer(8), "STARTING");
        stateStrings.put(new Integer(16), "STOPPING");
        stateStrings.put(new Integer(1), "UNINSTALLED");
    }

    public BundleContribution(Bundle bundle) {
        this(bundle, null);
    }

    public BundleContribution(Bundle bundle, ServiceReference service) {
        super((Object)bundle);
        this.bundle = bundle;
        this.service = service;
        this.setProperties(bundle);
        Activator.getBundleContext().addBundleListener((BundleListener)this);
    }

    protected ObjectName getObjectName() {
        try {
            return new ObjectName("jmxserver:type=Bundle,name=" + this.getName());
        }
        catch (Exception exception) {
            return super.getObjectName();
        }
    }

    protected Object[] getChildren() {
        return null;
    }

    protected Set getProperties() {
        TreeSet<String> ret = new TreeSet<String>();
        ret.add("Symbolic-name: " + this.symbolicName);
        ret.add("Bundle ID: " + Long.toString(this.id));
        ret.add("Description: " + this.description);
        ret.add("State: " + (String)stateStrings.get(new Integer(this.getState())));
        ret.add("Vendor: " + this.vendor);
        ret.add("Contact Address: " + this.contactAddress);
        ret.add("Location: " + this.location);
        ret.add("DocURL: " + this.docURL);
        return ret;
    }

    protected URL getImageLocation() {
        String imgPath = BUNDLE_IMG_PATH;
        if (this.service != null) {
            if (this.service.getBundle() == this.bundle) {
                imgPath = "icons/services/bundle_reg_service.png";
                Bundle[] usingBundles = this.service.getUsingBundles();
                if (usingBundles != null) {
                    int i = 0;
                    while (i < usingBundles.length) {
                        if (usingBundles[i] == this.bundle) {
                            imgPath = "icons/services/bundle_use_reg_service.png";
                            break;
                        }
                        ++i;
                    }
                }
            } else {
                imgPath = "icons/services/bundle_use_service.png";
            }
        }
        return FileLocator.find((Bundle)Activator.getBundle(), (IPath)new Path(imgPath), null);
    }

    protected Object invokeOperation(String operationName, Object[] args, String[] argTypes) {
        if (args.length == 0 && argTypes.length == 0) {
            try {
                if (operationName.equals("start")) {
                    this.bundle.start();
                } else if (operationName.equals("stop")) {
                    this.bundle.stop();
                } else if (operationName.equals("uninstall")) {
                    this.bundle.uninstall();
                }
            }
            catch (Exception e) {
                return e.getMessage();
            }
        }
        return null;
    }

    public void bundleChanged(BundleEvent event) {
        Bundle b = (Bundle)event.getSource();
        if (b != this.bundle && event.getType() != this.getState()) {
            return;
        }
        this.setProperties(this.bundle);
        ContributionNotificationEvent cEvent = null;
        switch (event.getType()) {
            case 16: {
                cEvent = new ContributionNotificationEvent("contribution.removed");
                break;
            }
            case 2: 
            case 4: {
                cEvent = new ContributionNotificationEvent("contribution.updated");
                break;
            }
            default: {
                return;
            }
        }
        super.contributionStateChanged(cEvent);
    }

    public String getName() {
        return String.valueOf(this.symbolicName) + "-" + this.version;
    }

    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        return null;
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
    }

    public AttributeList getAttributes(String[] attributes) {
        return null;
    }

    public AttributeList setAttributes(AttributeList attributes) {
        return null;
    }

    public MBeanInfo getMBeanInfo(Object delegate) {
        MBeanInfo info = new MBeanInfo(((Object)((Object)this)).getClass().getName(), BundleContributionMessages.bundle_description, this.getAttributes(), this.getConstructorInfo(), this.getOperationInfo(), ((NotificationBroadcasterSupport)((Object)this)).getNotificationInfo());
        return info;
    }

    public String getContactAddress() {
        return this.contactAddress;
    }

    public void setContactAddress(String contactAddress) {
        this.contactAddress = contactAddress;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDocURL() {
        return this.docURL;
    }

    public void setDocURL(String docURL) {
        this.docURL = docURL;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) throws IllegalArgumentException {
        Assert.isLegal((id >= 0L ? 1 : 0) != 0);
        this.id = id;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) throws IllegalArgumentException {
        Assert.isLegal((location != null && !location.equals("") ? 1 : 0) != 0);
        this.location = location;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public String getSymbolicName() {
        return this.symbolicName;
    }

    public void setSymbolicName(String symbolicName) {
        this.symbolicName = symbolicName;
    }

    public String getVendor() {
        return this.vendor;
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    public Version getVersion() {
        return this.version;
    }

    public void setVersion(Version version) throws IllegalArgumentException {
        Assert.isLegal((version != null ? 1 : 0) != 0);
        this.version = version;
    }

    private MBeanAttributeInfo[] getAttributes() {
        MBeanAttributeInfo[] ret = new MBeanAttributeInfo[]{};
        return ret;
    }

    private MBeanConstructorInfo[] getConstructorInfo() {
        MBeanConstructorInfo[] ret = new MBeanConstructorInfo[]{};
        return ret;
    }

    private MBeanOperationInfo[] getOperationInfo() {
        if (BundleContributionProvider.isPluginDependency(this.bundle)) {
            return new MBeanOperationInfo[0];
        }
        return new MBeanOperationInfo[]{BundleContribution.createStartOperation(), BundleContribution.createStopOperation(), BundleContribution.createUninstallOperation()};
    }

    private void setProperties(Bundle bundle) {
        this.setContactAddress((String)bundle.getHeaders().get("Bundle-ContactAddress"));
        this.setDescription((String)bundle.getHeaders().get("Bundle-Description"));
        this.setDocURL((String)bundle.getHeaders().get("Bundle-DocURL"));
        this.setId(bundle.getBundleId());
        this.setLastModified(bundle.getLastModified());
        this.setLocation(bundle.getLocation());
        this.setState(bundle.getState());
        this.setSymbolicName(bundle.getSymbolicName());
        this.setVendor((String)bundle.getHeaders().get("Bundle-Vendor"));
        this.setVersion(new Version((String)bundle.getHeaders().get("Bundle-Version")));
    }

    private static MBeanOperationInfo createStartOperation() {
        return new MBeanOperationInfo("start", BundleContributionMessages.start_operation_desc, new MBeanParameterInfo[0], Void.TYPE.getName(), 0);
    }

    private static MBeanOperationInfo createStopOperation() {
        return new MBeanOperationInfo("stop", BundleContributionMessages.stop_operation_desc, new MBeanParameterInfo[0], Void.TYPE.getName(), 0);
    }

    private static MBeanOperationInfo createUninstallOperation() {
        return new MBeanOperationInfo("uninstall", BundleContributionMessages.stop_operation_desc, new MBeanParameterInfo[0], Void.TYPE.getName(), 0);
    }
}

