/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.contexts;

import java.lang.reflect.Type;
import javax.inject.Named;
import org.eclipse.e4.core.contexts.Active;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.IInjector;
import org.eclipse.e4.core.di.suppliers.IObjectDescriptor;
import org.eclipse.e4.core.di.suppliers.IRequestor;
import org.eclipse.e4.core.di.suppliers.PrimaryObjectSupplier;
import org.eclipse.e4.core.internal.contexts.Computation;
import org.eclipse.e4.core.internal.contexts.EclipseContext;
import org.eclipse.e4.core.internal.contexts.RunAndTrackExt;

public class ContextObjectSupplier
extends PrimaryObjectSupplier {
    protected static final String ECLIPSE_CONTEXT_NAME = IEclipseContext.class.getName();
    private final IEclipseContext context;
    private Computation outerComputation;
    private int paused = 0;

    public ContextObjectSupplier(IEclipseContext context, IInjector injector) {
        this.context = context;
    }

    public IEclipseContext getContext() {
        return this.context;
    }

    public void get(IObjectDescriptor[] descriptors, Object[] actualArgs, IRequestor requestor, boolean track, boolean group) {
        String[] keys = new String[descriptors.length];
        boolean[] active = new boolean[descriptors.length];
        int i = 0;
        while (i < descriptors.length) {
            String key = this.getKey(descriptors[i]);
            keys[i] = actualArgs[i] == IInjector.NOT_A_VALUE ? key : (ECLIPSE_CONTEXT_NAME.equals(key) ? ECLIPSE_CONTEXT_NAME : null);
            active[i] = descriptors[i] == null ? false : descriptors[i].hasQualifier(Active.class);
            ++i;
        }
        if (requestor != null && track) {
            ContextInjectionListener trackable = new ContextInjectionListener(this.context, actualArgs, keys, active, requestor, group);
            this.context.runAndTrack(trackable);
        } else if (descriptors.length > 0) {
            this.pauseRecording();
            try {
                i = 0;
                while (i < descriptors.length) {
                    if (keys[i] != null) {
                        IEclipseContext targetContext;
                        IEclipseContext iEclipseContext = targetContext = active[i] ? this.context.getActiveLeaf() : this.context;
                        if (ECLIPSE_CONTEXT_NAME.equals(keys[i])) {
                            actualArgs[i] = targetContext;
                        } else if (this.context.containsKey(keys[i])) {
                            actualArgs[i] = targetContext.get(keys[i]);
                        }
                    }
                    ++i;
                }
            }
            finally {
                this.resumeRecoding();
            }
        }
    }

    private String getKey(IObjectDescriptor descriptor) {
        if (descriptor.hasQualifier(Named.class)) {
            Named namedAnnotation = (Named)descriptor.getQualifier(Named.class);
            return namedAnnotation.value();
        }
        Type elementType = descriptor.getDesiredType();
        if (elementType instanceof Class) {
            return ((Class)elementType).getName();
        }
        return null;
    }

    public synchronized void pauseRecording() {
        if (this.paused == 0) {
            this.outerComputation = EclipseContext.localComputation().get();
        }
        EclipseContext.localComputation().set(null);
        ++this.paused;
    }

    public synchronized void resumeRecoding() {
        --this.paused;
        if (this.paused == 0) {
            EclipseContext.localComputation().set(this.outerComputation);
        }
    }

    public static ContextObjectSupplier getObjectSupplier(IEclipseContext context, IInjector injector) {
        if (context == null) {
            return null;
        }
        ContextObjectSupplier supplier = context.getLocal(ContextObjectSupplier.class);
        if (supplier != null) {
            return supplier;
        }
        ContextObjectSupplier objectSupplier = new ContextObjectSupplier(context, injector);
        context.set(ContextObjectSupplier.class, objectSupplier);
        return objectSupplier;
    }

    public static class ContextInjectionListener
    extends RunAndTrackExt {
        private final Object[] result;
        private final String[] keys;
        private final boolean[] active;
        private final IRequestor requestor;
        private final IEclipseContext context;

        public ContextInjectionListener(IEclipseContext context, Object[] result, String[] keys, boolean[] active, IRequestor requestor, boolean group) {
            super(group);
            this.result = result;
            this.keys = keys;
            this.active = active;
            this.requestor = requestor;
            this.context = context;
        }

        public boolean update(IEclipseContext eventsContext, int eventType, Object[] extraArguments) {
            if (eventType == 0) {
                int i = 0;
                while (i < this.keys.length) {
                    if (this.keys[i] != null) {
                        IEclipseContext targetContext;
                        IEclipseContext iEclipseContext = targetContext = this.active[i] ? this.context.getActiveLeaf() : this.context;
                        if (ECLIPSE_CONTEXT_NAME.equals(this.keys[i])) {
                            this.result[i] = targetContext;
                            targetContext.getParent();
                        } else if (targetContext.containsKey(this.keys[i])) {
                            this.result[i] = targetContext.get(this.keys[i]);
                        }
                    }
                    ++i;
                }
                return true;
            }
            if (eventType == 3) {
                if (eventsContext == this.context) {
                    ContextObjectSupplier originatingSupplier = eventsContext.getLocal(ContextObjectSupplier.class);
                    this.requestor.disposed((PrimaryObjectSupplier)originatingSupplier);
                    return false;
                }
            } else if (eventType == 4) {
                if (eventsContext == this.context) {
                    ContextObjectSupplier originatingSupplier = eventsContext.getLocal(ContextObjectSupplier.class);
                    return this.requestor.uninject(extraArguments[0], (PrimaryObjectSupplier)originatingSupplier);
                }
            } else {
                if (!this.requestor.isValid()) {
                    return false;
                }
                this.requestor.resolveArguments();
                this.requestor.execute();
            }
            return true;
        }

        public boolean changed(IEclipseContext eventsContext) {
            return true;
        }

        public int hashCode() {
            int hashRresult = 1;
            hashRresult = 31 * hashRresult + (this.context == null ? 0 : this.context.hashCode());
            hashRresult = 31 * hashRresult + (this.requestor == null ? 0 : this.requestor.hashCode());
            return hashRresult;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ContextInjectionListener other = (ContextInjectionListener)obj;
            if (this.context == null ? other.context != null : !this.context.equals(other.context)) {
                return false;
            }
            return !(this.requestor == null ? other.requestor != null : !this.requestor.equals(other.requestor));
        }

        public String toString() {
            return this.requestor.toString();
        }
    }
}

