/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.bindings.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.contexts.Context;
import org.eclipse.core.commands.contexts.ContextManager;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.bindings.EBindingService;
import org.eclipse.e4.ui.bindings.internal.BindingTable;
import org.eclipse.e4.ui.bindings.internal.BindingTableManager;
import org.eclipse.e4.ui.bindings.internal.ContextSet;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeyBinding;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.bindings.keys.ParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindingServiceImpl
implements EBindingService {
    static final String ACTIVE_CONTEXTS = "activeContexts";
    @Inject
    private IEclipseContext context;
    @Inject
    private BindingTableManager manager;
    private ContextManager contextManager;
    private ContextSet contextSet = ContextSet.EMPTY;

    @Inject
    void setContextManager(ContextManager contextManager) {
        this.contextManager = contextManager;
        if (contextManager != null && ContextSet.getComparator() == null) {
            ContextSet.setComparator(new ContextSet.CComp(contextManager));
        }
    }

    @Override
    public Binding createBinding(TriggerSequence sequence, ParameterizedCommand command, String schemeId, String contextId) {
        return new KeyBinding((KeySequence)sequence, command, schemeId, contextId, null, null, null, 0);
    }

    @Override
    public void activateBinding(Binding binding) {
        String contextId = binding.getContextId();
        BindingTable table = this.manager.getTable(contextId);
        if (table == null) {
            System.err.println("No binding table for " + contextId);
        }
        table.addBinding(binding);
    }

    @Override
    public void deactivateBinding(Binding binding) {
        String contextId = binding.getContextId();
        BindingTable table = this.manager.getTable(contextId);
        if (table == null) {
            System.err.println("No binding table for " + contextId);
        }
        table.removeBinding(binding);
    }

    @Override
    public TriggerSequence createSequence(String sequence) {
        try {
            return KeySequence.getInstance((String)sequence);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    @Override
    public Collection<Binding> getConflictsFor(TriggerSequence sequence) {
        return null;
    }

    @Override
    public Binding getPerfectMatch(TriggerSequence trigger) {
        return this.manager.getPerfectMatch(this.contextSet, trigger);
    }

    @Override
    public boolean isPartialMatch(TriggerSequence keySequence) {
        return this.manager.isPartialMatch(this.contextSet, keySequence);
    }

    @Override
    public TriggerSequence getBestSequenceFor(ParameterizedCommand command) {
        Binding binding = this.manager.getBestSequenceFor(this.contextSet, command);
        return binding == null ? null : binding.getTriggerSequence();
    }

    @Override
    public Collection<TriggerSequence> getSequencesFor(ParameterizedCommand command) {
        Collection<Binding> bindings = this.manager.getSequencesFor(this.contextSet, command);
        ArrayList<TriggerSequence> sequences = new ArrayList<TriggerSequence>(bindings.size());
        for (Binding binding : bindings) {
            sequences.add(binding.getTriggerSequence());
        }
        return sequences;
    }

    @Override
    public boolean isPerfectMatch(TriggerSequence sequence) {
        return this.getPerfectMatch(sequence) != null;
    }

    @Override
    public Collection<Binding> getPartialMatches(TriggerSequence sequence) {
        return this.manager.getPartialMatches(this.contextSet, sequence);
    }

    public IEclipseContext getContext() {
        return this.context;
    }

    @Inject
    public void setContextIds(@Named(value="activeContexts") @Optional Set<String> set) {
        if (set == null || set.isEmpty() || this.contextManager == null) {
            this.contextSet = ContextSet.EMPTY;
            return;
        }
        ArrayList<Context> contexts = new ArrayList<Context>();
        for (String id : set) {
            contexts.add(this.contextManager.getContext(id));
        }
        this.contextSet = this.manager.createContextSet(contexts);
    }
}

