/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.addons.dndaddon;

import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.widgets.CTabFolder;
import org.eclipse.e4.ui.widgets.CTabItem;
import org.eclipse.e4.ui.workbench.addons.dndaddon.CursorInfo;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

class DragAndDropUtil {
    private MWindow topLevelWindow;
    private Display display;
    private EModelService modelService;

    public DragAndDropUtil(MWindow window) {
        this.topLevelWindow = window;
        this.display = Display.getCurrent();
        this.modelService = (EModelService)window.getContext().get(EModelService.class);
    }

    public CursorInfo getCursorInfo() {
        CursorInfo info = new CursorInfo();
        info.cursorPos = this.display.getCursorLocation();
        info.curCtrl = this.display.getCursorControl();
        if (info.curCtrl == null) {
            return info;
        }
        MUIElement curElement = this.getModelElement(info.curCtrl);
        if (curElement instanceof MPlaceholder) {
            info.curElement = ((MPlaceholder)curElement).getRef();
            info.curElementRef = (MPlaceholder)curElement;
        } else {
            info.curElement = curElement;
            info.curElementRef = null;
        }
        if (info.curElement instanceof MElementContainer) {
            Point cursorPos = this.display.getCursorLocation();
            this.setItemElement(info, cursorPos);
        }
        return info;
    }

    private void setItemElement(CursorInfo info, Point cursorPos) {
        ToolBar tb;
        ToolItem curItem;
        info.itemIndex = -1;
        info.itemRect = null;
        Control ctrl = (Control)info.curElement.getWidget();
        if (ctrl instanceof CTabFolder) {
            CTabFolder ctf = (CTabFolder)ctrl;
            CTabItem curItem2 = ctf.getItem(cursorPos = this.display.map(null, (Control)ctf, cursorPos));
            if (curItem2 != null) {
                MUIElement itemElement = (MUIElement)curItem2.getData("modelElement");
                if (itemElement instanceof MPlaceholder) {
                    info.itemElement = ((MPlaceholder)itemElement).getRef();
                    info.itemElementRef = (MPlaceholder)itemElement;
                } else {
                    info.itemElement = itemElement;
                    info.itemElementRef = null;
                }
                info.itemIndex = ctf.indexOf(curItem2);
                info.itemRect = curItem2.getBounds();
                info.itemRect = this.display.map((Control)ctf, (Control)ctf.getShell(), info.itemRect);
            }
        } else if (ctrl instanceof ToolBar && (curItem = (tb = (ToolBar)ctrl).getItem(cursorPos = this.display.map(null, (Control)tb, cursorPos))) != null) {
            info.itemElement = (MUIElement)curItem.getData("modelElement");
            ToolItem[] items = tb.getItems();
            int i = 0;
            while (i < items.length) {
                if (items[i] == curItem) {
                    info.itemIndex = i;
                    info.itemRect = curItem.getBounds();
                    info.itemRect = this.display.map((Control)tb, (Control)tb.getShell(), info.itemRect);
                }
                ++i;
            }
        }
    }

    private MUIElement getModelElement(Control ctrl) {
        if (ctrl == null) {
            return null;
        }
        MUIElement element = (MUIElement)ctrl.getData("modelElement");
        if (element != null) {
            if (this.modelService.getTopLevelWindowFor(element) == this.topLevelWindow) {
                return element;
            }
            return null;
        }
        return this.getModelElement((Control)ctrl.getParent());
    }
}

