/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.addons.dndaddon;

import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.SideValue;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimElement;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.workbench.addons.dndaddon.CursorInfo;
import org.eclipse.e4.ui.workbench.addons.dndaddon.DropAgent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ToolbarDropAgent
extends DropAgent {
    private Shell dragShell;

    public boolean canDrop(MUIElement dragElement, CursorInfo info) {
        if (!(dragElement instanceof MToolBar) || info.curElement == null) {
            return false;
        }
        if (info.curElement instanceof MTrimBar) {
            return true;
        }
        MElementContainer parentElement = info.curElement.getParent();
        return parentElement instanceof MTrimBar;
    }

    public boolean drop(MUIElement dragElement, CursorInfo info) {
        MTrimBar theBar = (MTrimBar)(info.curElement instanceof MTrimBar ? info.curElement : info.curElement.getParent());
        int index = -1;
        if (info.curElement != theBar) {
            index = info.curElement.getParent().getChildren().indexOf(info.curElement);
            if (this.after(info)) {
                ++index;
            }
        }
        dragElement.getParent().getChildren().remove(dragElement);
        dragElement.setVisible(true);
        if (index == -1 || index > theBar.getChildren().size() - 1) {
            theBar.getChildren().add((MTrimElement)dragElement);
        } else {
            theBar.getChildren().add(index, (MTrimElement)dragElement);
        }
        if (this.dragShell != null) {
            this.dragShell.dispose();
        }
        return true;
    }

    private boolean after(CursorInfo info) {
        if (info.curElement instanceof MTrimBar) {
            return false;
        }
        MTrimBar theBar = (MTrimBar)info.curElement.getParent();
        boolean isHorizontal = theBar.getSide() == SideValue.TOP || theBar.getSide() == SideValue.BOTTOM;
        MUIElement overElement = info.curElement;
        Control ctrl = (Control)overElement.getWidget();
        Rectangle bounds = ctrl.getBounds();
        bounds = ctrl.getDisplay().map((Control)ctrl.getParent(), null, bounds);
        if (isHorizontal && info.cursorPos.x - bounds.x >= bounds.x + bounds.width - info.cursorPos.x) {
            return true;
        }
        return !isHorizontal && info.cursorPos.y - bounds.y >= bounds.y + bounds.height - info.cursorPos.y;
    }

    public Rectangle getRectangle(MUIElement dragElement, CursorInfo info) {
        boolean needsOpen = false;
        if (this.dragShell == null) {
            this.dragShell = new Shell(8);
            this.dragShell.setAlpha(150);
            this.dragShell.setLayout((Layout)new FillLayout());
            Composite comp = new Composite((Composite)this.dragShell, 2048);
            comp.setLayout((Layout)new FillLayout());
            this.dragShell.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    ToolbarDropAgent.this.dragShell = null;
                }
            });
            Control ctrl = (Control)dragElement.getWidget();
            ctrl.setParent(comp);
            this.dragShell.pack();
            needsOpen = true;
        }
        Point newLoc = new Point(info.cursorPos.x + 4, info.cursorPos.y + 4);
        this.dragShell.setLocation(newLoc);
        if (needsOpen) {
            this.dragShell.open();
        }
        MUIElement overElement = info.curElement;
        Control ctrl = (Control)overElement.getWidget();
        Rectangle bounds = ctrl.getBounds();
        bounds = ctrl.getDisplay().map((Control)ctrl.getParent(), null, bounds);
        bounds.x = this.after(info) ? bounds.x + bounds.width : bounds.x;
        bounds.width = 5;
        bounds.x -= bounds.width / 2;
        return bounds;
    }

    public Cursor getCursor(Display display, MUIElement dragElement, CursorInfo info) {
        return display.getSystemCursor(21);
    }
}

