/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.addons.minmax;

import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.SideValue;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MToolControl;
import org.eclipse.e4.ui.widgets.CTabFolder;
import org.eclipse.e4.ui.widgets.CTabItem;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.e4.ui.workbench.addons.minmax.MinMaxAddon;
import org.eclipse.e4.ui.workbench.addons.minmax.TrimPaneLayout;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.renderers.swt.TrimmedPartLayout;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.internal.WorkbenchImages;
import org.osgi.service.event.EventHandler;

public class TrimStack {
    private static Image restoreImage;
    private ToolBar trimStackTB;
    private boolean isShowing = false;
    private MPartStack theStack;
    private Composite hostPane;
    ControlListener caResizeListener = new ControlListener(){

        public void controlResized(ControlEvent e) {
            if (TrimStack.this.hostPane != null && TrimStack.this.hostPane.isVisible()) {
                TrimStack.this.setPaneLocation(TrimStack.this.hostPane);
            }
        }

        public void controlMoved(ControlEvent e) {
        }
    };
    private Listener mouseDownListener = new Listener(){

        /*
         * Unable to fully structure code
         */
        public void handleEvent(Event event) {
            block3: {
                if (!(event.widget instanceof Control)) break block3;
                control = (Control)event.widget;
                if (control.getShell() != TrimStack.access$0(TrimStack.this).getParent()) {
                    return;
                }
                if (control != TrimStack.access$2(TrimStack.this)) ** GOTO lbl10
                return;
lbl-1000:
                // 1 sources

                {
                    if (control == TrimStack.access$0(TrimStack.this)) {
                        return;
                    }
                    control = control.getParent();
lbl10:
                    // 2 sources

                    ** while (!(control instanceof Shell))
                }
lbl11:
                // 1 sources

                TrimStack.this.showStack(false);
            }
        }
    };
    private Listener escapeListener = new Listener(){

        public void handleEvent(Event event) {
            if (event.character == '\u001b') {
                TrimStack.this.showStack(false);
            }
        }
    };
    @Inject
    EModelService modelService;
    @Inject
    EPartService partService;
    @Inject
    MWindow window;
    @Inject
    MToolControl toolControl;
    @Inject
    protected IEventBroker eventBroker;
    private EventHandler selectionHandler = new EventHandler(){

        public void handleEvent(org.osgi.service.event.Event event) {
            MUIElement changedElement = (MUIElement)event.getProperty("ChangedElement");
            if (changedElement != TrimStack.this.theStack) {
                return;
            }
            if (TrimStack.this.hostPane != null && TrimStack.this.hostPane.isVisible()) {
                TrimStack.this.updateSelection((MStackElement)TrimStack.this.theStack.getSelectedElement());
            }
        }
    };
    private EventHandler toBeRenderedHandler = new EventHandler(){

        public void handleEvent(org.osgi.service.event.Event event) {
            if (TrimStack.this.theStack == null || TrimStack.this.trimStackTB == null) {
                return;
            }
            MUIElement changedElement = (MUIElement)event.getProperty("ChangedElement");
            if (changedElement == TrimStack.this.theStack && !TrimStack.this.theStack.isToBeRendered()) {
                TrimStack.this.restoreStack();
                return;
            }
            MElementContainer parentElement = changedElement.getParent();
            if (parentElement == TrimStack.this.theStack) {
                TrimStack.this.trimStackTB.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        TrimStack.this.updateTrimStackItems();
                    }
                });
            }
        }
    };
    private EventHandler childrenHandler = new EventHandler(){

        public void handleEvent(org.osgi.service.event.Event event) {
            if (TrimStack.this.theStack == null || TrimStack.this.trimStackTB == null) {
                return;
            }
            Object changedObj = event.getProperty("ChangedElement");
            if (changedObj == TrimStack.this.theStack) {
                TrimStack.this.trimStackTB.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        TrimStack.this.updateTrimStackItems();
                    }
                });
            }
        }
    };
    private EventHandler widgetHandler = new EventHandler(){

        public void handleEvent(org.osgi.service.event.Event event) {
            Object changedObj = event.getProperty("ChangedElement");
            if (changedObj != TrimStack.this.theStack) {
                return;
            }
            if (TrimStack.this.theStack.getWidget() != null) {
                TrimStack.this.trimStackTB.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        TrimStack.this.updateTrimStackItems();
                    }
                });
            }
        }
    };
    private MTrimBar bar;
    private int fixedSides;

    @PostConstruct
    void addListeners() {
        this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/ui/ElementContainer", (String)"children"), this.childrenHandler);
        this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/ui/UIElement", (String)"toBeRendered"), this.toBeRenderedHandler);
        this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/ui/ElementContainer", (String)"selectedElement"), this.selectionHandler);
        this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/ui/UIElement", (String)"widget"), this.widgetHandler);
    }

    @PreDestroy
    void removeListeners() {
        this.eventBroker.unsubscribe(this.toBeRenderedHandler);
        this.eventBroker.unsubscribe(this.childrenHandler);
        this.eventBroker.unsubscribe(this.selectionHandler);
        this.eventBroker.unsubscribe(this.widgetHandler);
    }

    @PostConstruct
    void createWidget(Composite parent, MToolControl me) {
        if (this.theStack == null) {
            this.theStack = this.findStack();
        }
        MElementContainer meParent = me.getParent();
        int orientation = 256;
        if (meParent instanceof MTrimBar) {
            this.bar = (MTrimBar)meParent;
            if (this.bar.getSide() == SideValue.RIGHT || this.bar.getSide() == SideValue.LEFT) {
                orientation = 512;
            }
        }
        this.trimStackTB = new ToolBar(parent, orientation | 0x800000 | 0x40);
        ToolItem restoreBtn = new ToolItem(this.trimStackTB, 8);
        restoreBtn.setImage(this.getRestoreImage(parent.getDisplay()));
        restoreBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TrimStack.this.theStack.getTags().remove(MinMaxAddon.MINIMIZED);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                TrimStack.this.theStack.getTags().remove(MinMaxAddon.MINIMIZED);
            }
        });
        this.updateTrimStackItems();
    }

    private MPartStack findStack() {
        List ps = this.modelService.findElements((MUIElement)this.window, null, MPerspectiveStack.class, null);
        if (ps.size() == 0) {
            String toolControlId = this.toolControl.getElementId();
            int index = toolControlId.indexOf(40);
            String stackId = toolControlId.substring(0, index);
            this.theStack = (MPartStack)this.modelService.find(stackId, (MUIElement)this.window);
        } else {
            String toolControlId = this.toolControl.getElementId();
            int index = toolControlId.indexOf(40);
            String stackId = toolControlId.substring(0, index);
            String perspId = toolControlId.substring(index + 1, toolControlId.length() - 1);
            MPerspective persp = (MPerspective)this.modelService.find(perspId, (MUIElement)ps.get(0));
            if (persp != null) {
                this.theStack = (MPartStack)this.modelService.find(stackId, (MUIElement)persp);
            }
        }
        return this.theStack;
    }

    /*
     * Unable to fully structure code
     */
    private void updateTrimStackItems() {
        if (this.trimStackTB == null || this.trimStackTB.isDisposed()) {
            return;
        }
        ctf = (CTabFolder)this.theStack.getWidget();
        if (ctf == null) {
            return;
        }
        if (ctf.getItemCount() != 0) ** GOTO lbl10
        this.restoreStack();
        return;
lbl-1000:
        // 1 sources

        {
            this.trimStackTB.getItem(this.trimStackTB.getItemCount() - 1).dispose();
lbl10:
            // 2 sources

            ** while (this.trimStackTB.getItemCount() > 1)
        }
lbl11:
        // 1 sources

        var6_3 = items = ctf.getItems();
        var5_4 = items.length;
        var4_5 = 0;
        while (var4_5 < var5_4) {
            item = var6_3[var4_5];
            newItem = new ToolItem(this.trimStackTB, 32);
            newItem.setData((Object)item);
            newItem.setImage(item.getImage());
            newItem.setToolTipText(item.getText());
            newItem.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    ToolItem item = (ToolItem)e.widget;
                    CTabItem cti = (CTabItem)item.getData();
                    MUIElement me = (MUIElement)cti.getData("modelElement");
                    if (me instanceof MPlaceholder) {
                        me = ((MPlaceholder)me).getRef();
                    }
                    boolean show = item.getSelection();
                    TrimStack.this.partService.activate((MPart)me);
                    TrimStack.this.showStack(show);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    ToolItem item = (ToolItem)e.widget;
                    CTabItem cti = (CTabItem)item.getData();
                    MUIElement me = (MUIElement)cti.getData("modelElement");
                    if (me instanceof MPlaceholder) {
                        me = ((MPlaceholder)me).getRef();
                    }
                    boolean show = item.getSelection();
                    TrimStack.this.partService.activate((MPart)me);
                    TrimStack.this.showStack(show);
                }
            });
            ++var4_5;
        }
        if (this.hostPane != null && this.hostPane.isVisible()) {
            this.updateSelection((MStackElement)this.theStack.getSelectedElement());
        }
        this.trimStackTB.pack();
        this.trimStackTB.getShell().layout(new Control[]{this.trimStackTB}, 4);
    }

    void restoreStack() {
        this.showStack(false);
        Display.getCurrent().removeFilter(3, this.mouseDownListener);
        this.theStack.setVisible(true);
        this.theStack.getTags().remove(MinMaxAddon.MINIMIZED);
        this.toolControl.setToBeRendered(false);
        if (this.hostPane != null && !this.hostPane.isDisposed()) {
            this.hostPane.dispose();
        }
        this.hostPane = null;
        if (this.trimStackTB != null && !this.trimStackTB.isDisposed()) {
            this.trimStackTB.dispose();
        }
        this.trimStackTB = null;
    }

    @Execute
    public void showStack(@Named(value="show") boolean show) {
        CTabFolder ctf = (CTabFolder)this.theStack.getWidget();
        if (show && !this.isShowing) {
            this.hostPane = this.getHostPane();
            ctf.setParent(this.hostPane);
            this.hostPane.getDisplay().addFilter(3, this.mouseDownListener);
            this.getShellClientComposite().addControlListener(this.caResizeListener);
            this.updateSelection((MStackElement)this.theStack.getSelectedElement());
            this.setPaneLocation(this.hostPane);
            this.hostPane.layout(true);
            this.hostPane.moveAbove(null);
            this.hostPane.setVisible(true);
            this.isShowing = true;
        } else if (!show && this.isShowing) {
            Display.getCurrent().removeFilter(3, this.mouseDownListener);
            Composite clientArea = this.getShellClientComposite();
            if (clientArea != null) {
                clientArea.removeControlListener(this.caResizeListener);
            }
            if (this.hostPane != null && this.hostPane.isVisible()) {
                this.hostPane.setVisible(false);
                this.updateSelection(null);
                Point size = this.hostPane.getSize();
                this.toolControl.getPersistedState().put("XSize", Integer.toString(size.x));
                this.toolControl.getPersistedState().put("YSize", Integer.toString(size.y));
            }
            this.isShowing = false;
        }
    }

    Composite getShellClientComposite() {
        if (this.trimStackTB.isDisposed()) {
            return null;
        }
        Shell theShell = this.trimStackTB.getShell();
        if (!(theShell.getLayout() instanceof TrimmedPartLayout)) {
            return null;
        }
        TrimmedPartLayout tpl = (TrimmedPartLayout)theShell.getLayout();
        return tpl.clientArea;
    }

    private void setPaneLocation(Composite someShell) {
        Composite clientComp = this.getShellClientComposite();
        if (clientComp == null || clientComp.isDisposed()) {
            return;
        }
        Rectangle caRect = this.getShellClientComposite().getBounds();
        Point paneSize = this.hostPane.getSize();
        Point loc = new Point(0, 0);
        loc.x = this.isFixed(16384) ? caRect.x : caRect.x + caRect.width - paneSize.x;
        loc.y = this.isFixed(128) ? caRect.y : caRect.y + caRect.height - paneSize.y;
        someShell.setLocation(loc);
    }

    private void updateSelection(MStackElement selectedElement) {
        ToolItem[] items;
        ToolItem[] toolItemArray = items = this.trimStackTB.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            ToolItem item = toolItemArray[n2];
            CTabItem cti = (CTabItem)item.getData();
            if (cti != null && !cti.isDisposed()) {
                item.setSelection(cti.getData("modelElement") == selectedElement);
            }
            ++n2;
        }
    }

    private Composite getHostPane() {
        if (this.hostPane != null) {
            return this.hostPane;
        }
        this.hostPane = new Composite((Composite)this.trimStackTB.getShell(), 0);
        this.hostPane.setData("org.eclipse.e4.ui.ignoreDialog", (Object)Boolean.TRUE);
        int xSize = 600;
        String xSizeStr = (String)this.toolControl.getPersistedState().get("XSize");
        if (xSizeStr != null) {
            xSize = Integer.parseInt(xSizeStr);
        }
        int ySize = 400;
        String ySizeStr = (String)this.toolControl.getPersistedState().get("YSize");
        if (ySizeStr != null) {
            ySize = Integer.parseInt(ySizeStr);
        }
        this.hostPane.setSize(xSize, ySize);
        this.hostPane.addListener(31, this.escapeListener);
        this.fixedSides = this.getFixedSides();
        this.hostPane.setLayout((Layout)new TrimPaneLayout(this.fixedSides));
        return this.hostPane;
    }

    private int getFixedSides() {
        int verticalValue = 128;
        if (this.bar.getSide() == SideValue.LEFT) {
            return 0x4000 | verticalValue;
        }
        if (this.bar.getSide() == SideValue.RIGHT) {
            return 0x20000 | verticalValue;
        }
        return 16512;
    }

    private Image getRestoreImage(Display display) {
        if (restoreImage == null) {
            restoreImage = WorkbenchImages.getImage((String)"IMG_ETOOL_RESTORE_TRIMPART");
        }
        return restoreImage;
    }

    private boolean isFixed(int swtSide) {
        return (this.fixedSides & swtSide) != 0;
    }
}

