/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.renderers.swt;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.MUILabel;
import org.eclipse.e4.ui.model.application.ui.advanced.MArea;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.widgets.CTabFolder;
import org.eclipse.e4.ui.widgets.CTabItem;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.e4.ui.workbench.renderers.swt.SWTPartRenderer;
import org.eclipse.e4.ui.workbench.renderers.swt.SashLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AreaRenderer
extends SWTPartRenderer {
    @Inject
    Logger logger;
    @Inject
    IEventBroker eventBroker;
    private EventHandler itemUpdater = new EventHandler(){

        public void handleEvent(Event event) {
            if (!(event.getProperty("ChangedElement") instanceof MArea)) {
                return;
            }
            MArea areaModel = (MArea)event.getProperty("ChangedElement");
            CTabFolder ctf = (CTabFolder)areaModel.getWidget();
            CTabItem areaItem = ctf.getItem(0);
            if (areaItem == null) {
                return;
            }
            String attName = (String)event.getProperty("AttName");
            if ("label".equals(attName)) {
                areaItem.setText(areaModel.getLabel());
            } else if ("iconURI".equals(attName)) {
                areaItem.setImage(AreaRenderer.this.getImage((MUILabel)areaModel));
            } else if ("tooltip".equals(attName)) {
                areaItem.setToolTipText(areaModel.getTooltip());
            }
        }
    };

    @PostConstruct
    void init() {
        this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/ui/UILabel"), this.itemUpdater);
    }

    @PreDestroy
    void contextDisposed() {
        this.eventBroker.unsubscribe(this.itemUpdater);
    }

    public Object createWidget(MUIElement element, Object parent) {
        if (!(element instanceof MArea) || !(parent instanceof Composite)) {
            return null;
        }
        MArea areaModel = (MArea)element;
        Composite parentComp = (Composite)parent;
        CTabFolder ctf = new CTabFolder(parentComp, 2052);
        ctf.setMaximizeVisible(true);
        ctf.setMinimizeVisible(true);
        MPerspective persp = this.modelService.getPerspectiveFor(element);
        if (persp != null && persp.getTags().contains("EAMaximized")) {
            ctf.setMaximized(true);
        }
        CTabItem cti = new CTabItem(ctf, 0);
        if (areaModel.getLabel() != null) {
            cti.setText(areaModel.getLabel());
        }
        if (areaModel.getTooltip() != null) {
            cti.setToolTipText(areaModel.getTooltip());
        }
        if (areaModel.getIconURI() != null) {
            cti.setImage(this.getImage((MUILabel)areaModel));
        }
        Composite areaComp = new Composite((Composite)ctf, 0);
        SashLayout sl = new SashLayout(areaComp, null);
        areaComp.setLayout((Layout)sl);
        cti.setControl((Control)areaComp);
        ctf.setSelection(cti);
        return ctf;
    }

    @Override
    public void childRendered(MElementContainer<MUIElement> parentElement, MUIElement element) {
        if (!(parentElement.getWidget() instanceof CTabFolder)) {
            return;
        }
        super.childRendered(parentElement, element);
        CTabFolder ctf = (CTabFolder)parentElement.getWidget();
        Composite layoutComp = (Composite)ctf.getItem(0).getControl();
        SashLayout sl = (SashLayout)layoutComp.getLayout();
        sl.setRootElemenr(element);
        layoutComp.layout(true, true);
    }

    public Object getUIContainer(MUIElement element) {
        MElementContainer parentElement = element.getParent();
        if (!(parentElement instanceof MArea) || !(parentElement.getWidget() instanceof CTabFolder)) {
            return null;
        }
        CTabFolder ctf = (CTabFolder)parentElement.getWidget();
        return ctf.getItem(0).getControl();
    }
}

