/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.renderers.swt;

import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.contributions.IContributionFactory;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.renderers.swt.SWTPartRenderer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

public class ContributedPartRenderer
extends SWTPartRenderer {
    private MUIElement partToActivate;

    public Object createWidget(final MUIElement element, Object parent) {
        if (!(element instanceof MPart) || !(parent instanceof Composite)) {
            return null;
        }
        Widget parentWidget = (Widget)parent;
        Composite newWidget = null;
        Composite newComposite = new Composite((Composite)parentWidget, 0){

            public boolean setFocus() {
                MPart part = (MPart)element;
                Object object = part.getObject();
                if (object != null) {
                    ContextInjectionFactory.invoke((Object)object, Focus.class, (IEclipseContext)part.getContext(), null);
                    return true;
                }
                return super.setFocus();
            }
        };
        newComposite.setLayout((Layout)new FillLayout(512));
        newWidget = newComposite;
        this.bindWidget(element, newWidget);
        MPart part = (MPart)element;
        IEclipseContext localContext = part.getContext();
        localContext.set(Composite.class.getName(), (Object)newComposite);
        IContributionFactory contributionFactory = (IContributionFactory)localContext.get(IContributionFactory.class.getName());
        Object newPart = contributionFactory.create(part.getContributionURI(), localContext);
        part.setObject(newPart);
        return newWidget;
    }

    public static void setDescription(MPart part, String description) {
        if (!(part.getWidget() instanceof Composite)) {
            return;
        }
        Composite c = (Composite)part.getWidget();
        if (c.getChildren().length == 2) {
            Label label = (Label)c.getChildren()[0];
            if (description == null) {
                description = "";
            }
            label.setText(description);
            label.setToolTipText(description);
            c.layout();
        } else if (c.getChildren().length == 1) {
            c.setLayout(new Layout(){

                protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
                    return new Point(0, 0);
                }

                protected void layout(Composite composite, boolean flushCache) {
                    Rectangle bounds = composite.getBounds();
                    if (composite.getChildren().length == 1) {
                        composite.getChildren()[0].setBounds(composite.getBounds());
                    } else if (composite.getChildren().length == 2) {
                        Label label = (Label)composite.getChildren()[0];
                        Control partCtrl = composite.getChildren()[1];
                        int labelHeight = label.computeSize((int)bounds.width, (int)-1).y;
                        label.setBounds(0, 0, bounds.width, labelHeight);
                        partCtrl.setBounds(0, labelHeight, bounds.width, bounds.height - labelHeight);
                    }
                }
            });
            Control partCtrl = c.getChildren()[0];
            Label label = new Label(c, 0);
            label.setText(description);
            label.setToolTipText(description);
            label.moveAbove(partCtrl);
            c.layout();
        }
    }

    protected boolean requiresFocus(MPart element) {
        if (element == this.partToActivate) {
            return true;
        }
        return super.requiresFocus(element);
    }

    public void hookControllerLogic(final MUIElement me) {
        super.hookControllerLogic(me);
        if (!(me instanceof MPart)) {
            return;
        }
        Widget widget = (Widget)me.getWidget();
        if (widget instanceof Composite) {
            ((Composite)widget).addListener(26, new Listener(){

                public void handleEvent(Event event) {
                    try {
                        ContributedPartRenderer.this.partToActivate = me;
                        ContributedPartRenderer.this.activate((MPart)me);
                    }
                    finally {
                        ContributedPartRenderer.this.partToActivate = null;
                    }
                }
            });
        }
    }
}

