/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.renderers.swt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.contexts.RunAndTrack;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.e4.ui.internal.workbench.ContributionsAnalyzer;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MContext;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.MUILabel;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledItem;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuContribution;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuSeparator;
import org.eclipse.e4.ui.model.application.ui.menu.MPopupMenu;
import org.eclipse.e4.ui.workbench.IResourceUtilities;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.e4.ui.workbench.modeling.ExpressionContext;
import org.eclipse.e4.ui.workbench.renderers.swt.DirectContributionItem;
import org.eclipse.e4.ui.workbench.renderers.swt.HandledContributionItem;
import org.eclipse.e4.ui.workbench.renderers.swt.SWTPartRenderer;
import org.eclipse.e4.ui.workbench.swt.util.ISWTResourceUtilities;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MenuManagerRenderer
extends SWTPartRenderer {
    private static final String NO_LABEL = "UnLabled";
    private Map<MMenu, MenuManager> modelToManager = new HashMap<MMenu, MenuManager>();
    private Map<MenuManager, MMenu> managerToModel = new HashMap<MenuManager, MMenu>();
    private Map<MMenuItem, IContributionItem> modelToContribution = new HashMap<MMenuItem, IContributionItem>();
    private Map<MMenuElement, ContributionRecord> modelContributionToRecord = new HashMap<MMenuElement, ContributionRecord>();
    @Inject
    private Logger logger;
    @Inject
    private MApplication application;
    @Inject
    IEventBroker eventBroker;
    private EventHandler itemUpdater = new EventHandler(){

        public void handleEvent(Event event) {
            if (!(event.getProperty("ChangedElement") instanceof MMenuItem)) {
                return;
            }
            MMenuItem itemModel = (MMenuItem)event.getProperty("ChangedElement");
            IContributionItem ici = MenuManagerRenderer.this.getContribution((MMenuElement)itemModel);
            if (ici == null) {
                return;
            }
            String attName = (String)event.getProperty("AttName");
            if ("label".equals(attName)) {
                ici.update();
            } else if ("iconURI".equals(attName)) {
                ici.update();
            }
        }
    };
    private EventHandler toBeRenderedUpdater = new EventHandler(){

        public void handleEvent(Event event) {
            MMenuItem itemModel;
            Object element = event.getProperty("ChangedElement");
            String attName = (String)event.getProperty("AttName");
            if (element instanceof MMenuItem) {
                itemModel = (MMenuItem)element;
                if ("toBeRendered".equals(attName)) {
                    MElementContainer obj = itemModel.getParent();
                    if (!(obj instanceof MMenu)) {
                        return;
                    }
                    MenuManager parent = MenuManagerRenderer.this.getManager((MMenu)obj);
                    if (itemModel.isToBeRendered()) {
                        if (parent != null) {
                            MenuManagerRenderer.this.modelProcessSwitch(parent, (MMenuElement)itemModel);
                        }
                    } else {
                        IContributionItem ici = (IContributionItem)MenuManagerRenderer.this.modelToContribution.remove(itemModel);
                        if (ici != null && parent != null) {
                            parent.remove(ici);
                        }
                        if (ici != null) {
                            ici.dispose();
                        }
                    }
                }
            }
            if ("visible".equals(attName)) {
                if (element instanceof MMenu) {
                    MMenu menuModel = (MMenu)element;
                    MenuManager manager = MenuManagerRenderer.this.getManager(menuModel);
                    if (manager == null) {
                        return;
                    }
                    manager.setVisible(menuModel.isVisible());
                } else if (element instanceof MMenuElement) {
                    itemModel = (MMenuElement)element;
                    IContributionItem ici = MenuManagerRenderer.this.getContribution((MMenuElement)itemModel);
                    if (ici == null) {
                        return;
                    }
                    ici.setVisible(itemModel.isVisible());
                }
            }
        }
    };
    private EventHandler selectionUpdater = new EventHandler(){

        public void handleEvent(Event event) {
            if (!(event.getProperty("ChangedElement") instanceof MMenuItem)) {
                return;
            }
            MMenuItem itemModel = (MMenuItem)event.getProperty("ChangedElement");
            IContributionItem ici = (IContributionItem)MenuManagerRenderer.this.modelToContribution.get(itemModel);
            if (ici != null) {
                ici.update();
            }
        }
    };
    private EventHandler enabledUpdater = new EventHandler(){

        public void handleEvent(Event event) {
            if (!(event.getProperty("ChangedElement") instanceof MMenuItem)) {
                return;
            }
            MMenuItem itemModel = (MMenuItem)event.getProperty("ChangedElement");
            IContributionItem ici = (IContributionItem)MenuManagerRenderer.this.modelToContribution.get(itemModel);
            if (ici != null) {
                ici.update();
            }
        }
    };
    private IMenuListener visibilityCalculationListener = new IMenuListener(){

        public void menuAboutToShow(IMenuManager manager) {
            MenuManager menuManager = (MenuManager)manager;
            if (menuManager.getMenu() == null) {
                return;
            }
            MMenu menuModel = MenuManagerRenderer.this.getMenuModel(menuManager);
            if (menuModel == null) {
                Menu menu = menuManager.getMenu();
                Object obj = menu.getData("modelElement");
                if (obj == null && menu.getParentItem() != null) {
                    obj = menu.getParentItem().getData("modelElement");
                }
                if (!(obj instanceof MMenu)) {
                    return;
                }
                menuModel = (MMenu)obj;
            } else if (menuModel.getWidget() == null) {
                MenuManagerRenderer.this.bindWidget((MUIElement)menuModel, menuManager.getMenu());
            }
            IEclipseContext evalContext = menuModel instanceof MContext ? ((MContext)menuModel).getContext() : MenuManagerRenderer.this.modelService.getContainingContext((MUIElement)menuModel);
            HashSet<ContributionRecord> records = new HashSet<ContributionRecord>();
            for (MMenuElement element : menuModel.getChildren()) {
                ContributionRecord record = (ContributionRecord)MenuManagerRenderer.this.modelContributionToRecord.get(element);
                if (record == null || !records.add(record)) continue;
                record.updateVisibility(evalContext);
            }
        }
    };

    @PostConstruct
    public void init() {
        this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/ui/UILabel"), this.itemUpdater);
        this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/menu/Item", (String)"selected"), this.selectionUpdater);
        this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/menu/Item", (String)"enabled"), this.enabledUpdater);
        this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/ui/UIElement"), this.toBeRenderedUpdater);
    }

    @PreDestroy
    public void contextDisposed() {
        this.eventBroker.unsubscribe(this.itemUpdater);
        this.eventBroker.unsubscribe(this.selectionUpdater);
        this.eventBroker.unsubscribe(this.enabledUpdater);
        this.eventBroker.unsubscribe(this.toBeRenderedUpdater);
    }

    public Object createWidget(MUIElement element, Object parent) {
        if (!(element instanceof MMenu)) {
            return null;
        }
        final MMenu menuModel = (MMenu)element;
        Menu newMenu = null;
        boolean menuBar = false;
        if (parent instanceof Decorations) {
            MUIElement container = (MUIElement)((EObject)element).eContainer();
            if (container instanceof MWindow) {
                MenuManager menuBarManager = this.getManager(menuModel);
                if (menuBarManager == null) {
                    menuBarManager = new MenuManager(NO_LABEL, menuModel.getElementId());
                    this.linkModelToManager(menuModel, menuBarManager);
                }
                newMenu = menuBarManager.createMenuBar((Decorations)parent);
                ((Decorations)parent).setMenuBar(newMenu);
                newMenu.setData((Object)menuBarManager);
                menuBar = true;
            } else {
                MenuManager popupManager = this.getManager(menuModel);
                if (popupManager == null) {
                    popupManager = new MenuManager(NO_LABEL, menuModel.getElementId());
                    this.linkModelToManager(menuModel, popupManager);
                }
                newMenu = popupManager.createContextMenu((Control)parent);
                ((Control)parent).setMenu(newMenu);
                newMenu.setData((Object)popupManager);
            }
        } else if (parent instanceof Menu) {
            this.logger.debug((Throwable)new Exception(), "Trying to render a sub menu " + menuModel + "\n\t" + parent);
        } else if (parent instanceof Control) {
            MenuManager popupManager = this.getManager(menuModel);
            if (popupManager == null) {
                popupManager = new MenuManager(NO_LABEL, menuModel.getElementId());
                this.linkModelToManager(menuModel, popupManager);
            }
            newMenu = popupManager.createContextMenu((Control)parent);
            ((Control)parent).setMenu(newMenu);
            newMenu.setData((Object)popupManager);
        }
        this.processContributions(menuModel, menuBar);
        if (newMenu != null) {
            newMenu.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    MenuManagerRenderer.this.cleanUp(menuModel);
                }
            });
        }
        return newMenu;
    }

    protected void cleanUp(MMenu menuModel) {
        Collection<ContributionRecord> vals = this.modelContributionToRecord.values();
        ContributionRecord[] contributionRecordArray = vals.toArray(new ContributionRecord[vals.size()]);
        int n = contributionRecordArray.length;
        int n2 = 0;
        while (n2 < n) {
            ContributionRecord record = contributionRecordArray[n2];
            if (record.menuModel == menuModel) {
                record.dispose();
                for (MMenuElement copy : record.generatedElements) {
                    this.modelContributionToRecord.remove(copy);
                    if (copy instanceof MMenu) {
                        MMenu menuCopy = (MMenu)copy;
                        this.cleanUp(menuCopy);
                        MenuManager copyManager = this.getManager(menuCopy);
                        this.clearModelToManager(menuCopy, copyManager);
                        if (copyManager == null) continue;
                        copyManager.dispose();
                        continue;
                    }
                    IContributionItem ici = this.modelToContribution.remove(copy);
                    if (ici == null) continue;
                    record.manager.remove(ici);
                }
                record.generatedElements.clear();
            }
            ++n2;
        }
    }

    private void processContributions(MMenu menuModel, boolean menuBar) {
        ArrayList<MMenuContribution> toContribute = new ArrayList<MMenuContribution>();
        ContributionsAnalyzer.XXXgatherMenuContributions((MMenu)menuModel, (List)this.application.getMenuContributions(), (String)menuModel.getElementId(), toContribute, null, (boolean)(menuModel instanceof MPopupMenu));
        this.generateContributions(menuModel, toContribute, menuBar);
    }

    private void generateContributions(MMenu menuModel, ArrayList<MMenuContribution> toContribute, boolean menuBar) {
        HashSet<String> existingMenuIds = new HashSet<String>();
        HashSet<String> existingSeparatorNames = new HashSet<String>();
        for (MMenuElement child : menuModel.getChildren()) {
            String elementId = child.getElementId();
            if (child instanceof MMenu && elementId != null) {
                existingMenuIds.add(elementId);
                continue;
            }
            if (!(child instanceof MMenuSeparator) || elementId == null) continue;
            existingSeparatorNames.add(elementId);
        }
        MenuManager manager = this.getManager(menuModel);
        boolean done = toContribute.size() == 0;
        while (!done) {
            ArrayList<MMenuContribution> curList = new ArrayList<MMenuContribution>(toContribute);
            int retryCount = toContribute.size();
            toContribute.clear();
            for (MMenuContribution menuContribution : curList) {
                if (this.processAddition(menuModel, manager, menuContribution, existingMenuIds, existingSeparatorNames, menuBar)) continue;
                toContribute.add(menuContribution);
            }
            boolean bl = done = toContribute.size() == 0 || toContribute.size() == retryCount;
        }
    }

    private boolean processAddition(MMenu menuModel, final MenuManager manager, MMenuContribution menuContribution, HashSet<String> existingMenuIds, HashSet<String> existingSeparatorNames, boolean menuBar) {
        int idx = MenuManagerRenderer.getIndex(menuModel, menuContribution.getPositionInParent());
        if (idx == -1) {
            return false;
        }
        final ContributionRecord record = new ContributionRecord(menuModel, menuContribution, manager);
        record.generate();
        for (MMenuElement copy : record.generatedElements) {
            this.modelContributionToRecord.put(copy, record);
            if (copy instanceof MMenu && existingMenuIds.contains(copy.getElementId()) || copy instanceof MMenuSeparator && existingSeparatorNames.contains(copy.getElementId())) continue;
            menuModel.getChildren().add(idx++, copy);
            if (copy instanceof MMenu && copy.getElementId() != null) {
                existingMenuIds.add(copy.getElementId());
                continue;
            }
            if (!(copy instanceof MMenuSeparator) || copy.getElementId() == null) continue;
            existingSeparatorNames.add(copy.getElementId());
        }
        if (menuBar && menuContribution.getVisibleWhen() != null) {
            final IEclipseContext parentContext = this.modelService.getContainingContext((MUIElement)menuModel);
            parentContext.runAndTrack(new RunAndTrack(){

                public boolean changed(IEclipseContext context) {
                    record.updateVisibility(parentContext.getActiveLeaf());
                    manager.update(true);
                    return true;
                }
            });
        }
        return true;
    }

    private static int getIndex(MElementContainer<?> menuModel, String positionInParent) {
        String id = null;
        String modifier = null;
        if (positionInParent != null && positionInParent.length() > 0) {
            String[] array = positionInParent.split("=");
            modifier = array[0];
            id = array[1];
        }
        if (id == null) {
            return menuModel.getChildren().size();
        }
        int idx = 0;
        int size = menuModel.getChildren().size();
        while (idx < size) {
            if (id.equals(((MUIElement)menuModel.getChildren().get(idx)).getElementId())) {
                if ("after".equals(modifier)) {
                    ++idx;
                }
                return idx;
            }
            ++idx;
        }
        return id.equals("additions") ? menuModel.getChildren().size() : -1;
    }

    void removeMenuContributions(MMenu menuModel, ArrayList<MMenuElement> menuContributionsToRemove) {
        for (MMenuElement item : menuContributionsToRemove) {
            menuModel.getChildren().remove(item);
        }
    }

    @Override
    public void processContents(MElementContainer<MUIElement> container) {
        if (container == null) {
            return;
        }
        MenuManager parentManager = this.getManager((MMenu)container);
        if (parentManager == null) {
            return;
        }
        List parts = container.getChildren();
        if (parts != null) {
            MUIElement[] plist = parts.toArray(new MUIElement[parts.size()]);
            int i = 0;
            while (i < plist.length) {
                MUIElement childME = plist[i];
                this.modelProcessSwitch(parentManager, (MMenuElement)childME);
                ++i;
            }
        }
        parentManager.update(false);
    }

    private void processMenu(MenuManager parentManager, MMenu menuModel) {
        String menuText = this.getText(menuModel);
        ImageDescriptor desc = this.getImageDescriptor((MUILabel)menuModel);
        MenuManager menuManager = new MenuManager(menuText, desc, menuModel.getElementId());
        this.linkModelToManager(menuModel, menuManager);
        menuManager.setVisible(menuModel.isVisible());
        parentManager.add((IContributionItem)menuManager);
        this.processContributions(menuModel, false);
        List parts = menuModel.getChildren();
        if (parts != null) {
            MMenuElement[] plist = parts.toArray(new MMenuElement[parts.size()]);
            int i = 0;
            while (i < plist.length) {
                MMenuElement childME = plist[i];
                this.modelProcessSwitch(menuManager, childME);
                ++i;
            }
        }
    }

    void modelProcessSwitch(MenuManager menuManager, MMenuElement childME) {
        if (!childME.isToBeRendered()) {
            return;
        }
        if (childME instanceof MHandledMenuItem) {
            MHandledMenuItem itemModel = (MHandledMenuItem)childME;
            this.processHandledItem(menuManager, itemModel);
        } else if (childME instanceof MDirectMenuItem) {
            MDirectMenuItem itemModel = (MDirectMenuItem)childME;
            this.processDirectItem(menuManager, itemModel, null);
        } else if (childME instanceof MMenuSeparator) {
            MMenuSeparator sep = (MMenuSeparator)childME;
            this.processSeparator(menuManager, sep);
        } else if (childME instanceof MMenu) {
            MMenu itemModel = (MMenu)childME;
            this.processMenu(menuManager, itemModel);
        }
    }

    private void processSeparator(MenuManager menuManager, MMenuSeparator itemModel) {
        Separator marker = null;
        if (itemModel.isVisible()) {
            marker = new Separator();
            marker.setId(itemModel.getElementId());
        } else if (itemModel.getElementId() != null) {
            marker = new GroupMarker(itemModel.getElementId());
        }
        menuManager.add((IContributionItem)marker);
    }

    void processDirectItem(MenuManager parentManager, MDirectMenuItem itemModel, String id) {
        IEclipseContext lclContext = this.getContext((MUIElement)itemModel);
        DirectContributionItem ci = (DirectContributionItem)((Object)ContextInjectionFactory.make(DirectContributionItem.class, (IEclipseContext)lclContext));
        ci.setModel((MItem)itemModel);
        ci.setVisible(itemModel.isVisible());
        parentManager.add((IContributionItem)ci);
        this.modelToContribution.put((MMenuItem)itemModel, (IContributionItem)ci);
    }

    void processHandledItem(MenuManager parentManager, MHandledMenuItem itemModel) {
        IEclipseContext lclContext = this.getContext((MUIElement)itemModel);
        HandledContributionItem ci = (HandledContributionItem)((Object)ContextInjectionFactory.make(HandledContributionItem.class, (IEclipseContext)lclContext));
        ci.setModel((MHandledItem)itemModel);
        ci.setVisible(itemModel.isVisible());
        parentManager.add((IContributionItem)ci);
        this.modelToContribution.put((MMenuItem)itemModel, (IContributionItem)ci);
    }

    private String getText(MMenu menuModel) {
        String text = menuModel.getLabel();
        if (text == null || text.length() == 0) {
            return NO_LABEL;
        }
        return text;
    }

    private ImageDescriptor getImageDescriptor(MUILabel element) {
        IEclipseContext localContext = this.context;
        String iconURI = element.getIconURI();
        if (iconURI != null && iconURI.length() > 0) {
            ISWTResourceUtilities resUtils = (ISWTResourceUtilities)localContext.get(IResourceUtilities.class.getName());
            return (ImageDescriptor)resUtils.imageDescriptorFromURI(URI.createURI((String)iconURI));
        }
        return null;
    }

    public MenuManager getManager(MMenu model) {
        return this.modelToManager.get(model);
    }

    public MMenu getMenuModel(MenuManager manager) {
        return this.managerToModel.get(manager);
    }

    public void linkModelToManager(MMenu model, MenuManager manager) {
        this.modelToManager.put(model, manager);
        this.managerToModel.put(manager, model);
        manager.addMenuListener(this.visibilityCalculationListener);
    }

    public void clearModelToManager(MMenu model, MenuManager manager) {
        this.modelToManager.remove(model);
        this.managerToModel.remove(manager);
        if (manager != null) {
            manager.removeMenuListener(this.visibilityCalculationListener);
        }
    }

    public IContributionItem getContribution(MMenuElement model) {
        return this.modelToContribution.get(model);
    }

    static class ContributionRecord {
        MMenu menuModel;
        MMenuContribution menuContribution;
        ArrayList<MMenuElement> generatedElements = new ArrayList();
        MenuManager manager;

        public ContributionRecord(MMenu menuModel, MMenuContribution contribution, MenuManager manager) {
            this.menuModel = menuModel;
            this.menuContribution = contribution;
            this.manager = manager;
        }

        public void updateVisibility(IEclipseContext context) {
            ExpressionContext exprContext = new ExpressionContext(context);
            boolean isVisible = ContributionsAnalyzer.isVisible((MMenuContribution)this.menuContribution, (ExpressionContext)exprContext);
            for (MMenuElement item : this.generatedElements) {
                item.setVisible(isVisible);
            }
            this.manager.markDirty();
        }

        public void generate() {
            for (MMenuElement item : this.menuContribution.getChildren()) {
                MMenuElement copy = (MMenuElement)EcoreUtil.copy((EObject)((EObject)item));
                this.generatedElements.add(copy);
            }
        }

        public void dispose() {
            for (MMenuElement copy : this.generatedElements) {
                this.menuModel.getChildren().remove(copy);
            }
        }
    }
}

