/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.workbench;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.internal.workbench.PartServiceImpl;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MGenericStack;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MArea;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PartActivationHistory {
    private PartServiceImpl partService;
    private EModelService modelService;
    private LinkedList<MPart> generalActivationHistory = new LinkedList();

    PartActivationHistory(PartServiceImpl partService, EModelService modelService) {
        this.partService = partService;
        this.modelService = modelService;
    }

    public void clear() {
        this.generalActivationHistory.clear();
    }

    void activate(MPart part, boolean activateBranch) {
        IEclipseContext context = part.getContext();
        if (activateBranch) {
            context.activateBranch();
        } else {
            IEclipseContext parent = context.getParent();
            do {
                context.activate();
                context = parent;
            } while ((parent = parent.getParent()).get(MWindow.class) != null);
        }
        this.generalActivationHistory.remove(part);
        this.generalActivationHistory.addFirst(part);
    }

    private boolean isValid(MUIElement element) {
        if (element == null) {
            return false;
        }
        if (element instanceof MApplication) {
            return true;
        }
        MElementContainer parent = element.getParent();
        if (parent == null) {
            MPlaceholder placeholder = element.getCurSharedRef();
            if (placeholder == null) {
                return false;
            }
            parent = placeholder.getParent();
            if (parent == null || !placeholder.isToBeRendered() || !placeholder.isVisible()) {
                return false;
            }
        }
        return element.isToBeRendered() && element.isVisible() && this.isValid((MUIElement)parent);
    }

    boolean isValid(MPerspective perspective, MUIElement element) {
        if (element instanceof MApplication) {
            return true;
        }
        if (!element.isToBeRendered() || !element.isVisible()) {
            return false;
        }
        MElementContainer parent = element.getParent();
        if (parent == null) {
            for (MPlaceholder placeholder : this.modelService.findElements((MUIElement)perspective, null, MPlaceholder.class, null)) {
                if (placeholder.getRef() != element) continue;
                parent = placeholder.getParent();
                if (!placeholder.isToBeRendered() || !placeholder.isVisible() || parent == null) {
                    return false;
                }
                if (parent instanceof MGenericStack && parent.getSelectedElement() != placeholder) {
                    return false;
                }
                break;
            }
        } else if (parent instanceof MGenericStack && parent.getSelectedElement() != element) {
            return false;
        }
        return this.isValid(perspective, (MUIElement)parent);
    }

    private MArea isInArea(MUIElement element) {
        MPlaceholder placeholder = element.getCurSharedRef();
        if (placeholder == null) {
            MElementContainer parent = element.getParent();
            if (parent == null) {
                parent = (MUIElement)((EObject)element).eContainer();
            }
            return parent instanceof MApplication ? null : (parent instanceof MArea ? (MArea)parent : this.isInArea((MUIElement)parent));
        }
        MElementContainer parent = placeholder.getParent();
        if (parent == null) {
            parent = (MUIElement)((EObject)placeholder).eContainer();
        }
        return parent instanceof MApplication ? null : (parent instanceof MArea ? (MArea)parent : this.isInArea((MUIElement)parent));
    }

    private MPart getActivationCandidate(MPart part) {
        Collection<MPart> candidates = ((EPartService)part.getContext().get(EPartService.class)).getParts();
        for (MPart candidate : candidates) {
            MElementContainer parent;
            MPlaceholder placeholder;
            if (part == candidate || !candidate.isToBeRendered() || !candidate.isVisible() || (placeholder = candidate.getCurSharedRef()) != null && (!placeholder.isToBeRendered() || !placeholder.isVisible())) continue;
            MElementContainer mElementContainer = parent = placeholder == null ? candidate.getParent() : placeholder.getParent();
            if (!this.isValid((MUIElement)parent)) continue;
            if (parent instanceof MGenericStack) {
                MUIElement element = parent.getSelectedElement();
                if (element instanceof MPlaceholder) {
                    element = ((MPlaceholder)element).getRef();
                }
                if (element == part) {
                    return candidate;
                }
                return element instanceof MPart ? (MPart)element : candidate;
            }
            return candidate;
        }
        return null;
    }

    private MPart findActivationCandidate(Collection<MPart> candidates, MPart currentlyActivePart) {
        MPlaceholder activePlaceholder = this.partService.getLocalPlaceholder(currentlyActivePart);
        for (MPart candidate : candidates) {
            MUIElement selection;
            MElementContainer parent;
            if (candidate == currentlyActivePart || !candidate.isToBeRendered() || !candidate.isVisible()) continue;
            MPlaceholder placeholder = this.partService.getLocalPlaceholder(candidate);
            if (placeholder == null) {
                parent = candidate.getParent();
                if (parent instanceof MGenericStack) {
                    selection = parent.getSelectedElement();
                    if (selection != candidate && selection != activePlaceholder && selection != currentlyActivePart) continue;
                    return candidate;
                }
                return candidate;
            }
            if (!placeholder.isToBeRendered() || !placeholder.isVisible()) continue;
            parent = placeholder.getParent();
            if (parent instanceof MGenericStack) {
                selection = parent.getSelectedElement();
                if (selection != placeholder && selection != activePlaceholder && selection != currentlyActivePart) continue;
                return candidate;
            }
            return candidate;
        }
        return null;
    }

    MPart getNextActivationCandidate(MPart part) {
        MPart candidate;
        MArea area = this.isInArea((MUIElement)part);
        if (area != null) {
            candidate = this.getSiblingActivationCandidate(part);
            if (candidate != null) {
                return candidate;
            }
            candidate = this.findActivationCandidate(this.modelService.findElements((MUIElement)area, null, MPart.class, null), part);
            if (candidate != null) {
                return candidate;
            }
        }
        return (candidate = this.findActivationCandidate(this.generalActivationHistory, part)) == null ? this.getActivationCandidate(part) : candidate;
    }

    void forget(MWindow window, MPart part, boolean full) {
        if (full) {
            this.generalActivationHistory.remove(part);
        } else {
            for (MPlaceholder placeholder : this.modelService.findElements((MUIElement)window, null, MPlaceholder.class, null)) {
                if (placeholder.getRef() != part || !placeholder.isToBeRendered()) continue;
                return;
            }
            this.generalActivationHistory.remove(part);
        }
    }

    MPart getActivationCandidate(MPerspective perspective) {
        for (MPart candidate : this.generalActivationHistory) {
            if (!this.partService.isInContainer((MElementContainer<?>)perspective, (MUIElement)candidate) || !this.isValid(perspective, (MUIElement)candidate)) continue;
            return candidate;
        }
        Collection<MPart> candidates = ((EPartService)perspective.getContext().get(EPartService.class)).getParts();
        for (MPart candidate : candidates) {
            if (!this.isValid(perspective, (MUIElement)candidate)) continue;
            return candidate;
        }
        return null;
    }

    private MPart getSiblingActivationCandidate(MPart part) {
        MPlaceholder placeholder = part.getCurSharedRef();
        MUIElement candidate = this.getSiblingSelectionCandidate(part, (MUIElement)(placeholder == null ? part : placeholder));
        return (MPart)(candidate instanceof MPlaceholder ? ((MPlaceholder)candidate).getRef() : candidate);
    }

    private MUIElement getSiblingSelectionCandidate(MPart part, MUIElement element) {
        List siblings = element.getParent().getChildren();
        for (MPart previouslyActivatedPart : this.generalActivationHistory) {
            if (previouslyActivatedPart == part || !previouslyActivatedPart.isToBeRendered()) continue;
            if (siblings.contains(previouslyActivatedPart)) {
                return previouslyActivatedPart;
            }
            MPlaceholder placeholder = this.partService.getLocalPlaceholder(previouslyActivatedPart);
            if (placeholder == null || !placeholder.isToBeRendered() || !siblings.contains(placeholder)) continue;
            return placeholder;
        }
        return null;
    }

    MUIElement getSiblingSelectionCandidate(MPart part) {
        MPlaceholder placeholder = part.getCurSharedRef();
        return this.getSiblingSelectionCandidate(part, (MUIElement)(placeholder == null ? part : placeholder));
    }
}

