/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.ds.impl;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.equinox.internal.ds.Activator;
import org.eclipse.equinox.internal.ds.InstanceProcess;
import org.eclipse.equinox.internal.ds.Messages;
import org.eclipse.equinox.internal.ds.Reference;
import org.eclipse.equinox.internal.ds.SCRManager;
import org.eclipse.equinox.internal.ds.impl.ComponentInstanceImpl;
import org.eclipse.equinox.internal.ds.impl.ReadOnlyDictionary;
import org.eclipse.equinox.internal.ds.model.ComponentReference;
import org.eclipse.equinox.internal.ds.model.ServiceComponent;
import org.eclipse.equinox.internal.ds.model.ServiceComponentProp;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.ComponentException;
import org.osgi.service.component.ComponentInstance;

public class ComponentContextImpl
implements ComponentContext {
    private ComponentInstanceImpl componentInstance;
    private ServiceComponentProp scp;
    private Bundle usingBundle;
    private SCRManager mgr;
    private ReadOnlyDictionary props;

    public ComponentContextImpl(ServiceComponentProp scp, Bundle usingBundle, ComponentInstanceImpl ci, SCRManager mgr) {
        this.scp = scp;
        this.componentInstance = ci;
        this.usingBundle = usingBundle;
        this.mgr = mgr;
    }

    public Dictionary getProperties() {
        if (this.props == null) {
            this.props = new ReadOnlyDictionary((Hashtable)this.scp.getProperties());
        } else if (this.props.delegate != this.scp.getProperties()) {
            this.props.delegate = (Hashtable)this.scp.getProperties();
        }
        return this.props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object locateService(String name) {
        if (this.scp.references == null) {
            return null;
        }
        if (Activator.DEBUG) {
            Activator.log.debug("ComponentContextImpl.locateService(): " + name, null);
        }
        Vector references = this.scp.references;
        int i = 0;
        while (i < references.size()) {
            Reference reference = (Reference)references.elementAt(i);
            ComponentReference ref = reference.reference;
            if (ref.name.equals(name)) {
                ServiceReference serviceReference = null;
                Hashtable hashtable = ref.serviceReferences;
                synchronized (hashtable) {
                    if (ref.serviceReferences.size() == 1) {
                        serviceReference = (ServiceReference)ref.serviceReferences.keys().nextElement();
                    }
                }
                try {
                    if (serviceReference == null) {
                        ServiceReference[] serviceReferences;
                        Vector boundServiceReferences = reference.getBoundServiceReferences();
                        if (reference.isUnary() && boundServiceReferences.size() > 0) {
                            serviceReference = (ServiceReference)boundServiceReferences.elementAt(0);
                        }
                        if (serviceReference == null && (serviceReferences = this.scp.bc.getServiceReferences(ref.interfaceName, reference.getTarget())) != null && serviceReferences.length > 0) {
                            serviceReference = serviceReferences[0];
                        }
                    }
                    if (serviceReference != null) {
                        return this.getBoundService(reference, serviceReference);
                    }
                }
                catch (Throwable t) {
                    if (t instanceof ComponentException) {
                        throw (ComponentException)t;
                    }
                    throw new ComponentException(NLS.bind((String)Messages.EXCEPTION_LOCATING_SERVICE, (Object)name), t);
                }
                if (Activator.DEBUG) {
                    Activator.log.debug("ComponentContextImpl.locateService(): error, service not found - " + ref.interfaceName + "; the comp. context belongs to " + this.scp.name, null);
                }
            }
            ++i;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] locateServices(String name) {
        if (this.scp.references == null) {
            return null;
        }
        if (Activator.DEBUG) {
            Activator.log.debug("ComponentContextImpl.locateServices(): " + name, null);
        }
        Vector references = this.scp.references;
        int i = 0;
        while (i < references.size()) {
            Reference reference = (Reference)references.elementAt(i);
            ComponentReference ref = reference.reference;
            if (ref.name.equals(name)) {
                ServiceReference[] serviceReferences = null;
                try {
                    if (reference.isUnary()) {
                        Object result;
                        Vector boundServiceReferences;
                        ServiceReference serviceReference = null;
                        Hashtable hashtable = ref.serviceReferences;
                        synchronized (hashtable) {
                            if (ref.serviceReferences.size() > 0) {
                                serviceReference = (ServiceReference)ref.serviceReferences.keys().nextElement();
                            }
                        }
                        if (serviceReference == null && (boundServiceReferences = reference.getBoundServiceReferences()).size() > 0) {
                            serviceReference = (ServiceReference)boundServiceReferences.elementAt(0);
                        }
                        if (serviceReference != null && (result = this.getBoundService(reference, serviceReference)) != null) {
                            return new Object[]{result};
                        }
                    }
                    if ((serviceReferences = this.scp.bc.getServiceReferences(ref.interfaceName, reference.getTarget())) != null) {
                        Vector<Object> theServices = new Vector<Object>(5);
                        int j = 0;
                        while (j < serviceReferences.length) {
                            Object service = this.getBoundService(reference, serviceReferences[j]);
                            if (service != null) {
                                theServices.addElement(service);
                            }
                            ++j;
                        }
                        if (!theServices.isEmpty()) {
                            return theServices.toArray();
                        }
                    }
                }
                catch (Throwable t) {
                    if (t instanceof ComponentException) {
                        throw (ComponentException)t;
                    }
                    throw new ComponentException(NLS.bind((String)Messages.EXCEPTION_LOCATING_SERVICES, (Object)name), t);
                }
            }
            ++i;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object locateService(String name, ServiceReference serviceReference) {
        if (this.scp.references == null) {
            return null;
        }
        if (Activator.DEBUG) {
            Activator.log.debug("ComponentContextImpl.locateService(): " + name + " by service reference : " + serviceReference, null);
        }
        Vector references = this.scp.references;
        try {
            int i = 0;
            while (true) {
                if (i >= references.size()) {
                    return null;
                }
                Reference reference = (Reference)references.elementAt(i);
                ComponentReference ref = reference.reference;
                if (ref.name.equals(name)) {
                    if (serviceReference != null) {
                        if (ref.serviceReferences.containsKey(serviceReference)) return this.getBoundService(reference, serviceReference);
                    }
                    if (!Activator.DEBUG) return null;
                    String referenceToString = serviceReference == null ? null : serviceReference.toString();
                    Activator.log.debug("ComponentContextImpl.locateService(): the specified service reference is not bound to the specified reference" + referenceToString, null);
                    return null;
                }
                ++i;
            }
        }
        catch (Throwable t) {
            if (!(t instanceof ComponentException)) throw new ComponentException(NLS.bind((String)Messages.EXCEPTION_LOCATING_SERVICE, (Object)name), t);
            throw (ComponentException)t;
        }
    }

    private Object getBoundService(Reference reference, ServiceReference theServiceReference) {
        Object result = this.componentInstance.bindedServices.get(theServiceReference);
        if (result != null) {
            return result;
        }
        result = InstanceProcess.staticRef.getService(reference, theServiceReference);
        if (result != null) {
            this.componentInstance.bindedServices.put(theServiceReference, result);
            return result;
        }
        return null;
    }

    public BundleContext getBundleContext() {
        return this.scp.bc;
    }

    public Bundle getUsingBundle() {
        ServiceComponent componentDescription = this.scp.serviceComponent;
        if (componentDescription.provides == null || !componentDescription.serviceFactory) {
            return null;
        }
        return this.usingBundle;
    }

    public ComponentInstance getComponentInstance() {
        return this.componentInstance;
    }

    public void enableComponent(String name) {
        this.mgr.enableComponent(name, this.scp.bc.getBundle());
    }

    public void disableComponent(String name) {
        if (name == null) {
            throw new IllegalArgumentException(Messages.COMPONENT_NAME_IS_NULL);
        }
        this.mgr.disableComponent(name, this.scp.bc.getBundle());
    }

    public ServiceReference getServiceReference() {
        ServiceRegistration reg;
        if (this.scp.serviceComponent.provides != null && (reg = this.scp.registration) != null) {
            return reg.getReference();
        }
        return null;
    }
}

