/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.callhierarchy;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.callhierarchy.CallHierarchyMessages;
import org.eclipse.jdt.internal.ui.callhierarchy.CallHierarchyViewPart;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.PlatformUI;

class HistoryAction
extends Action {
    private static long LABEL_FLAGS = JavaElementLabels.ALL_POST_QUALIFIED | 1L | 0x20L | 0x200000L;
    private CallHierarchyViewPart fView;
    private IMember[] fMembers;

    public HistoryAction(CallHierarchyViewPart viewPart, IMember[] members) {
        super("", 8);
        this.fView = viewPart;
        this.fMembers = members;
        String elementName = HistoryAction.getElementLabel(members);
        this.setText(elementName);
        this.setImageDescriptor(HistoryAction.getImageDescriptor(members));
        this.setDescription(Messages.format(CallHierarchyMessages.HistoryAction_description, elementName));
        this.setToolTipText(Messages.format(CallHierarchyMessages.HistoryAction_tooltip, elementName));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.call_hierarchy_history_action_context");
    }

    private static ImageDescriptor getImageDescriptor(IMember[] members) {
        JavaElementImageProvider imageProvider = new JavaElementImageProvider();
        ImageDescriptor desc = imageProvider.getBaseImageDescriptor((IJavaElement)members[0], 0);
        imageProvider.dispose();
        return desc;
    }

    public void run() {
        this.fView.gotoHistoryEntry(this.fMembers);
    }

    static String getElementLabel(IMember[] members) {
        switch (members.length) {
            case 0: {
                Assert.isTrue((boolean)false);
                return null;
            }
            case 1: {
                return Messages.format(CallHierarchyMessages.HistoryAction_inputElements_1, new String[]{HistoryAction.getShortLabel(members[0])});
            }
            case 2: {
                return Messages.format(CallHierarchyMessages.HistoryAction_inputElements_2, new String[]{HistoryAction.getShortLabel(members[0]), HistoryAction.getShortLabel(members[1])});
            }
        }
        return Messages.format(CallHierarchyMessages.HistoryAction_inputElements_more, new String[]{HistoryAction.getShortLabel(members[0]), HistoryAction.getShortLabel(members[1])});
    }

    private static String getShortLabel(IMember member) {
        return JavaElementLabels.getElementLabel((IJavaElement)member, LABEL_FLAGS | 0x80000000000000L);
    }
}

