/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IImportContainer;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.filters.EmptyLibraryContainerFilter;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditorBreadcrumbActionGroup;
import org.eclipse.jdt.internal.ui.javaeditor.breadcrumb.BreadcrumbViewer;
import org.eclipse.jdt.internal.ui.javaeditor.breadcrumb.EditorBreadcrumb;
import org.eclipse.jdt.internal.ui.packageview.ClassPathContainer;
import org.eclipse.jdt.internal.ui.packageview.LibraryContainer;
import org.eclipse.jdt.internal.ui.packageview.PackageFragmentRootContainer;
import org.eclipse.jdt.internal.ui.util.JavaUIHelp;
import org.eclipse.jdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.jdt.internal.ui.viewsupport.DecoratingJavaLabelProvider;
import org.eclipse.jdt.internal.ui.viewsupport.JavaUILabelProvider;
import org.eclipse.jdt.internal.ui.viewsupport.ResourceToItemsMapper;
import org.eclipse.jdt.ui.IWorkingCopyProvider;
import org.eclipse.jdt.ui.JavaElementComparator;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.ProblemsLabelDecorator;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.texteditor.ITextEditor;

public class JavaEditorBreadcrumb
extends EditorBreadcrumb {
    private static final boolean SHOW_LIBRARIES_NODE = true;
    private ActionGroup fBreadcrumbActionGroup;
    private BreadcrumbViewer fViewer;
    private ISelection fEditorSelection;
    private ElementChangeListener fElementChangeListener;

    public JavaEditorBreadcrumb(JavaEditor javaEditor) {
        super((ITextEditor)javaEditor);
        this.setTextViewer((ITextViewer)javaEditor.getViewer());
    }

    protected void activateBreadcrumb() {
        this.fEditorSelection = this.getJavaEditor().getSelectionProvider().getSelection();
        IEditorSite editorSite = this.getJavaEditor().getEditorSite();
        editorSite.getKeyBindingService().setScopes(new String[]{"org.eclipse.jdt.ui.breadcrumbEditorScope"});
        this.getJavaEditor().setActionsActivated(false);
        this.fBreadcrumbActionGroup.fillActionBars(editorSite.getActionBars());
    }

    protected void deactivateBreadcrumb() {
        IEditorSite editorSite = this.getJavaEditor().getEditorSite();
        editorSite.getKeyBindingService().setScopes(new String[]{"org.eclipse.jdt.ui.javaEditorScope"});
        this.getJavaEditor().getActionGroup().fillActionBars(editorSite.getActionBars());
        this.getJavaEditor().setActionsActivated(true);
        this.fEditorSelection = null;
    }

    protected BreadcrumbViewer createViewer(Composite composite) {
        this.fViewer = new ProblemBreadcrumbViewer(composite, 256);
        this.fViewer.setLabelProvider((IBaseLabelProvider)JavaEditorBreadcrumb.createLabelProvider());
        this.fViewer.setToolTipLabelProvider(this.createToolTipLabelProvider());
        this.fViewer.setContentProvider((IContentProvider)JavaEditorBreadcrumb.createContentProvider());
        this.fViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                JavaEditorBreadcrumb.this.fBreadcrumbActionGroup.setContext(new ActionContext(JavaEditorBreadcrumb.this.fViewer.getSelection()));
            }
        });
        this.fBreadcrumbActionGroup = new JavaEditorBreadcrumbActionGroup(this.getJavaEditor(), (ISelectionProvider)this.fViewer);
        this.fElementChangeListener = new ElementChangeListener();
        JavaCore.addElementChangedListener((IElementChangedListener)this.fElementChangeListener);
        JavaUIHelp.setHelp(this.fViewer, "org.eclipse.jdt.ui.java_editor_breadcrumb_context");
        return this.fViewer;
    }

    private static JavaEditorBreadcrumbContentProvider createContentProvider() {
        StandardJavaElementContentProvider parentContentProvider = new StandardJavaElementContentProvider(true);
        return new JavaEditorBreadcrumbContentProvider(parentContentProvider);
    }

    private static JavaEditorBreadcrumbContentProvider createDropDownContentProvider() {
        StandardJavaElementContentProvider parentContentProvider = new StandardJavaElementContentProvider(true){

            public Object[] getChildren(Object element) {
                if (element instanceof PackageFragmentRootContainer) {
                    return this.getContainerPackageFragmentRoots((PackageFragmentRootContainer)element);
                }
                return super.getChildren(element);
            }

            protected Object[] getPackageFragmentRoots(IJavaProject project) throws JavaModelException {
                IClasspathEntry classpathEntry;
                if (!project.getProject().isOpen()) {
                    return NO_CHILDREN;
                }
                ArrayList<Object> result = new ArrayList<Object>();
                IPackageFragmentRoot[] roots = project.getPackageFragmentRoots();
                int i = 0;
                while (i < roots.length) {
                    IPackageFragmentRoot root = roots[i];
                    classpathEntry = JavaModelUtil.getClasspathEntry(root);
                    int entryKind = classpathEntry.getEntryKind();
                    if (entryKind != 5 && entryKind != 1 && entryKind != 4) {
                        if (this.isProjectPackageFragmentRoot(root)) {
                            Object[] fragments = this.getPackageFragmentRootContent(root);
                            int j = 0;
                            while (j < fragments.length) {
                                result.add(fragments[j]);
                                ++j;
                            }
                        } else {
                            result.add(root);
                        }
                    }
                    ++i;
                }
                result.add(new LibraryContainer(project));
                IClasspathEntry[] rawClasspath = project.getRawClasspath();
                int i2 = 0;
                while (i2 < rawClasspath.length) {
                    classpathEntry = rawClasspath[i2];
                    if (classpathEntry.getEntryKind() == 5) {
                        result.add(new ClassPathContainer(project, classpathEntry));
                    }
                    ++i2;
                }
                Object[] resources = project.getNonJavaResources();
                int i3 = 0;
                while (i3 < resources.length) {
                    result.add(resources[i3]);
                    ++i3;
                }
                return result.toArray();
            }

            private Object[] getContainerPackageFragmentRoots(PackageFragmentRootContainer container) {
                return container.getChildren();
            }

            protected Object internalGetParent(Object element) {
                if (element instanceof IPackageFragmentRoot) {
                    IPackageFragmentRoot root = (IPackageFragmentRoot)element;
                    try {
                        IClasspathEntry entry = root.getRawClasspathEntry();
                        int entryKind = entry.getEntryKind();
                        if (entryKind == 5) {
                            return new ClassPathContainer(root.getJavaProject(), entry);
                        }
                        if (entryKind == 1 || entryKind == 4) {
                            return new LibraryContainer(root.getJavaProject());
                        }
                    }
                    catch (JavaModelException javaModelException) {}
                } else if (element instanceof PackageFragmentRootContainer) {
                    return ((PackageFragmentRootContainer)element).getJavaProject();
                }
                return super.internalGetParent(element);
            }
        };
        return new JavaEditorBreadcrumbContentProvider(parentContentProvider);
    }

    private static ILabelProvider createLabelProvider() {
        final AppearanceAwareLabelProvider result = new AppearanceAwareLabelProvider(0x10000204029L | JavaElementLabels.ALL_CATEGORY, 3);
        return new DecoratingJavaLabelProvider((JavaUILabelProvider)result){

            public String getText(Object element) {
                IPackageFragmentRoot root;
                if (element instanceof IPackageFragmentRoot && (root = (IPackageFragmentRoot)element).isArchive() && root.isExternal()) {
                    return JavaElementLabels.getElementLabel((IJavaElement)root, JavaElementLabels.ALL_DEFAULT);
                }
                return result.getText(element);
            }

            protected StyledString getStyledText(Object element) {
                return new StyledString(this.getText(element));
            }
        };
    }

    private ILabelProvider createToolTipLabelProvider() {
        AppearanceAwareLabelProvider result = new AppearanceAwareLabelProvider(0x210000204029L | JavaElementLabels.ALL_CATEGORY, 3);
        return new DecoratingJavaLabelProvider(result);
    }

    public void dispose() {
        super.dispose();
        if (this.fViewer != null) {
            this.fBreadcrumbActionGroup.dispose();
            JavaCore.removeElementChangedListener((IElementChangedListener)this.fElementChangeListener);
            this.fViewer = null;
        }
    }

    protected ActionGroup createContextMenuActionGroup(ISelectionProvider selectionProvider) {
        return new JavaEditorBreadcrumbActionGroup(this.getJavaEditor(), selectionProvider);
    }

    public void setInput(Object element) {
        if (element == null && (element = this.getCurrentInput()) instanceof IType) {
            element = ((IType)element).getDeclaringType();
        }
        if (element instanceof IJavaElement) {
            super.setInput(this.getInput((IJavaElement)element));
        } else {
            super.setInput(element);
        }
    }

    protected Object getCurrentInput() {
        ITypeRoot input;
        block3: {
            try {
                input = SelectionConverter.getInput(this.getJavaEditor());
                if (input != null) break block3;
                return null;
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
                return null;
            }
        }
        ITextSelection selection = this.fEditorSelection instanceof ITextSelection ? (ITextSelection)this.fEditorSelection : (ITextSelection)this.getJavaEditor().getSelectionProvider().getSelection();
        return this.getInput(SelectionConverter.getElementAtOffset(input, selection));
    }

    private IJavaElement getInput(IJavaElement element) {
        try {
            IType[] types;
            if (element instanceof IImportDeclaration) {
                element = element.getParent();
            }
            if (element instanceof IImportContainer) {
                element = element.getParent();
            }
            if (element instanceof IPackageDeclaration) {
                element = element.getParent();
            }
            if (element instanceof ICompilationUnit && (types = ((ICompilationUnit)element).getTypes()).length > 0) {
                element = types[0];
            }
            if (element instanceof IClassFile) {
                element = ((IClassFile)element).getType();
            }
            return element;
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
            return null;
        }
    }

    protected boolean open(Object element) {
        if (element instanceof IFile) {
            return this.openInNewEditor(element);
        }
        if (element instanceof IJarEntryResource) {
            if (((IJarEntryResource)element).isFile()) {
                return this.openInNewEditor(element);
            }
            return false;
        }
        if (!(element instanceof IJavaElement)) {
            return false;
        }
        IJavaElement javaElement = (IJavaElement)element;
        ITypeRoot root = (ITypeRoot)javaElement.getAncestor(5);
        if (root == null) {
            root = (ITypeRoot)javaElement.getAncestor(6);
        }
        if (root == null) {
            return false;
        }
        return this.openInNewEditor(element);
    }

    protected boolean reveal(Object element) {
        if (!(element instanceof IJavaElement)) {
            return false;
        }
        IJavaElement javaElement = (IJavaElement)element;
        ITypeRoot inputElement = EditorUtility.getEditorInputJavaElement((IEditorPart)this.getJavaEditor(), false);
        ITypeRoot root = (ITypeRoot)javaElement.getAncestor(5);
        if (root == null) {
            root = (ITypeRoot)javaElement.getAncestor(6);
        }
        if (root == null) {
            return false;
        }
        if (!root.equals(inputElement)) {
            return false;
        }
        return this.revealInEditor(javaElement);
    }

    private boolean openInNewEditor(Object element) {
        try {
            IEditorPart newEditor = EditorUtility.openInEditor(element);
            if (newEditor != null && element instanceof IJavaElement) {
                EditorUtility.revealInEditor(newEditor, (IJavaElement)element);
            }
            return true;
        }
        catch (PartInitException e) {
            JavaPlugin.log(e);
            return false;
        }
    }

    private boolean revealInEditor(IJavaElement element) {
        EditorUtility.revealInEditor((IEditorPart)this.getJavaEditor(), element);
        return true;
    }

    private JavaEditor getJavaEditor() {
        return (JavaEditor)this.getTextEditor();
    }

    static /* synthetic */ IJavaElement access$2(JavaEditorBreadcrumb javaEditorBreadcrumb, IJavaElement iJavaElement) {
        return javaEditorBreadcrumb.getInput(iJavaElement);
    }

    private class ElementChangeListener
    implements IElementChangedListener {
        private Runnable fRunnable;

        private ElementChangeListener() {
        }

        public void elementChanged(ElementChangedEvent event) {
            if (JavaEditorBreadcrumb.this.fViewer == null) {
                return;
            }
            Object input = JavaEditorBreadcrumb.this.fViewer.getInput();
            if (!(input instanceof IJavaElement)) {
                return;
            }
            if (this.fRunnable != null) {
                return;
            }
            IJavaElement changedElement = this.getChangedParentElement((IJavaElement)input, event.getDelta());
            if (changedElement == null) {
                return;
            }
            this.fRunnable = new Runnable(this){
                final /* synthetic */ ElementChangeListener this$1;
                {
                    this.this$1 = elementChangeListener;
                }

                public void run() {
                    if (JavaEditorBreadcrumb.access$1(ElementChangeListener.access$2(this.this$1)) == null) {
                        return;
                    }
                    Object newInput = ElementChangeListener.access$2(this.this$1).getCurrentInput();
                    if (newInput instanceof IJavaElement) {
                        newInput = JavaEditorBreadcrumb.access$2(ElementChangeListener.access$2(this.this$1), (IJavaElement)newInput);
                    }
                    JavaEditorBreadcrumb.access$1(ElementChangeListener.access$2(this.this$1)).setInput(newInput);
                    ElementChangeListener.access$0(this.this$1, null);
                }
            };
            JavaEditorBreadcrumb.this.fViewer.getControl().getDisplay().asyncExec(this.fRunnable);
        }

        private IJavaElement getChangedParentElement(IJavaElement input, IJavaElementDelta delta) {
            IJavaElement element = delta.getElement();
            if (!this.isAncestor(element, input)) {
                return null;
            }
            if (element instanceof ICompilationUnit) {
                ICompilationUnit cu = (ICompilationUnit)element;
                if (!cu.getPrimary().equals(cu)) {
                    return null;
                }
                if (this.isStructuralChange(delta)) {
                    return element;
                }
            } else if (!this.onlyChildrenChanged(delta)) {
                return element;
            }
            IJavaElementDelta[] affectedChildren = delta.getAffectedChildren();
            int i = 0;
            while (i < affectedChildren.length) {
                IJavaElement res = this.getChangedParentElement(input, affectedChildren[i]);
                if (res != null) {
                    return res;
                }
                ++i;
            }
            return null;
        }

        private boolean isAncestor(IJavaElement element, IJavaElement input) {
            while (input != null && !input.equals(element)) {
                input = input.getParent();
            }
            return input != null;
        }

        private boolean isStructuralChange(IJavaElementDelta delta) {
            if (delta.getKind() != 4) {
                return true;
            }
            return (delta.getFlags() & 1 | 0x4000) == 1;
        }

        private boolean onlyChildrenChanged(IJavaElementDelta delta) {
            if (delta.getKind() != 4) {
                return false;
            }
            return (delta.getFlags() & 0xFFFFBFFF) == 8;
        }

        static /* synthetic */ void access$0(ElementChangeListener elementChangeListener, Runnable runnable) {
            elementChangeListener.fRunnable = runnable;
        }

        static /* synthetic */ JavaEditorBreadcrumb access$2(ElementChangeListener elementChangeListener) {
            return elementChangeListener.JavaEditorBreadcrumb.this;
        }
    }

    private static final class JavaEditorBreadcrumbContentProvider
    implements ITreeContentProvider {
        private final StandardJavaElementContentProvider fParent;
        private Object[] fElements;
        private Object fLastInputElement;

        public JavaEditorBreadcrumbContentProvider(StandardJavaElementContentProvider parent) {
            this.fParent = parent;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public Object[] getChildren(Object inputElement) {
            if (inputElement == this.fLastInputElement) {
                return this.fElements;
            }
            this.fLastInputElement = inputElement;
            if (inputElement instanceof IPackageFragment) {
                this.fElements = this.getPackageContent((IPackageFragment)inputElement);
            } else if (inputElement instanceof IProject) {
                IProject project = (IProject)inputElement;
                if (project.isAccessible()) {
                    try {
                        this.fElements = ((IProject)inputElement).members();
                    }
                    catch (CoreException e) {
                        JavaPlugin.log(e);
                    }
                } else {
                    this.fElements = new Object[0];
                }
            } else if (inputElement instanceof IPackageFragmentRoot) {
                Object[] fragments = this.fParent.getChildren(inputElement);
                ArrayList<Object> packages = new ArrayList<Object>();
                int i = 0;
                while (i < fragments.length) {
                    Object object = fragments[i];
                    if (object instanceof IPackageFragment) {
                        try {
                            if (((IPackageFragment)object).hasChildren()) {
                                packages.add(object);
                            }
                        }
                        catch (JavaModelException e) {
                            JavaPlugin.log(e);
                            packages.add(object);
                        }
                    } else {
                        packages.add(object);
                    }
                    ++i;
                }
                this.fElements = packages.toArray();
            } else {
                this.fElements = inputElement instanceof IJavaModel ? this.getAccessibleProjects((IJavaModel)inputElement) : this.fParent.getChildren(inputElement);
            }
            return this.fElements;
        }

        private Object[] getAccessibleProjects(IJavaModel model) {
            Object[] nonJavaResources;
            IJavaProject[] javaProjects;
            try {
                javaProjects = model.getJavaProjects();
                nonJavaResources = model.getNonJavaResources();
            }
            catch (JavaModelException javaModelException) {
                return this.fParent.getChildren(model);
            }
            ArrayList<Object> result = new ArrayList<Object>(javaProjects.length + nonJavaResources.length);
            int i = 0;
            while (i < nonJavaResources.length) {
                IProject project = (IProject)nonJavaResources[i];
                if (project.isAccessible()) {
                    result.add(project);
                }
                ++i;
            }
            i = 0;
            while (i < javaProjects.length) {
                IJavaProject javaProject = javaProjects[i];
                if (javaProject.getProject().isAccessible()) {
                    result.add(javaProject);
                }
                ++i;
            }
            return result.toArray(new Object[result.size()]);
        }

        public Object getParent(Object element) {
            IType declaringType;
            if (element instanceof IType && ((IType)element).isBinary() && (declaringType = ((IType)element).getDeclaringType()) != null) {
                return declaringType;
            }
            Object result = this.fParent.getParent(element);
            if (result instanceof ITypeRoot) {
                if (ActionUtil.isOnBuildPath((IJavaElement)result)) {
                    result = this.fParent.getParent(result);
                } else if ((result = ((ITypeRoot)result).getResource()) instanceof IFile) {
                    result = this.fParent.getParent(result);
                }
            }
            return result;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof IProject) {
                IProject project = (IProject)element;
                if (!project.isAccessible()) {
                    return false;
                }
                try {
                    return project.members().length > 0;
                }
                catch (CoreException e) {
                    JavaPlugin.log(e);
                    return false;
                }
            }
            return this.fParent.hasChildren(element);
        }

        private Object[] getPackageContent(IPackageFragment pack) {
            ArrayList<Object> result = new ArrayList<Object>();
            try {
                ICompilationUnit[] units = pack.getCompilationUnits();
                int i = 0;
                while (i < units.length) {
                    IType[] types = units[i].getTypes();
                    int j = 0;
                    while (j < types.length) {
                        if (this.isValidType(types[j])) {
                            result.add(types[j]);
                        }
                        ++j;
                    }
                    ++i;
                }
                IClassFile[] classFiles = pack.getClassFiles();
                int i2 = 0;
                while (i2 < classFiles.length) {
                    if (this.isValidType(classFiles[i2].getType())) {
                        result.add(classFiles[i2].getType());
                    }
                    ++i2;
                }
                Object[] nonJavaResources = pack.getNonJavaResources();
                int i3 = 0;
                while (i3 < nonJavaResources.length) {
                    result.add(nonJavaResources[i3]);
                    ++i3;
                }
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
            return result.toArray();
        }

        private boolean isValidType(IType type) {
            if (type.getDeclaringType() != null) {
                return false;
            }
            try {
                return !type.isAnonymous();
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
                return false;
            }
        }

        public void dispose() {
            this.fParent.dispose();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.fElements = null;
            this.fLastInputElement = null;
            this.fParent.inputChanged(viewer, oldInput, newInput);
        }
    }

    private static class ProblemBreadcrumbViewer
    extends BreadcrumbViewer
    implements ResourceToItemsMapper.IContentViewerAccessor {
        private ResourceToItemsMapper fResourceToItemsMapper = new ResourceToItemsMapper(this);

        public ProblemBreadcrumbViewer(Composite parent, int style) {
            super(parent, style);
        }

        public void doUpdateItem(Widget item) {
            this.doUpdateItem(item, item.getData(), true);
        }

        protected void mapElement(Object element, Widget item) {
            super.mapElement(element, item);
            if (item instanceof Item) {
                this.fResourceToItemsMapper.addToMap(element, (Item)item);
            }
        }

        protected void unmapElement(Object element, Widget item) {
            if (item instanceof Item) {
                this.fResourceToItemsMapper.removeFromMap(element, (Item)item);
            }
            super.unmapElement(element, item);
        }

        protected void unmapAllElements() {
            this.fResourceToItemsMapper.clearMap();
            super.unmapAllElements();
        }

        protected void handleLabelProviderChanged(LabelProviderChangedEvent event) {
            ProblemsLabelDecorator.ProblemsLabelChangedEvent e;
            if (event instanceof ProblemsLabelDecorator.ProblemsLabelChangedEvent && !(e = (ProblemsLabelDecorator.ProblemsLabelChangedEvent)event).isMarkerChange() && this.canIgnoreChangesFromAnnotionModel()) {
                return;
            }
            Object[] changed = event.getElements();
            if (changed != null && !this.fResourceToItemsMapper.isEmpty()) {
                ArrayList<Object> others = new ArrayList<Object>(changed.length);
                int i = 0;
                while (i < changed.length) {
                    Object curr = changed[i];
                    if (curr instanceof IResource) {
                        this.fResourceToItemsMapper.resourceChanged((IResource)curr);
                    } else {
                        others.add(curr);
                    }
                    ++i;
                }
                if (others.isEmpty()) {
                    return;
                }
                event = new LabelProviderChangedEvent((IBaseLabelProvider)event.getSource(), others.toArray());
            }
            super.handleLabelProviderChanged(event);
        }

        private boolean canIgnoreChangesFromAnnotionModel() {
            IContentProvider contentProvider = this.getContentProvider();
            return contentProvider instanceof IWorkingCopyProvider && !((IWorkingCopyProvider)contentProvider).providesWorkingCopies();
        }

        public void configureDropDownViewer(TreeViewer viewer, Object input) {
            viewer.setContentProvider((IContentProvider)JavaEditorBreadcrumb.createDropDownContentProvider());
            viewer.setLabelProvider((IBaseLabelProvider)this.createDropDownLabelProvider());
            viewer.setComparator((ViewerComparator)new JavaElementComparator());
            viewer.addFilter(new ViewerFilter(this){
                final /* synthetic */ ProblemBreadcrumbViewer this$1;
                {
                    this.this$1 = problemBreadcrumbViewer;
                }

                public boolean select(Viewer viewer1, Object parentElement, Object element) {
                    return !(element instanceof IMember) || !((IMember)element).getElementName().startsWith("<");
                }
            });
            viewer.addFilter((ViewerFilter)new EmptyLibraryContainerFilter());
            JavaUIHelp.setHelp((StructuredViewer)viewer, "org.eclipse.jdt.ui.java_editor_breadcrumb_context");
        }

        private ILabelProvider createDropDownLabelProvider() {
            AppearanceAwareLabelProvider result = new AppearanceAwareLabelProvider(0x210000204029L | JavaElementLabels.ALL_CATEGORY, 3);
            return new DecoratingJavaLabelProvider(result);
        }
    }
}

