/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences;

import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.VariableBlock;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class ClasspathVariablesPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "org.eclipse.jdt.ui.preferences.ClasspathVariablesPreferencePage";
    public static final String DATA_SELECT_VARIABLE = "ClasspathVariablesPreferencePage.select_var";
    private VariableBlock fVariableBlock;
    private String fStoredSettings;

    public ClasspathVariablesPreferencePage() {
        this.setPreferenceStore(JavaPlugin.getDefault().getPreferenceStore());
        this.fVariableBlock = new VariableBlock(true, null);
        this.fStoredSettings = null;
        this.setTitle(PreferencesMessages.ClasspathVariablesPreferencePage_title);
        this.setDescription(PreferencesMessages.ClasspathVariablesPreferencePage_description);
        this.noDefaultAndApplyButton();
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.jdt.ui.cp_variables_preference_page_context");
    }

    protected Control createContents(Composite parent) {
        Control result = this.fVariableBlock.createContents(parent);
        Dialog.applyDialogFont((Control)result);
        return result;
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        super.performDefaults();
    }

    public boolean performOk() {
        JavaPlugin.getDefault().savePluginPreferences();
        return this.fVariableBlock.performOk();
    }

    public void setVisible(boolean visible) {
        if (visible) {
            if (this.fStoredSettings != null && !this.fStoredSettings.equals(this.getCurrentSettings())) {
                this.fVariableBlock.refresh(null);
            }
        } else {
            if (this.fVariableBlock.hasChanges()) {
                String title = PreferencesMessages.ClasspathVariablesPreferencePage_savechanges_title;
                String message = PreferencesMessages.ClasspathVariablesPreferencePage_savechanges_message;
                if (MessageDialog.openQuestion((Shell)this.getShell(), (String)title, (String)message)) {
                    this.performOk();
                }
                this.fVariableBlock.setChanges(false);
            }
            this.fStoredSettings = this.getCurrentSettings();
        }
        super.setVisible(visible);
    }

    private String getCurrentSettings() {
        StringBuffer buf = new StringBuffer();
        String[] names = JavaCore.getClasspathVariableNames();
        int i = 0;
        while (i < names.length) {
            String curr = names[i];
            buf.append(curr).append('\u0000');
            IPath val = JavaCore.getClasspathVariable((String)curr);
            if (val != null) {
                buf.append(val.toString());
            }
            buf.append('\u0000');
            ++i;
        }
        return buf.toString();
    }

    public void applyData(Object data) {
        Object id;
        if (data instanceof Map && this.fVariableBlock != null && (id = ((Map)data).get(DATA_SELECT_VARIABLE)) instanceof String) {
            this.fVariableBlock.setSelection((String)id);
        }
        super.applyData(data);
    }
}

