/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.propertiesfileeditor;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.propertiesfileeditor.PropertiesFileEditorMessages;

public class PropertiesFileEscapes {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private static char toHex(int halfByte) {
        return HEX_DIGITS[halfByte & 0xF];
    }

    private static int getHexDigitValue(char digit) {
        switch (digit) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return digit - 48;
            }
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': {
                return 10 + digit - 97;
            }
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': {
                return 10 + digit - 65;
            }
        }
        return -1;
    }

    public static String escape(char c) {
        switch (c) {
            case '\t': {
                return "\\t";
            }
            case '\n': {
                return "\\n";
            }
            case '\f': {
                return "\\f";
            }
            case '\r': {
                return "\\r";
            }
            case '\\': {
                return "\\\\";
            }
        }
        if (c < ' ' || c > '~' && c <= '\u00a0' || c > '\u00ff') {
            return "" + '\\' + 'u' + PropertiesFileEscapes.toHex(c >> 12 & 0xF) + PropertiesFileEscapes.toHex(c >> 8 & 0xF) + PropertiesFileEscapes.toHex(c >> 4 & 0xF) + PropertiesFileEscapes.toHex(c & 0xF);
        }
        return String.valueOf(c);
    }

    public static String unescape(String s) throws CoreException {
        boolean isValidEscapedString = true;
        if (s == null) {
            return null;
        }
        int len = s.length();
        StringBuffer outBuffer = new StringBuffer(len);
        int x = 0;
        while (x < len) {
            char aChar;
            if ((aChar = s.charAt(x++)) == '\\') {
                if (x > len - 1) {
                    return outBuffer.toString();
                }
                if ((aChar = s.charAt(x++)) == 'u') {
                    int value = 0;
                    if (x > len - 4) {
                        String exceptionMessage = Messages.format(PropertiesFileEditorMessages.PropertiesFileHover_MalformedEncoding, String.valueOf(outBuffer.toString()) + s.substring(x - 2));
                        throw new CoreException((IStatus)new StatusInfo(2, exceptionMessage));
                    }
                    StringBuffer buf = new StringBuffer("\\u");
                    int digit = 0;
                    int i = 0;
                    while (i < 4) {
                        if ((digit = PropertiesFileEscapes.getHexDigitValue(aChar = s.charAt(x++))) == -1) {
                            isValidEscapedString = false;
                            --x;
                            break;
                        }
                        value = (value << 4) + digit;
                        buf.append(aChar);
                        ++i;
                    }
                    outBuffer.append(digit == -1 ? buf.toString() : String.valueOf((char)value));
                    continue;
                }
                if (aChar == 't') {
                    outBuffer.append('\t');
                    continue;
                }
                if (aChar == 'n') {
                    outBuffer.append('\n');
                    continue;
                }
                if (aChar == 'f') {
                    outBuffer.append('\f');
                    continue;
                }
                if (aChar == 'r') {
                    outBuffer.append('\r');
                    continue;
                }
                outBuffer.append(aChar);
                continue;
            }
            outBuffer.append(aChar);
        }
        if (isValidEscapedString) {
            return outBuffer.toString();
        }
        String exceptionMessage = Messages.format(PropertiesFileEditorMessages.PropertiesFileHover_MalformedEncoding, outBuffer.toString());
        throw new CoreException((IStatus)new StatusInfo(2, exceptionMessage));
    }
}

