/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.propertiesfileeditor;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.propertiesfileeditor.IPropertiesFilePartitions;
import org.eclipse.jdt.internal.ui.propertiesfileeditor.PropertiesFileAutoEditStrategy;
import org.eclipse.jdt.internal.ui.propertiesfileeditor.PropertiesFileDocumentProvider;
import org.eclipse.jdt.internal.ui.propertiesfileeditor.PropertiesFileHover;
import org.eclipse.jdt.internal.ui.propertiesfileeditor.PropertyValueScanner;
import org.eclipse.jdt.internal.ui.text.AbstractJavaScanner;
import org.eclipse.jdt.internal.ui.text.HTMLAnnotationHover;
import org.eclipse.jdt.internal.ui.text.JavaPresentationReconciler;
import org.eclipse.jdt.internal.ui.text.SingleTokenJavaScanner;
import org.eclipse.jdt.internal.ui.text.java.PartitionDoubleClickSelector;
import org.eclipse.jdt.ui.text.IColorManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.MonoReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.spelling.SpellingReconcileStrategy;

public class PropertiesFileSourceViewerConfiguration
extends TextSourceViewerConfiguration {
    private static final IContentType PROPERTIES_CONTENT_TYPE = Platform.getContentTypeManager().getContentType("org.eclipse.jdt.core.javaProperties");
    private ITextEditor fTextEditor;
    private String fDocumentPartitioning;
    private AbstractJavaScanner fPropertyKeyScanner;
    private AbstractJavaScanner fCommentScanner;
    private AbstractJavaScanner fPropertyValueScanner;
    private IColorManager fColorManager;

    public PropertiesFileSourceViewerConfiguration(IColorManager colorManager, IPreferenceStore preferenceStore, ITextEditor editor, String partitioning) {
        super(preferenceStore);
        this.fColorManager = colorManager;
        this.fTextEditor = editor;
        this.fDocumentPartitioning = partitioning;
        this.initializeScanners();
    }

    protected RuleBasedScanner getPropertyKeyScanner() {
        return this.fPropertyKeyScanner;
    }

    protected RuleBasedScanner getCommentScanner() {
        return this.fCommentScanner;
    }

    protected RuleBasedScanner getPropertyValueScanner() {
        return this.fPropertyValueScanner;
    }

    protected IColorManager getColorManager() {
        return this.fColorManager;
    }

    protected ITextEditor getEditor() {
        return this.fTextEditor;
    }

    private void initializeScanners() {
        this.fPropertyKeyScanner = new SingleTokenJavaScanner(this.getColorManager(), this.fPreferenceStore, "pf_coloring_key");
        this.fPropertyValueScanner = new PropertyValueScanner(this.getColorManager(), this.fPreferenceStore);
        this.fCommentScanner = new SingleTokenJavaScanner(this.getColorManager(), this.fPreferenceStore, "pf_coloring_comment");
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        JavaPresentationReconciler reconciler = new JavaPresentationReconciler();
        reconciler.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.getPropertyKeyScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getCommentScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__pf_comment");
        reconciler.setRepairer((IPresentationRepairer)dr, "__pf_comment");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getPropertyValueScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__pf_roperty_value");
        reconciler.setRepairer((IPresentationRepairer)dr, "__pf_roperty_value");
        return reconciler;
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        if ("__dftl_partition_content_type".equals(contentType)) {
            return new PartitionDoubleClickSelector(this.getConfiguredDocumentPartitioning(sourceViewer), 0, 0, 0);
        }
        if ("__pf_comment".equals(contentType)) {
            return new PartitionDoubleClickSelector(this.getConfiguredDocumentPartitioning(sourceViewer), 0, 0);
        }
        if ("__pf_roperty_value".equals(contentType)) {
            return new PartitionDoubleClickSelector(this.getConfiguredDocumentPartitioning(sourceViewer), 1, -1);
        }
        return super.getDoubleClickStrategy(sourceViewer, contentType);
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        int length = IPropertiesFilePartitions.PARTITIONS.length;
        String[] contentTypes = new String[length + 1];
        contentTypes[0] = "__dftl_partition_content_type";
        int i = 0;
        while (i < length) {
            contentTypes[i + 1] = IPropertiesFilePartitions.PARTITIONS[i];
            ++i;
        }
        return contentTypes;
    }

    public String getConfiguredDocumentPartitioning(ISourceViewer sourceViewer) {
        if (this.fDocumentPartitioning != null) {
            return this.fDocumentPartitioning;
        }
        return super.getConfiguredDocumentPartitioning(sourceViewer);
    }

    public boolean affectsTextPresentation(PropertyChangeEvent event) {
        return this.fPropertyKeyScanner.affectsBehavior(event) || this.fCommentScanner.affectsBehavior(event) || this.fPropertyValueScanner.affectsBehavior(event);
    }

    public void handlePropertyChangeEvent(PropertyChangeEvent event) {
        if (this.fPropertyKeyScanner.affectsBehavior(event)) {
            this.fPropertyKeyScanner.adaptToPreferenceChange(event);
        }
        if (this.fCommentScanner.affectsBehavior(event)) {
            this.fCommentScanner.adaptToPreferenceChange(event);
        }
        if (this.fPropertyValueScanner.affectsBehavior(event)) {
            this.fPropertyValueScanner.adaptToPreferenceChange(event);
        }
    }

    protected Map getHyperlinkDetectorTargets(ISourceViewer sourceViewer) {
        Map targets = super.getHyperlinkDetectorTargets(sourceViewer);
        targets.put("org.eclipse.jdt.ui.PropertiesFileEditor", this.fTextEditor);
        return targets;
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        return new HTMLAnnotationHover(false){

            protected boolean isIncluded(Annotation annotation) {
                return PropertiesFileSourceViewerConfiguration.this.isShowInVerticalRuler(annotation);
            }
        };
    }

    public IAnnotationHover getOverviewRulerAnnotationHover(ISourceViewer sourceViewer) {
        return new HTMLAnnotationHover(true){

            protected boolean isIncluded(Annotation annotation) {
                return PropertiesFileSourceViewerConfiguration.this.isShowInOverviewRuler(annotation);
            }
        };
    }

    public IInformationControlCreator getInformationControlCreator(ISourceViewer sourceViewer) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent, JavaPlugin.getAdditionalInfoAffordanceString());
            }
        };
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        if (!EditorsUI.getPreferenceStore().getBoolean("spellingEnabled")) {
            return null;
        }
        SpellingReconcileStrategy strategy = new SpellingReconcileStrategy(sourceViewer, EditorsUI.getSpellingService()){

            protected IContentType getContentType() {
                return PROPERTIES_CONTENT_TYPE;
            }
        };
        MonoReconciler reconciler = new MonoReconciler((IReconcilingStrategy)strategy, false);
        reconciler.setDelay(500);
        return reconciler;
    }

    public String[] getDefaultPrefixes(ISourceViewer sourceViewer, String contentType) {
        return new String[]{"#", ""};
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        IAutoEditStrategy[] autoEditStrategies = super.getAutoEditStrategies(sourceViewer, contentType);
        if (this.fTextEditor == null) {
            return autoEditStrategies;
        }
        try {
            if (!PropertiesFileDocumentProvider.isJavaPropertiesFile(this.fTextEditor.getEditorInput())) {
                return autoEditStrategies;
            }
        }
        catch (CoreException e1) {
            JavaPlugin.log(e1);
            return autoEditStrategies;
        }
        ArrayList<IAutoEditStrategy> stratergies = new ArrayList<IAutoEditStrategy>();
        int i = 0;
        while (i < autoEditStrategies.length) {
            stratergies.add(autoEditStrategies[i]);
            ++i;
        }
        stratergies.add(new PropertiesFileAutoEditStrategy());
        return stratergies.toArray(new IAutoEditStrategy[stratergies.size()]);
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType, int stateMask) {
        return new PropertiesFileHover(super.getTextHover(sourceViewer, contentType));
    }
}

