/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.javadoc;

import java.io.IOException;
import java.io.Reader;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MemberRef;
import org.eclipse.jdt.core.dom.MethodRef;
import org.eclipse.jdt.core.dom.MethodRefParameter;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TextElement;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.MethodOverrideTester;
import org.eclipse.jdt.internal.corext.util.SuperTypeHierarchyCache;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.javadoc.JavaDocMessages;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementLinks;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.JavadocContentAccess;
import org.eclipse.jdt.ui.SharedASTProvider;
import org.eclipse.jface.internal.text.html.HTMLPrinter;

public class JavadocContentAccess2 {
    private static final String BLOCK_TAG_START = "<dl>";
    private static final String BLOCK_TAG_END = "</dl>";
    private static final String BlOCK_TAG_ENTRY_START = "<dd>";
    private static final String BlOCK_TAG_ENTRY_END = "</dd>";
    private static final String PARAM_NAME_START = "<b>";
    private static final String PARAM_NAME_END = "</b> ";
    private final IMember fMember;
    private final IMethod fMethod;
    private final Javadoc fJavadoc;
    private final String fSource;
    private final JavadocLookup fJavadocLookup;
    private StringBuffer fBuf;
    private int fLiteralContent;
    private StringBuffer fMainDescription;
    private StringBuffer fReturnDescription;
    private StringBuffer[] fParamDescriptions;
    private HashMap fExceptionDescriptions;

    private JavadocContentAccess2(IMethod method, Javadoc javadoc, String source, JavadocLookup lookup) {
        this.fMember = method;
        this.fMethod = method;
        this.fJavadoc = javadoc;
        this.fSource = source;
        this.fJavadocLookup = lookup;
    }

    private JavadocContentAccess2(IMember member, Javadoc javadoc, String source) {
        this.fMember = member;
        this.fMethod = null;
        this.fJavadoc = javadoc;
        this.fSource = source;
        this.fJavadocLookup = JavadocLookup.NONE;
    }

    public static String getHTMLContent(IMember member, boolean useAttachedJavadoc) throws JavaModelException {
        String sourceJavadoc = JavadocContentAccess2.getHTMLContentFromSource(member);
        if ((sourceJavadoc == null || sourceJavadoc.length() == 0 || sourceJavadoc.trim().equals("{@inheritDoc}")) && useAttachedJavadoc) {
            if (member.getOpenable().getBuffer() == null) {
                return member.getAttachedJavadoc(null);
            }
            if (JavadocContentAccess2.canInheritJavadoc(member)) {
                IMethod method = (IMethod)member;
                String attachedDocInHierarchy = JavadocContentAccess2.findAttachedDocInHierarchy(method);
                if (attachedDocInHierarchy == null) {
                    return sourceJavadoc;
                }
                StringBuffer superMethodReferences = JavadocContentAccess2.createSuperMethodReferences(method);
                if (superMethodReferences == null) {
                    return attachedDocInHierarchy;
                }
                superMethodReferences.append(attachedDocInHierarchy);
                return superMethodReferences.toString();
            }
        }
        return sourceJavadoc;
    }

    private static StringBuffer createSuperMethodReferences(final IMethod method) throws JavaModelException {
        boolean hasSuperInterfaceMethods;
        IType type = method.getDeclaringType();
        ITypeHierarchy hierarchy = SuperTypeHierarchyCache.getTypeHierarchy(type);
        final MethodOverrideTester tester = SuperTypeHierarchyCache.getMethodOverrideTester(type);
        final ArrayList superInterfaceMethods = new ArrayList();
        final IMethod[] superClassMethod = new IMethod[1];
        new InheritDocVisitor(){

            public Object visit(IType currType) throws JavaModelException {
                IMethod overridden = tester.findOverriddenMethodInType(currType, method);
                if (overridden == null) {
                    return InheritDocVisitor.CONTINUE;
                }
                if (currType.isInterface()) {
                    superInterfaceMethods.add(overridden);
                } else {
                    superClassMethod[0] = overridden;
                }
                return STOP_BRANCH;
            }
        }.visitInheritDoc(type, hierarchy);
        boolean bl = hasSuperInterfaceMethods = superInterfaceMethods.size() != 0;
        if (!hasSuperInterfaceMethods && superClassMethod[0] == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        buf.append("<div>");
        if (hasSuperInterfaceMethods) {
            buf.append(PARAM_NAME_START);
            buf.append(JavaDocMessages.JavaDoc2HTMLTextReader_specified_by_section);
            buf.append(PARAM_NAME_END);
            Iterator iter = superInterfaceMethods.iterator();
            while (iter.hasNext()) {
                IMethod overridden = (IMethod)iter.next();
                buf.append(JavadocContentAccess2.createMethodInTypeLinks(overridden));
                if (!iter.hasNext()) continue;
                buf.append(JavaElementLabels.COMMA_STRING);
            }
        }
        if (superClassMethod[0] != null) {
            if (hasSuperInterfaceMethods) {
                buf.append(JavaElementLabels.COMMA_STRING);
            }
            buf.append(PARAM_NAME_START);
            buf.append(JavaDocMessages.JavaDoc2HTMLTextReader_overrides_section);
            buf.append(PARAM_NAME_END);
            buf.append(JavadocContentAccess2.createMethodInTypeLinks(superClassMethod[0]));
        }
        buf.append("</div>");
        return buf;
    }

    private static String createMethodInTypeLinks(IMethod overridden) {
        CharSequence methodLink = JavadocContentAccess2.createSimpleMemberLink((IMember)overridden);
        CharSequence typeLink = JavadocContentAccess2.createSimpleMemberLink((IMember)overridden.getDeclaringType());
        String methodInType = MessageFormat.format(JavaDocMessages.JavaDoc2HTMLTextReader_method_in_type, methodLink, typeLink);
        return methodInType;
    }

    private static CharSequence createSimpleMemberLink(IMember member) {
        StringBuffer buf = new StringBuffer();
        buf.append("<a href='");
        try {
            String uri = JavaElementLinks.createURI("eclipse-javadoc", (IJavaElement)member);
            buf.append(uri);
        }
        catch (URISyntaxException e) {
            JavaPlugin.log(e);
        }
        buf.append("'>");
        JavaElementLabels.getElementLabel((IJavaElement)member, 0L, buf);
        buf.append("</a>");
        return buf;
    }

    private static String getHTMLContentFromSource(IMember member) throws JavaModelException {
        IBuffer buf = member.getOpenable().getBuffer();
        if (buf == null) {
            return null;
        }
        ISourceRange javadocRange = member.getJavadocRange();
        if (javadocRange == null) {
            if (JavadocContentAccess2.canInheritJavadoc(member)) {
                String inheritedJavadoc = JavadocContentAccess2.javadoc2HTML(member, "/***/");
                return inheritedJavadoc != null && inheritedJavadoc.length() > 0 ? inheritedJavadoc : null;
            }
            return null;
        }
        String rawJavadoc = buf.getText(javadocRange.getOffset(), javadocRange.getLength());
        return JavadocContentAccess2.javadoc2HTML(member, rawJavadoc);
    }

    private static Javadoc getJavadocNode(IMember member, String rawJavadoc) {
        ASTParser parser = ASTParser.newParser((int)3);
        IJavaProject javaProject = member.getJavaProject();
        parser.setProject(javaProject);
        Map options = javaProject.getOptions(true);
        options.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
        parser.setCompilerOptions(options);
        String source = String.valueOf(rawJavadoc) + "class C{}";
        parser.setSource(source.toCharArray());
        CompilationUnit root = (CompilationUnit)parser.createAST(null);
        if (root == null) {
            return null;
        }
        List types = root.types();
        if (types.size() != 1) {
            return null;
        }
        AbstractTypeDeclaration type = (AbstractTypeDeclaration)types.get(0);
        return type.getJavadoc();
    }

    private static String javadoc2HTML(IMember member, String rawJavadoc) {
        Javadoc javadoc = JavadocContentAccess2.getJavadocNode(member, rawJavadoc);
        if (javadoc == null) {
            try {
                Reader contentReader = JavadocContentAccess.getHTMLContentReader(member, false, false);
                if (contentReader != null) {
                    return JavadocContentAccess2.getString(contentReader);
                }
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
            return null;
        }
        if (JavadocContentAccess2.canInheritJavadoc(member)) {
            IMethod method = (IMethod)member;
            return new JavadocContentAccess2(method, javadoc, rawJavadoc, new JavadocLookup(method.getDeclaringType(), null, null)).toHTML();
        }
        return new JavadocContentAccess2(member, javadoc, rawJavadoc).toHTML();
    }

    private static boolean canInheritJavadoc(IMember member) {
        if (member instanceof IMethod && member.getJavaProject().exists()) {
            try {
                return !((IMethod)member).isConstructor();
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
        }
        return false;
    }

    private static String getString(Reader reader) {
        StringBuffer buf = new StringBuffer();
        char[] buffer = new char[1024];
        try {
            int count;
            while ((count = reader.read(buffer)) != -1) {
                buf.append(buffer, 0, count);
            }
        }
        catch (IOException iOException) {
            return null;
        }
        return buf.toString();
    }

    private static String findAttachedDocInHierarchy(final IMethod method) throws JavaModelException {
        IType type = method.getDeclaringType();
        ITypeHierarchy hierarchy = SuperTypeHierarchyCache.getTypeHierarchy(type);
        final MethodOverrideTester tester = SuperTypeHierarchyCache.getMethodOverrideTester(type);
        return (String)new InheritDocVisitor(){

            public Object visit(IType currType) throws JavaModelException {
                String attachedJavadoc;
                IMethod overridden = tester.findOverriddenMethodInType(currType, method);
                if (overridden == null) {
                    return InheritDocVisitor.CONTINUE;
                }
                if (overridden.getOpenable().getBuffer() == null && (attachedJavadoc = overridden.getAttachedJavadoc(null)) != null) {
                    return attachedJavadoc;
                }
                return CONTINUE;
            }
        }.visitInheritDoc(type, hierarchy);
    }

    private String toHTML() {
        boolean hasExceptions;
        this.fBuf = new StringBuffer();
        this.fLiteralContent = 0;
        List parameterNames = this.initParameterNames();
        List exceptionNames = this.initExceptionNames();
        TagElement deprecatedTag = null;
        TagElement start = null;
        ArrayList<TagElement> parameters = new ArrayList<TagElement>();
        TagElement returnTag = null;
        ArrayList<TagElement> exceptions = new ArrayList<TagElement>();
        ArrayList<TagElement> versions = new ArrayList<TagElement>();
        ArrayList<TagElement> authors = new ArrayList<TagElement>();
        ArrayList<TagElement> sees = new ArrayList<TagElement>();
        ArrayList<TagElement> since = new ArrayList<TagElement>();
        ArrayList<TagElement> rest = new ArrayList<TagElement>();
        List tags = this.fJavadoc.tags();
        Iterator iter = tags.iterator();
        while (iter.hasNext()) {
            String name;
            Object first;
            List fragments;
            TagElement tag = (TagElement)iter.next();
            String tagName = tag.getTagName();
            if (tagName == null) {
                start = tag;
                continue;
            }
            if ("@param".equals(tagName)) {
                int paramIndex;
                parameters.add(tag);
                fragments = tag.fragments();
                if (fragments.size() <= 0 || !((first = fragments.get(0)) instanceof SimpleName) || (paramIndex = parameterNames.indexOf(name = ((SimpleName)first).getIdentifier())) == -1) continue;
                parameterNames.set(paramIndex, null);
                continue;
            }
            if ("@return".equals(tagName)) {
                if (returnTag != null) continue;
                returnTag = tag;
                continue;
            }
            if ("@exception".equals(tagName) || "@throws".equals(tagName)) {
                int exceptionIndex;
                exceptions.add(tag);
                fragments = tag.fragments();
                if (fragments.size() <= 0 || !((first = fragments.get(0)) instanceof Name) || (exceptionIndex = exceptionNames.indexOf(name = ASTNodes.getSimpleNameIdentifier((Name)first))) == -1) continue;
                exceptionNames.set(exceptionIndex, null);
                continue;
            }
            if ("@since".equals(tagName)) {
                since.add(tag);
                continue;
            }
            if ("@version".equals(tagName)) {
                versions.add(tag);
                continue;
            }
            if ("@author".equals(tagName)) {
                authors.add(tag);
                continue;
            }
            if ("@see".equals(tagName)) {
                sees.add(tag);
                continue;
            }
            if ("@deprecated".equals(tagName)) {
                if (deprecatedTag != null) continue;
                deprecatedTag = tag;
                continue;
            }
            rest.add(tag);
        }
        if (deprecatedTag != null) {
            this.handleDeprecatedTag(deprecatedTag);
        }
        if (start != null) {
            this.handleContentElements(start.fragments());
        } else if (this.fMethod != null) {
            CharSequence inherited = this.fJavadocLookup.getInheritedMainDescription(this.fMethod);
            this.handleInherited(inherited);
        }
        CharSequence[] parameterDescriptions = new CharSequence[parameterNames.size()];
        boolean hasInheritedParameters = this.inheritParameterDescriptions(parameterNames, parameterDescriptions);
        boolean hasParameters = parameters.size() > 0 || hasInheritedParameters;
        CharSequence returnDescription = null;
        if (returnTag == null && this.needsReturnTag()) {
            returnDescription = this.fJavadocLookup.getInheritedReturnDescription(this.fMethod);
        }
        boolean hasReturnTag = returnTag != null || returnDescription != null;
        CharSequence[] exceptionDescriptions = new CharSequence[exceptionNames.size()];
        boolean hasInheritedExceptions = this.inheritExceptionDescriptions(exceptionNames, exceptionDescriptions);
        boolean bl = hasExceptions = exceptions.size() > 0 || hasInheritedExceptions;
        if (hasParameters || hasReturnTag || hasExceptions || versions.size() > 0 || authors.size() > 0 || since.size() > 0 || sees.size() > 0 || rest.size() > 0 || this.fBuf.length() > 0 && (parameterDescriptions.length > 0 || exceptionDescriptions.length > 0)) {
            this.handleSuperMethodReferences();
            this.fBuf.append(BLOCK_TAG_START);
            this.handleParameterTags(parameters, parameterNames, parameterDescriptions);
            this.handleReturnTag(returnTag, returnDescription);
            this.handleExceptionTags(exceptions, exceptionNames, exceptionDescriptions);
            this.handleBlockTags(JavaDocMessages.JavaDoc2HTMLTextReader_since_section, since);
            this.handleBlockTags(JavaDocMessages.JavaDoc2HTMLTextReader_version_section, versions);
            this.handleBlockTags(JavaDocMessages.JavaDoc2HTMLTextReader_author_section, authors);
            this.handleBlockTags(JavaDocMessages.JavaDoc2HTMLTextReader_see_section, sees);
            this.handleBlockTags(rest);
            this.fBuf.append(BLOCK_TAG_END);
        } else if (this.fBuf.length() > 0) {
            this.handleSuperMethodReferences();
        }
        String result = this.fBuf.toString();
        this.fBuf = null;
        return result;
    }

    private void handleDeprecatedTag(TagElement tag) {
        this.fBuf.append("<p><b>");
        this.fBuf.append(JavaDocMessages.JavaDoc2HTMLTextReader_deprecated_section);
        this.fBuf.append("</b> <i>");
        this.handleContentElements(tag.fragments());
        this.fBuf.append("</i><p>");
    }

    private void handleSuperMethodReferences() {
        if (this.fMethod != null) {
            try {
                StringBuffer superMethodReferences = JavadocContentAccess2.createSuperMethodReferences(this.fMethod);
                if (superMethodReferences != null) {
                    this.fBuf.append(superMethodReferences);
                }
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
        }
    }

    private List initParameterNames() {
        if (this.fMethod != null) {
            try {
                return new ArrayList<String>(Arrays.asList(this.fMethod.getParameterNames()));
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
        }
        return Collections.EMPTY_LIST;
    }

    private List initExceptionNames() {
        if (this.fMethod != null) {
            try {
                String[] exceptionTypes = this.fMethod.getExceptionTypes();
                ArrayList<String> exceptionNames = new ArrayList<String>();
                int i = 0;
                while (i < exceptionTypes.length) {
                    exceptionNames.add(Signature.getSimpleName((String)Signature.toString((String)exceptionTypes[i])));
                    ++i;
                }
                return exceptionNames;
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
        }
        return Collections.EMPTY_LIST;
    }

    private boolean needsReturnTag() {
        if (this.fMethod == null) {
            return false;
        }
        try {
            return !"V".equals(this.fMethod.getReturnType());
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
            return false;
        }
    }

    private boolean inheritParameterDescriptions(List parameterNames, CharSequence[] parameterDescriptions) {
        boolean hasInheritedParameters = false;
        int i = 0;
        while (i < parameterNames.size()) {
            String name = (String)parameterNames.get(i);
            if (name != null) {
                parameterDescriptions[i] = this.fJavadocLookup.getInheritedParamDescription(this.fMethod, i);
                if (parameterDescriptions[i] != null) {
                    hasInheritedParameters = true;
                }
            }
            ++i;
        }
        return hasInheritedParameters;
    }

    private boolean inheritExceptionDescriptions(List exceptionNames, CharSequence[] exceptionDescriptions) {
        boolean hasInheritedExceptions = false;
        int i = 0;
        while (i < exceptionNames.size()) {
            String name = (String)exceptionNames.get(i);
            if (name != null) {
                exceptionDescriptions[i] = this.fJavadocLookup.getInheritedExceptionDescription(this.fMethod, name);
                if (exceptionDescriptions[i] != null) {
                    hasInheritedExceptions = true;
                }
            }
            ++i;
        }
        return hasInheritedExceptions;
    }

    CharSequence getMainDescription() {
        if (this.fMainDescription == null) {
            this.fBuf = this.fMainDescription = new StringBuffer();
            this.fLiteralContent = 0;
            List tags = this.fJavadoc.tags();
            Iterator iter = tags.iterator();
            while (iter.hasNext()) {
                TagElement tag = (TagElement)iter.next();
                String tagName = tag.getTagName();
                if (tagName != null) continue;
                this.handleContentElements(tag.fragments());
                break;
            }
            this.fBuf = null;
        }
        return this.fMainDescription.length() > 0 ? this.fMainDescription : null;
    }

    CharSequence getReturnDescription() {
        if (this.fReturnDescription == null) {
            this.fBuf = this.fReturnDescription = new StringBuffer();
            this.fLiteralContent = 0;
            List tags = this.fJavadoc.tags();
            Iterator iter = tags.iterator();
            while (iter.hasNext()) {
                TagElement tag = (TagElement)iter.next();
                String tagName = tag.getTagName();
                if (!"@return".equals(tagName)) continue;
                this.handleContentElements(tag.fragments());
                break;
            }
            this.fBuf = null;
        }
        return this.fReturnDescription.length() > 0 ? this.fReturnDescription : null;
    }

    CharSequence getInheritedParamDescription(int paramIndex) throws JavaModelException {
        if (this.fMethod != null) {
            StringBuffer description;
            String[] parameterNames = this.fMethod.getParameterNames();
            if (this.fParamDescriptions == null) {
                this.fParamDescriptions = new StringBuffer[parameterNames.length];
            } else {
                description = this.fParamDescriptions[paramIndex];
                if (description != null) {
                    return description.length() > 0 ? description : null;
                }
            }
            this.fParamDescriptions[paramIndex] = description = new StringBuffer();
            this.fBuf = description;
            this.fLiteralContent = 0;
            String paramName = parameterNames[paramIndex];
            List tags = this.fJavadoc.tags();
            Iterator iter = tags.iterator();
            while (iter.hasNext()) {
                String name;
                Object first;
                List fragments;
                TagElement tag = (TagElement)iter.next();
                String tagName = tag.getTagName();
                if (!"@param".equals(tagName) || (fragments = tag.fragments()).size() <= 0 || !((first = fragments.get(0)) instanceof SimpleName) || !(name = ((SimpleName)first).getIdentifier()).equals(paramName)) continue;
                this.handleContentElements(fragments.subList(1, fragments.size()));
                break;
            }
            this.fBuf = null;
            return description.length() > 0 ? description : null;
        }
        return null;
    }

    CharSequence getExceptionDescription(String simpleName) {
        if (this.fMethod != null) {
            StringBuffer description;
            if (this.fExceptionDescriptions == null) {
                this.fExceptionDescriptions = new HashMap();
            } else {
                description = (StringBuffer)this.fExceptionDescriptions.get(simpleName);
                if (description != null) {
                    return description.length() > 0 ? description : null;
                }
            }
            description = new StringBuffer();
            this.fExceptionDescriptions.put(simpleName, description);
            this.fBuf = description;
            this.fLiteralContent = 0;
            List tags = this.fJavadoc.tags();
            Iterator iter = tags.iterator();
            while (iter.hasNext()) {
                String name;
                Object first;
                List fragments;
                TagElement tag = (TagElement)iter.next();
                String tagName = tag.getTagName();
                if (!"@throws".equals(tagName) && !"@exception".equals(tagName) || (fragments = tag.fragments()).size() <= 0 || !((first = fragments.get(0)) instanceof Name) || !(name = ASTNodes.getSimpleNameIdentifier((Name)first)).equals(simpleName)) continue;
                if (fragments.size() <= 1) break;
                this.handleContentElements(fragments.subList(1, fragments.size()));
                break;
            }
            this.fBuf = null;
            return description.length() > 0 ? description : null;
        }
        return null;
    }

    private void handleContentElements(List nodes) {
        this.handleContentElements(nodes, false);
    }

    private void handleContentElements(List nodes, boolean skipLeadingWhitespace) {
        ASTNode previousNode = null;
        Iterator iter = nodes.iterator();
        while (iter.hasNext()) {
            ASTNode child = (ASTNode)iter.next();
            if (previousNode != null) {
                int childStart;
                int previousEnd = previousNode.getStartPosition() + previousNode.getLength();
                if (previousEnd > (childStart = child.getStartPosition())) {
                    Exception exception = new Exception("Illegal ASTNode positions: previousEnd=" + previousEnd + ", childStart=" + childStart + ", member=" + this.fMember.getHandleIdentifier() + ", Javadoc:\n" + this.fSource);
                    JavaPlugin.log(exception);
                } else if (previousEnd != childStart) {
                    String textWithStars = this.fSource.substring(previousEnd, childStart);
                    String text = this.removeDocLineIntros(textWithStars);
                    this.fBuf.append(text);
                }
            }
            previousNode = child;
            if (child instanceof TextElement) {
                String text = ((TextElement)child).getText();
                if (skipLeadingWhitespace) {
                    text = text.replaceFirst("^\\s+", "");
                }
                this.handleText(text);
                continue;
            }
            if (child instanceof TagElement) {
                this.handleInlineTagElement((TagElement)child);
                continue;
            }
            int start = child.getStartPosition();
            String text = this.fSource.substring(start, start + child.getLength());
            this.fBuf.append(this.removeDocLineIntros(text));
        }
    }

    private String removeDocLineIntros(String textWithStars) {
        String lineBreakGroup = "(\\r\\n?|\\n)";
        String noBreakSpace = "[^\r\n&&\\s]";
        return textWithStars.replaceAll(String.valueOf(lineBreakGroup) + noBreakSpace + "*\\*", "$1");
    }

    private void handleText(String text) {
        if (this.fLiteralContent == 0) {
            this.fBuf.append(text);
        } else {
            JavadocContentAccess2.appendEscaped(this.fBuf, text);
        }
    }

    private static void appendEscaped(StringBuffer buf, String text) {
        int nextToCopy = 0;
        int length = text.length();
        int i = 0;
        while (i < length) {
            char ch = text.charAt(i);
            String rep = null;
            switch (ch) {
                case '&': {
                    rep = "&amp;";
                    break;
                }
                case '\"': {
                    rep = "&quot;";
                    break;
                }
                case '<': {
                    rep = "&lt;";
                    break;
                }
                case '>': {
                    rep = "&gt;";
                }
            }
            if (rep != null) {
                if (nextToCopy < i) {
                    buf.append(text.substring(nextToCopy, i));
                }
                buf.append(rep);
                nextToCopy = i + 1;
            }
            ++i;
        }
        if (nextToCopy < length) {
            buf.append(text.substring(nextToCopy));
        }
    }

    private void handleInlineTagElement(TagElement node) {
        String name = node.getTagName();
        if ("@value".equals(name) && this.handleValueTag(node)) {
            return;
        }
        boolean isLink = "@link".equals(name);
        boolean isLinkplain = "@linkplain".equals(name);
        boolean isCode = "@code".equals(name);
        boolean isLiteral = "@literal".equals(name);
        if (isLiteral || isCode) {
            ++this.fLiteralContent;
        }
        if (isLink || isCode) {
            this.fBuf.append("<code>");
        }
        if (isLink || isLinkplain) {
            this.handleLink(node.fragments());
        } else if (isCode || isLiteral) {
            this.handleContentElements(node.fragments(), true);
        } else if (!this.handleInheritDoc(node) && !this.handleDocRoot(node)) {
            int start = node.getStartPosition();
            String text = this.fSource.substring(start, start + node.getLength());
            this.fBuf.append(this.removeDocLineIntros(text));
        }
        if (isLink || isCode) {
            this.fBuf.append("</code>");
        }
        if (isLiteral || isCode) {
            --this.fLiteralContent;
        }
    }

    private boolean handleValueTag(TagElement node) {
        List fragments = node.fragments();
        try {
            MemberRef memberRef;
            Object first;
            if (fragments.isEmpty()) {
                if (this.fMember instanceof IField && JdtFlags.isStatic(this.fMember) && JdtFlags.isFinal(this.fMember)) {
                    IField field = (IField)this.fMember;
                    return this.handleConstantValue(field, false);
                }
            } else if (fragments.size() == 1 && (first = fragments.get(0)) instanceof MemberRef && (memberRef = (MemberRef)first).getQualifier() == null) {
                SimpleName name = memberRef.getName();
                IField field = this.fMember.getDeclaringType().getField(name.getIdentifier());
                if (field != null && field.exists() && JdtFlags.isStatic((IMember)field) && JdtFlags.isFinal((IMember)field)) {
                    return this.handleConstantValue(field, true);
                }
            }
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
        }
        return false;
    }

    private boolean handleConstantValue(IField field, boolean link) throws JavaModelException {
        Object constant;
        IVariableBinding variableBinding;
        Object constantValue;
        IBinding binding;
        ASTNode nameNode;
        CompilationUnit cuNode;
        String text = null;
        ISourceRange nameRange = field.getNameRange();
        if (SourceRange.isAvailable((ISourceRange)nameRange) && (cuNode = SharedASTProvider.getAST(field.getTypeRoot(), SharedASTProvider.WAIT_ACTIVE_ONLY, null)) != null && (nameNode = NodeFinder.perform((ASTNode)cuNode, (ISourceRange)nameRange)) instanceof SimpleName && (binding = ((SimpleName)nameNode).resolveBinding()) instanceof IVariableBinding && (constantValue = (variableBinding = (IVariableBinding)binding).getConstantValue()) != null) {
            if (constantValue instanceof String) {
                StringLiteral stringLiteral = AST.newAST((int)3).newStringLiteral();
                stringLiteral.setLiteralValue((String)constantValue);
                text = stringLiteral.getEscapedValue();
            } else {
                text = constantValue.toString();
            }
        }
        if (text == null && (constant = field.getConstant()) != null) {
            text = constant.toString();
        }
        if (text != null) {
            text = HTMLPrinter.convertToHTMLContentWithWhitespace(text);
            if (link) {
                try {
                    String uri = JavaElementLinks.createURI("eclipse-javadoc", (IJavaElement)field);
                    this.fBuf.append(JavaElementLinks.createLink(uri, text));
                }
                catch (URISyntaxException e) {
                    JavaPlugin.log(e);
                    return false;
                }
            } else {
                this.handleText(text);
            }
            return true;
        }
        return false;
    }

    private boolean handleDocRoot(TagElement node) {
        if (!"@docRoot".equals(node.getTagName())) {
            return false;
        }
        try {
            String url = null;
            if (this.fMember.isBinary()) {
                URL javadocBaseLocation = JavaUI.getJavadocBaseLocation((IJavaElement)this.fMember);
                if (javadocBaseLocation != null) {
                    url = javadocBaseLocation.toExternalForm();
                }
            } else {
                IPath location;
                IResource resource;
                IPackageFragmentRoot srcRoot = JavaModelUtil.getPackageFragmentRoot((IJavaElement)this.fMember);
                if (srcRoot != null && (resource = srcRoot.getResource()) != null && (location = resource.getLocation()) != null) {
                    url = location.toFile().toURI().toASCIIString();
                }
            }
            if (url != null) {
                if (url.endsWith("/")) {
                    url = url.substring(0, url.length() - 1);
                }
                this.fBuf.append(url);
                return true;
            }
        }
        catch (JavaModelException javaModelException) {}
        return false;
    }

    private boolean handleInheritDoc(TagElement node) {
        block12: {
            if (!"@inheritDoc".equals(node.getTagName())) {
                return false;
            }
            if (this.fMethod != null) break block12;
            return false;
        }
        try {
            TagElement blockTag = (TagElement)node.getParent();
            String blockTagName = blockTag.getTagName();
            if (blockTagName == null) {
                CharSequence inherited = this.fJavadocLookup.getInheritedMainDescription(this.fMethod);
                return this.handleInherited(inherited);
            }
            if ("@param".equals(blockTagName)) {
                Object first;
                List fragments = blockTag.fragments();
                if (fragments.size() > 0 && (first = fragments.get(0)) instanceof SimpleName) {
                    String name = ((SimpleName)first).getIdentifier();
                    String[] parameterNames = this.fMethod.getParameterNames();
                    int i = 0;
                    while (i < parameterNames.length) {
                        if (name.equals(parameterNames[i])) {
                            CharSequence inherited = this.fJavadocLookup.getInheritedParamDescription(this.fMethod, i);
                            return this.handleInherited(inherited);
                        }
                        ++i;
                    }
                }
            } else {
                Object first;
                List fragments;
                if ("@return".equals(blockTagName)) {
                    CharSequence inherited = this.fJavadocLookup.getInheritedReturnDescription(this.fMethod);
                    return this.handleInherited(inherited);
                }
                if (("@throws".equals(blockTagName) || "@exception".equals(blockTagName)) && (fragments = blockTag.fragments()).size() > 0 && (first = fragments.get(0)) instanceof Name) {
                    String name = ASTNodes.getSimpleNameIdentifier((Name)first);
                    CharSequence inherited = this.fJavadocLookup.getInheritedExceptionDescription(this.fMethod, name);
                    return this.handleInherited(inherited);
                }
            }
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
        }
        return false;
    }

    private boolean handleInherited(CharSequence inherited) {
        if (inherited == null) {
            return false;
        }
        this.fBuf.append((Object)inherited);
        return true;
    }

    private void handleBlockTags(String title, List tags) {
        if (tags.isEmpty()) {
            return;
        }
        this.handleBlockTagTitle(title);
        Iterator iter = tags.iterator();
        while (iter.hasNext()) {
            TagElement tag = (TagElement)iter.next();
            this.fBuf.append(BlOCK_TAG_ENTRY_START);
            if ("@see".equals(tag.getTagName())) {
                this.handleSeeTag(tag);
            } else {
                this.handleContentElements(tag.fragments());
            }
            this.fBuf.append(BlOCK_TAG_ENTRY_END);
        }
    }

    private void handleReturnTag(TagElement tag, CharSequence returnDescription) {
        if (tag == null && returnDescription == null) {
            return;
        }
        this.handleBlockTagTitle(JavaDocMessages.JavaDoc2HTMLTextReader_returns_section);
        this.fBuf.append(BlOCK_TAG_ENTRY_START);
        if (tag != null) {
            this.handleContentElements(tag.fragments());
        } else {
            this.fBuf.append((Object)returnDescription);
        }
        this.fBuf.append(BlOCK_TAG_ENTRY_END);
    }

    private void handleBlockTags(List tags) {
        Iterator iter = tags.iterator();
        while (iter.hasNext()) {
            TagElement tag = (TagElement)iter.next();
            this.handleBlockTagTitle(tag.getTagName());
            this.fBuf.append(BlOCK_TAG_ENTRY_START);
            this.handleContentElements(tag.fragments());
            this.fBuf.append(BlOCK_TAG_ENTRY_END);
        }
    }

    private void handleBlockTagTitle(String title) {
        this.fBuf.append("<dt>");
        this.fBuf.append(title);
        this.fBuf.append("</dt>");
    }

    private void handleSeeTag(TagElement tag) {
        this.handleLink(tag.fragments());
    }

    private void handleExceptionTags(List tags, List exceptionNames, CharSequence[] exceptionDescriptions) {
        if (tags.size() == 0 && this.containsOnlyNull(exceptionNames)) {
            return;
        }
        this.handleBlockTagTitle(JavaDocMessages.JavaDoc2HTMLTextReader_throws_section);
        Iterator iter = tags.iterator();
        while (iter.hasNext()) {
            TagElement tag = (TagElement)iter.next();
            this.fBuf.append(BlOCK_TAG_ENTRY_START);
            this.handleThrowsTag(tag);
            this.fBuf.append(BlOCK_TAG_ENTRY_END);
        }
        int i = 0;
        while (i < exceptionDescriptions.length) {
            CharSequence description = exceptionDescriptions[i];
            String name = (String)exceptionNames.get(i);
            if (name != null) {
                this.fBuf.append(BlOCK_TAG_ENTRY_START);
                this.handleLink(Collections.singletonList(this.fJavadoc.getAST().newSimpleName(name)));
                if (description != null) {
                    this.fBuf.append(JavaElementLabels.CONCAT_STRING);
                    this.fBuf.append((Object)description);
                }
                this.fBuf.append(BlOCK_TAG_ENTRY_END);
            }
            ++i;
        }
    }

    private void handleThrowsTag(TagElement tag) {
        List fragments = tag.fragments();
        int size = fragments.size();
        if (size > 0) {
            this.handleLink(fragments.subList(0, 1));
            if (size > 1) {
                this.fBuf.append(JavaElementLabels.CONCAT_STRING);
                this.handleContentElements(fragments.subList(1, size));
            }
        }
    }

    private void handleParameterTags(List tags, List parameterNames, CharSequence[] parameterDescriptions) {
        if (tags.size() == 0 && this.containsOnlyNull(parameterNames)) {
            return;
        }
        this.handleBlockTagTitle(JavaDocMessages.JavaDoc2HTMLTextReader_parameters_section);
        Iterator iter = tags.iterator();
        while (iter.hasNext()) {
            TagElement tag = (TagElement)iter.next();
            this.fBuf.append(BlOCK_TAG_ENTRY_START);
            this.handleParamTag(tag);
            this.fBuf.append(BlOCK_TAG_ENTRY_END);
        }
        int i = 0;
        while (i < parameterDescriptions.length) {
            CharSequence description = parameterDescriptions[i];
            String name = (String)parameterNames.get(i);
            if (name != null) {
                this.fBuf.append(BlOCK_TAG_ENTRY_START);
                this.fBuf.append(PARAM_NAME_START);
                this.fBuf.append(name);
                this.fBuf.append(PARAM_NAME_END);
                if (description != null) {
                    this.fBuf.append((Object)description);
                }
                this.fBuf.append(BlOCK_TAG_ENTRY_END);
            }
            ++i;
        }
    }

    private void handleParamTag(TagElement tag) {
        List fragments = tag.fragments();
        int i = 0;
        int size = fragments.size();
        if (size > 0) {
            String firstText;
            Object first = fragments.get(0);
            this.fBuf.append(PARAM_NAME_START);
            if (first instanceof SimpleName) {
                String name = ((SimpleName)first).getIdentifier();
                this.fBuf.append(name);
                ++i;
            } else if (first instanceof TextElement && "<".equals(firstText = ((TextElement)first).getText())) {
                Object second;
                this.fBuf.append("&lt;");
                ++i;
                if (size > 1 && (second = fragments.get(1)) instanceof SimpleName) {
                    Object third;
                    String thirdText;
                    String name = ((SimpleName)second).getIdentifier();
                    this.fBuf.append(name);
                    ++i;
                    if (size > 2 && ">".equals(thirdText = ((TextElement)(third = fragments.get(2))).getText())) {
                        this.fBuf.append("&gt;");
                        ++i;
                    }
                }
            }
            this.fBuf.append(PARAM_NAME_END);
            this.handleContentElements(fragments.subList(i, fragments.size()));
        }
    }

    private void handleLink(List fragments) {
        int fs = fragments.size();
        if (fs > 0) {
            Name qualifier;
            Object first = fragments.get(0);
            String refTypeName = null;
            String refMemberName = null;
            String[] refMethodParamTypes = null;
            String[] refMethodParamNames = null;
            if (first instanceof Name) {
                Name name = (Name)first;
                refTypeName = name.getFullyQualifiedName();
            } else if (first instanceof MemberRef) {
                MemberRef memberRef = (MemberRef)first;
                qualifier = memberRef.getQualifier();
                refTypeName = qualifier == null ? "" : qualifier.getFullyQualifiedName();
                refMemberName = memberRef.getName().getIdentifier();
            } else if (first instanceof MethodRef) {
                MethodRef methodRef = (MethodRef)first;
                qualifier = methodRef.getQualifier();
                refTypeName = qualifier == null ? "" : qualifier.getFullyQualifiedName();
                refMemberName = methodRef.getName().getIdentifier();
                List params = methodRef.parameters();
                int ps = params.size();
                refMethodParamTypes = new String[ps];
                refMethodParamNames = new String[ps];
                int i = 0;
                while (i < ps) {
                    MethodRefParameter param = (MethodRefParameter)params.get(i);
                    refMethodParamTypes[i] = ASTNodes.asString((ASTNode)param.getType());
                    SimpleName paramName = param.getName();
                    if (paramName != null) {
                        refMethodParamNames[i] = paramName.getIdentifier();
                    }
                    ++i;
                }
            }
            if (refTypeName != null) {
                this.fBuf.append("<a href='");
                try {
                    String scheme = "eclipse-javadoc";
                    String uri = JavaElementLinks.createURI(scheme, (IJavaElement)this.fMember, refTypeName, refMemberName, refMethodParamTypes);
                    this.fBuf.append(uri);
                }
                catch (URISyntaxException e) {
                    JavaPlugin.log(e);
                }
                this.fBuf.append("'>");
                if (!(fs <= 1 || fs == 2 && JavadocContentAccess2.isWhitespaceTextElement(fragments.get(1)))) {
                    this.handleContentElements(fragments.subList(1, fs), true);
                } else {
                    this.fBuf.append(refTypeName);
                    if (refMemberName != null) {
                        if (refTypeName.length() > 0) {
                            this.fBuf.append('.');
                        }
                        this.fBuf.append(refMemberName);
                        if (refMethodParamTypes != null) {
                            this.fBuf.append('(');
                            int i = 0;
                            while (i < refMethodParamTypes.length) {
                                String pType = refMethodParamTypes[i];
                                this.fBuf.append(pType);
                                String pName = refMethodParamNames[i];
                                if (pName != null) {
                                    this.fBuf.append(' ').append(pName);
                                }
                                if (i < refMethodParamTypes.length - 1) {
                                    this.fBuf.append(", ");
                                }
                                ++i;
                            }
                            this.fBuf.append(')');
                        }
                    }
                }
                this.fBuf.append("</a>");
            } else {
                this.handleContentElements(fragments);
            }
        }
    }

    private static boolean isWhitespaceTextElement(Object fragment) {
        if (!(fragment instanceof TextElement)) {
            return false;
        }
        TextElement textElement = (TextElement)fragment;
        return textElement.getText().trim().length() == 0;
    }

    private boolean containsOnlyNull(List parameterNames) {
        Iterator iter = parameterNames.iterator();
        while (iter.hasNext()) {
            if (iter.next() == null) continue;
            return false;
        }
        return true;
    }

    /* synthetic */ JavadocContentAccess2(IMethod iMethod, Javadoc javadoc, String string, JavadocLookup javadocLookup, JavadocContentAccess2 javadocContentAccess2) {
        this(iMethod, javadoc, string, javadocLookup);
    }

    private static abstract class InheritDocVisitor {
        public static final Object STOP_BRANCH = new Object(){

            public String toString() {
                return "STOP_BRANCH";
            }
        };
        public static final Object CONTINUE = new Object(){

            public String toString() {
                return "CONTINUE";
            }
        };

        private InheritDocVisitor() {
        }

        public abstract Object visit(IType var1) throws JavaModelException;

        public Object visitInheritDoc(IType currentType, ITypeHierarchy typeHierarchy) throws JavaModelException {
            ArrayList<IType> visited = new ArrayList<IType>();
            visited.add(currentType);
            Object result = this.visitInheritDocInterfaces(visited, currentType, typeHierarchy);
            if (result != CONTINUE) {
                return result;
            }
            IType superClass = currentType.isInterface() ? currentType.getJavaProject().findType("java.lang.Object") : typeHierarchy.getSuperclass(currentType);
            while (superClass != null && !visited.contains(superClass)) {
                result = this.visit(superClass);
                if (result == STOP_BRANCH) {
                    return null;
                }
                if (result == CONTINUE) {
                    visited.add(superClass);
                    result = this.visitInheritDocInterfaces(visited, superClass, typeHierarchy);
                    if (result != CONTINUE) {
                        return result;
                    }
                    superClass = typeHierarchy.getSuperclass(superClass);
                    continue;
                }
                return result;
            }
            return null;
        }

        private Object visitInheritDocInterfaces(ArrayList visited, IType currentType, ITypeHierarchy typeHierarchy) throws JavaModelException {
            Object result;
            ArrayList<IType> toVisitChildren = new ArrayList<IType>();
            IType[] superInterfaces = typeHierarchy.getSuperInterfaces(currentType);
            int i = 0;
            while (i < superInterfaces.length) {
                IType superInterface = superInterfaces[i];
                if (!visited.contains(superInterface)) {
                    visited.add(superInterface);
                    result = this.visit(superInterface);
                    if (result != STOP_BRANCH) {
                        if (result == CONTINUE) {
                            toVisitChildren.add(superInterface);
                        } else {
                            return result;
                        }
                    }
                }
                ++i;
            }
            Iterator iter = toVisitChildren.iterator();
            while (iter.hasNext()) {
                IType child = (IType)iter.next();
                result = this.visitInheritDocInterfaces(visited, child, typeHierarchy);
                if (result == CONTINUE) continue;
                return result;
            }
            return CONTINUE;
        }
    }

    private static class JavadocLookup {
        private static final JavadocLookup NONE = new JavadocLookup(null){

            public CharSequence getInheritedMainDescription(IMethod method) {
                return null;
            }

            public CharSequence getInheritedParamDescription(IMethod method, int i) {
                return null;
            }

            public CharSequence getInheritedReturnDescription(IMethod method) {
                return null;
            }

            public CharSequence getInheritedExceptionDescription(IMethod method, String name) {
                return null;
            }
        };
        private final IType fStartingType;
        private final HashMap fContentAccesses;
        private ITypeHierarchy fTypeHierarchy;
        private MethodOverrideTester fOverrideTester;

        private JavadocLookup(IType startingType) {
            this.fStartingType = startingType;
            this.fContentAccesses = new HashMap();
        }

        public CharSequence getInheritedMainDescription(IMethod method) {
            return this.getInheritedDescription(method, new DescriptionGetter(this){
                final /* synthetic */ JavadocLookup this$1;
                {
                    this.this$1 = javadocLookup;
                }

                public CharSequence getDescription(JavadocContentAccess2 contentAccess) {
                    return contentAccess.getMainDescription();
                }
            });
        }

        public CharSequence getInheritedParamDescription(IMethod method, int paramIndex) {
            return this.getInheritedDescription(method, new DescriptionGetter(this, paramIndex){
                final /* synthetic */ JavadocLookup this$1;
                private final /* synthetic */ int val$paramIndex;
                {
                    this.this$1 = javadocLookup;
                    this.val$paramIndex = n;
                }

                public CharSequence getDescription(JavadocContentAccess2 contentAccess) throws JavaModelException {
                    return contentAccess.getInheritedParamDescription(this.val$paramIndex);
                }
            });
        }

        public CharSequence getInheritedReturnDescription(IMethod method) {
            return this.getInheritedDescription(method, new DescriptionGetter(this){
                final /* synthetic */ JavadocLookup this$1;
                {
                    this.this$1 = javadocLookup;
                }

                public CharSequence getDescription(JavadocContentAccess2 contentAccess) {
                    return contentAccess.getReturnDescription();
                }
            });
        }

        public CharSequence getInheritedExceptionDescription(IMethod method, String simpleName) {
            return this.getInheritedDescription(method, new DescriptionGetter(this, simpleName){
                final /* synthetic */ JavadocLookup this$1;
                private final /* synthetic */ String val$simpleName;
                {
                    this.this$1 = javadocLookup;
                    this.val$simpleName = string;
                }

                public CharSequence getDescription(JavadocContentAccess2 contentAccess) {
                    return contentAccess.getExceptionDescription(this.val$simpleName);
                }
            });
        }

        private CharSequence getInheritedDescription(IMethod method, DescriptionGetter descriptionGetter) {
            try {
                return (CharSequence)new InheritDocVisitor(this, method, descriptionGetter){
                    final /* synthetic */ JavadocLookup this$1;
                    private final /* synthetic */ IMethod val$method;
                    private final /* synthetic */ DescriptionGetter val$descriptionGetter;
                    {
                        this.this$1 = javadocLookup;
                        this.val$method = iMethod;
                        this.val$descriptionGetter = descriptionGetter;
                    }

                    public Object visit(IType currType) throws JavaModelException {
                        IMethod overridden = JavadocLookup.access$1(this.this$1).findOverriddenMethodInType(currType, this.val$method);
                        if (overridden == null) {
                            return InheritDocVisitor.CONTINUE;
                        }
                        JavadocContentAccess2 contentAccess = JavadocLookup.access$2(this.this$1, overridden);
                        if (contentAccess == null) {
                            if (overridden.getOpenable().getBuffer() == null) {
                                return InheritDocVisitor.STOP_BRANCH;
                            }
                            return InheritDocVisitor.CONTINUE;
                        }
                        CharSequence overriddenDescription = this.val$descriptionGetter.getDescription(contentAccess);
                        if (overriddenDescription != null) {
                            return overriddenDescription;
                        }
                        return InheritDocVisitor.CONTINUE;
                    }
                }.visitInheritDoc(method.getDeclaringType(), this.getTypeHierarchy());
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
                return null;
            }
        }

        private JavadocContentAccess2 getJavadocContentAccess(IMethod method) throws JavaModelException {
            Object cached = this.fContentAccesses.get(method);
            if (cached != null) {
                return (JavadocContentAccess2)cached;
            }
            if (this.fContentAccesses.containsKey(method)) {
                return null;
            }
            IBuffer buf = method.getOpenable().getBuffer();
            if (buf == null) {
                this.fContentAccesses.put(method, null);
                return null;
            }
            ISourceRange javadocRange = method.getJavadocRange();
            if (javadocRange == null) {
                this.fContentAccesses.put(method, null);
                return null;
            }
            String rawJavadoc = buf.getText(javadocRange.getOffset(), javadocRange.getLength());
            Javadoc javadoc = JavadocContentAccess2.getJavadocNode((IMember)method, rawJavadoc);
            if (javadoc == null) {
                this.fContentAccesses.put(method, null);
                return null;
            }
            JavadocContentAccess2 contentAccess = new JavadocContentAccess2(method, javadoc, rawJavadoc, this, null);
            this.fContentAccesses.put(method, contentAccess);
            return contentAccess;
        }

        private ITypeHierarchy getTypeHierarchy() throws JavaModelException {
            if (this.fTypeHierarchy == null) {
                this.fTypeHierarchy = SuperTypeHierarchyCache.getTypeHierarchy(this.fStartingType);
            }
            return this.fTypeHierarchy;
        }

        private MethodOverrideTester getOverrideTester() throws JavaModelException {
            if (this.fOverrideTester == null) {
                this.fOverrideTester = SuperTypeHierarchyCache.getMethodOverrideTester(this.fStartingType);
            }
            return this.fOverrideTester;
        }

        static /* synthetic */ MethodOverrideTester access$1(JavadocLookup javadocLookup) throws JavaModelException {
            return javadocLookup.getOverrideTester();
        }

        static /* synthetic */ JavadocContentAccess2 access$2(JavadocLookup javadocLookup, IMethod iMethod) throws JavaModelException {
            return javadocLookup.getJavadocContentAccess(iMethod);
        }

        /* synthetic */ JavadocLookup(IType iType, JavadocLookup javadocLookup, JavadocLookup javadocLookup2) {
            this(iType);
        }

        private static interface DescriptionGetter {
            public CharSequence getDescription(JavadocContentAccess2 var1) throws JavaModelException;
        }
    }
}

