/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.launching.launcher;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.ModelEntry;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.DependencyManager;
import org.eclipse.pde.internal.core.FeatureModelManager;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.ifeature.IFeatureImport;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeaturePlugin;
import org.eclipse.pde.internal.launching.launcher.LaunchPluginValidator;
import org.eclipse.pde.internal.launching.launcher.RequirementHelper;
import org.osgi.framework.Version;

public class BundleLauncherHelper {
    public static final String DEFAULT_UPDATE_CONFIGURATOR_START_LEVEL = "3:true";
    public static final char VERSION_SEPARATOR = '*';

    public static Map getWorkspaceBundleMap(ILaunchConfiguration configuration) throws CoreException {
        return BundleLauncherHelper.getWorkspaceBundleMap(configuration, null, "workspace_bundles");
    }

    public static Map getTargetBundleMap(ILaunchConfiguration configuration) throws CoreException {
        return BundleLauncherHelper.getTargetBundleMap(configuration, null, "target_bundles");
    }

    public static Map getMergedBundleMap(ILaunchConfiguration configuration, boolean osgi) throws CoreException {
        HashSet set = new HashSet();
        Map map = new HashMap();
        if (!osgi) {
            BundleLauncherHelper.checkBackwardCompatibility(configuration, true);
            if (configuration.getAttribute("default", true)) {
                IPluginModelBase[] models = PluginRegistry.getActiveModels();
                int i = 0;
                while (i < models.length) {
                    BundleLauncherHelper.addBundleToMap(map, models[i], "default:default");
                    ++i;
                }
                return map;
            }
            if (configuration.getAttribute("usefeatures", false)) {
                IPluginModelBase[] models = PluginRegistry.getWorkspaceModels();
                int i = 0;
                while (i < models.length) {
                    BundleLauncherHelper.addBundleToMap(map, models[i], "default:default");
                    ++i;
                }
                return map;
            }
        }
        if (configuration.getAttribute("useCustomFeatures", false)) {
            String defaultLocation = configuration.getAttribute("featureDefaultLocation", "workspace");
            String defaultPluginResolution = configuration.getAttribute("featurePluginResolution", "workspace");
            HashMap<String, IFeatureModel> workspaceFeatureMap = new HashMap<String, IFeatureModel>();
            HashMap<String, IFeatureModel> externalFeatureMap = new HashMap<String, IFeatureModel>();
            FeatureModelManager fmm = PDECore.getDefault().getFeatureModelManager();
            IFeatureModel[] workspaceFeatureModels = fmm.getWorkspaceModels();
            int i = 0;
            while (i < workspaceFeatureModels.length) {
                String id = workspaceFeatureModels[i].getFeature().getId();
                workspaceFeatureMap.put(id, workspaceFeatureModels[i]);
                ++i;
            }
            IFeatureModel[] externalFeatureModels = fmm.getExternalModels();
            int i2 = 0;
            while (i2 < externalFeatureModels.length) {
                String id = externalFeatureModels[i2].getFeature().getId();
                externalFeatureMap.put(id, externalFeatureModels[i2]);
                ++i2;
            }
            HashMap<String, String> featureResolutionMap = new HashMap<String, String>();
            Set selectedFeatures = configuration.getAttribute("selected_features", null);
            if (selectedFeatures != null) {
                Iterator iterator = selectedFeatures.iterator();
                while (iterator.hasNext()) {
                    String currentSelected = (String)iterator.next();
                    String[] attributes = currentSelected.split(":");
                    if (attributes.length <= 1) continue;
                    featureResolutionMap.put(attributes[0], attributes[1]);
                }
            }
            HashSet<Object> launchPlugins = new HashSet<Object>();
            Iterator iterator = featureResolutionMap.keySet().iterator();
            while (iterator.hasNext()) {
                String id = (String)iterator.next();
                IFeatureModel featureModel = null;
                if ("workspace".equalsIgnoreCase(defaultLocation)) {
                    featureModel = (IFeatureModel)workspaceFeatureMap.get(id);
                }
                if ((featureModel == null || "external".equalsIgnoreCase(defaultLocation)) && externalFeatureMap.containsKey(id)) {
                    featureModel = (IFeatureModel)externalFeatureMap.get(id);
                }
                if (featureModel == null) continue;
                IFeaturePlugin[] featurePlugins = featureModel.getFeature().getPlugins();
                String pluginResolution = (String)featureResolutionMap.get(id);
                if ("default".equalsIgnoreCase(pluginResolution)) {
                    pluginResolution = defaultPluginResolution;
                }
                int i3 = 0;
                while (i3 < featurePlugins.length) {
                    IPluginModelBase model;
                    ModelEntry modelEntry = PluginRegistry.findEntry((String)featurePlugins[i3].getId());
                    if (modelEntry != null && (model = BundleLauncherHelper.findModel(modelEntry, featurePlugins[i3].getVersion(), pluginResolution)) != null) {
                        launchPlugins.add(model);
                    }
                    ++i3;
                }
                IFeatureImport[] featureImports = featureModel.getFeature().getImports();
                int i4 = 0;
                while (i4 < featureImports.length) {
                    IPluginModelBase model;
                    ModelEntry modelEntry;
                    if (featureImports[i4].getType() == 0 && (modelEntry = PluginRegistry.findEntry((String)featureImports[i4].getId())) != null && (model = BundleLauncherHelper.findModel(modelEntry, featureImports[i4].getVersion(), pluginResolution)) != null) {
                        launchPlugins.add(model);
                    }
                    ++i4;
                }
            }
            HashMap additionalPlugins = BundleLauncherHelper.getAdditionalPlugins(configuration, true);
            launchPlugins.addAll(additionalPlugins.keySet());
            if (!osgi) {
                String[] applicationIds = RequirementHelper.getApplicationRequirements(configuration);
                int i5 = 0;
                while (i5 < applicationIds.length) {
                    IPluginModelBase model;
                    ModelEntry modelEntry = PluginRegistry.findEntry((String)applicationIds[i5]);
                    if (modelEntry != null && (model = BundleLauncherHelper.findModel(modelEntry, null, defaultPluginResolution)) != null) {
                        launchPlugins.add(model);
                    }
                    ++i5;
                }
            }
            Set additionalIds = DependencyManager.getDependencies((Object[])launchPlugins.toArray(), (boolean)false, (String[])new String[]{"org.eclipse.ui.workbench.compatibility"});
            Iterator it = additionalIds.iterator();
            while (it.hasNext()) {
                IPluginModelBase model;
                String id = (String)it.next();
                ModelEntry modelEntry = PluginRegistry.findEntry((String)id);
                if (modelEntry == null || (model = BundleLauncherHelper.findModel(modelEntry, null, defaultPluginResolution)) == null) continue;
                launchPlugins.add(model);
            }
            HashMap<String, IPluginModelBase> pluginMap = new HashMap<String, IPluginModelBase>();
            List<IPluginModelBase> workspaceModels = null;
            Iterator<Object> iterator2 = launchPlugins.iterator();
            while (iterator2.hasNext()) {
                IPluginModelBase model = (IPluginModelBase)iterator2.next();
                String id = model.getPluginBase().getId();
                if (pluginMap.containsKey(id)) {
                    IPluginModelBase existing = (IPluginModelBase)pluginMap.get(id);
                    if (model.getPluginBase().getVersion().equalsIgnoreCase(existing.getPluginBase().getVersion()) || BundleLauncherHelper.isSingleton(model) && BundleLauncherHelper.isSingleton(existing)) {
                        if (workspaceModels == null) {
                            workspaceModels = Arrays.asList(PluginRegistry.getWorkspaceModels());
                        }
                        if (!workspaceModels.contains(existing)) {
                            pluginMap.put(id, model);
                            continue;
                        }
                    }
                }
                pluginMap.put(id, model);
            }
            iterator2 = pluginMap.values().iterator();
            while (iterator2.hasNext()) {
                IPluginModelBase model = (IPluginModelBase)iterator2.next();
                BundleLauncherHelper.addBundleToMap(map, model, "default:default");
            }
            return map;
        }
        String workspace = !osgi ? "selected_workspace_plugins" : "workspace_bundles";
        String target = !osgi ? "selected_target_plugins" : "target_bundles";
        map = BundleLauncherHelper.getWorkspaceBundleMap(configuration, set, workspace);
        map.putAll(BundleLauncherHelper.getTargetBundleMap(configuration, set, target));
        return map;
    }

    private static IPluginModelBase findModel(ModelEntry modelEntry, String version, String location) {
        IPluginModelBase model = null;
        if ("workspace".equalsIgnoreCase(location)) {
            model = BundleLauncherHelper.getBestCandidateModel(modelEntry.getWorkspaceModels(), version);
        }
        if (model == null) {
            model = BundleLauncherHelper.getBestCandidateModel(modelEntry.getExternalModels(), version);
        }
        if (model == null && "external".equalsIgnoreCase(location)) {
            model = BundleLauncherHelper.getBestCandidateModel(modelEntry.getWorkspaceModels(), version);
        }
        return model;
    }

    private static boolean isSingleton(IPluginModelBase model) {
        return model.getBundleDescription() == null || model.getBundleDescription().isSingleton();
    }

    private static IPluginModelBase getBestCandidateModel(IPluginModelBase[] models, String version) {
        Version requiredVersion = version != null ? Version.parseVersion((String)version) : Version.emptyVersion;
        IPluginModelBase model = null;
        int i = 0;
        while (i < models.length) {
            if (models[i].getBundleDescription() != null && models[i].isEnabled()) {
                if (model == null) {
                    model = models[i];
                    if (requiredVersion.compareTo(model.getBundleDescription().getVersion()) == 0) {
                        break;
                    }
                } else if (!model.isEnabled() && models[i].isEnabled()) {
                    model = models[i];
                } else {
                    BundleDescription current = model.getBundleDescription();
                    BundleDescription candidate = models[i].getBundleDescription();
                    if (current != null && candidate != null) {
                        if (!current.isResolved() && candidate.isResolved()) {
                            model = models[i];
                        } else {
                            if (requiredVersion.compareTo(candidate.getVersion()) == 0) {
                                model = models[i];
                                break;
                            }
                            if (current.getVersion().compareTo(candidate.getVersion()) < 0) {
                                model = models[i];
                            }
                        }
                    }
                }
            }
            ++i;
        }
        return model;
    }

    public static IPluginModelBase[] getMergedBundles(ILaunchConfiguration configuration, boolean osgi) throws CoreException {
        Map map = BundleLauncherHelper.getMergedBundleMap(configuration, osgi);
        return map.keySet().toArray(new IPluginModelBase[map.size()]);
    }

    public static Map getWorkspaceBundleMap(ILaunchConfiguration configuration, Set set, String attribute) throws CoreException {
        String selected = configuration.getAttribute(attribute, "");
        HashMap map = new HashMap();
        StringTokenizer tok = new StringTokenizer(selected, ",");
        while (tok.hasMoreTokens()) {
            ModelEntry entry;
            String version;
            String idVersion;
            int versionIndex;
            String token = tok.nextToken();
            int index = token.indexOf(64);
            if (index < 0) {
                token = token.concat("@default:default");
                index = token.indexOf(64);
            }
            String id = (versionIndex = (idVersion = token.substring(0, index)).indexOf(42)) > 0 ? idVersion.substring(0, versionIndex) : idVersion;
            String string = version = versionIndex > 0 ? idVersion.substring(versionIndex + 1) : null;
            if (set != null) {
                set.add(id);
            }
            if ((entry = PluginRegistry.findEntry((String)id)) == null) continue;
            IPluginModelBase[] models = entry.getWorkspaceModels();
            HashSet<String> versions = new HashSet<String>();
            int i = 0;
            while (i < models.length) {
                IPluginBase base = models[i].getPluginBase();
                String v = base.getVersion();
                if (versions.add(v) && (base.getVersion().equals(version) || version == null || models.length == 1)) {
                    BundleLauncherHelper.addBundleToMap(map, models[i], token.substring(index + 1));
                }
                ++i;
            }
        }
        if (configuration.getAttribute("automaticAdd", true)) {
            Set deselectedPlugins = LaunchPluginValidator.parsePlugins(configuration, "deselected_workspace_plugins");
            IPluginModelBase[] models = PluginRegistry.getWorkspaceModels();
            int i = 0;
            while (i < models.length) {
                String id = models[i].getPluginBase().getId();
                if (id != null && !deselectedPlugins.contains(models[i])) {
                    if (set != null) {
                        set.add(id);
                    }
                    if (!map.containsKey(models[i])) {
                        BundleLauncherHelper.addBundleToMap(map, models[i], "default:default");
                    }
                }
                ++i;
            }
        }
        return map;
    }

    private static void addBundleToMap(Map map, IPluginModelBase bundle, String sl) {
        boolean defaultsl;
        BundleDescription desc = bundle.getBundleDescription();
        boolean bl = defaultsl = sl == null || sl.equals("default:default");
        if (desc != null && defaultsl) {
            String modelName = desc.getSymbolicName();
            if ("org.eclipse.equinox.ds".equals(modelName)) {
                map.put(bundle, "1:true");
            } else if ("org.eclipse.equinox.simpleconfigurator".equals(modelName)) {
                map.put(bundle, "1:true");
            } else if ("org.eclipse.equinox.common".equals(modelName)) {
                map.put(bundle, "2:true");
            } else if ("org.eclipse.osgi".equals(modelName)) {
                map.put(bundle, "-1:true");
            } else if ("org.eclipse.update.configurator".equals(modelName)) {
                map.put(bundle, DEFAULT_UPDATE_CONFIGURATOR_START_LEVEL);
            } else if ("org.eclipse.core.runtime".equals(modelName)) {
                if (TargetPlatformHelper.getTargetVersion() > 3.1) {
                    map.put(bundle, "default:true");
                } else {
                    map.put(bundle, "2:true");
                }
            } else {
                map.put(bundle, sl);
            }
        } else {
            map.put(bundle, sl);
        }
    }

    public static Map getTargetBundleMap(ILaunchConfiguration configuration, Set set, String attribute) throws CoreException {
        String selected = configuration.getAttribute(attribute, "");
        HashMap map = new HashMap();
        StringTokenizer tok = new StringTokenizer(selected, ",");
        while (tok.hasMoreTokens()) {
            ModelEntry entry;
            String version;
            String idVersion;
            int versionIndex;
            String token = tok.nextToken();
            int index = token.indexOf(64);
            if (index < 0) {
                token = token.concat("@default:default");
                index = token.indexOf(64);
            }
            String id = (versionIndex = (idVersion = token.substring(0, index)).indexOf(42)) > 0 ? idVersion.substring(0, versionIndex) : idVersion;
            String string = version = versionIndex > 0 ? idVersion.substring(versionIndex + 1) : null;
            if (set != null && set.contains(id) || (entry = PluginRegistry.findEntry((String)id)) == null) continue;
            IPluginModelBase[] models = entry.getExternalModels();
            int i = 0;
            while (i < models.length) {
                IPluginBase base;
                if (models[i].isEnabled() && ((base = models[i].getPluginBase()).getVersion().equals(version) || version == null || models.length == 1)) {
                    BundleLauncherHelper.addBundleToMap(map, models[i], token.substring(index + 1));
                }
                ++i;
            }
        }
        return map;
    }

    public static String writeBundleEntry(IPluginModelBase model, String startLevel, String autoStart) {
        boolean hasAutoStart;
        IPluginBase base = model.getPluginBase();
        String id = base.getId();
        StringBuffer buffer = new StringBuffer(id);
        ModelEntry entry = PluginRegistry.findEntry((String)id);
        if (entry != null && entry.getActiveModels().length > 1) {
            buffer.append('*');
            buffer.append(model.getPluginBase().getVersion());
        }
        boolean hasStartLevel = startLevel != null && startLevel.length() > 0;
        boolean bl = hasAutoStart = autoStart != null && autoStart.length() > 0;
        if (hasStartLevel || hasAutoStart) {
            buffer.append('@');
        }
        if (hasStartLevel) {
            buffer.append(startLevel);
        }
        if (hasStartLevel || hasAutoStart) {
            buffer.append(':');
        }
        if (hasAutoStart) {
            buffer.append(autoStart);
        }
        return buffer.toString();
    }

    public static void checkBackwardCompatibility(ILaunchConfiguration configuration, boolean save) throws CoreException {
        boolean upgrade;
        String value2;
        ILaunchConfigurationWorkingCopy wc = null;
        wc = configuration.isWorkingCopy() ? (ILaunchConfigurationWorkingCopy)configuration : configuration.getWorkingCopy();
        String value = configuration.getAttribute("wsproject", null);
        if (value != null) {
            wc.setAttribute("wsproject", null);
            if (value.indexOf(59) != -1) {
                value = value.replace(';', ',');
            } else if (value.indexOf(58) != -1) {
                value = value.replace(':', ',');
            }
            value = value.length() == 0 || value.equals(",") ? null : value.substring(0, value.length() - 1);
            boolean automatic = configuration.getAttribute("automaticAdd", true);
            String attr = automatic ? "deselected_workspace_plugins" : "selected_workspace_plugins";
            wc.setAttribute(attr, value);
        }
        if ((value2 = configuration.getAttribute("extplugins", null)) != null) {
            wc.setAttribute("extplugins", null);
            if (value2.indexOf(59) != -1) {
                value2 = value2.replace(';', ',');
            } else if (value2.indexOf(58) != -1) {
                value2 = value2.replace(':', ',');
            }
            value2 = value2.length() == 0 || value2.equals(",") ? null : value2.substring(0, value2.length() - 1);
            wc.setAttribute("selected_target_plugins", value2);
        }
        String version = configuration.getAttribute("pde.version", null);
        boolean newApp = TargetPlatformHelper.usesNewApplicationModel();
        boolean bl = upgrade = !"3.3".equals(version) && newApp;
        if (!upgrade) {
            boolean bl2 = upgrade = TargetPlatformHelper.getTargetVersion() >= 3.2 && version == null;
        }
        if (upgrade) {
            wc.setAttribute("pde.version", newApp ? "3.3" : "3.2a");
            boolean usedefault = configuration.getAttribute("default", true);
            boolean useFeatures = configuration.getAttribute("usefeatures", false);
            boolean automaticAdd = configuration.getAttribute("automaticAdd", true);
            if (!usedefault && !useFeatures) {
                ArrayList<String> list = new ArrayList<String>();
                if (version == null) {
                    list.add("org.eclipse.core.contenttype");
                    list.add("org.eclipse.core.jobs");
                    list.add("org.eclipse.equinox.common");
                    list.add("org.eclipse.equinox.preferences");
                    list.add("org.eclipse.equinox.registry");
                    list.add("org.eclipse.core.runtime.compatibility.registry");
                }
                if (!"3.3".equals(version) && newApp) {
                    list.add("org.eclipse.equinox.app");
                }
                StringBuffer extensions = new StringBuffer(configuration.getAttribute("selected_workspace_plugins", ""));
                StringBuffer target = new StringBuffer(configuration.getAttribute("selected_target_plugins", ""));
                int i = 0;
                while (i < list.size()) {
                    String plugin = list.get(i).toString();
                    IPluginModelBase model = PluginRegistry.findModel((String)plugin);
                    if (model != null) {
                        if (model.getUnderlyingResource() != null) {
                            if (!automaticAdd) {
                                if (extensions.length() > 0) {
                                    extensions.append(",");
                                }
                                extensions.append(plugin);
                            }
                        } else {
                            if (target.length() > 0) {
                                target.append(",");
                            }
                            target.append(plugin);
                        }
                    }
                    ++i;
                }
                if (extensions.length() > 0) {
                    wc.setAttribute("selected_workspace_plugins", extensions.toString());
                }
                if (target.length() > 0) {
                    wc.setAttribute("selected_target_plugins", target.toString());
                }
            }
        }
        if (save && (value != null || value2 != null || upgrade)) {
            wc.doSave();
        }
    }

    public static String writeAdditionalPluginsEntry(IPluginModelBase model, String pluginResolution, boolean checked) {
        IPluginBase base = model.getPluginBase();
        String id = base.getId();
        StringBuffer buffer = new StringBuffer(id);
        buffer.append(':');
        buffer.append(base.getVersion());
        buffer.append(':');
        buffer.append(pluginResolution);
        buffer.append(':');
        buffer.append(checked);
        return buffer.toString();
    }

    public static HashMap getAdditionalPlugins(ILaunchConfiguration config, boolean onlyEnabled) throws CoreException {
        HashMap<IPluginModelBase, String> resolvedAdditionalPlugins = new HashMap<IPluginModelBase, String>();
        Set userAddedPlugins = config.getAttribute("additional_plugins", null);
        String defaultPluginResolution = config.getAttribute("featurePluginResolution", "workspace");
        if (userAddedPlugins != null) {
            Iterator iterator = userAddedPlugins.iterator();
            while (iterator.hasNext()) {
                IPluginModelBase model;
                String addedPlugin = (String)iterator.next();
                String[] pluginData = addedPlugin.split(":");
                boolean checked = Boolean.valueOf(pluginData[3]);
                if (onlyEnabled && !checked) continue;
                String id = pluginData[0];
                String version = pluginData[1];
                String pluginResolution = pluginData[2];
                ModelEntry pluginModelEntry = PluginRegistry.findEntry((String)id);
                if (pluginModelEntry == null) continue;
                if ("default".equalsIgnoreCase(pluginResolution)) {
                    pluginResolution = defaultPluginResolution;
                }
                if ((model = BundleLauncherHelper.findModel(pluginModelEntry, version, pluginResolution)) == null) continue;
                resolvedAdditionalPlugins.put(model, pluginData[2]);
            }
        }
        return resolvedAdditionalPlugins;
    }
}

