/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.preferences;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.pde.internal.core.PDEPreferencesManager;
import org.eclipse.pde.internal.core.target.TargetPlatformService;
import org.eclipse.pde.internal.core.target.provisional.ITargetHandle;
import org.eclipse.pde.internal.launching.PDELaunchingPlugin;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.SWTFactory;
import org.eclipse.pde.internal.ui.launcher.BaseBlock;
import org.eclipse.pde.internal.ui.preferences.AddToJavaSearchJob;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.prefs.BackingStoreException;

public class MainPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button fUseID;
    private Button fUseName;
    private Button fAutoManage;
    private Button fOverwriteBuildFiles;
    private Button fShowSourceBundles;
    private Button fPromptOnRemove;
    private Button fAddToJavaSearch;
    private Text fJUnitWorkspaceLocation;
    private Button fJUnitWorkspaceLocationRadio;
    private Button fJUnitWorkspacesContainerRadio;

    public MainPreferencePage() {
        this.setPreferenceStore(PDEPlugin.getDefault().getPreferenceStore());
        this.setDescription(PDEUIMessages.Preferences_MainPage_Description);
    }

    protected Control createContents(Composite parent) {
        IPreferenceStore store = PDEPlugin.getDefault().getPreferenceStore();
        PDEPreferencesManager launchingStore = PDELaunchingPlugin.getDefault().getPreferenceManager();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 15;
        composite.setLayout((Layout)layout);
        Group group = SWTFactory.createGroup(composite, PDEUIMessages.Preferences_MainPage_showObjects, 1, 1, 768);
        this.fUseID = new Button((Composite)group, 16);
        this.fUseID.setText(PDEUIMessages.Preferences_MainPage_useIds);
        this.fUseName = new Button((Composite)group, 16);
        this.fUseName.setText(PDEUIMessages.Preferences_MainPage_useFullNames);
        if (store.getString("Preferences.MainPage.showObjects").equals("useIds")) {
            this.fUseID.setSelection(true);
        } else {
            this.fUseName.setSelection(true);
        }
        group = SWTFactory.createGroup(composite, PDEUIMessages.MainPreferencePage_group2, 1, 1, 768);
        this.fAutoManage = new Button((Composite)group, 32);
        this.fAutoManage.setText(PDEUIMessages.MainPreferencePage_updateStale);
        this.fAutoManage.setSelection(launchingStore.getBoolean("Preferences.MainPage.automanageDependencies"));
        group = SWTFactory.createGroup(composite, PDEUIMessages.MainPreferencePage_exportingGroup, 1, 1, 768);
        this.fOverwriteBuildFiles = new Button((Composite)group, 32);
        this.fOverwriteBuildFiles.setText(PDEUIMessages.MainPreferencePage_promptBeforeOverwrite);
        this.fOverwriteBuildFiles.setSelection(!"always".equals(store.getString("Preferences.MainPage.overwriteBuildFilesOnExport")));
        group = SWTFactory.createGroup(composite, PDEUIMessages.MainPreferencePage_sourceGroup, 1, 1, 768);
        this.fShowSourceBundles = new Button((Composite)group, 32);
        this.fShowSourceBundles.setText(PDEUIMessages.MainPreferencePage_showSourceBundles);
        this.fShowSourceBundles.setSelection(store.getBoolean("Preferences.MainPage.showSourceBundles"));
        group = SWTFactory.createGroup(composite, PDEUIMessages.MainPreferencePage_targetDefinitionsGroup, 1, 1, 768);
        this.fPromptOnRemove = new Button((Composite)group, 32);
        this.fPromptOnRemove.setText(PDEUIMessages.MainPreferencePage_promtBeforeRemove);
        this.fPromptOnRemove.setSelection(!"always".equals(store.getString("Preferences.MainPage.promptRemoveTarget")));
        this.fPromptOnRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PDEPlugin.getDefault().getPreferenceStore().setValue("Preferences.MainPage.promptRemoveTarget", MainPreferencePage.this.fPromptOnRemove.getSelection() ? "prompt" : "always");
            }
        });
        this.fAddToJavaSearch = new Button((Composite)group, 32);
        this.fAddToJavaSearch.setText(PDEUIMessages.MainPreferencePage_addToJavaSearch);
        this.fAddToJavaSearch.setSelection(store.getBoolean("Preferences.MainPage.addToJavaSearch"));
        new DefaultJUnitWorkspaceBlock().createControl(composite);
        this.fJUnitWorkspaceLocation.setText(launchingStore.getString("Preferences.MainPage.junitWorkspaceLocation"));
        boolean locationIsContainer = launchingStore.getBoolean("Preferences.MainPage.junitWorkspaceLocationIsContainer");
        this.fJUnitWorkspaceLocationRadio.setSelection(!locationIsContainer);
        this.fJUnitWorkspacesContainerRadio.setSelection(locationIsContainer);
        return composite;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        Dialog.applyDialogFont((Control)this.getControl());
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.pde.doc.user.main_preference_page");
    }

    public boolean performOk() {
        IPreferenceStore store = PDEPlugin.getDefault().getPreferenceStore();
        if (this.fUseID.getSelection()) {
            store.setValue("Preferences.MainPage.showObjects", "useIds");
        } else {
            store.setValue("Preferences.MainPage.showObjects", "useNames");
        }
        store.setValue("Preferences.MainPage.overwriteBuildFilesOnExport", this.fOverwriteBuildFiles.getSelection() ? "prompt" : "always");
        store.setValue("Preferences.MainPage.showSourceBundles", this.fShowSourceBundles.getSelection());
        boolean synchJavaSearch = this.fAddToJavaSearch.getSelection();
        if (store.getBoolean("Preferences.MainPage.addToJavaSearch") != synchJavaSearch) {
            store.setValue("Preferences.MainPage.addToJavaSearch", synchJavaSearch);
            try {
                if (synchJavaSearch) {
                    ITargetHandle target = TargetPlatformService.getDefault().getWorkspaceTargetHandle();
                    if (target != null) {
                        AddToJavaSearchJob.synchWithTarget(target.getTargetDefinition());
                    }
                } else {
                    AddToJavaSearchJob.clearAll();
                }
            }
            catch (CoreException e) {
                PDEPlugin.log(e);
            }
        }
        PDEPlugin.getDefault().getPreferenceManager().savePluginPreferences();
        PDEPreferencesManager launchingStore = PDELaunchingPlugin.getDefault().getPreferenceManager();
        launchingStore.setValueOrRemove("Preferences.MainPage.automanageDependencies", this.fAutoManage.getSelection());
        launchingStore.setValueOrRemove("Preferences.MainPage.junitWorkspaceLocation", this.fJUnitWorkspaceLocation.getText());
        launchingStore.setValueOrRemove("Preferences.MainPage.junitWorkspaceLocationIsContainer", this.fJUnitWorkspacesContainerRadio.getSelection());
        try {
            launchingStore.flush();
        }
        catch (BackingStoreException e) {
            PDEPlugin.log(e);
        }
        return super.performOk();
    }

    protected void performDefaults() {
        IPreferenceStore store = PDEPlugin.getDefault().getPreferenceStore();
        if (store.getDefaultString("Preferences.MainPage.showObjects").equals("useIds")) {
            this.fUseID.setSelection(true);
            this.fUseName.setSelection(false);
        } else {
            this.fUseID.setSelection(false);
            this.fUseName.setSelection(true);
        }
        this.fAutoManage.setSelection(false);
        this.fOverwriteBuildFiles.setSelection(true);
        this.fShowSourceBundles.setSelection(false);
        this.fPromptOnRemove.setSelection(true);
        this.fAddToJavaSearch.setSelection(store.getDefaultBoolean("Preferences.MainPage.addToJavaSearch"));
        PDEPreferencesManager launchingStore = PDELaunchingPlugin.getDefault().getPreferenceManager();
        boolean locationIsContainer = launchingStore.getDefaultBoolean("Preferences.MainPage.junitWorkspaceLocationIsContainer");
        this.fJUnitWorkspaceLocationRadio.setSelection(!locationIsContainer);
        this.fJUnitWorkspacesContainerRadio.setSelection(locationIsContainer);
        this.fJUnitWorkspaceLocation.setText(launchingStore.getDefaultString("Preferences.MainPage.junitWorkspaceLocation"));
    }

    public void setVisible(boolean visible) {
        this.fPromptOnRemove.setSelection(!"always".equals(PDEPlugin.getDefault().getPreferenceManager().getString("Preferences.MainPage.promptRemoveTarget")));
        super.setVisible(visible);
    }

    public void init(IWorkbench workbench) {
    }

    private final class DefaultJUnitWorkspaceBlock
    extends BaseBlock {
        DefaultJUnitWorkspaceBlock() {
            super(null);
        }

        public void createControl(Composite composite) {
            Group group = SWTFactory.createGroup(composite, PDEUIMessages.MainPreferencePage_junitWorkspaceGroup, 2, 1, 768);
            Composite radios = SWTFactory.createComposite((Composite)group, 2, 2, 768, 0, 0);
            MainPreferencePage.this.fJUnitWorkspaceLocationRadio = new Button(radios, 16);
            MainPreferencePage.this.fJUnitWorkspaceLocationRadio.setText(PDEUIMessages.MainPreferencePage_junitWorkspace_asLocation);
            MainPreferencePage.this.fJUnitWorkspaceLocationRadio.setLayoutData((Object)new GridData(32));
            MainPreferencePage.this.fJUnitWorkspaceLocationRadio.setSelection(true);
            MainPreferencePage.this.fJUnitWorkspacesContainerRadio = new Button(radios, 16);
            MainPreferencePage.this.fJUnitWorkspacesContainerRadio.setText(PDEUIMessages.MainPreferencePage_junitWorkspace_asContainer);
            MainPreferencePage.this.fJUnitWorkspacesContainerRadio.setLayoutData((Object)new GridData(32));
            this.createText((Composite)group, PDEUIMessages.WorkspaceDataBlock_location, 0);
            MainPreferencePage.this.fJUnitWorkspaceLocation = this.fLocationText;
            Composite buttons = SWTFactory.createComposite((Composite)group, 3, 2, 640, 0, 0);
            this.createButtons(buttons, new String[]{PDEUIMessages.MainPreferencePage_junitWorkspace_workspace, PDEUIMessages.MainPreferencePage_junitWorkspace_fileSystem, PDEUIMessages.MainPreferencePage_junitWorkspace_variables});
        }

        protected String getName() {
            return PDEUIMessages.WorkspaceDataBlock_name;
        }

        protected boolean isFile() {
            return false;
        }
    }
}

