/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import java.util.Hashtable;
import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.Mozilla;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.LONG;
import org.eclipse.swt.internal.carbon.CFRange;
import org.eclipse.swt.internal.carbon.CGRect;
import org.eclipse.swt.internal.carbon.HILayoutInfo;
import org.eclipse.swt.internal.carbon.HISideBinding;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.cocoa.Cocoa;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.mozilla.nsIBaseWindow;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

class MozillaDelegate {
    Browser browser;
    Listener listener;
    boolean hasFocus;
    static Callback Callback3;
    static Hashtable handles;

    static {
        handles = new Hashtable();
    }

    MozillaDelegate(Browser browser) {
        this.browser = browser;
    }

    static Browser findBrowser(int handle) {
        LONG value = (LONG)handles.get(new LONG(handle));
        if (value != null) {
            Display display = Display.getCurrent();
            return (Browser)display.findWidget(value.value);
        }
        return null;
    }

    static String getLibraryName() {
        return "libxpcom.dylib";
    }

    static char[] mbcsToWcs(String codePage, byte[] buffer) {
        int encoding = OS.CFStringGetSystemEncoding();
        int cfstring = OS.CFStringCreateWithBytes(0, buffer, buffer.length, encoding, false);
        char[] chars = null;
        if (cfstring != 0) {
            int length = OS.CFStringGetLength(cfstring);
            chars = new char[length];
            if (length != 0) {
                CFRange range = new CFRange();
                range.length = length;
                OS.CFStringGetCharacters(cfstring, range, chars);
            }
            OS.CFRelease(cfstring);
        }
        return chars;
    }

    static byte[] wcsToMbcs(String codePage, String string, boolean terminate) {
        char[] chars = new char[string.length()];
        string.getChars(0, chars.length, chars, 0);
        int cfstring = OS.CFStringCreateWithCharacters(0, chars, chars.length);
        byte[] buffer = null;
        if (cfstring != 0) {
            CFRange range = new CFRange();
            range.length = chars.length;
            int encoding = OS.CFStringGetSystemEncoding();
            int[] size = new int[1];
            int numChars = OS.CFStringGetBytes(cfstring, range, encoding, (byte)63, true, null, 0, size);
            buffer = new byte[size[0] + (terminate ? 1 : 0)];
            if (numChars != 0) {
                numChars = OS.CFStringGetBytes(cfstring, range, encoding, (byte)63, true, buffer, size[0], size);
            }
            OS.CFRelease(cfstring);
        }
        return buffer;
    }

    static int eventProc3(int nextHandler, int theEvent, int userData) {
        Widget widget = Display.getCurrent().findWidget(userData);
        if (widget instanceof Browser) {
            Browser browser = (Browser)widget;
            switch (OS.GetEventClass(theEvent)) {
                case 1836021107: {
                    browser.getShell().forceActive();
                    ((Mozilla)browser.webBrowser).Activate();
                    break;
                }
                case 1801812322: {
                    int handle = browser.handle;
                    OS.CFRetain(handle);
                    int result = OS.CallNextEventHandler(nextHandler, theEvent);
                    OS.CFRelease(handle);
                    return result;
                }
            }
        }
        return -9874;
    }

    void addWindowSubclass() {
    }

    int createBaseWindow(nsIBaseWindow baseWindow) {
        int application = Cocoa.objc_msgSend(Cocoa.C_NSApplication, Cocoa.S_sharedApplication);
        int mainMenu = Cocoa.objc_msgSend(application, Cocoa.S_mainMenu);
        if (mainMenu != 0) {
            Cocoa.objc_msgSend(mainMenu, Cocoa.S_retain);
        }
        int rc = baseWindow.Create();
        if (mainMenu != 0) {
            Cocoa.objc_msgSend(application, Cocoa.S_setMainMenu, mainMenu);
            Cocoa.objc_msgSend(mainMenu, Cocoa.S_release);
        }
        return rc;
    }

    int getHandle() {
        int callback3Address;
        int[] outControl;
        NSRect r;
        int rc;
        int embedHandle = Cocoa.objc_msgSend(Cocoa.C_NSImageView, Cocoa.S_alloc);
        if (embedHandle == 0) {
            this.browser.dispose();
            SWT.error(2);
        }
        if ((rc = Cocoa.HICocoaViewCreate(embedHandle = Cocoa.objc_msgSend(embedHandle, Cocoa.S_initWithFrame, r = new NSRect()), 0, outControl = new int[1])) == 0 && outControl[0] != 0) {
            Cocoa.objc_msgSend(embedHandle, Cocoa.S_release);
        } else {
            try {
                System.loadLibrary("frameembedding");
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {}
            rc = Cocoa.HIJavaViewCreateWithCocoaView(outControl, embedHandle);
            if (rc != 0 || outControl[0] == 0) {
                this.browser.dispose();
                SWT.error(2);
            }
        }
        int subHIView = outControl[0];
        HILayoutInfo newLayoutInfo = new HILayoutInfo();
        newLayoutInfo.version = 0;
        OS.HIViewGetLayoutInfo(subHIView, newLayoutInfo);
        HISideBinding biding = newLayoutInfo.binding.top;
        biding.toView = 0;
        biding.kind = 1;
        biding.offset = 0.0f;
        biding = newLayoutInfo.binding.left;
        biding.toView = 0;
        biding.kind = 1;
        biding.offset = 0.0f;
        biding = newLayoutInfo.binding.bottom;
        biding.toView = 0;
        biding.kind = (short)2;
        biding.offset = 0.0f;
        biding = newLayoutInfo.binding.right;
        biding.toView = 0;
        biding.kind = (short)2;
        biding.offset = 0.0f;
        OS.HIViewSetLayoutInfo(subHIView, newLayoutInfo);
        OS.HIViewChangeFeatures(subHIView, 0x2000000, 0);
        OS.HIViewSetVisible(subHIView, true);
        int parentHandle = this.browser.handle;
        OS.HIViewAddSubview(this.browser.handle, subHIView);
        CGRect rect = new CGRect();
        OS.HIViewGetFrame(parentHandle, rect);
        rect.y = 0.0f;
        rect.x = 0.0f;
        OS.HIViewSetFrame(subHIView, rect);
        handles.put(new LONG(embedHandle), new LONG(this.browser.handle));
        if (Callback3 == null) {
            Callback3 = new Callback(this.getClass(), "eventProc3", 3);
        }
        if ((callback3Address = Callback3.getAddress()) == 0) {
            this.browser.dispose();
            SWT.error(3);
        }
        int[] mask = new int[]{1836021107, 1, 1801812322, 1};
        int controlTarget = OS.GetControlEventTarget(subHIView);
        OS.InstallEventHandler(controlTarget, callback3Address, mask.length / 2, mask, this.browser.handle, null);
        return embedHandle;
    }

    String getJSLibraryName() {
        return "libmozjs.dylib";
    }

    String getProfilePath() {
        String baseDir = System.getProperty("user.home");
        return String.valueOf(baseDir) + Mozilla.SEPARATOR_OS + ".mozilla" + Mozilla.SEPARATOR_OS + "eclipse";
    }

    String getSWTInitLibraryName() {
        return "swt-xulrunner";
    }

    void handleFocus() {
        if (this.hasFocus) {
            return;
        }
        this.hasFocus = true;
        ((Mozilla)this.browser.webBrowser).Activate();
        this.browser.setFocus();
        this.listener = new Listener(){

            public void handleEvent(Event event) {
                if (event.widget == MozillaDelegate.this.browser) {
                    return;
                }
                ((Mozilla)MozillaDelegate.this.browser.webBrowser).Deactivate();
                MozillaDelegate.this.hasFocus = false;
                MozillaDelegate.this.browser.getDisplay().removeFilter(15, this);
                MozillaDelegate.this.browser.getShell().removeListener(27, this);
                MozillaDelegate.this.listener = null;
            }
        };
        this.browser.getDisplay().addFilter(15, this.listener);
        this.browser.getShell().addListener(27, this.listener);
    }

    void handleMouseDown() {
    }

    boolean hookEnterExit() {
        return true;
    }

    void init() {
    }

    boolean needsSpinup() {
        return false;
    }

    void onDispose(int embedHandle) {
        handles.remove(new LONG(embedHandle));
        if (this.listener != null) {
            this.browser.getDisplay().removeFilter(15, this.listener);
            this.browser.getShell().removeListener(27, this.listener);
            this.listener = null;
        }
        this.browser = null;
    }

    void removeWindowSubclass() {
    }

    boolean sendTraverse() {
        return true;
    }

    void setSize(int embedHandle, int width, int height) {
    }
}

