/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DragDetectListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.internal.carbon.ATSFontMetrics;
import org.eclipse.swt.internal.carbon.CFRange;
import org.eclipse.swt.internal.carbon.CGPoint;
import org.eclipse.swt.internal.carbon.CGRect;
import org.eclipse.swt.internal.carbon.ControlFontStyleRec;
import org.eclipse.swt.internal.carbon.HIThemeFrameDrawInfo;
import org.eclipse.swt.internal.carbon.HIThemeTextInfo;
import org.eclipse.swt.internal.carbon.HMHelpContentRec;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Point;
import org.eclipse.swt.internal.carbon.Rect;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public abstract class Control
extends Widget
implements Drawable {
    public int handle;
    Composite parent;
    String toolTipText;
    Object layoutData;
    int drawCount;
    int visibleRgn;
    Menu menu;
    float[] foreground;
    float[] background;
    Image backgroundImage;
    Font font;
    Cursor cursor;
    Region region;
    GCData[] gcs;
    Accessible accessible;
    static final String RESET_VISIBLE_REGION = "org.eclipse.swt.internal.resetVisibleRegion";
    static final String DRAG_STARTED = "org.eclipse.swt.internal.dragStarted";

    Control() {
    }

    public Control(Composite parent, int style) {
        super(parent, style);
        this.parent = parent;
        this.createWidget();
    }

    int actionProc(int theControl, int partCode) {
        int result = super.actionProc(theControl, partCode);
        if (result == 0) {
            return result;
        }
        if (this.isDisposed()) {
            return 0;
        }
        this.sendTrackEvents();
        return result;
    }

    public void addControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(11, typedListener);
        this.addListener(10, typedListener);
    }

    public void addDragDetectListener(DragDetectListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(29, typedListener);
    }

    public void addFocusListener(FocusListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(15, typedListener);
        this.addListener(16, typedListener);
    }

    public void addHelpListener(HelpListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(28, typedListener);
    }

    public void addKeyListener(KeyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(2, typedListener);
        this.addListener(1, typedListener);
    }

    public void addMenuDetectListener(MenuDetectListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(35, typedListener);
    }

    public void addMouseListener(MouseListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(3, typedListener);
        this.addListener(4, typedListener);
        this.addListener(8, typedListener);
    }

    public void addMouseTrackListener(MouseTrackListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(6, typedListener);
        this.addListener(7, typedListener);
        this.addListener(32, typedListener);
    }

    public void addMouseMoveListener(MouseMoveListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(5, typedListener);
    }

    public void addMouseWheelListener(MouseWheelListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(37, typedListener);
    }

    void addRelation(Control control) {
    }

    public void addPaintListener(PaintListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(9, typedListener);
    }

    public void addTraverseListener(TraverseListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(31, typedListener);
    }

    int colorProc(int inControl, int inMessage, int inDrawDepth, int inDrawInColor) {
        switch (inMessage) {
            case 30: {
                if (this.foreground != null) {
                    OS.RGBForeColor(this.toRGBColor(this.foreground));
                } else {
                    OS.SetThemeTextColor((short)1, (short)inDrawDepth, inDrawInColor != 0);
                }
                return 0;
            }
            case 23: {
                float[] background;
                float[] fArray = background = this.background != null ? this.background : this.getParentBackground();
                if (background != null) {
                    OS.RGBBackColor(this.toRGBColor(background));
                } else {
                    OS.SetThemeBackground((short)1, (short)inDrawDepth, inDrawInColor != 0);
                }
                return 0;
            }
        }
        return -9874;
    }

    int callFocusEventHandler(int nextHandler, int theEvent) {
        return OS.CallNextEventHandler(nextHandler, theEvent);
    }

    void checkBackground() {
        Shell shell = this.getShell();
        if (this == shell) {
            return;
        }
        this.state &= 0xFFFFFBFF;
        Composite composite = this.parent;
        while (true) {
            int mode;
            if ((mode = composite.backgroundMode) != 0) {
                if (mode == 1) {
                    Control control = this;
                    do {
                        if ((control.state & 0x800) != 0) continue;
                        return;
                    } while ((control = control.parent) != composite);
                }
                this.state |= 0x400;
                return;
            }
            if (composite == shell) break;
            composite = composite.parent;
        }
    }

    void checkBuffered() {
        this.style |= 0x20000000;
    }

    public org.eclipse.swt.graphics.Point computeSize(int wHint, int hHint) {
        return this.computeSize(wHint, hHint, true);
    }

    public org.eclipse.swt.graphics.Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 64;
        int height = 64;
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        int border = this.getBorderWidth();
        return new org.eclipse.swt.graphics.Point(width += border * 2, height += border * 2);
    }

    Control computeTabGroup() {
        if (this.isTabGroup()) {
            return this;
        }
        return this.parent.computeTabGroup();
    }

    Control[] computeTabList() {
        if (this.isTabGroup() && this.getVisible() && this.getEnabled()) {
            return new Control[]{this};
        }
        return new Control[0];
    }

    Control computeTabRoot() {
        Control[] tabList = this.parent._getTabList();
        if (tabList != null) {
            int index = 0;
            while (index < tabList.length) {
                if (tabList[index] == this) break;
                ++index;
            }
            if (index == tabList.length && this.isTabGroup()) {
                return this;
            }
        }
        return this.parent.computeTabRoot();
    }

    boolean contains(String[] array, String element) {
        int i = 0;
        while (i < array.length) {
            if (array[i].equals(element)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    void createWidget() {
        this.state |= 0x40000;
        this.checkOrientation(this.parent);
        super.createWidget();
        this.checkBackground();
        this.checkBuffered();
        this.setDefaultFont();
        this.setZOrder();
        this.setRelations();
    }

    Color defaultBackground() {
        return this.display.getSystemColor(22);
    }

    Font defaultFont() {
        byte[] family = new byte[256];
        short[] size = new short[1];
        byte[] style = new byte[1];
        OS.GetThemeFont((short)this.defaultThemeFont(), (short)-1, family, size, style);
        short id = OS.FMGetFontFamilyFromName(family);
        int[] font = new int[1];
        OS.FMGetFontFromFontFamilyInstance(id, style[0], font, null);
        return Font.carbon_new(this.display, OS.FMGetATSFontRefFromFont(font[0]), style[0], size[0]);
    }

    Color defaultForeground() {
        return this.display.getSystemColor(21);
    }

    int defaultThemeFont() {
        if (this.display.smallFonts) {
            return 1;
        }
        return 0;
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(this.handle);
    }

    void destroyWidget() {
        Display display = this.display;
        int theControl = this.topHandle();
        this.releaseHandle();
        if (theControl != 0) {
            if (display.delayDispose) {
                display.addToDisposeWindow(theControl);
            } else {
                OS.DisposeControl(theControl);
            }
        }
    }

    public boolean dragDetect(Event event) {
        this.checkWidget();
        if (event == null) {
            this.error(4);
        }
        return this.dragDetect(event.button, event.count, event.stateMask, event.x, event.y);
    }

    public boolean dragDetect(MouseEvent event) {
        this.checkWidget();
        if (event == null) {
            this.error(4);
        }
        return this.dragDetect(event.button, event.count, event.stateMask, event.x, event.y);
    }

    boolean dragDetect(int button, int count, int stateMask, int x, int y) {
        if (button != 1 || count != 1) {
            return false;
        }
        if (!this.dragDetect(x, y, false, null)) {
            return false;
        }
        return this.sendDragEvent(button, stateMask, x, y);
    }

    boolean dragDetect(int x, int y, boolean filter, boolean[] consume) {
        Rect rect = new Rect();
        int window = OS.GetControlOwner(this.handle);
        CGPoint pt = new CGPoint();
        OS.HIViewConvertPoint(pt, this.handle, 0);
        x += (int)pt.x;
        y += (int)pt.y;
        OS.GetWindowBounds(window, (short)32, rect);
        Point pt1 = new Point();
        pt1.h = (short)(x += rect.left);
        pt1.v = (short)(y += rect.top);
        return OS.WaitMouseMoved(pt1);
    }

    void drawFocus(int control, int context, boolean hasFocus, boolean hasBorder, boolean drawBackground, Rect inset) {
        int state;
        if (drawBackground) {
            this.fillBackground(control, context, null);
        }
        CGRect rect = new CGRect();
        OS.HIViewGetBounds(control, rect);
        rect.x += (float)inset.left;
        rect.y += (float)inset.top;
        rect.width -= (float)(inset.right + inset.left);
        rect.height -= (float)(inset.bottom + inset.top);
        if (OS.IsControlEnabled(control)) {
            state = OS.IsControlActive(control) ? 1 : 0;
        } else {
            int n = state = OS.IsControlActive(control) ? 7 : 8;
        }
        if (hasBorder) {
            HIThemeFrameDrawInfo info = new HIThemeFrameDrawInfo();
            info.state = state;
            info.kind = 0;
            info.isFocused = hasFocus;
            OS.HIThemeDrawFrame(rect, info, context, 0);
        } else {
            OS.HIThemeDrawFocusRect(rect, hasFocus, context, 0);
        }
    }

    boolean drawFocusRing() {
        return this.hasBorder();
    }

    boolean drawGripper(int x, int y, int width, int height, boolean vertical) {
        return false;
    }

    void drawWidget(int control, int context, int damageRgn, int visibleRgn, int theEvent) {
        if (control != this.handle) {
            return;
        }
        if (!this.hooks(9) && !this.filters(9)) {
            return;
        }
        Rect rect = new Rect();
        OS.GetRegionBounds(visibleRgn, rect);
        int[] port = new int[1];
        OS.GetPort(port);
        GCData data = new GCData();
        data.port = port[0];
        data.paintEvent = theEvent;
        data.visibleRgn = visibleRgn;
        GC gc = GC.carbon_new(this, data);
        Event event = new Event();
        event.gc = gc;
        event.x = rect.left;
        event.y = rect.top;
        event.width = rect.right - rect.left;
        event.height = rect.bottom - rect.top;
        this.sendEvent(9, event);
        event.gc = null;
        gc.dispose();
    }

    void enableWidget(boolean enabled) {
        int topHandle = this.topHandle();
        if (enabled) {
            OS.EnableControl(topHandle);
        } else {
            OS.DisableControl(topHandle);
        }
    }

    boolean equals(float[] color1, float[] color2) {
        if (color1 == color2) {
            return true;
        }
        if (color1 == null) {
            return color2 == null;
        }
        if (color2 == null) {
            return color1 == null;
        }
        int i = 0;
        while (i < color1.length) {
            if (color1[i] != color2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    void fillBackground(int control, int context, Rectangle bounds) {
        this.fillBackground(control, context, bounds, 0, 0);
    }

    void fillBackground(int control, int context, Rectangle bounds, int tx, int ty) {
        OS.CGContextSaveGState(context);
        CGRect rect = new CGRect();
        if (bounds != null) {
            rect.x = bounds.x;
            rect.y = bounds.y;
            rect.width = bounds.width;
            rect.height = bounds.height;
        } else {
            OS.HIViewGetBounds(control, rect);
        }
        Control widget = this.findBackgroundControl();
        if (widget != null && widget.backgroundImage != null) {
            CGPoint pt = new CGPoint();
            OS.HIViewConvertPoint(pt, control, widget.handle);
            OS.CGContextTranslateCTM(context, -pt.x - (float)tx, -pt.y - (float)ty);
            Pattern pattern = new Pattern(this.display, widget.backgroundImage);
            GCData data = new GCData();
            data.device = this.display;
            data.background = widget.getBackgroundColor().handle;
            GC gc = GC.carbon_new(context, data);
            gc.setBackgroundPattern(pattern);
            gc.fillRectangle((int)(rect.x + pt.x + (float)tx), (int)(rect.y + pt.y + (float)ty), (int)rect.width, (int)rect.height);
            gc.dispose();
            pattern.dispose();
        } else if (widget != null && widget.background != null) {
            int colorspace = OS.CGColorSpaceCreateDeviceRGB();
            OS.CGContextSetFillColorSpace(context, colorspace);
            OS.CGContextSetFillColor(context, widget.background);
            OS.CGColorSpaceRelease(colorspace);
            OS.CGContextSetAlpha(context, this.getThemeAlpha());
            OS.CGContextFillRect(context, rect);
        } else if (OS.VERSION >= 4160) {
            OS.HIThemeSetFill(1, 0, context, 0);
            OS.CGContextSetAlpha(context, this.getThemeAlpha());
            OS.CGContextFillRect(context, rect);
        } else {
            Rect rect1 = new Rect();
            rect1.left = (short)rect.x;
            rect1.top = (short)rect.y;
            rect1.right = (short)(rect.x + rect.width);
            rect1.bottom = (short)(rect.y + rect.height);
            OS.SetThemeBackground((short)1, (short)0, true);
            OS.EraseRect(rect1);
        }
        OS.CGContextRestoreGState(context);
    }

    Cursor findCursor() {
        if (this.cursor != null) {
            return this.cursor;
        }
        return this.parent.findCursor();
    }

    Control findBackgroundControl() {
        if (this.backgroundImage != null || this.background != null) {
            return this;
        }
        return (this.state & 0x400) != 0 ? this.parent.findBackgroundControl() : null;
    }

    Menu[] findMenus(Control control) {
        if (this.menu != null && this != control) {
            return new Menu[]{this.menu};
        }
        return new Menu[0];
    }

    void fixChildren(Shell newShell, Shell oldShell, Decorations newDecorations, Decorations oldDecorations, Menu[] menus) {
        oldShell.fixShell(newShell, this);
        oldDecorations.fixDecorations(newDecorations, this, menus);
    }

    void fixFocus(Control focusControl) {
        Shell shell = this.getShell();
        Control control = this;
        while (control != shell && (control = control.parent) != null) {
            if (!control.setFocus()) continue;
            return;
        }
        shell.setSavedFocus(focusControl);
        int window = OS.GetControlOwner(this.handle);
        OS.ClearKeyboardFocus(window);
    }

    int focusHandle() {
        return this.handle;
    }

    int focusPart() {
        return -1;
    }

    public boolean forceFocus() {
        this.checkWidget();
        if (this.display.focusEvent == 16) {
            return false;
        }
        Decorations shell = this.menuShell();
        shell.setSavedFocus(this);
        if (!this.isEnabled() || !this.isVisible()) {
            return false;
        }
        if (this.isFocusControl()) {
            return true;
        }
        shell.setSavedFocus(null);
        shell.bringToTop(false);
        if (this.isDisposed()) {
            return false;
        }
        int focusHandle = this.focusHandle();
        int window = OS.GetControlOwner(focusHandle);
        Control oldFocus = this.display.getFocusControl(window, true);
        if (oldFocus == this) {
            return true;
        }
        this.display.ignoreFocus = true;
        OS.SetKeyboardFocus(window, focusHandle, (short)this.focusPart());
        this.display.ignoreFocus = false;
        Control newFocus = this.display.getFocusControl();
        if (oldFocus != newFocus) {
            if (oldFocus != null && !oldFocus.isDisposed()) {
                oldFocus.sendFocusEvent(16, false);
            }
            if (newFocus != null && !newFocus.isDisposed() && newFocus.isEnabled()) {
                newFocus.sendFocusEvent(15, false);
            }
        }
        if (this.isDisposed()) {
            return false;
        }
        shell.setSavedFocus(this);
        return this.hasFocus();
    }

    public Accessible getAccessible() {
        this.checkWidget();
        if (this.accessible == null) {
            this.accessible = this.new_Accessible(this);
        }
        return this.accessible;
    }

    String[] getAxAttributes() {
        return null;
    }

    public Color getBackground() {
        this.checkWidget();
        Control control = this.findBackgroundControl();
        if (control == null) {
            control = this;
        }
        return control.getBackgroundColor();
    }

    Color getBackgroundColor() {
        return this.background != null ? Color.carbon_new(this.display, this.background) : this.defaultBackground();
    }

    public Image getBackgroundImage() {
        this.checkWidget();
        Control control = this.findBackgroundControl();
        if (control == null) {
            control = this;
        }
        return control.backgroundImage;
    }

    public int getBorderWidth() {
        this.checkWidget();
        return 0;
    }

    public Rectangle getBounds() {
        this.checkWidget();
        return this.getControlBounds(this.topHandle());
    }

    boolean isActive() {
        return this.getShell().getModalShell() == null && this.display.getModalDialog() == null;
    }

    public boolean getDragDetect() {
        this.checkWidget();
        return (this.state & 0x40000) != 0;
    }

    boolean getDrawing() {
        return this.drawCount <= 0;
    }

    public Cursor getCursor() {
        this.checkWidget();
        return this.cursor;
    }

    public boolean getEnabled() {
        this.checkWidget();
        return (this.state & 8) == 0;
    }

    public Font getFont() {
        this.checkWidget();
        return this.font != null ? this.font : this.defaultFont();
    }

    public Color getForeground() {
        this.checkWidget();
        return this.getForegroundColor();
    }

    Color getForegroundColor() {
        return this.foreground != null ? Color.carbon_new(this.display, this.foreground) : this.defaultForeground();
    }

    public Object getLayoutData() {
        this.checkWidget();
        return this.layoutData;
    }

    public org.eclipse.swt.graphics.Point getLocation() {
        this.checkWidget();
        Rectangle rect = this.getControlBounds(this.topHandle());
        return new org.eclipse.swt.graphics.Point(rect.x, rect.y);
    }

    public Menu getMenu() {
        this.checkWidget();
        return this.menu;
    }

    int getMininumHeight() {
        return 0;
    }

    public Monitor getMonitor() {
        this.checkWidget();
        Monitor[] monitors = this.display.getMonitors();
        if (monitors.length == 1) {
            return monitors[0];
        }
        int index = -1;
        int value = -1;
        Rectangle bounds = this.getBounds();
        if (this != this.getShell()) {
            bounds = this.display.map((Control)this.parent, null, bounds);
        }
        int i = 0;
        while (i < monitors.length) {
            Rectangle rect = bounds.intersection(monitors[i].getBounds());
            int area = rect.width * rect.height;
            if (area > 0 && area > value) {
                index = i;
                value = area;
            }
            ++i;
        }
        if (index >= 0) {
            return monitors[index];
        }
        int centerX = bounds.x + bounds.width / 2;
        int centerY = bounds.y + bounds.height / 2;
        int i2 = 0;
        while (i2 < monitors.length) {
            int x;
            Rectangle rect = monitors[i2].getBounds();
            int n = centerX < rect.x ? rect.x - centerX : (x = centerX > rect.x + rect.width ? centerX - rect.x - rect.width : 0);
            int y = centerY < rect.y ? rect.y - centerY : (centerY > rect.y + rect.height ? centerY - rect.y - rect.height : 0);
            int distance = x * x + y * y;
            if (index == -1 || distance < value) {
                index = i2;
                value = distance;
            }
            ++i2;
        }
        return monitors[index];
    }

    public Composite getParent() {
        this.checkWidget();
        return this.parent;
    }

    float[] getParentBackground() {
        return this.parent.background;
    }

    Control[] getPath() {
        int count = 0;
        Shell shell = this.getShell();
        Control control = this;
        while (control != shell) {
            ++count;
            control = control.parent;
        }
        control = this;
        Control[] result = new Control[count];
        while (control != shell) {
            result[--count] = control;
            control = control.parent;
        }
        return result;
    }

    public Region getRegion() {
        this.checkWidget();
        return this.region;
    }

    public Shell getShell() {
        this.checkWidget();
        return this.parent.getShell();
    }

    public org.eclipse.swt.graphics.Point getSize() {
        this.checkWidget();
        return this.getControlSize(this.topHandle());
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    float getThemeAlpha() {
        return 1.0f * this.parent.getThemeAlpha();
    }

    public boolean getVisible() {
        this.checkWidget();
        return (this.state & 0x10) == 0;
    }

    int getVisibleRegion(int control, boolean clipChildren) {
        if (!clipChildren) {
            return super.getVisibleRegion(control, clipChildren);
        }
        if (this.visibleRgn == 0) {
            this.visibleRgn = OS.NewRgn();
            this.calculateVisibleRegion(control, this.visibleRgn, clipChildren);
        }
        int result = OS.NewRgn();
        OS.CopyRgn(this.visibleRgn, result);
        return result;
    }

    boolean hasBorder() {
        return (this.style & 0x800) != 0;
    }

    boolean hasFocus() {
        return this == this.display.getFocusControl();
    }

    int helpProc(int inControl, int inGlobalMouse, int inRequest, int outContentProvided, int ioHelpContent) {
        switch (inRequest) {
            case 0: {
                short[] contentProvided = new short[]{-2};
                if (this.toolTipText != null && this.toolTipText.length() != 0) {
                    char[] buffer = new char[this.toolTipText.length()];
                    this.toolTipText.getChars(0, buffer.length, buffer, 0);
                    int length = this.fixMnemonic(buffer);
                    if (this.display.helpString != 0) {
                        OS.CFRelease(this.display.helpString);
                    }
                    this.display.helpString = OS.CFStringCreateWithCharacters(0, buffer, length);
                    HMHelpContentRec helpContent = new HMHelpContentRec();
                    OS.memmove(helpContent, ioHelpContent, 534);
                    helpContent.version = 3;
                    int cursorHeight = 16;
                    helpContent.tagSide = (short)23;
                    Point pt = new Point();
                    OS.memmove(pt, new int[]{inGlobalMouse}, 4);
                    int x = pt.h;
                    int y = pt.v;
                    if (this.display.helpWidget != this) {
                        this.display.lastHelpX = x + cursorHeight / 2;
                        this.display.lastHelpY = y + cursorHeight + cursorHeight / 2;
                    }
                    int jitter = 4;
                    int deltaX = Math.abs(this.display.lastHelpX - x) + jitter;
                    int deltaY = Math.abs(this.display.lastHelpY - y) + jitter;
                    x = this.display.lastHelpX - deltaX;
                    y = this.display.lastHelpY - deltaY;
                    int width = deltaX * 2;
                    int height = deltaY * 2;
                    this.display.helpWidget = this;
                    helpContent.absHotRect_left = (short)x;
                    helpContent.absHotRect_top = (short)y;
                    helpContent.absHotRect_right = (short)(x + width);
                    helpContent.absHotRect_bottom = (short)(y + height);
                    helpContent.content0_contentType = 1667658612;
                    helpContent.content0_tagCFString = this.display.helpString;
                    helpContent.content1_contentType = 1667658612;
                    helpContent.content1_tagCFString = this.display.helpString;
                    OS.memmove(ioHelpContent, helpContent, 534);
                    contentProvided[0] = 0;
                    OS.memmove(outContentProvided, contentProvided, 2);
                    break;
                }
                OS.HMHideTag();
                OS.memmove(outContentProvided, contentProvided, 2);
                return -9874;
            }
            case 1: {
                if (this.display.helpString != 0) {
                    OS.CFRelease(this.display.helpString);
                }
                this.display.helpWidget = null;
                this.display.helpString = 0;
            }
        }
        return 0;
    }

    void hookEvents() {
        super.hookEvents();
        int controlProc = this.display.controlProc;
        int[] mask = new int[]{1668183148, 9, 1668183148, 5, 1668183148, 154, 1668183148, 13, 1668183148, 12, 1668183148, 10, 1668183148, 4, 1668183148, 17, 1668183148, 8, 1668183148, 101, 1668183148, 1, 1668183148, 3, 1668183148, 11, 1668183148, 7, 1668183148, 51};
        int controlTarget = OS.GetControlEventTarget(this.handle);
        OS.InstallEventHandler(controlTarget, controlProc, mask.length / 2, mask, this.handle, null);
        int accessibilityProc = this.display.accessibilityProc;
        mask = new int[]{1633903461, 1, 1633903461, 2, 1633903461, 21, 1633903461, 22};
        OS.InstallEventHandler(controlTarget, accessibilityProc, mask.length / 2, mask, this.handle, null);
        int helpProc = this.display.helpProc;
        OS.HMInstallControlContentCallback(this.handle, helpProc);
        int colorProc = this.display.colorProc;
        OS.SetControlColorProc(this.handle, colorProc);
        if (OS.GetControlAction(this.handle) == 0) {
            OS.SetControlAction(this.handle, this.display.actionProc);
        }
    }

    public int internal_new_GC(GCData data) {
        boolean isPaint;
        int port;
        this.checkWidget();
        int window = OS.GetControlOwner(this.handle);
        int n = port = data != null ? data.port : 0;
        if (port == 0) {
            port = OS.GetWindowPort(window);
        }
        int[] buffer = new int[1];
        boolean bl = isPaint = data != null && data.paintEvent != 0;
        if (isPaint) {
            OS.GetEventParameter(data.paintEvent, 1668183160, 1668183160, null, 4, null, buffer);
        } else {
            OS.CreateCGContextForPort(port, buffer);
        }
        int context = buffer[0];
        if (context == 0) {
            SWT.error(2);
        }
        int visibleRgn = 0;
        visibleRgn = data != null && data.paintEvent != 0 ? data.visibleRgn : (this.isDrawing() ? this.getVisibleRegion(this.handle, true) : OS.NewRgn());
        Rect rect = new Rect();
        Rect portRect = new Rect();
        OS.GetControlBounds(this.handle, rect);
        OS.GetPortBounds(port, portRect);
        if (isPaint) {
            rect.right = (short)(rect.right + rect.left);
            rect.bottom = (short)(rect.bottom + rect.top);
            rect.top = 0;
            rect.left = 0;
        } else {
            int[] contentView = new int[1];
            OS.HIViewFindByID(OS.HIViewGetRoot(window), OS.kHIViewWindowContentID(), contentView);
            CGPoint pt = new CGPoint();
            OS.HIViewConvertPoint(pt, OS.HIViewGetSuperview(this.handle), contentView[0]);
            rect.left = (short)(rect.left + (int)pt.x);
            rect.top = (short)(rect.top + (int)pt.y);
            rect.right = (short)(rect.right + (int)pt.x);
            rect.bottom = (short)(rect.bottom + (int)pt.y);
            OS.ClipCGContextToRegion(context, portRect, visibleRgn);
            int portHeight = portRect.bottom - portRect.top;
            OS.CGContextScaleCTM(context, 1.0f, -1.0f);
            OS.CGContextTranslateCTM(context, rect.left, -portHeight + rect.top);
        }
        if (data != null) {
            int mask = 0x6000000;
            if ((data.style & mask) == 0) {
                data.style |= this.style & (mask | 0x8000000);
            }
            data.device = this.display;
            data.thread = this.display.thread;
            data.foreground = this.getForegroundColor().handle;
            Control control = this.findBackgroundControl();
            if (control == null) {
                control = this;
            }
            data.background = control.getBackgroundColor().handle;
            data.font = this.font != null ? this.font : this.defaultFont();
            data.visibleRgn = visibleRgn;
            data.control = this.handle;
            data.portRect = portRect;
            data.controlRect = rect;
            data.insetRect = this.getInset();
            if (data.paintEvent == 0) {
                if (this.gcs == null) {
                    this.gcs = new GCData[4];
                }
                int index = 0;
                while (index < this.gcs.length && this.gcs[index] != null) {
                    ++index;
                }
                if (index == this.gcs.length) {
                    GCData[] newGCs = new GCData[this.gcs.length + 4];
                    System.arraycopy(this.gcs, 0, newGCs, 0, this.gcs.length);
                    this.gcs = newGCs;
                }
                this.gcs[index] = data;
            }
        }
        return context;
    }

    public void internal_dispose_GC(int context, GCData data) {
        this.checkWidget();
        if (data != null) {
            if (data.paintEvent == 0) {
                if (data.visibleRgn != 0) {
                    OS.DisposeRgn(data.visibleRgn);
                    data.visibleRgn = 0;
                }
                int index = 0;
                while (index < this.gcs.length && this.gcs[index] != data) {
                    ++index;
                }
                if (index < this.gcs.length) {
                    this.gcs[index] = null;
                    index = 0;
                    while (index < this.gcs.length && this.gcs[index] == null) {
                        ++index;
                    }
                    if (index == this.gcs.length) {
                        this.gcs = null;
                    }
                }
            } else {
                return;
            }
        }
        OS.CGContextSynchronize(context);
        OS.CGContextRelease(context);
    }

    void invalidateChildrenVisibleRegion(int control) {
    }

    void invalidateVisibleRegion(int control) {
        int index = 0;
        Control[] siblings = this.parent._getChildren();
        while (index < siblings.length && siblings[index] != this) {
            ++index;
        }
        int i = index;
        while (i < siblings.length) {
            Control sibling = siblings[i];
            sibling.resetVisibleRegion(control);
            sibling.invalidateChildrenVisibleRegion(control);
            ++i;
        }
        this.parent.resetVisibleRegion(control);
    }

    void invalWindowRgn(int window, int rgn) {
        this.parent.invalWindowRgn(window, rgn);
    }

    boolean isDescribedByLabel() {
        return true;
    }

    boolean isDrawing() {
        return this.getDrawing() && this.parent.isDrawing();
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled() && this.parent.isEnabled();
    }

    boolean isEnabledCursor() {
        return this.isEnabled();
    }

    boolean isEnabledModal() {
        Shell[] shells = this.display.getShells();
        int i = 0;
        while (i < shells.length) {
            Shell modal = shells[i];
            if (modal != this && modal.isVisible()) {
                Shell shell;
                if ((modal.style & 0x8000) != 0 && modal.parent == (shell = this.getShell())) {
                    return false;
                }
                int bits = 196608;
                if ((modal.style & bits) != 0) {
                    Control control = this;
                    while (control != null) {
                        if (control == modal) break;
                        control = control.parent;
                    }
                    if (control != modal) {
                        return false;
                    }
                }
            }
            ++i;
        }
        return true;
    }

    boolean isFocusAncestor(Control control) {
        while (control != null && control != this && !(control instanceof Shell)) {
            control = control.parent;
        }
        return control == this;
    }

    public boolean isFocusControl() {
        this.checkWidget();
        Control focusControl = this.display.focusControl;
        if (focusControl != null && !focusControl.isDisposed()) {
            return this == focusControl;
        }
        return this.hasFocus();
    }

    public boolean isReparentable() {
        this.checkWidget();
        return true;
    }

    boolean isShowing() {
        if (!this.isVisible()) {
            return false;
        }
        Control control = this;
        while (control != null) {
            org.eclipse.swt.graphics.Point size = control.getSize();
            if (size.x == 0 || size.y == 0) {
                return false;
            }
            control = control.parent;
        }
        return true;
    }

    boolean isTabGroup() {
        int code;
        Control[] tabList = this.parent._getTabList();
        if (tabList != null) {
            int i = 0;
            while (i < tabList.length) {
                if (tabList[i] == this) {
                    return true;
                }
                ++i;
            }
        }
        if (((code = this.traversalCode(0, 0)) & 0x60) != 0) {
            return false;
        }
        return (code & 0x18) != 0;
    }

    boolean isTabItem() {
        int code;
        Control[] tabList = this.parent._getTabList();
        if (tabList != null) {
            int i = 0;
            while (i < tabList.length) {
                if (tabList[i] == this) {
                    return false;
                }
                ++i;
            }
        }
        return ((code = this.traversalCode(0, 0)) & 0x60) != 0;
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible() && this.parent.isVisible();
    }

    Decorations menuShell() {
        return this.parent.menuShell();
    }

    int kEventAccessibleGetChildAtPoint(int nextHandler, int theEvent, int userData) {
        if (this.accessible != null) {
            return this.accessible.internal_kEventAccessibleGetChildAtPoint(nextHandler, theEvent, userData);
        }
        return -9874;
    }

    int kEventAccessibleGetFocusedChild(int nextHandler, int theEvent, int userData) {
        if (this.accessible != null) {
            return this.accessible.internal_kEventAccessibleGetFocusedChild(nextHandler, theEvent, userData);
        }
        return -9874;
    }

    int kEventAccessibleGetAllAttributeNames(int nextHandler, int theEvent, int userData) {
        int code = -9874;
        String[] attributes = this.getAxAttributes();
        if (attributes != null) {
            OS.CallNextEventHandler(nextHandler, theEvent);
            int[] arrayRef = new int[1];
            OS.GetEventParameter(theEvent, 1635020403, 1667657057, null, 4, null, arrayRef);
            int attributesArrayRef = arrayRef[0];
            int length = OS.CFArrayGetCount(attributesArrayRef);
            String[] osAttributes = new String[length];
            int i = 0;
            while (i < length) {
                int stringRef = OS.CFArrayGetValueAtIndex(attributesArrayRef, i);
                int strLength = OS.CFStringGetLength(stringRef);
                char[] buffer = new char[strLength];
                CFRange range = new CFRange();
                range.length = strLength;
                OS.CFStringGetCharacters(stringRef, range, buffer);
                osAttributes[i] = new String(buffer);
                ++i;
            }
            i = 0;
            while (i < attributes.length) {
                if (!this.contains(osAttributes, attributes[i])) {
                    String string = attributes[i];
                    char[] buffer = new char[string.length()];
                    string.getChars(0, buffer.length, buffer, 0);
                    int stringRef = OS.CFStringCreateWithCharacters(0, buffer, buffer.length);
                    OS.CFArrayAppendValue(attributesArrayRef, stringRef);
                    OS.CFRelease(stringRef);
                }
                ++i;
            }
            code = 0;
        }
        if (this.accessible != null) {
            code = this.accessible.internal_kEventAccessibleGetAllAttributeNames(nextHandler, theEvent, code);
        }
        return code;
    }

    int kEventAccessibleGetNamedAttribute(int nextHandler, int theEvent, int userData) {
        if (this.accessible != null) {
            return this.accessible.internal_kEventAccessibleGetNamedAttribute(nextHandler, theEvent, -9874);
        }
        return -9874;
    }

    int kEventControlContextualMenuClick(int nextHandler, int theEvent, int userData) {
        int[] theControl = new int[1];
        OS.GetEventParameter(theEvent, 0x2D2D2D2D, 1668575852, null, 4, null, theControl);
        Widget widget = this.display.getWidget(theControl[0]);
        while (widget != null && !(widget instanceof Control)) {
            OS.GetSuperControl(theControl[0], theControl);
            widget = this.display.getWidget(theControl[0]);
        }
        if (widget == this && this.isEnabled()) {
            Rect rect = new Rect();
            int window = OS.GetControlOwner(this.handle);
            CGPoint pt = new CGPoint();
            OS.GetEventParameter(theEvent, 2003660661, 1751740532, null, 8, null, pt);
            int x = (int)pt.x;
            int y = (int)pt.y;
            OS.GetWindowBounds(window, (short)32, rect);
            Event event = new Event();
            event.x = x += rect.left;
            event.y = y += rect.top;
            this.sendEvent(35, event);
            if (this.isDisposed()) {
                return 0;
            }
            if (event.doit && this.menu != null && !this.menu.isDisposed()) {
                if (event.x != x || event.y != y) {
                    this.menu.setLocation(event.x, event.y);
                }
                this.menu.setVisible(true);
            }
        }
        return -9874;
    }

    int kEventControlGetClickActivation(int nextHandler, int theEvent, int userData) {
        if ((this.getShell().style & 0x4000) != 0) {
            OS.SetEventParameter(theEvent, 1668047203, 1668047203, 4, new int[]{3});
            return 0;
        }
        return super.kEventControlGetClickActivation(nextHandler, theEvent, userData);
    }

    int kEventControlGetPartRegion(int nextHandler, int theEvent, int userData) {
        int result = super.kEventControlGetPartRegion(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        if (this.region != null && this != this.getShell()) {
            short[] part = new short[1];
            OS.GetEventParameter(theEvent, 1668313716, 1668313716, null, 2, null, part);
            if (part[0] == -1 || part[0] == -4) {
                int[] rgn = new int[1];
                OS.GetEventParameter(theEvent, 1668441966, 1919381096, null, 4, null, rgn);
                OS.CopyRgn(this.region.handle, rgn[0]);
                Rect rect = this.getInset();
                OS.OffsetRgn(rgn[0], -rect.left, -rect.top);
                return 0;
            }
        }
        return result;
    }

    int kEventControlHitTest(int nextHandler, int theEvent, int userData) {
        int result = super.kEventControlHitTest(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        if (this.region != null && this != this.getShell()) {
            result = OS.CallNextEventHandler(nextHandler, theEvent);
            CGPoint pt = new CGPoint();
            OS.GetEventParameter(theEvent, 1835822947, 1751740532, null, 8, null, pt);
            if (!this.region.contains((int)pt.x, (int)pt.y)) {
                OS.SetEventParameter(theEvent, 1668313716, 1668313716, 2, new short[1]);
                return result;
            }
        }
        if ((this.state & 0x20) != 0) {
            CGRect rect = new CGRect();
            OS.HIViewGetBounds(this.handle, rect);
            CGPoint pt = new CGPoint();
            OS.GetEventParameter(theEvent, 1835822947, 1751740532, null, 8, null, pt);
            if (OS.CGRectContainsPoint(rect, pt) != 0) {
                OS.SetEventParameter(theEvent, 1668313716, 1668313716, 2, new short[]{1});
            }
            return 0;
        }
        return result;
    }

    int kEventControlSetCursor(int nextHandler, int theEvent, int userData) {
        if (!this.isEnabledCursor()) {
            return 0;
        }
        Cursor cursor = null;
        if (this.isEnabledModal() && (cursor = this.findCursor()) != null) {
            this.display.setCursor(cursor.handle);
        }
        return cursor != null ? 0 : -9874;
    }

    int kEventControlSetFocusPart(int nextHandler, int theEvent, int userData) {
        this.display.focusCombo = null;
        int result = this.callFocusEventHandler(nextHandler, theEvent);
        if (!this.display.ignoreFocus && result == 0) {
            int window = OS.GetControlOwner(this.handle);
            if (window == OS.GetUserFocusWindow()) {
                int focusHandle = this.focusHandle();
                int[] focusControl = new int[1];
                OS.GetKeyboardFocus(window, focusControl);
                short[] part = new short[1];
                OS.GetEventParameter(theEvent, 1668313716, 1668313716, null, 2, null, part);
                Display display = this.display;
                display.delayDispose = true;
                if (part[0] == 0) {
                    if (focusControl[0] == focusHandle) {
                        this.sendFocusEvent(16, false);
                    }
                } else if (focusControl[0] != focusHandle) {
                    this.sendFocusEvent(15, false);
                }
                display.delayDispose = false;
            }
            if (this.isDisposed()) {
                return 0;
            }
        }
        return result;
    }

    int kEventControlTrack(int nextHandler, int theEvent, int userData) {
        Display display = this.display;
        if (this.isDisposed()) {
            return 0;
        }
        if (display.runPopups()) {
            return 0;
        }
        if (this.isDisposed()) {
            return 0;
        }
        display.lastState = OS.GetCurrentEventButtonState();
        display.lastModifiers = OS.GetCurrentEventKeyModifiers();
        display.grabControl = this;
        int timer = 0;
        if (this.pollTrackEvent() && display.pollingTimer == 0) {
            int[] id = new int[1];
            int eventLoop = OS.GetCurrentEventLoop();
            OS.InstallEventLoopTimer(eventLoop, 0.01, 0.01, display.pollingProc, 0, id);
            display.pollingTimer = timer = id[0];
        }
        int result = super.kEventControlTrack(nextHandler, theEvent, userData);
        if (timer != 0) {
            OS.RemoveEventLoopTimer(timer);
            display.pollingTimer = 0;
        }
        display.grabControl = null;
        if (this.isDisposed()) {
            return 0;
        }
        this.sendTrackEvents();
        return result;
    }

    int kEventMouseDown(int nextHandler, int theEvent, int userData) {
        Shell shell = this.getShell();
        this.display.dragging = false;
        boolean[] consume = new boolean[1];
        short[] button = new short[1];
        OS.GetEventParameter(theEvent, 1835168878, 1835168878, null, 2, null, button);
        int[] clickCount = new int[1];
        OS.GetEventParameter(theEvent, 1667460724, 1835100014, null, 4, null, clickCount);
        if (button[0] == 1 && clickCount[0] == 1 && (this.state & 0x40000) != 0 && this.hooks(29)) {
            CGPoint pt = new CGPoint();
            OS.GetEventParameter(theEvent, 2003660661, 1751740532, null, 8, null, pt);
            OS.HIViewConvertPoint(pt, 0, this.handle);
            int x = (int)pt.x;
            int y = (int)pt.y;
            if (this.dragDetect(x, y, true, consume)) {
                this.display.dragging = true;
                this.display.dragButton = button[0];
                this.display.dragX = x;
                this.display.dragY = y;
                int[] chord = new int[1];
                OS.GetEventParameter(theEvent, 1667788658, 1835100014, null, 4, null, chord);
                this.display.dragState = chord[0];
                int[] modifiers = new int[1];
                OS.GetEventParameter(theEvent, 1802334052, 1835100014, null, 4, null, modifiers);
                this.display.dragModifiers = modifiers[0];
            }
            if (this.isDisposed()) {
                return 0;
            }
        }
        if (!this.sendMouseEvent(3, button[0], this.display.clickCount, 0, false, theEvent)) {
            consume[0] = true;
        }
        if (this.isDisposed()) {
            return 0;
        }
        if (this.display.clickCount == 2) {
            if (!this.sendMouseEvent(8, button[0], this.display.clickCount, 0, false, theEvent)) {
                consume[0] = true;
            }
            if (this.isDisposed()) {
                return 0;
            }
        }
        if (!shell.isDisposed()) {
            shell.setActiveControl(this);
        }
        return consume[0] ? 0 : -9874;
    }

    int kEventMouseDragged(int nextHandler, int theEvent, int userData) {
        if (this.isEnabledModal()) {
            int result;
            if (this.display.dragging) {
                this.display.dragging = false;
                this.sendDragEvent(this.display.dragButton, this.display.dragState, this.display.dragModifiers, this.display.dragX, this.display.dragY);
                if (this.isDisposed()) {
                    return 0;
                }
            }
            int n = result = this.sendMouseEvent(5, (short)0, 0, 0, false, theEvent) ? -9874 : 0;
            if (this.isDisposed()) {
                return 0;
            }
            return result;
        }
        return -9874;
    }

    int kEventMouseMoved(int nextHandler, int theEvent, int userData) {
        if (this.isEnabledModal()) {
            return this.sendMouseEvent(5, (short)0, 0, 0, false, theEvent) ? -9874 : 0;
        }
        return -9874;
    }

    int kEventMouseUp(int nextHandler, int theEvent, int userData) {
        short[] button = new short[1];
        OS.GetEventParameter(theEvent, 1835168878, 1835168878, null, 2, null, button);
        return this.sendMouseEvent(4, button[0], this.display.clickCount, 0, false, theEvent) ? -9874 : 0;
    }

    int kEventMouseWheelMoved(int nextHandler, int theEvent, int userData) {
        if ((this.state & 0x200) != 0) {
            return -9874;
        }
        int window = OS.GetControlOwner(this.handle);
        if (OS.HIWindowIsDocumentModalTarget(window, null)) {
            return 0;
        }
        int[] event = new int[1];
        OS.CreateEvent(0, 2003398244, 8, 0.0, 0, event);
        if (event[0] != 0) {
            short[] part = new short[1];
            OS.GetEventParameter(theEvent, 2003853682, 2003853682, null, 2, null, part);
            int[] modifiers = new int[1];
            OS.GetEventParameter(theEvent, 1802334052, 1835100014, null, modifiers.length * 4, null, modifiers);
            OS.SetEventParameter(event[0], 0x2D2D2D2D, 2003398244, 4, new int[]{window});
            OS.SetEventParameter(event[0], 2003853682, 2003853682, 2, part);
            OS.SetEventParameter(event[0], 1802334052, 1835100014, 4, modifiers);
            OS.SetEventParameter(event[0], 1702260340, 1702261350, 4, new int[]{theEvent});
            OS.SendEventToEventTarget(event[0], OS.GetApplicationEventTarget());
            int[] clickResult = new int[1];
            OS.GetEventParameter(event[0], 2003657586, 2003657586, null, 4, null, clickResult);
            OS.ReleaseEvent(event[0]);
            if ((clickResult[0] & 1) != 0 && (clickResult[0] & 2) == 0) {
                return 0;
            }
        }
        short[] wheelAxis = new short[1];
        OS.GetEventParameter(theEvent, 1836540280, 1836540280, null, 2, null, wheelAxis);
        int[] wheelDelta = new int[1];
        OS.GetEventParameter(theEvent, 1836541036, 1819242087, null, 4, null, wheelDelta);
        Shell shell = this.getShell();
        Control control = this;
        int type = wheelAxis[0] == 1 ? 37 : 38;
        while (control != null) {
            if (!control.sendMouseEvent(type, (short)0, wheelDelta[0], 1, true, theEvent) || control.sendMouseWheel(wheelAxis[0], wheelDelta[0])) break;
            if (control == this) {
                this.state |= 0x200;
                int result = OS.CallNextEventHandler(nextHandler, theEvent);
                this.state &= 0xFFFFFDFF;
                if (result == 0) break;
            }
            if (control == shell) break;
            control = control.parent;
        }
        return 0;
    }

    int kEventTextInputUnicodeForKeyEvent(int nextHandler, int theEvent, int userData) {
        Control focusControl;
        int result;
        int[] keyboardEvent = new int[1];
        OS.GetEventParameter(theEvent, 1953721189, 1702261350, null, keyboardEvent.length * 4, null, keyboardEvent);
        int[] keyCode = new int[1];
        OS.GetEventParameter(keyboardEvent[0], 1801678692, 1835100014, null, keyCode.length * 4, null, keyCode);
        boolean[] consume = new boolean[1];
        if (this.translateTraversal(keyCode[0], keyboardEvent[0], consume)) {
            return 0;
        }
        if (this.isDisposed()) {
            return 0;
        }
        if (keyCode[0] == 114) {
            Control control = this;
            while (control != null) {
                if (control.hooks(28)) {
                    control.postEvent(28);
                    break;
                }
                control = control.parent;
            }
        }
        if ((result = this.kEventUnicodeKeyPressed(nextHandler, theEvent, userData)) == 0 || consume[0]) {
            return 0;
        }
        if (!this.isDisposed() && (focusControl = this.display.getFocusControl()) != this) {
            int window = OS.GetControlOwner(this.handle);
            int newWindow = 0;
            if (focusControl != null) {
                newWindow = OS.GetControlOwner(focusControl.handle);
            }
            this.display.ignoreFocus = true;
            if (window != newWindow) {
                OS.SetUserFocusWindow(window);
            }
            OS.SetKeyboardFocus(window, this.focusHandle(), (short)this.focusPart());
            this.display.ignoreFocus = false;
            result = OS.CallNextEventHandler(nextHandler, theEvent);
            this.display.ignoreFocus = true;
            if (window != newWindow && newWindow != 0) {
                OS.SetUserFocusWindow(newWindow);
            }
            if (window == newWindow && focusControl != null) {
                OS.SetKeyboardFocus(window, focusControl.focusHandle(), (short)focusControl.focusPart());
            } else {
                OS.ClearKeyboardFocus(window);
            }
            this.display.ignoreFocus = false;
            return 0;
        }
        return result;
    }

    int kEventUnicodeKeyPressed(int nextHandler, int theEvent, int userData) {
        int[] keyboardEvent = new int[1];
        OS.GetEventParameter(theEvent, 1953721189, 1702261350, null, keyboardEvent.length * 4, null, keyboardEvent);
        if (!this.sendKeyEvent(1, keyboardEvent[0])) {
            return 0;
        }
        return -9874;
    }

    void markLayout(boolean changed, boolean all) {
    }

    public void moveAbove(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (this.parent != control.parent) {
                return;
            }
        }
        this.setZOrder(control, true);
    }

    public void moveBelow(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (this.parent != control.parent) {
                return;
            }
        }
        this.setZOrder(control, false);
    }

    Accessible new_Accessible(Control control) {
        return Accessible.internal_new_Accessible(this);
    }

    public void pack() {
        this.checkWidget();
        this.pack(true);
    }

    public void pack(boolean changed) {
        this.checkWidget();
        this.setSize(this.computeSize(-1, -1, changed));
    }

    public boolean print(GC gc) {
        int[] outImage;
        CGRect outFrame;
        this.checkWidget();
        if (gc == null) {
            this.error(4);
        }
        if (gc.isDisposed()) {
            this.error(5);
        }
        if (OS.HIViewCreateOffscreenImage(this.handle, 0, outFrame = new CGRect(), outImage = new int[1]) == 0) {
            int width = OS.CGImageGetWidth(outImage[0]);
            int height = OS.CGImageGetHeight(outImage[0]);
            CGRect rect = new CGRect();
            rect.width = width;
            rect.height = height;
            OS.HIViewDrawCGImage(gc.handle, rect, outImage[0]);
            OS.CGImageRelease(outImage[0]);
        }
        return true;
    }

    boolean pollTrackEvent() {
        return false;
    }

    public void redraw() {
        this.checkWidget();
        this.redrawWidget(this.handle, false);
    }

    void redraw(boolean children) {
        this.redrawWidget(this.handle, children);
    }

    public void redraw(int x, int y, int width, int height, boolean all) {
        this.checkWidget();
        this.redrawWidget(this.handle, x, y, width, height, all);
    }

    void register() {
        super.register();
        this.display.addWidget(this.handle, this);
    }

    void release(boolean destroy) {
        Control next = null;
        Control previous = null;
        if (destroy && this.parent != null) {
            Control[] children = this.parent._getChildren();
            int index = 0;
            while (index < children.length) {
                if (children[index] == this) break;
                ++index;
            }
            if (index > 0 && index + 1 < children.length) {
                next = children[index + 1];
                previous = children[index - 1];
            }
        }
        super.release(destroy);
        if (destroy && previous != null) {
            previous.addRelation(next);
        }
    }

    void releaseHandle() {
        super.releaseHandle();
        this.handle = 0;
        this.parent = null;
    }

    void releaseParent() {
        this.setVisible(this.topHandle(), false);
        this.parent.removeControl(this);
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.menu != null && !this.menu.isDisposed()) {
            this.menu.dispose();
        }
        if (this.visibleRgn != 0) {
            OS.DisposeRgn(this.visibleRgn);
        }
        this.visibleRgn = 0;
        this.menu = null;
        this.layoutData = null;
        if (this.accessible != null) {
            this.accessible.internal_dispose_Accessible();
        }
        this.accessible = null;
        this.region = null;
    }

    public void removeControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(10, listener);
        this.eventTable.unhook(11, listener);
    }

    public void removeDragDetectListener(DragDetectListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(29, listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(15, listener);
        this.eventTable.unhook(16, listener);
    }

    public void removeHelpListener(HelpListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(28, listener);
    }

    public void removeKeyListener(KeyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(2, listener);
        this.eventTable.unhook(1, listener);
    }

    public void removeMenuDetectListener(MenuDetectListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(35, listener);
    }

    public void removeMouseListener(MouseListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(3, listener);
        this.eventTable.unhook(4, listener);
        this.eventTable.unhook(8, listener);
    }

    public void removeMouseMoveListener(MouseMoveListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(5, listener);
    }

    public void removeMouseTrackListener(MouseTrackListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(6, listener);
        this.eventTable.unhook(7, listener);
        this.eventTable.unhook(32, listener);
    }

    public void removeMouseWheelListener(MouseWheelListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(37, listener);
    }

    public void removePaintListener(PaintListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(9, listener);
    }

    void removeRelation() {
        if (!this.isDescribedByLabel()) {
            return;
        }
        String string = "AXTitleUIElement";
        char[] buffer = new char[string.length()];
        string.getChars(0, buffer.length, buffer, 0);
        int stringRef = OS.CFStringCreateWithCharacters(0, buffer, buffer.length);
        OS.HIObjectSetAuxiliaryAccessibilityAttribute(this.handle, 0L, stringRef, 0);
        OS.CFRelease(stringRef);
    }

    public void removeTraverseListener(TraverseListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(31, listener);
    }

    void resetVisibleRegion(int control) {
        Object runnable;
        if (this.visibleRgn != 0) {
            OS.DisposeRgn(this.visibleRgn);
            this.visibleRgn = 0;
        }
        if (this.gcs != null) {
            int visibleRgn = this.getVisibleRegion(this.handle, true);
            int i = 0;
            while (i < this.gcs.length) {
                GCData data = this.gcs[i];
                if (data != null) {
                    data.updateClip = true;
                    OS.CopyRgn(visibleRgn, data.visibleRgn);
                }
                ++i;
            }
            OS.DisposeRgn(visibleRgn);
        }
        if ((runnable = this.getData(RESET_VISIBLE_REGION)) != null && runnable instanceof Runnable) {
            ((Runnable)runnable).run();
        }
    }

    boolean sendDragEvent(int button, int stateMask, int x, int y) {
        Event event = new Event();
        event.button = button;
        event.x = x;
        event.y = y;
        event.stateMask = stateMask;
        this.postEvent(29, event);
        return event.doit;
    }

    boolean sendDragEvent(int button, int chord, int modifiers, int x, int y) {
        Event event = new Event();
        switch (button) {
            case 1: {
                event.button = 1;
                break;
            }
            case 2: {
                event.button = 3;
                break;
            }
            case 3: {
                event.button = 2;
                break;
            }
            case 4: {
                event.button = 4;
                break;
            }
            case 5: {
                event.button = 5;
            }
        }
        event.x = x;
        event.y = y;
        this.setInputState(event, 29, chord, modifiers);
        this.postEvent(29, event);
        return event.doit;
    }

    void sendFocusEvent(int type, boolean post) {
        Display display = this.display;
        Shell shell = this.getShell();
        display.focusControl = this;
        display.focusEvent = type;
        if (post) {
            this.postEvent(type);
        } else {
            this.sendEvent(type);
        }
        if (!shell.isDisposed()) {
            switch (type) {
                case 15: {
                    shell.setActiveControl(this);
                    break;
                }
                case 16: {
                    if (shell == display.getActiveShell()) break;
                    shell.setActiveControl(null);
                }
            }
        }
        display.focusEvent = 0;
        display.focusControl = null;
    }

    boolean sendMouseEvent(int type, short button, int count, int detail, boolean send, int theEvent) {
        CGPoint pt = new CGPoint();
        OS.GetEventParameter(theEvent, 2003660661, 1751740532, null, 8, null, pt);
        OS.HIViewConvertPoint(pt, 0, this.handle);
        int x = (int)pt.x;
        int y = (int)pt.y;
        this.display.lastX = x;
        this.display.lastY = y;
        int[] chord = new int[1];
        OS.GetEventParameter(theEvent, 1667788658, 1835100014, null, 4, null, chord);
        int[] modifiers = new int[1];
        OS.GetEventParameter(theEvent, 1802334052, 1835100014, null, 4, null, modifiers);
        return this.sendMouseEvent(type, button, count, detail, send, chord[0], (short)x, (short)y, modifiers[0]);
    }

    boolean sendMouseEvent(int type, short button, int count, boolean send, int chord, short x, short y, int modifiers) {
        return this.sendMouseEvent(type, button, count, 0, send, chord, x, y, modifiers);
    }

    boolean sendMouseEvent(int type, short button, int count, int detail, boolean send, int chord, short x, short y, int modifiers) {
        if (!this.hooks(type) && !this.filters(type)) {
            return true;
        }
        if ((this.state & 0x80000) != 0) {
            switch (type) {
                case 4: 
                case 5: 
                case 8: {
                    return true;
                }
                case 3: {
                    if (button != 1) break;
                    return true;
                }
            }
        }
        Event event = new Event();
        switch (button) {
            case 1: {
                event.button = 1;
                break;
            }
            case 2: {
                event.button = 3;
                break;
            }
            case 3: {
                event.button = 2;
                break;
            }
            case 4: {
                event.button = 4;
                break;
            }
            case 5: {
                event.button = 5;
            }
        }
        event.x = x;
        event.y = y;
        event.count = count;
        event.detail = detail;
        this.setInputState(event, type, chord, modifiers);
        if (send) {
            this.sendEvent(type, event);
            if (this.isDisposed()) {
                return false;
            }
        } else {
            this.postEvent(type, event);
        }
        return event.doit;
    }

    boolean sendMouseWheel(short wheelAxis, int wheelDelta) {
        return false;
    }

    void sendTrackEvents() {
        int type;
        Display display = this.display;
        display.runDeferredEvents();
        if (this.isDisposed()) {
            return;
        }
        boolean events = false;
        if (display.dragging) {
            display.dragging = false;
            this.sendDragEvent(display.dragButton, display.dragState, display.dragModifiers, display.dragX, display.dragY);
            if (this.isDisposed()) {
                return;
            }
            events = true;
        }
        Point outPt = new Point();
        OS.GetGlobalMouse(outPt);
        Rect rect = new Rect();
        int window = OS.GetControlOwner(this.handle);
        CGPoint pt = new CGPoint();
        pt.x = outPt.h;
        pt.y = outPt.v;
        OS.HIViewConvertPoint(pt, 0, this.handle);
        int newX = (int)pt.x;
        int newY = (int)pt.y;
        OS.GetWindowBounds(window, (short)32, rect);
        newX -= rect.left;
        newY -= rect.top;
        int newModifiers = OS.GetCurrentEventKeyModifiers();
        int newState = OS.GetCurrentEventButtonState();
        int oldX = display.lastX;
        int oldY = display.lastY;
        int oldState = display.lastState;
        int oldModifiers = display.lastModifiers;
        display.lastX = newX;
        display.lastY = newY;
        display.lastModifiers = newModifiers;
        display.lastState = newState;
        if (newState != oldState) {
            int button = 0;
            type = 3;
            if ((oldState & 1) == 0 && (newState & 1) != 0) {
                button = 1;
            }
            if ((oldState & 2) == 0 && (newState & 2) != 0) {
                button = 2;
            }
            if ((oldState & 4) == 0 && (newState & 4) != 0) {
                button = 3;
            }
            if ((oldState & 8) == 0 && (newState & 8) != 0) {
                button = 4;
            }
            if ((oldState & 0x10) == 0 && (newState & 0x10) != 0) {
                button = 5;
            }
            if (button == 0) {
                type = 4;
                if ((oldState & 1) != 0 && (newState & 1) == 0) {
                    button = 1;
                }
                if ((oldState & 2) != 0 && (newState & 2) == 0) {
                    button = 2;
                }
                if ((oldState & 4) != 0 && (newState & 4) == 0) {
                    button = 3;
                }
                if ((oldState & 8) != 0 && (newState & 8) == 0) {
                    button = 4;
                }
                if ((oldState & 0x10) != 0 && (newState & 0x10) == 0) {
                    button = 5;
                }
            }
            if (button != 0) {
                this.sendMouseEvent(type, (short)button, 1, false, newState, (short)newX, (short)newY, newModifiers);
                events = true;
            }
        }
        if (newModifiers != oldModifiers && !this.isDisposed()) {
            int key = 0;
            type = 1;
            if ((newModifiers & 0x400) != 0 && (oldModifiers & 0x400) == 0) {
                key = 16777298;
            }
            if ((newModifiers & 0x200) != 0 && (oldModifiers & 0x200) == 0) {
                key = 131072;
            }
            if ((newModifiers & 0x1000) != 0 && (oldModifiers & 0x1000) == 0) {
                key = 262144;
            }
            if ((newModifiers & 0x100) != 0 && (oldModifiers & 0x100) == 0) {
                key = 0x400000;
            }
            if ((newModifiers & 0x800) != 0 && (oldModifiers & 0x800) == 0) {
                key = 65536;
            }
            if (key == 0) {
                type = 2;
                if ((newModifiers & 0x400) == 0 && (oldModifiers & 0x400) != 0) {
                    key = 16777298;
                }
                if ((newModifiers & 0x200) == 0 && (oldModifiers & 0x200) != 0) {
                    key = 131072;
                }
                if ((newModifiers & 0x1000) == 0 && (oldModifiers & 0x1000) != 0) {
                    key = 262144;
                }
                if ((newModifiers & 0x100) == 0 && (oldModifiers & 0x100) != 0) {
                    key = 0x400000;
                }
                if ((newModifiers & 0x800) == 0 && (oldModifiers & 0x800) != 0) {
                    key = 65536;
                }
            }
            if (key != 0) {
                Event event = new Event();
                event.keyCode = key;
                this.setInputState(event, type, newState, newModifiers);
                this.sendKeyEvent(type, event);
                events = true;
            }
        }
        if (newX != oldX || newY != oldY && !this.isDisposed()) {
            display.mouseMoved = true;
            this.sendMouseEvent(5, (short)0, 0, false, newState, (short)newX, (short)newY, newModifiers);
            events = true;
        }
        if (events) {
            display.runDeferredEvents();
        }
    }

    void setBackground() {
        this.redrawWidget(this.handle, false);
    }

    public void setBackground(Color color) {
        float[] background;
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        float[] fArray = background = color != null ? color.handle : null;
        if (this.equals(background, this.background)) {
            return;
        }
        this.background = background;
        this.setBackground(background);
        this.redrawWidget(this.handle, false);
    }

    public void setBackgroundImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            SWT.error(5);
        }
        if (image == this.backgroundImage) {
            return;
        }
        this.backgroundImage = image;
        this.redrawWidget(this.handle, false);
    }

    void setBackground(float[] color) {
        this.setBackground(this.handle, color);
    }

    void setBackground(int control, float[] color) {
        ControlFontStyleRec fontStyle = new ControlFontStyleRec();
        OS.GetControlData(control, (short)0, 1718578804, 24, fontStyle, null);
        if (color != null) {
            fontStyle.backColor_red = (short)(color[0] * 65535.0f);
            fontStyle.backColor_green = (short)(color[1] * 65535.0f);
            fontStyle.backColor_blue = (short)(color[2] * 65535.0f);
            fontStyle.flags = (short)(fontStyle.flags | 0x10);
        } else {
            fontStyle.flags = (short)(fontStyle.flags & 0xFFFFFFEF);
        }
        OS.SetControlFontStyle(control, fontStyle);
    }

    public void setBounds(int x, int y, int width, int height) {
        this.checkWidget();
        this.setBounds(x, y, Math.max(0, width), Math.max(0, height), true, true, true);
    }

    int setBounds(int x, int y, int width, int height, boolean move, boolean resize, boolean events) {
        return this.setBounds(this.topHandle(), x, y, width, height, move, resize, events);
    }

    public void setBounds(Rectangle rect) {
        this.checkWidget();
        if (rect == null) {
            this.error(4);
        }
        this.setBounds(rect.x, rect.y, Math.max(0, rect.width), Math.max(0, rect.height), true, true, true);
    }

    public void setCapture(boolean capture) {
        this.checkWidget();
    }

    public void setCursor(Cursor cursor) {
        this.checkWidget();
        if (cursor != null && cursor.isDisposed()) {
            this.error(5);
        }
        this.cursor = cursor;
        if (!this.isEnabled()) {
            return;
        }
        Point where = new Point();
        OS.GetGlobalMouse(where);
        int[] theWindow = new int[1];
        if (this.display.grabControl == this) {
            theWindow[0] = OS.GetControlOwner(this.handle);
        } else {
            if (OS.FindWindow(where, theWindow) != 3) {
                return;
            }
            if (theWindow[0] == 0) {
                return;
            }
        }
        Rect rect = new Rect();
        OS.GetWindowBounds(theWindow[0], (short)32, rect);
        int[] theControl = new int[1];
        if (this.display.grabControl == this) {
            theControl[0] = this.handle;
        } else {
            Control control;
            Widget widget;
            CGPoint inPoint = new CGPoint();
            inPoint.x = where.h - rect.left;
            inPoint.y = where.v - rect.top;
            int[] theRoot = new int[1];
            OS.GetRootControl(theWindow[0], theRoot);
            int[] event = new int[1];
            OS.CreateEvent(0, 1836021107, 1, 0.0, 0, event);
            OS.SetEventParameter(event[0], 2003660661, 1751740532, 8, inPoint);
            OS.HIViewGetViewForMouseEvent(theRoot[0], event[0], theControl);
            OS.ReleaseEvent(event[0]);
            int cursorControl = theControl[0];
            while (theControl[0] != 0 && theControl[0] != this.handle) {
                OS.GetSuperControl(theControl[0], theControl);
            }
            if (theControl[0] == 0) {
                return;
            }
            theControl[0] = cursorControl;
            while ((widget = this.display.getWidget(theControl[0])) == null || !(widget instanceof Control) || !(control = (Control)widget).isEnabled()) {
                OS.GetSuperControl(theControl[0], theControl);
                if (theControl[0] != 0) continue;
            }
            if (theControl[0] == 0) {
                theControl[0] = theRoot[0];
                widget = this.display.getWidget(theControl[0]);
                if (widget != null && widget instanceof Control) {
                    control = (Control)widget;
                    theControl[0] = control.handle;
                }
            }
        }
        CGPoint pt = new CGPoint();
        OS.HIViewConvertPoint(pt, theControl[0], 0);
        where.h = (short)(where.h - (int)pt.x);
        where.v = (short)(where.v - (int)pt.y);
        where.h = (short)(where.h - rect.left);
        where.v = (short)(where.v - rect.top);
        int modifiers = OS.GetCurrentEventKeyModifiers();
        boolean[] cursorWasSet = new boolean[1];
        OS.HandleControlSetCursor(theControl[0], where, (short)modifiers, cursorWasSet);
        if (!cursorWasSet[0]) {
            OS.SetThemeCursor(0);
        }
    }

    void setDefaultFont() {
        if (this.display.smallFonts) {
            this.setFontStyle(this.defaultFont());
        }
    }

    public void setDragDetect(boolean dragDetect) {
        this.checkWidget();
        this.state = dragDetect ? (this.state |= 0x40000) : (this.state &= 0xFFFBFFFF);
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        if ((this.state & 8) == 0 == enabled) {
            return;
        }
        Control control = null;
        boolean fixFocus = false;
        if (!enabled && this.display.focusEvent != 16) {
            control = this.display.getFocusControl();
            fixFocus = this.isFocusAncestor(control);
        }
        this.state = enabled ? (this.state &= 0xFFFFFFF7) : (this.state |= 8);
        this.enableWidget(enabled);
        if (fixFocus) {
            this.fixFocus(control);
        }
    }

    public boolean setFocus() {
        this.checkWidget();
        if ((this.style & 0x80000) != 0) {
            return false;
        }
        return this.forceFocus();
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        this.font = font;
        this.setFontStyle(this.display.smallFonts ? (font != null ? font : this.defaultFont()) : font);
        this.redrawWidget(this.handle, false);
    }

    void setFontStyle(Font font) {
        this.setFontStyle(this.handle, font);
    }

    void setFontStyle(int control, Font font) {
        ControlFontStyleRec fontStyle = new ControlFontStyleRec();
        OS.GetControlData(control, (short)0, 1718578804, 24, fontStyle, null);
        fontStyle.flags = (short)(fontStyle.flags & 0xFFFFFF78);
        if (font != null) {
            short[] family = new short[1];
            short[] style = new short[1];
            OS.FMGetFontFamilyInstanceFromFont(font.handle, family, style);
            fontStyle.flags = (short)(fontStyle.flags | 7);
            fontStyle.font = family[0];
            fontStyle.style = (short)(style[0] | font.style);
            fontStyle.size = (short)font.size;
        }
        OS.SetControlFontStyle(control, fontStyle);
    }

    public void setForeground(Color color) {
        float[] foreground;
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        float[] fArray = foreground = color != null ? color.handle : null;
        if (this.equals(foreground, this.foreground)) {
            return;
        }
        this.foreground = foreground;
        this.setForeground(foreground);
        this.redrawWidget(this.handle, false);
    }

    void setForeground(float[] color) {
        this.setForeground(this.handle, color);
    }

    void setForeground(int control, float[] color) {
        ControlFontStyleRec fontStyle = new ControlFontStyleRec();
        OS.GetControlData(control, (short)0, 1718578804, 24, fontStyle, null);
        if (color != null) {
            fontStyle.foreColor_red = (short)(color[0] * 65535.0f);
            fontStyle.foreColor_green = (short)(color[1] * 65535.0f);
            fontStyle.foreColor_blue = (short)(color[2] * 65535.0f);
            fontStyle.flags = (short)(fontStyle.flags | 8);
        } else {
            fontStyle.flags = (short)(fontStyle.flags & 0xFFFFFFF7);
        }
        OS.SetControlFontStyle(control, fontStyle);
    }

    public void setLayoutData(Object layoutData) {
        this.checkWidget();
        this.layoutData = layoutData;
    }

    public void setLocation(int x, int y) {
        this.checkWidget();
        this.setBounds(x, y, 0, 0, true, false, true);
    }

    public void setLocation(org.eclipse.swt.graphics.Point location) {
        this.checkWidget();
        if (location == null) {
            this.error(4);
        }
        this.setBounds(location.x, location.y, 0, 0, true, false, true);
    }

    public void setMenu(Menu menu) {
        this.checkWidget();
        if (menu != null) {
            if (menu.isDisposed()) {
                SWT.error(5);
            }
            if ((menu.style & 8) == 0) {
                this.error(37);
            }
            if (menu.parent != this.menuShell()) {
                this.error(32);
            }
        }
        this.menu = menu;
    }

    public boolean setParent(Composite parent) {
        this.checkWidget();
        if (parent == null) {
            this.error(4);
        }
        if (parent.isDisposed()) {
            SWT.error(5);
        }
        if (this.parent == parent) {
            return true;
        }
        if (!this.isReparentable()) {
            return false;
        }
        this.releaseParent();
        Shell newShell = parent.getShell();
        Shell oldShell = this.getShell();
        Decorations newDecorations = parent.menuShell();
        Decorations oldDecorations = this.menuShell();
        if (oldShell != newShell || oldDecorations != newDecorations) {
            Menu[] menus = oldShell.findMenus(this);
            this.fixChildren(newShell, oldShell, newDecorations, oldDecorations, menus);
        }
        int topHandle = this.topHandle();
        OS.HIViewAddSubview(parent.handle, topHandle);
        OS.HIViewSetVisible(topHandle, (this.state & 0x10) == 0);
        OS.HIViewSetZOrder(topHandle, 2, 0);
        this.parent = parent;
        this.reskin(1);
        return true;
    }

    public void setRedraw(boolean redraw) {
        this.checkWidget();
        if (redraw) {
            if (--this.drawCount == 0) {
                int topHandle = this.topHandle();
                OS.HIViewSetDrawingEnabled(topHandle, true);
                this.invalidateVisibleRegion(topHandle);
                this.redrawWidget(topHandle, true);
            }
        } else {
            if (this.drawCount == 0) {
                int topHandle = this.topHandle();
                OS.HIViewSetDrawingEnabled(topHandle, false);
                this.invalidateVisibleRegion(topHandle);
            }
            ++this.drawCount;
        }
    }

    public void setRegion(Region region) {
        this.checkWidget();
        if (region != null && region.isDisposed()) {
            this.error(5);
        }
        this.region = region;
        OS.HIViewRegionChanged(this.handle, -1);
        this.redrawWidget(this.handle, true);
    }

    boolean setRadioSelection(boolean value) {
        return false;
    }

    void setRelations() {
        Control child;
        if (this.parent == null) {
            return;
        }
        Control[] children = this.parent._getChildren();
        int count = children.length;
        if (count > 1 && (child = children[count - 2]) != this) {
            child.addRelation(this);
        }
    }

    public void setSize(int width, int height) {
        this.checkWidget();
        this.setBounds(0, 0, Math.max(0, width), Math.max(0, height), false, true, true);
    }

    public void setSize(org.eclipse.swt.graphics.Point size) {
        this.checkWidget();
        if (size == null) {
            this.error(4);
        }
        this.setBounds(0, 0, Math.max(0, size.x), Math.max(0, size.y), false, true, true);
    }

    boolean setTabGroupFocus() {
        return this.setTabItemFocus();
    }

    boolean setTabItemFocus() {
        if (!this.isShowing()) {
            return false;
        }
        return this.forceFocus();
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.toolTipText = string;
        if (this.display.helpWidget == this) {
            this.display.helpWidget = null;
            OS.HMInstallControlContentCallback(this.handle, 0);
            OS.HMInstallControlContentCallback(this.handle, this.display.helpProc);
        }
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        if (visible) {
            if ((this.state & 0x10) == 0) {
                return;
            }
            this.state &= 0xFFFFFFEF;
        } else {
            if ((this.state & 0x10) != 0) {
                return;
            }
            this.state |= 0x10;
        }
        if (visible) {
            this.sendEvent(22);
            if (this.isDisposed()) {
                return;
            }
        }
        Control control = null;
        boolean fixFocus = false;
        if (!visible && this.display.focusEvent != 16) {
            control = this.display.getFocusControl();
            fixFocus = this.isFocusAncestor(control);
        }
        this.setVisible(this.topHandle(), visible);
        if (!visible) {
            this.sendEvent(23);
            if (this.isDisposed()) {
                return;
            }
        }
        if (fixFocus) {
            this.fixFocus(control);
        }
    }

    void setZOrder() {
        int topHandle = this.topHandle();
        int parentHandle = this.parent.handle;
        OS.HIViewAddSubview(parentHandle, topHandle);
        OS.HIViewSetZOrder(topHandle, 2, 0);
        Rect inset = this.getInset();
        Rect rect = new Rect();
        rect.left = rect.right = inset.left;
        rect.top = rect.bottom = inset.top;
        OS.SetControlBounds(topHandle, rect);
    }

    void setZOrder(Control sibling, boolean above) {
        int siblingHandle = sibling == null ? 0 : sibling.topHandle();
        int index = 0;
        int siblingIndex = 0;
        int oldNextIndex = -1;
        Control[] children = null;
        children = this.parent._getChildren();
        while (index < children.length) {
            if (children[index] == this) break;
            ++index;
        }
        if (sibling != null) {
            while (siblingIndex < children.length) {
                if (children[siblingIndex] == sibling) break;
                ++siblingIndex;
            }
        }
        this.removeRelation();
        if (index + 1 < children.length) {
            oldNextIndex = index + 1;
            children[oldNextIndex].removeRelation();
        }
        if (sibling != null) {
            if (above) {
                sibling.removeRelation();
            } else if (siblingIndex + 1 < children.length) {
                children[siblingIndex + 1].removeRelation();
            }
        }
        this.setZOrder(this.topHandle(), siblingHandle, above);
        index = sibling != null ? (above ? siblingIndex - (index < siblingIndex ? 1 : 0) : siblingIndex + (siblingIndex < index ? 1 : 0)) : (above ? 0 : children.length - 1);
        children = this.parent._getChildren();
        if (index > 0) {
            children[index - 1].addRelation(this);
        }
        if (index + 1 < children.length) {
            this.addRelation(children[index + 1]);
        }
        if (oldNextIndex != -1) {
            if (oldNextIndex <= index) {
                --oldNextIndex;
            }
            if (oldNextIndex > 0 && oldNextIndex != index && oldNextIndex != index + 1) {
                children[oldNextIndex - 1].addRelation(children[oldNextIndex]);
            }
        }
    }

    void sort(int[] items) {
        int length = items.length;
        int gap = length / 2;
        while (gap > 0) {
            int i = gap;
            while (i < length) {
                int j = i - gap;
                while (j >= 0) {
                    if (items[j] <= items[j + gap]) {
                        int swap = items[j];
                        items[j] = items[j + gap];
                        items[j + gap] = swap;
                    }
                    j -= gap;
                }
                ++i;
            }
            gap /= 2;
        }
    }

    org.eclipse.swt.graphics.Point textExtent(int ptr, int wHint) {
        if (ptr != 0 && OS.CFStringGetLength(ptr) > 0) {
            float[] w = new float[1];
            float[] h = new float[1];
            HIThemeTextInfo info = new HIThemeTextInfo();
            info.state = 1;
            if (this.font != null) {
                short[] family = new short[1];
                short[] style = new short[1];
                OS.FMGetFontFamilyInstanceFromFont(this.font.handle, family, style);
                OS.TextFont(family[0]);
                OS.TextFace((short)(style[0] | this.font.style));
                OS.TextSize((short)this.font.size);
                info.fontID = (short)200;
            } else {
                info.fontID = (short)this.defaultThemeFont();
            }
            OS.HIThemeGetTextDimensions(ptr, wHint == -1 ? 0 : wHint, info, w, h, null);
            return new org.eclipse.swt.graphics.Point((int)w[0], (int)h[0]);
        }
        Font font = this.getFont();
        ATSFontMetrics metrics = new ATSFontMetrics();
        OS.ATSFontGetVerticalMetrics(font.handle, 0, metrics);
        OS.ATSFontGetHorizontalMetrics(font.handle, 0, metrics);
        return new org.eclipse.swt.graphics.Point(0, (int)(0.5f + (metrics.ascent - metrics.descent + metrics.leading) * font.size));
    }

    org.eclipse.swt.graphics.Point textExtent(char[] chars, int wHint) {
        int ptr = OS.CFStringCreateWithCharacters(0, chars, chars.length);
        org.eclipse.swt.graphics.Point result = this.textExtent(ptr, wHint);
        if (ptr != 0) {
            OS.CFRelease(ptr);
        }
        return result;
    }

    public org.eclipse.swt.graphics.Point toControl(int x, int y) {
        this.checkWidget();
        Rect rect = new Rect();
        int window = OS.GetControlOwner(this.handle);
        CGPoint pt = new CGPoint();
        OS.HIViewConvertPoint(pt, this.handle, 0);
        x -= (int)pt.x;
        y -= (int)pt.y;
        OS.GetWindowBounds(window, (short)32, rect);
        x -= rect.left;
        y -= rect.top;
        Rect inset = this.getInset();
        return new org.eclipse.swt.graphics.Point(x += inset.left, y += inset.top);
    }

    public org.eclipse.swt.graphics.Point toControl(org.eclipse.swt.graphics.Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        return this.toControl(point.x, point.y);
    }

    public org.eclipse.swt.graphics.Point toDisplay(int x, int y) {
        this.checkWidget();
        Rect rect = new Rect();
        int window = OS.GetControlOwner(this.handle);
        CGPoint pt = new CGPoint();
        OS.HIViewConvertPoint(pt, this.handle, 0);
        x += (int)pt.x;
        y += (int)pt.y;
        OS.GetWindowBounds(window, (short)32, rect);
        x += rect.left;
        y += rect.top;
        Rect inset = this.getInset();
        return new org.eclipse.swt.graphics.Point(x -= inset.left, y -= inset.top);
    }

    public org.eclipse.swt.graphics.Point toDisplay(org.eclipse.swt.graphics.Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        return this.toDisplay(point.x, point.y);
    }

    int topHandle() {
        return this.handle;
    }

    boolean translateTraversal(int key, int theEvent, boolean[] consume) {
        int detail = 0;
        int code = this.traversalCode(key, theEvent);
        boolean all = false;
        switch (key) {
            case 53: {
                all = true;
                detail = 2;
                break;
            }
            case 36: 
            case 76: {
                all = true;
                detail = 4;
                break;
            }
            case 48: {
                int[] modifiers = new int[1];
                OS.GetEventParameter(theEvent, 1802334052, 1835100014, null, 4, null, modifiers);
                boolean next = (modifiers[0] & 0x200) == 0;
                detail = next ? 16 : 8;
                break;
            }
            case 123: 
            case 124: 
            case 125: 
            case 126: {
                boolean next = key == 125 || key == 124;
                detail = next ? 64 : 32;
                break;
            }
            case 116: 
            case 121: {
                all = true;
                int[] modifiers = new int[1];
                OS.GetEventParameter(theEvent, 1802334052, 1835100014, null, 4, null, modifiers);
                if ((modifiers[0] & 0x1000) == 0) {
                    return false;
                }
                detail = key == 121 ? 512 : 256;
                break;
            }
            default: {
                return false;
            }
        }
        Event event = new Event();
        consume[0] = (code & detail) != 0;
        event.doit = consume[0];
        event.detail = detail;
        if (!this.setKeyState(event, 31, theEvent)) {
            return false;
        }
        Shell shell = this.getShell();
        Control control = this;
        do {
            if (control.traverse(event)) {
                return true;
            }
            if (!event.doit && control.hooks(31)) {
                return false;
            }
            if (control == shell) {
                return false;
            }
            control = control.parent;
        } while (all && control != null);
        return false;
    }

    int traversalCode(int key, int theEvent) {
        int code = 28;
        Shell shell = this.getShell();
        if (shell.parent != null) {
            code |= 2;
        }
        return code;
    }

    boolean traverseMnemonic(char key) {
        return false;
    }

    public boolean traverse(int traversal, Event event) {
        this.checkWidget();
        if (event == null) {
            this.error(4);
        }
        return this.traverse(traversal, event.character, event.keyCode, event.keyLocation, event.stateMask, event.doit);
    }

    public boolean traverse(int traversal, KeyEvent event) {
        this.checkWidget();
        if (event == null) {
            this.error(4);
        }
        return this.traverse(traversal, event.character, event.keyCode, event.keyLocation, event.stateMask, event.doit);
    }

    boolean traverse(int traversal, char character, int keyCode, int keyLocation, int stateMask, boolean doit) {
        if (traversal == 0) {
            switch (keyCode) {
                case 27: {
                    traversal = 2;
                    doit = true;
                    break;
                }
                case 13: {
                    traversal = 4;
                    doit = true;
                    break;
                }
                case 0x1000002: 
                case 0x1000004: {
                    traversal = 64;
                    doit = false;
                    break;
                }
                case 0x1000001: 
                case 0x1000003: {
                    traversal = 32;
                    doit = false;
                    break;
                }
                case 9: {
                    traversal = (stateMask & 0x20000) != 0 ? 8 : 16;
                    doit = true;
                    break;
                }
                case 0x1000006: {
                    if ((stateMask & 0x40000) == 0) break;
                    traversal = 512;
                    doit = true;
                    break;
                }
                case 0x1000005: {
                    if ((stateMask & 0x40000) == 0) break;
                    traversal = 256;
                    doit = true;
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        Event event = new Event();
        event.character = character;
        event.detail = traversal;
        event.doit = doit;
        event.keyCode = keyCode;
        event.keyLocation = keyLocation;
        event.stateMask = stateMask;
        Shell shell = this.getShell();
        boolean all = false;
        switch (traversal) {
            case 2: 
            case 4: 
            case 256: 
            case 512: {
                all = true;
            }
            case 8: 
            case 16: 
            case 32: 
            case 64: {
                break;
            }
            default: {
                return false;
            }
        }
        Control control = this;
        do {
            if (control.traverse(event)) {
                return true;
            }
            if (!event.doit && control.hooks(31)) {
                return false;
            }
            if (control == shell) {
                return false;
            }
            control = control.parent;
        } while (all && control != null);
        return false;
    }

    public boolean traverse(int traversal) {
        this.checkWidget();
        Event event = new Event();
        event.doit = true;
        event.detail = traversal;
        return this.traverse(event);
    }

    boolean traverse(Event event) {
        this.sendEvent(31, event);
        if (this.isDisposed()) {
            return true;
        }
        if (!event.doit) {
            return false;
        }
        switch (event.detail) {
            case 0: {
                return true;
            }
            case 2: {
                return this.traverseEscape();
            }
            case 4: {
                return this.traverseReturn();
            }
            case 16: {
                return this.traverseGroup(true);
            }
            case 8: {
                return this.traverseGroup(false);
            }
            case 64: {
                return this.traverseItem(true);
            }
            case 32: {
                return this.traverseItem(false);
            }
            case 128: {
                return this.traverseMnemonic(event);
            }
            case 512: {
                return this.traversePage(true);
            }
            case 256: {
                return this.traversePage(false);
            }
        }
        return false;
    }

    boolean traverseEscape() {
        return false;
    }

    boolean traverseGroup(boolean next) {
        Control root = this.computeTabRoot();
        Control group = this.computeTabGroup();
        Control[] list = root.computeTabList();
        int length = list.length;
        int index = 0;
        while (index < length) {
            if (list[index] == group) break;
            ++index;
        }
        if (index == length) {
            return false;
        }
        int start = index;
        int offset = next ? 1 : -1;
        while ((index = (index + offset + length) % length) != start) {
            Control control = list[index];
            if (control.isDisposed() || !control.setTabGroupFocus()) continue;
            return true;
        }
        if (group.isDisposed()) {
            return false;
        }
        return group.setTabGroupFocus();
    }

    boolean traverseItem(boolean next) {
        Control[] children = this.parent._getChildren();
        int length = children.length;
        int index = 0;
        while (index < length) {
            if (children[index] == this) break;
            ++index;
        }
        if (index == length) {
            return false;
        }
        int start = index;
        int offset = next ? 1 : -1;
        while ((index = (index + offset + length) % length) != start) {
            Control child = children[index];
            if (child.isDisposed() || !child.isTabItem() || !child.setTabItemFocus()) continue;
            return true;
        }
        return false;
    }

    boolean traverseReturn() {
        return false;
    }

    boolean traversePage(boolean next) {
        return false;
    }

    boolean traverseMnemonic(Event event) {
        return false;
    }

    public void update() {
        this.checkWidget();
        this.update(false);
    }

    void update(boolean all) {
        if (this.display.inPaint) {
            return;
        }
        OS.HIViewRender(this.handle);
        if (this.isDisposed()) {
            return;
        }
        OS.HIWindowFlush(OS.GetControlOwner(this.handle));
    }

    void updateBackgroundMode() {
        int oldState = this.state & 0x400;
        this.checkBackground();
        if (oldState != (this.state & 0x400)) {
            this.setBackground();
        }
    }

    void updateLayout(boolean all) {
    }
}

