/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.carbon.ControlButtonContentInfo;
import org.eclipse.swt.internal.carbon.ControlTabInfoRecV1;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Rect;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TabFolder;

public class TabItem
extends Item {
    TabFolder parent;
    Control control;
    String toolTipText;
    static final int EXTRA_WIDTH = 25;

    public TabItem(TabFolder parent, int style) {
        super(parent, style);
        this.parent = parent;
        parent.createItem(this, parent.getItemCount());
    }

    public TabItem(TabFolder parent, int style, int index) {
        super(parent, style);
        this.parent = parent;
        parent.createItem(this, index);
    }

    int calculateWidth(GC gc) {
        int width = 0;
        Image image = this.getImage();
        String text = this.getText();
        if (image != null) {
            width = image.getBounds().width + 2;
        }
        if (text != null && text.length() > 0) {
            width += gc.stringExtent((String)text).x;
        }
        return width + 25;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    public Rectangle getBounds() {
        this.checkWidget();
        int index = this.parent.indexOf(this);
        if (index == -1) {
            return new Rectangle(0, 0, 0, 0);
        }
        int rgnHandle = OS.NewRgn();
        OS.GetControlRegion(this.parent.handle, (short)(index + 1), rgnHandle);
        Rect rect = new Rect();
        OS.GetRegionBounds(rgnHandle, rect);
        OS.DisposeRgn(rgnHandle);
        return new Rectangle(rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top);
    }

    public Control getControl() {
        this.checkWidget();
        return this.control;
    }

    public TabFolder getParent() {
        this.checkWidget();
        return this.parent;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    void releaseHandle() {
        super.releaseHandle();
        this.parent = null;
    }

    void releaseParent() {
        super.releaseParent();
        int index = this.parent.indexOf(this);
        if (index == this.parent.getSelectionIndex() && this.control != null) {
            this.control.setVisible(false);
        }
    }

    void releaseWidget() {
        super.releaseWidget();
        this.control = null;
    }

    public void setControl(Control control) {
        int selectionIndex;
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (control.parent != this.parent) {
                this.error(32);
            }
        }
        if (this.control != null && this.control.isDisposed()) {
            this.control = null;
        }
        Control oldControl = this.control;
        Control newControl = control;
        this.control = control;
        int index = this.parent.indexOf(this);
        if (index != (selectionIndex = this.parent.getSelectionIndex()) && newControl != null) {
            Control selectedControl;
            if (selectionIndex != -1 && (selectedControl = this.parent.getItem(selectionIndex).getControl()) == newControl) {
                return;
            }
            newControl.setVisible(false);
            return;
        }
        if (newControl != null) {
            newControl.setBounds(this.parent.getClientArea());
            newControl.setVisible(true);
        }
        if (oldControl != null) {
            oldControl.setVisible(false);
        }
    }

    public void setImage(Image image) {
        this.checkWidget();
        int index = this.parent.indexOf(this);
        if (index == -1) {
            return;
        }
        super.setImage(image);
        ControlButtonContentInfo inContent = new ControlButtonContentInfo();
        if (image == null) {
            inContent.contentType = 0;
        } else {
            inContent.contentType = (short)134;
            inContent.iconRef = image.handle;
        }
        OS.SetControlData(this.parent.handle, index + 1, 1668247156, 6, inContent);
        this.parent.redraw();
    }

    public void setText(String string) {
        int index;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((index = this.parent.indexOf(this)) == -1) {
            return;
        }
        super.setText(string);
        char[] buffer = new char[this.text.length()];
        this.text.getChars(0, buffer.length, buffer, 0);
        int length = this.fixMnemonic(buffer);
        int ptr = OS.CFStringCreateWithCharacters(0, buffer, length);
        if (ptr == 0) {
            this.error(13);
        }
        ControlTabInfoRecV1 tab = new ControlTabInfoRecV1();
        tab.version = 1;
        tab.iconSuiteID = 0;
        tab.name = ptr;
        OS.SetControlData(this.parent.handle, index + 1, 1952539241, 8, tab);
        OS.CFRelease(ptr);
        if (this.image != null) {
            ControlButtonContentInfo inContent = new ControlButtonContentInfo();
            inContent.contentType = (short)134;
            inContent.iconRef = this.image.handle;
            OS.SetControlData(this.parent.handle, index + 1, 1668247156, 6, inContent);
        }
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.toolTipText = string;
    }

    void update() {
        this.setText(this.text);
        this.setImage(this.image);
        this.setToolTipText(this.toolTipText);
    }
}

