/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSCalendarDate;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSControl;
import org.eclipse.swt.internal.cocoa.NSDate;
import org.eclipse.swt.internal.cocoa.NSDatePicker;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSImage;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTDatePicker;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TypedListener;

public class DateTime
extends Composite {
    static final int MIN_YEAR = 1752;
    static final int MAX_YEAR = 9999;

    public DateTime(Composite parent, int style) {
        super(parent, DateTime.checkStyle(style));
    }

    static int checkStyle(int style) {
        style &= 0xFFFFFCFF;
        style = DateTime.checkBits(style, 65536, 32768, 0x10000000, 0, 0, 0);
        return DateTime.checkBits(style, 32, 128, 1024, 0, 0, 0);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 0;
        int height = 0;
        NSControl widget = (NSControl)this.view;
        NSSize size = widget.cell().cellSize();
        width = (int)Math.ceil(size.width);
        height = (int)Math.ceil(size.height);
        if (width == 0) {
            width = 64;
        }
        if (height == 0) {
            height = 64;
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        int border = this.getBorderWidth();
        return new Point(width += border * 2, height += border * 2);
    }

    void createHandle() {
        NSDatePicker widget = (NSDatePicker)new SWTDatePicker().alloc();
        widget.init();
        int pickerStyle = 0;
        int elementFlags = 0;
        if ((this.style & 0x400) != 0) {
            pickerStyle = 1;
            elementFlags = 224;
        } else {
            if ((this.style & 0x80) != 0) {
                int n = elementFlags = (this.style & 0x8000) != 0 ? 12 : 14;
            }
            if ((this.style & 0x20) != 0) {
                elementFlags = (this.style & 0x8000) != 0 ? 192 : 224;
            }
        }
        widget.setDrawsBackground(true);
        widget.setDatePickerStyle(pickerStyle);
        widget.setDatePickerElements(elementFlags);
        NSCalendarDate date = NSCalendarDate.calendarDate();
        widget.setDateValue(date);
        widget.setTarget(widget);
        widget.setAction(OS.sel_sendSelection);
        this.view = widget;
    }

    NSFont defaultNSFont() {
        return this.display.datePickerFont;
    }

    void drawBackground(long id2, NSGraphicsContext context, NSRect rect) {
        if (id2 != this.view.id) {
            return;
        }
        this.fillBackground(this.view, context, rect, -1);
    }

    NSCalendarDate getCalendarDate() {
        NSDate date = ((NSDatePicker)this.view).dateValue();
        return date.dateWithCalendarFormat(null, null);
    }

    public int getDay() {
        this.checkWidget();
        return (int)this.getCalendarDate().dayOfMonth();
    }

    public int getHours() {
        this.checkWidget();
        return (int)this.getCalendarDate().hourOfDay();
    }

    public int getMinutes() {
        this.checkWidget();
        return (int)this.getCalendarDate().minuteOfHour();
    }

    public int getMonth() {
        this.checkWidget();
        return (int)this.getCalendarDate().monthOfYear() - 1;
    }

    String getNameText() {
        return (this.style & 0x80) != 0 ? String.valueOf(this.getHours()) + ":" + this.getMinutes() + ":" + this.getSeconds() : String.valueOf(this.getMonth() + 1) + "/" + this.getDay() + "/" + this.getYear();
    }

    public int getSeconds() {
        this.checkWidget();
        return (int)this.getCalendarDate().secondOfMinute();
    }

    public int getYear() {
        this.checkWidget();
        return (int)this.getCalendarDate().yearOfCommonEra();
    }

    boolean isEventView(long id2) {
        return true;
    }

    boolean isFlipped(long id2, long sel) {
        if ((this.style & 0x400) != 0) {
            return super.isFlipped(id2, sel);
        }
        return true;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    boolean sendKeyEvent(NSEvent nsEvent, int type) {
        boolean result = super.sendKeyEvent(nsEvent, type);
        if (!result) {
            return result;
        }
        if (type != 1) {
            return result;
        }
        if ((this.style & 0x400) == 0) {
            short keyCode = nsEvent.keyCode();
            switch (keyCode) {
                case 36: 
                case 76: {
                    this.sendSelectionEvent(14);
                }
            }
        }
        return result;
    }

    void sendSelection() {
        NSEvent event = NSApplication.sharedApplication().currentEvent();
        if (event != null && (this.style & 0x400) != 0) {
            if (event.clickCount() == 2L) {
                this.sendSelectionEvent(14);
            } else if (event.type() == 2L) {
                this.sendSelectionEvent(13);
            }
        } else {
            this.sendSelectionEvent(13);
        }
    }

    void setBackgroundColor(NSColor nsColor) {
        ((NSDatePicker)this.view).setBackgroundColor(nsColor);
    }

    void setBackgroundImage(NSImage image) {
        ((NSDatePicker)this.view).setDrawsBackground(image == null);
    }

    public void setDate(int year, int month, int day) {
        this.checkWidget();
        if (year < 1752 || year > 9999) {
            return;
        }
        NSCalendarDate date = this.getCalendarDate();
        NSCalendarDate newDate = NSCalendarDate.dateWithYear(year, month + 1, day, date.hourOfDay(), date.minuteOfHour(), date.secondOfMinute(), date.timeZone());
        if (newDate.yearOfCommonEra() == (long)year && newDate.monthOfYear() == (long)(month + 1) && newDate.dayOfMonth() == (long)day) {
            ((NSDatePicker)this.view).setDateValue(newDate);
        }
    }

    public void setDay(int day) {
        this.checkWidget();
        NSCalendarDate date = this.getCalendarDate();
        NSCalendarDate newDate = NSCalendarDate.dateWithYear(date.yearOfCommonEra(), date.monthOfYear(), day, date.hourOfDay(), date.minuteOfHour(), date.secondOfMinute(), date.timeZone());
        if (newDate.yearOfCommonEra() == date.yearOfCommonEra() && newDate.monthOfYear() == date.monthOfYear() && newDate.dayOfMonth() == (long)day) {
            ((NSDatePicker)this.view).setDateValue(newDate);
        }
    }

    void setForeground(double[] color) {
        NSColor nsColor = color == null ? ((this.style & 0x400) != 0 ? NSColor.controlTextColor() : NSColor.textColor()) : NSColor.colorWithCalibratedRed(color[0], color[1], color[2], 1.0);
        ((NSDatePicker)this.view).setTextColor(nsColor);
    }

    public void setHours(int hours) {
        this.checkWidget();
        if (hours < 0 || hours > 23) {
            return;
        }
        NSCalendarDate date = this.getCalendarDate();
        NSCalendarDate newDate = NSCalendarDate.dateWithYear(date.yearOfCommonEra(), date.monthOfYear(), date.dayOfMonth(), hours, date.minuteOfHour(), date.secondOfMinute(), date.timeZone());
        ((NSDatePicker)this.view).setDateValue(newDate);
    }

    public void setMinutes(int minutes) {
        this.checkWidget();
        if (minutes < 0 || minutes > 59) {
            return;
        }
        NSCalendarDate date = this.getCalendarDate();
        NSCalendarDate newDate = NSCalendarDate.dateWithYear(date.yearOfCommonEra(), date.monthOfYear(), date.dayOfMonth(), date.hourOfDay(), minutes, date.secondOfMinute(), date.timeZone());
        ((NSDatePicker)this.view).setDateValue(newDate);
    }

    public void setMonth(int month) {
        this.checkWidget();
        NSCalendarDate date = this.getCalendarDate();
        NSCalendarDate newDate = NSCalendarDate.dateWithYear(date.yearOfCommonEra(), month + 1, date.dayOfMonth(), date.hourOfDay(), date.minuteOfHour(), date.secondOfMinute(), date.timeZone());
        if (newDate.yearOfCommonEra() == date.yearOfCommonEra() && newDate.monthOfYear() == (long)(month + 1) && newDate.dayOfMonth() == date.dayOfMonth()) {
            ((NSDatePicker)this.view).setDateValue(newDate);
        }
    }

    public void setSeconds(int seconds) {
        this.checkWidget();
        if (seconds < 0 || seconds > 59) {
            return;
        }
        NSCalendarDate date = this.getCalendarDate();
        NSCalendarDate newDate = NSCalendarDate.dateWithYear(date.yearOfCommonEra(), date.monthOfYear(), date.dayOfMonth(), date.hourOfDay(), date.minuteOfHour(), seconds, date.timeZone());
        ((NSDatePicker)this.view).setDateValue(newDate);
    }

    public void setTime(int hours, int minutes, int seconds) {
        this.checkWidget();
        if (hours < 0 || hours > 23 || minutes < 0 || minutes > 59 || seconds < 0 || seconds > 59) {
            return;
        }
        NSCalendarDate date = this.getCalendarDate();
        NSCalendarDate newDate = NSCalendarDate.dateWithYear(date.yearOfCommonEra(), date.monthOfYear(), date.dayOfMonth(), hours, minutes, seconds, date.timeZone());
        ((NSDatePicker)this.view).setDateValue(newDate);
    }

    public void setYear(int year) {
        this.checkWidget();
        if (year < 1752 || year > 9999) {
            return;
        }
        NSCalendarDate date = this.getCalendarDate();
        NSCalendarDate newDate = NSCalendarDate.dateWithYear(year, date.monthOfYear(), date.dayOfMonth(), date.hourOfDay(), date.minuteOfHour(), date.secondOfMinute(), date.timeZone());
        if (newDate.yearOfCommonEra() == (long)year && newDate.monthOfYear() == date.monthOfYear() && newDate.dayOfMonth() == date.dayOfMonth()) {
            ((NSDatePicker)this.view).setDateValue(newDate);
        }
    }
}

