/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.internal.cocoa.NSButton;
import org.eclipse.swt.internal.cocoa.NSButtonCell;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Widget;

public class Decorations
extends Canvas {
    Image image;
    Image[] images = new Image[0];
    Menu menuBar;
    String text = "";
    boolean minimized;
    boolean maximized;
    Control savedFocus;
    Button defaultButton;

    Decorations() {
    }

    public Decorations(Composite parent, int style) {
        super(parent, Decorations.checkStyle(style));
    }

    static int checkStyle(int style) {
        if ((style & 8) != 0) {
            style &= 0xFFFFF30F;
        }
        if ((style & 0x4C0) != 0) {
            style |= 0x20;
        }
        return style;
    }

    void bringToTop(boolean force) {
        this.moveAbove(null);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    int compare(ImageData data1, ImageData data2) {
        if (data1.width == data2.width && data1.height == data2.height) {
            int transparent1 = data1.getTransparencyType();
            int transparent2 = data2.getTransparencyType();
            if (transparent1 == 1) {
                return -1;
            }
            if (transparent2 == 1) {
                return 1;
            }
            if (transparent1 == 2) {
                return -1;
            }
            if (transparent2 == 2) {
                return 1;
            }
            if (transparent1 == 4) {
                return -1;
            }
            if (transparent2 == 4) {
                return 1;
            }
            return 0;
        }
        return data1.width > data2.width || data1.height > data2.height ? -1 : 1;
    }

    Widget computeTabGroup() {
        return this;
    }

    Control computeTabRoot() {
        return this;
    }

    void fixDecorations(Decorations newDecorations, Control control, Menu[] menus) {
        if (this == newDecorations) {
            return;
        }
        if (control == this.savedFocus) {
            this.savedFocus = null;
        }
        if (control == this.defaultButton) {
            this.defaultButton = null;
        }
        if (menus == null) {
            return;
        }
        Menu menu = control.menu;
        if (menu != null) {
            int index = 0;
            while (index < menus.length) {
                if (menus[index] == menu) {
                    control.setMenu(null);
                    return;
                }
                ++index;
            }
            menu.fixMenus(newDecorations);
        }
    }

    public Button getDefaultButton() {
        this.checkWidget();
        if (this.defaultButton != null && this.defaultButton.isDisposed()) {
            return null;
        }
        return this.defaultButton;
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    public Image[] getImages() {
        this.checkWidget();
        if (this.images == null) {
            return new Image[0];
        }
        Image[] result = new Image[this.images.length];
        System.arraycopy(this.images, 0, result, 0, this.images.length);
        return result;
    }

    public boolean getMaximized() {
        this.checkWidget();
        return this.maximized;
    }

    public Menu getMenuBar() {
        this.checkWidget();
        return this.menuBar;
    }

    public boolean getMinimized() {
        this.checkWidget();
        return this.minimized;
    }

    String getNameText() {
        return this.getText();
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    public boolean isReparentable() {
        this.checkWidget();
        return false;
    }

    boolean isTabGroup() {
        return true;
    }

    boolean isTabItem() {
        return false;
    }

    Decorations menuShell() {
        return this;
    }

    void releaseChildren(boolean destroy) {
        if (this.menuBar != null) {
            this.menuBar.dispose();
            this.menuBar = null;
        }
        Display display = this.display;
        super.releaseChildren(destroy);
        Menu[] menus = display.getMenus(this);
        if (menus != null) {
            int i = 0;
            while (i < menus.length) {
                Menu menu = menus[i];
                if (menu != null && !menu.isDisposed()) {
                    menu.dispose();
                }
                ++i;
            }
            menus = null;
        }
    }

    void releaseWidget() {
        super.releaseWidget();
        this.image = null;
        this.images = null;
        this.savedFocus = null;
        this.defaultButton = null;
    }

    void reskinChildren(int flags) {
        Menu[] menus;
        if (this.menuBar != null) {
            this.menuBar.reskin(flags);
        }
        if ((menus = this.display.getMenus(this)) != null) {
            int i = 0;
            while (i < menus.length) {
                Menu menu = menus[i];
                if (menu != null) {
                    menu.reskin(flags);
                }
                ++i;
            }
        }
        super.reskinChildren(flags);
    }

    boolean restoreFocus() {
        if (this.savedFocus != null && this.savedFocus.isDisposed()) {
            this.savedFocus = null;
        }
        if (this.savedFocus == null) {
            return false;
        }
        return this.savedFocus.forceFocus();
    }

    void saveFocus() {
        Control control = this.display.getFocusControl();
        if (control != null && control != this && this == control.menuShell()) {
            this.setSavedFocus(control);
        }
    }

    public void setDefaultButton(Button button) {
        this.checkWidget();
        if (button != null) {
            if (button.isDisposed()) {
                this.error(5);
            }
            if (button.menuShell() != this) {
                this.error(32);
            }
            if ((button.style & 8) == 0) {
                return;
            }
        }
        if (button == this.defaultButton) {
            return;
        }
        this.defaultButton = button;
        NSButtonCell cell = null;
        if (this.defaultButton != null && (this.defaultButton.style & 8) != 0) {
            cell = new NSButtonCell(((NSButton)this.defaultButton.view).cell());
        }
        this.view.window().setDefaultButtonCell(cell);
        this.display.updateDefaultButton();
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        this.image = image;
        if (this.parent != null) {
            return;
        }
        if (this.display.dockImage == null) {
            this.display.application.setApplicationIconImage(image != null ? image.handle : null);
        }
    }

    public void setImages(Image[] images) {
        this.checkWidget();
        if (images == null) {
            this.error(5);
        }
        int i = 0;
        while (i < images.length) {
            if (images[i] == null || images[i].isDisposed()) {
                this.error(5);
            }
            ++i;
        }
        this.images = images;
        if (this.parent != null) {
            return;
        }
        if (this.display.dockImage == null) {
            if (images != null && images.length > 1) {
                Image[] bestImages = new Image[images.length];
                System.arraycopy(images, 0, bestImages, 0, images.length);
                this.sort(bestImages);
                images = bestImages;
            }
            if (images != null && images.length > 0) {
                this.display.application.setApplicationIconImage(images[0].handle);
            } else {
                this.display.application.setApplicationIconImage(null);
            }
        }
    }

    public void setMaximized(boolean maximized) {
        this.checkWidget();
        this.maximized = maximized;
    }

    public void setMenuBar(Menu menu) {
        this.checkWidget();
        if (this.menuBar == menu) {
            return;
        }
        if (menu != null) {
            if (menu.isDisposed()) {
                this.error(5);
            }
            if ((menu.style & 2) == 0) {
                this.error(33);
            }
            if (menu.parent != this) {
                this.error(32);
            }
        }
        this.menuBar = menu;
    }

    public void setMinimized(boolean minimized) {
        this.checkWidget();
        this.minimized = minimized;
    }

    void setSavedFocus(Control control) {
        this.savedFocus = control;
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.text = string;
    }

    void sort(Image[] images) {
        int length = images.length;
        if (length <= 1) {
            return;
        }
        ImageData[] datas = new ImageData[length];
        int i = 0;
        while (i < length) {
            datas[i] = images[i].getImageData();
            ++i;
        }
        int gap = length / 2;
        while (gap > 0) {
            int i2 = gap;
            while (i2 < length) {
                int j = i2 - gap;
                while (j >= 0) {
                    if (this.compare(datas[j], datas[j + gap]) >= 0) {
                        Image swap = images[j];
                        images[j] = images[j + gap];
                        images[j + gap] = swap;
                        ImageData swapData = datas[j];
                        datas[j] = datas[j + gap];
                        datas[j + gap] = swapData;
                    }
                    j -= gap;
                }
                ++i2;
            }
            gap /= 2;
        }
    }

    boolean traverseItem(boolean next) {
        return false;
    }

    boolean traverseReturn() {
        if (this.defaultButton == null || this.defaultButton.isDisposed()) {
            return false;
        }
        if (!this.defaultButton.isVisible() || !this.defaultButton.isEnabled()) {
            return false;
        }
        this.defaultButton.click();
        return true;
    }
}

