/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.addons.dndaddon;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.addons.dndaddon.CursorInfo;
import org.eclipse.e4.ui.workbench.addons.dndaddon.DetachedDropAgent;
import org.eclipse.e4.ui.workbench.addons.dndaddon.DragAgent;
import org.eclipse.e4.ui.workbench.addons.dndaddon.DragAndDropUtil;
import org.eclipse.e4.ui.workbench.addons.dndaddon.DropAgent;
import org.eclipse.e4.ui.workbench.addons.dndaddon.PartDragAgent;
import org.eclipse.e4.ui.workbench.addons.dndaddon.SplitDropAgent;
import org.eclipse.e4.ui.workbench.addons.dndaddon.StackDropAgent;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tracker;

class DnDManager {
    private static final int DRAG_OFFSET = 8;
    DragAndDropUtil dndUtil;
    Rectangle offScreenRect = new Rectangle(10000, -10000, 1, 1);
    Collection<DragAgent> dragAgents = new ArrayList<DragAgent>();
    DragAgent dragAgent;
    boolean dragging = false;
    Collection<DropAgent> dropAgents = new ArrayList<DropAgent>();
    DropAgent dropAgent;
    protected CursorInfo dndInfo;
    protected Point downPos;
    protected CursorInfo downInfo;
    private Display display;
    Listener keyListener = new Listener(){

        public void handleEvent(Event event) {
            if (event.character == '\u001b' && DnDManager.this.dragAgent != null) {
                DnDManager.this.dragAgent.cancelDrag();
                DnDManager.this.dragAgent = null;
            }
        }
    };
    Listener mouseButtonListener = new Listener(){

        public void handleEvent(Event event) {
            if (event.button != 1) {
                DnDManager.this.downPos = null;
                return;
            }
            CursorInfo info = DnDManager.this.dndUtil.getCursorInfo();
            if (event.type == 3) {
                DnDManager.this.dragAgent = DnDManager.this.getDragAgent(info);
                if (DnDManager.this.dragAgent != null) {
                    DnDManager.this.downPos = new Point(event.x, event.y);
                    DnDManager.this.downInfo = info;
                }
            } else if (event.type == 4) {
                DnDManager.this.downPos = null;
                DnDManager.this.downInfo = null;
                if (DnDManager.this.dragging) {
                    if (DnDManager.this.dropAgent != null) {
                        DnDManager.this.dropAgent.drop(DnDManager.this.dragAgent.dragElement, DnDManager.this.dndUtil.getCursorInfo());
                    } else if (DnDManager.this.dragAgent != null) {
                        DnDManager.this.dragAgent.cancelDrag();
                    }
                    DnDManager.this.dragging = false;
                }
            }
        }
    };
    Listener mouseMoveListener = new Listener(){

        public void handleEvent(Event event) {
            if (DnDManager.this.dragging) {
                CursorInfo info = DnDManager.this.dndUtil.getCursorInfo();
                DnDManager.this.dragAgent.trackDragFeedback(info);
                DropAgent newDropAgent = DnDManager.this.getDropAgent(DnDManager.this.dragAgent.dragElement, info);
                if (DnDManager.this.dropAgent != newDropAgent) {
                    if (DnDManager.this.dropAgent != null) {
                        DnDManager.this.dropAgent.dragLeave();
                    }
                    DnDManager.this.dropAgent = newDropAgent;
                    if (DnDManager.this.dropAgent != null) {
                        DnDManager.this.dropAgent.dragEnter();
                    }
                }
            } else if (DnDManager.this.downPos != null) {
                Point curPos = new Point(event.x, event.y);
                int dx = Math.abs(DnDManager.this.downPos.x - curPos.x);
                int dy = Math.abs(DnDManager.this.downPos.y - curPos.y);
                if (dx > 8 || dy > 8) {
                    DnDManager.this.downPos = null;
                    DnDManager.this.startDrag(DnDManager.this.downInfo);
                }
            }
        }
    };
    private EModelService modelService;
    private MWindow baseWindow;
    private Shell baseShell;

    public DnDManager(MWindow window) {
        this.baseWindow = window;
        this.dragAgents.add(new PartDragAgent());
        this.dropAgents.add(new StackDropAgent(window));
        this.modelService = (EModelService)window.getContext().get(EModelService.class.getName());
        this.dropAgents.add(new SplitDropAgent(this.modelService));
        this.dropAgents.add(new DetachedDropAgent(this.modelService));
        if (this.baseWindow.getWidget() instanceof Shell) {
            this.baseShell = (Shell)this.baseWindow.getWidget();
            this.display = this.baseShell.getDisplay();
            this.setDisplayFilters(true);
            this.dndUtil = new DragAndDropUtil(window);
            this.modelService = (EModelService)this.baseWindow.getContext().get(EModelService.class.getName());
            this.baseShell.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    if (!DnDManager.this.display.isDisposed()) {
                        DnDManager.this.setDisplayFilters(false);
                    }
                }
            });
        }
    }

    protected void startDrag(CursorInfo downInfo2) {
        this.dragging = true;
        this.setDisplayFilters(false);
        final Tracker tracker = new Tracker(this.display, 0);
        tracker.setStippled(true);
        tracker.addListener(10, new Listener(){

            public void handleEvent(Event event) {
                DnDManager.this.display.syncExec(new Runnable(){

                    public void run() {
                        CursorInfo dragInfo = (this).DnDManager.this.dndUtil.getCursorInfo();
                        (this).DnDManager.this.dropAgent = DnDManager.this.getDropAgent((this).DnDManager.this.dragAgent.getDragElement(), dragInfo);
                        if ((this).DnDManager.this.dropAgent == null) {
                            DnDManager.this.baseShell.setCursor(DnDManager.this.baseShell.getDisplay().getSystemCursor(20));
                            tracker.setRectangles(new Rectangle[]{(this).DnDManager.this.offScreenRect});
                        } else {
                            Rectangle rect = (this).DnDManager.this.dropAgent.getRectangle((this).DnDManager.this.dragAgent.dragElement, dragInfo);
                            if (rect == null) {
                                rect = (this).DnDManager.this.offScreenRect;
                            }
                            tracker.setRectangles(new Rectangle[]{rect});
                            DnDManager.this.baseShell.setCursor((this).DnDManager.this.dropAgent.getCursor(DnDManager.this.display, (this).DnDManager.this.dragAgent.dragElement, dragInfo));
                        }
                    }
                });
            }
        });
        this.baseShell.setCapture(true);
        try {
            this.dragAgent.dragStart(this.dragAgent.dragElement);
            boolean performDrop = tracker.open();
            if (performDrop && this.dropAgent != null) {
                this.dropAgent.drop(this.dragAgent.getDragElement(), this.dndUtil.getCursorInfo());
            } else {
                this.dragAgent.cancelDrag();
            }
        }
        finally {
            tracker.dispose();
            this.baseShell.setCursor(null);
            this.baseShell.setCapture(false);
            this.dragging = false;
            this.setDisplayFilters(true);
        }
    }

    public void addDragAgent(DragAgent newAgent) {
        if (!this.dragAgents.contains(newAgent)) {
            this.dragAgents.add(newAgent);
        }
    }

    public void removeDragAgent(DragAgent agentToRemove) {
        this.dragAgents.remove(agentToRemove);
    }

    public void addDropAgent(DropAgent newAgent) {
        if (!this.dropAgents.contains(newAgent)) {
            this.dropAgents.add(newAgent);
        }
    }

    public void removeDropAgent(DropAgent agentToRemove) {
        this.dropAgents.remove(agentToRemove);
    }

    private DragAgent getDragAgent(CursorInfo info) {
        for (DragAgent agent : this.dragAgents) {
            if (!agent.canDrag(info)) continue;
            return agent;
        }
        return null;
    }

    private DropAgent getDropAgent(MUIElement dragElement, CursorInfo info) {
        for (DropAgent agent : this.dropAgents) {
            if (!agent.canDrop(dragElement, info)) continue;
            return agent;
        }
        return null;
    }

    public void setDisplayFilters(boolean enable) {
        if (enable) {
            this.display.addFilter(5, this.mouseMoveListener);
            this.display.addFilter(3, this.mouseButtonListener);
            this.display.addFilter(4, this.mouseButtonListener);
            this.display.addFilter(1, this.keyListener);
        } else {
            this.display.removeFilter(5, this.mouseMoveListener);
            this.display.removeFilter(3, this.mouseButtonListener);
            this.display.removeFilter(4, this.mouseButtonListener);
            this.display.removeFilter(1, this.keyListener);
        }
    }
}

