/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.base.remote;

import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.internal.base.util.TestConnectionUtility;

public class RemoteStatusData {
    public static boolean isAnyRemoteHelpUnavailable() {
        ArrayList sites = RemoteStatusData.getRemoteSites();
        if (sites.isEmpty()) {
            return false;
        }
        ArrayList badSites = RemoteStatusData.checkSitesConnectivity(sites);
        return !badSites.isEmpty();
    }

    public static ArrayList checkSitesConnectivity(ArrayList sites) {
        ArrayList<URL> badSites = new ArrayList<URL>();
        int i = 0;
        while (i < sites.size()) {
            URL baseURL = (URL)sites.get(i);
            boolean isConnected = TestConnectionUtility.testConnection(baseURL.getHost(), "" + baseURL.getPort(), baseURL.getPath(), baseURL.getProtocol());
            if (!isConnected) {
                badSites.add(baseURL);
            }
            ++i;
        }
        return badSites;
    }

    public static ArrayList getRemoteSites() {
        ArrayList<URL> sites = new ArrayList<URL>();
        boolean remoteHelpEnabled = Platform.getPreferencesService().getBoolean("org.eclipse.help.base", "remoteHelpOn", false, null);
        if (!remoteHelpEnabled) {
            return sites;
        }
        String[] hosts = Platform.getPreferencesService().getString("org.eclipse.help.base", "remoteHelpHost", "", null).split(",");
        String[] paths = Platform.getPreferencesService().getString("org.eclipse.help.base", "remoteHelpPath", "", null).split(",");
        String[] protocols = Platform.getPreferencesService().getString("org.eclipse.help.base", "remoteHelpProtocol", "", null).split(",");
        String[] ports = Platform.getPreferencesService().getString("org.eclipse.help.base", "remoteHelpPort", "", null).split(",");
        String[] enableds = Platform.getPreferencesService().getString("org.eclipse.help.base", "remoteHelpICEnabled", "", null).split(",");
        int i = 0;
        while (i < hosts.length) {
            try {
                if (enableds[i].equalsIgnoreCase("true")) {
                    URL url = new URL(String.valueOf(protocols[i]) + "://" + hosts[i] + ':' + ports[i] + paths[i]);
                    sites.add(url);
                }
            }
            catch (Exception exception) {}
            ++i;
        }
        return sites;
    }
}

