/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.callhierarchy;

import java.util.Iterator;
import org.eclipse.jdt.internal.corext.callhierarchy.MethodWrapper;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.callhierarchy.CallHierarchyMessages;
import org.eclipse.jdt.internal.ui.callhierarchy.CallHierarchyViewPart;
import org.eclipse.jdt.internal.ui.callhierarchy.CallHierarchyViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

class RemoveFromViewAction
extends Action {
    private CallHierarchyViewPart fPart;
    private CallHierarchyViewer fCallHierarchyViewer;

    public RemoveFromViewAction(CallHierarchyViewPart part, CallHierarchyViewer viewer) {
        this.fPart = part;
        this.fCallHierarchyViewer = viewer;
        this.setText(CallHierarchyMessages.RemoveFromViewAction_removeFromView_text);
        this.setDescription(CallHierarchyMessages.RemoveFromViewAction_removeFromView_description);
        this.setToolTipText(CallHierarchyMessages.RemoveFromViewAction_removeFromView_tooltip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.call_hierarchy_remove_from_view_action_context");
        ISharedImages workbenchImages = JavaPlugin.getDefault().getWorkbench().getSharedImages();
        this.setDisabledImageDescriptor(workbenchImages.getImageDescriptor("IMG_ELCL_REMOVE_DISABLED"));
        this.setImageDescriptor(workbenchImages.getImageDescriptor("IMG_ELCL_REMOVE"));
        this.setHoverImageDescriptor(workbenchImages.getImageDescriptor("IMG_ELCL_REMOVE"));
    }

    public void run() {
        TreeItem[] items = this.fCallHierarchyViewer.getTree().getSelection();
        int i = 0;
        while (i < items.length) {
            items[i].dispose();
            ++i;
        }
    }

    private ISelection getSelection() {
        return this.fPart.getSelection();
    }

    protected boolean canActionBeAdded() {
        IStructuredSelection selection = (IStructuredSelection)this.getSelection();
        if (selection.isEmpty()) {
            return false;
        }
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (element instanceof MethodWrapper) continue;
            return false;
        }
        TreeItem[] items = this.fCallHierarchyViewer.getTree().getSelection();
        int k = 0;
        while (k < items.length) {
            if (!this.checkForChildren(items[k])) {
                return false;
            }
            ++k;
        }
        return true;
    }

    private boolean checkForChildren(TreeItem item) {
        Object data;
        TreeItem[] children = item.getItems();
        if (children.length == 1 && !((data = children[0].getData()) instanceof MethodWrapper) && data != null) {
            return false;
        }
        int i = 0;
        while (i < children.length) {
            if (!this.checkForChildren(children[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

