/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java.hover;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CharacterLiteral;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMemberValuePairBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.internal.corext.javadoc.JavaDocLocations;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.actions.OpenBrowserUtil;
import org.eclipse.jdt.internal.ui.actions.SimpleSelectionProvider;
import org.eclipse.jdt.internal.ui.infoviews.JavadocView;
import org.eclipse.jdt.internal.ui.text.java.hover.AbstractJavaEditorTextHover;
import org.eclipse.jdt.internal.ui.text.java.hover.JavaHoverMessages;
import org.eclipse.jdt.internal.ui.text.java.hover.JavadocBrowserInformationControlInput;
import org.eclipse.jdt.internal.ui.text.javadoc.JavadocContentAccess2;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementLinks;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.SharedASTProvider;
import org.eclipse.jdt.ui.actions.OpenAttachedJavadocAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.internal.text.html.BrowserInformationControl;
import org.eclipse.jface.internal.text.html.BrowserInformationControlInput;
import org.eclipse.jface.internal.text.html.BrowserInput;
import org.eclipse.jface.internal.text.html.HTMLPrinter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.AbstractReusableInformationControlCreator;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInformationControlExtension4;
import org.eclipse.jface.text.IInputChangedListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;
import org.osgi.framework.Bundle;

public class JavadocHover
extends AbstractJavaEditorTextHover {
    private static final long LABEL_FLAGS = JavaElementLabels.ALL_FULLY_QUALIFIED | 0x40L | 1L | 2L | 0x10L | 0x8000L | 4L | 0x200000L | 0x1000000000000L;
    private static final long LOCAL_VARIABLE_FLAGS = LABEL_FLAGS & 0xFFFFFFFFFFFEFFFFL | 0x20000L;
    private static final long TYPE_PARAMETER_FLAGS = LABEL_FLAGS | 0x400000L;
    private static String fgStyleSheet;
    private IInformationControlCreator fHoverControlCreator;
    private IInformationControlCreator fPresenterControlCreator;

    public IInformationControlCreator getInformationPresenterControlCreator() {
        if (this.fPresenterControlCreator == null) {
            this.fPresenterControlCreator = new PresenterControlCreator(this.getSite());
        }
        return this.fPresenterControlCreator;
    }

    private IWorkbenchSite getSite() {
        IWorkbenchPage page;
        IEditorPart editor = this.getEditor();
        if (editor == null && (page = JavaPlugin.getActivePage()) != null) {
            editor = page.getActiveEditor();
        }
        if (editor != null) {
            return editor.getSite();
        }
        return null;
    }

    public IInformationControlCreator getHoverControlCreator() {
        if (this.fHoverControlCreator == null) {
            this.fHoverControlCreator = new HoverControlCreator(this.getInformationPresenterControlCreator());
        }
        return this.fHoverControlCreator;
    }

    private static void addLinkListener(final BrowserInformationControl control) {
        control.addLocationListener(JavaElementLinks.createLocationListener(new JavaElementLinks.ILinkHandler(){

            public void handleJavadocViewLink(IJavaElement linkTarget) {
                control.notifyDelayedInputChange(null);
                control.setVisible(false);
                control.dispose();
                try {
                    JavadocView view = (JavadocView)JavaPlugin.getActivePage().showView("org.eclipse.jdt.ui.JavadocView");
                    view.setInput(linkTarget);
                }
                catch (PartInitException e) {
                    JavaPlugin.log(e);
                }
            }

            public void handleInlineJavadocLink(IJavaElement linkTarget) {
                JavadocBrowserInformationControlInput hoverInfo = JavadocHover.getHoverInfo(new IJavaElement[]{linkTarget}, null, null, (JavadocBrowserInformationControlInput)control.getInput());
                if (control.hasDelayedInputChangeListener()) {
                    control.notifyDelayedInputChange((Object)hoverInfo);
                } else {
                    control.setInput((Object)hoverInfo);
                }
            }

            public void handleDeclarationLink(IJavaElement linkTarget) {
                control.notifyDelayedInputChange(null);
                control.dispose();
                try {
                    JavaUI.openInEditor(linkTarget);
                }
                catch (PartInitException e) {
                    JavaPlugin.log(e);
                }
                catch (JavaModelException e) {
                    JavaPlugin.log(e);
                }
            }

            public boolean handleExternalLink(URL url, Display display) {
                control.notifyDelayedInputChange(null);
                control.dispose();
                OpenBrowserUtil.open(url, display);
                return true;
            }

            public void handleTextSet() {
            }
        }));
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        JavadocBrowserInformationControlInput info = (JavadocBrowserInformationControlInput)((Object)this.getHoverInfo2(textViewer, hoverRegion));
        return info != null ? info.getHtml() : null;
    }

    public Object getHoverInfo2(ITextViewer textViewer, IRegion hoverRegion) {
        return this.internalGetHoverInfo(textViewer, hoverRegion);
    }

    private JavadocBrowserInformationControlInput internalGetHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        IJavaElement[] elements = this.getJavaElementsAt(textViewer, hoverRegion);
        if (elements == null || elements.length == 0) {
            return null;
        }
        return JavadocHover.getHoverInfo(elements, this.getEditorInputJavaElement(), hoverRegion, null);
    }

    private static JavadocBrowserInformationControlInput getHoverInfo(IJavaElement[] elements, ITypeRoot editorInputElement, IRegion hoverRegion, JavadocBrowserInformationControlInput previousInput) {
        int nResults = elements.length;
        StringBuffer buffer = new StringBuffer();
        boolean hasContents = false;
        String base = null;
        IJavaElement element = null;
        int leadingImageWidth = 0;
        if (nResults > 1) {
            int i = 0;
            while (i < elements.length) {
                HTMLPrinter.startBulletList((StringBuffer)buffer);
                IJavaElement curr = elements[i];
                if (curr instanceof IMember || curr.getElementType() == 14) {
                    String link;
                    String label = JavaElementLabels.getElementLabel(curr, JavadocHover.getHeaderFlags(curr));
                    try {
                        String uri = JavaElementLinks.createURI("eclipse-javadoc", curr);
                        link = JavaElementLinks.createLink(uri, label);
                    }
                    catch (URISyntaxException e) {
                        JavaPlugin.log(e);
                        link = label;
                    }
                    HTMLPrinter.addBullet((StringBuffer)buffer, (String)link);
                    hasContents = true;
                }
                HTMLPrinter.endBulletList((StringBuffer)buffer);
                ++i;
            }
        } else {
            element = elements[0];
            if (element instanceof IMember) {
                StringReader reader;
                HTMLPrinter.addSmallHeader((StringBuffer)buffer, (String)JavadocHover.getInfoText(element, editorInputElement, hoverRegion, true));
                buffer.append("<br>");
                JavadocHover.addAnnotations(buffer, element, editorInputElement, hoverRegion);
                IMember member = (IMember)element;
                try {
                    String content = JavadocContentAccess2.getHTMLContent(member, true);
                    StringReader stringReader = reader = content == null ? null : new StringReader(content);
                    if (reader == null && member.isBinary()) {
                        boolean hasSource;
                        boolean hasAttachedJavadoc = JavaDocLocations.getJavadocBaseLocation((IJavaElement)member) != null;
                        IPackageFragmentRoot root = (IPackageFragmentRoot)member.getAncestor(3);
                        boolean hasAttachedSource = root != null && root.getSourceAttachmentPath() != null;
                        IOpenable openable = member.getOpenable();
                        boolean bl = hasSource = openable.getBuffer() != null;
                        if (!hasAttachedSource && !hasAttachedJavadoc) {
                            reader = new StringReader(JavaHoverMessages.JavadocHover_noAttachments);
                        } else if (!hasAttachedJavadoc && !hasSource) {
                            reader = new StringReader(JavaHoverMessages.JavadocHover_noAttachedJavadoc);
                        } else if (!hasAttachedSource) {
                            reader = new StringReader(JavaHoverMessages.JavadocHover_noAttachedSource);
                        } else if (!hasSource) {
                            reader = new StringReader(JavaHoverMessages.JavadocHover_noInformation);
                        }
                    } else {
                        base = JavaDocLocations.getBaseURL(member);
                    }
                }
                catch (JavaModelException ex) {
                    reader = new StringReader(JavaHoverMessages.JavadocHover_error_gettingJavadoc);
                    JavaPlugin.log(ex);
                }
                if (reader != null) {
                    HTMLPrinter.addParagraph((StringBuffer)buffer, (Reader)reader);
                }
                hasContents = true;
            } else if (element.getElementType() == 14 || element.getElementType() == 15) {
                JavadocHover.addAnnotations(buffer, element, editorInputElement, hoverRegion);
                HTMLPrinter.addSmallHeader((StringBuffer)buffer, (String)JavadocHover.getInfoText(element, editorInputElement, hoverRegion, true));
                hasContents = true;
            }
            leadingImageWidth = 20;
        }
        if (!hasContents) {
            return null;
        }
        if (buffer.length() > 0) {
            HTMLPrinter.insertPageProlog((StringBuffer)buffer, (int)0, (String)JavadocHover.getStyleSheet());
            if (base != null) {
                int endHeadIdx = buffer.indexOf("</head>");
                buffer.insert(endHeadIdx, "\n<base href='" + base + "'>\n");
            }
            HTMLPrinter.addPageEpilog((StringBuffer)buffer);
            return new JavadocBrowserInformationControlInput(previousInput, element, buffer.toString(), leadingImageWidth);
        }
        return null;
    }

    private static String getInfoText(IJavaElement element, ITypeRoot editorInputElement, IRegion hoverRegion, boolean allowImage) {
        URL imageUrl;
        String constantValue;
        long flags = JavadocHover.getHeaderFlags(element);
        StringBuffer label = new StringBuffer(JavaElementLinks.getElementLabel(element, flags));
        if (element.getElementType() == 8 && (constantValue = JavadocHover.getConstantValue((IField)element, editorInputElement, hoverRegion)) != null) {
            constantValue = HTMLPrinter.convertToHTMLContentWithWhitespace((String)constantValue);
            IJavaProject javaProject = element.getJavaProject();
            if ("insert".equals(javaProject.getOption("org.eclipse.jdt.core.formatter.insert_space_before_assignment_operator", true))) {
                label.append(' ');
            }
            label.append('=');
            if ("insert".equals(javaProject.getOption("org.eclipse.jdt.core.formatter.insert_space_after_assignment_operator", true))) {
                label.append(' ');
            }
            label.append(constantValue);
        }
        String imageName = null;
        if (allowImage && (imageUrl = JavaPlugin.getDefault().getImagesOnFSRegistry().getImageURL(element)) != null) {
            imageName = imageUrl.toExternalForm();
        }
        StringBuffer buf = new StringBuffer();
        JavadocHover.addImageAndLabel(buf, element, imageName, 16, 16, label.toString(), 20, 2);
        return buf.toString();
    }

    private static long getHeaderFlags(IJavaElement element) {
        switch (element.getElementType()) {
            case 14: {
                return LOCAL_VARIABLE_FLAGS;
            }
            case 15: {
                return TYPE_PARAMETER_FLAGS;
            }
        }
        return LABEL_FLAGS;
    }

    private static boolean isStaticFinal(IField field) {
        try {
            return JdtFlags.isFinal((IMember)field) && JdtFlags.isStatic((IMember)field);
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
            return false;
        }
    }

    private static String getConstantValue(IField field, ITypeRoot editorInputElement, IRegion hoverRegion) {
        IVariableBinding variableBinding;
        IBinding binding;
        if (!JavadocHover.isStaticFinal(field)) {
            return null;
        }
        ASTNode node = JavadocHover.getHoveredASTNode(editorInputElement, hoverRegion);
        if (node == null) {
            return null;
        }
        Object constantValue = null;
        if (node.getNodeType() == 42 && (binding = ((SimpleName)node).resolveBinding()) != null && binding.getKind() == 3 && field.equals((variableBinding = (IVariableBinding)binding).getJavaElement())) {
            constantValue = variableBinding.getConstantValue();
        }
        if (constantValue == null) {
            return null;
        }
        if (constantValue instanceof String) {
            return JavadocHover.getEscapedStringLiteral((String)constantValue);
        }
        if (constantValue instanceof Character) {
            String constantResult = JavadocHover.getEscapedCharacterLiteral(((Character)constantValue).charValue());
            char charValue = ((Character)constantValue).charValue();
            String hexString = Integer.toHexString(charValue);
            StringBuffer hexResult = new StringBuffer("\\u");
            int i = hexString.length();
            while (i < 4) {
                hexResult.append('0');
                ++i;
            }
            hexResult.append(hexString);
            return JavadocHover.formatWithHexValue(constantResult, hexResult.toString());
        }
        if (constantValue instanceof Byte) {
            int byteValue = ((Byte)constantValue).intValue() & 0xFF;
            return JavadocHover.formatWithHexValue(constantValue, "0x" + Integer.toHexString(byteValue));
        }
        if (constantValue instanceof Short) {
            int shortValue = (Short)constantValue & 0xFFFF;
            return JavadocHover.formatWithHexValue(constantValue, "0x" + Integer.toHexString(shortValue));
        }
        if (constantValue instanceof Integer) {
            int intValue = (Integer)constantValue;
            return JavadocHover.formatWithHexValue(constantValue, "0x" + Integer.toHexString(intValue));
        }
        if (constantValue instanceof Long) {
            long longValue = (Long)constantValue;
            return JavadocHover.formatWithHexValue(constantValue, "0x" + Long.toHexString(longValue));
        }
        return constantValue.toString();
    }

    private static ASTNode getHoveredASTNode(ITypeRoot editorInputElement, IRegion hoverRegion) {
        if (editorInputElement == null) {
            return null;
        }
        CompilationUnit unit = SharedASTProvider.getAST(editorInputElement, SharedASTProvider.WAIT_ACTIVE_ONLY, null);
        if (unit == null) {
            return null;
        }
        return NodeFinder.perform((ASTNode)unit, (int)hoverRegion.getOffset(), (int)hoverRegion.getLength());
    }

    private static String getEscapedStringLiteral(String stringValue) {
        StringLiteral stringLiteral = AST.newAST((int)3).newStringLiteral();
        stringLiteral.setLiteralValue(stringValue);
        String stringConstant = stringLiteral.getEscapedValue();
        if (stringConstant.length() > 80) {
            return String.valueOf(stringConstant.substring(0, 80)) + "...";
        }
        return stringConstant;
    }

    private static String getEscapedCharacterLiteral(char ch) {
        CharacterLiteral characterLiteral = AST.newAST((int)3).newCharacterLiteral();
        characterLiteral.setCharValue(ch);
        return characterLiteral.getEscapedValue();
    }

    private static String formatWithHexValue(Object constantValue, String hexValue) {
        return Messages.format(JavaHoverMessages.JavadocHover_constantValue_hexValue, new String[]{constantValue.toString(), hexValue});
    }

    private static String getStyleSheet() {
        String css;
        if (fgStyleSheet == null) {
            fgStyleSheet = JavadocHover.loadStyleSheet();
        }
        if ((css = fgStyleSheet) != null) {
            FontData fontData = JFaceResources.getFontRegistry().getFontData("org.eclipse.jdt.ui.javadocfont")[0];
            css = HTMLPrinter.convertTopLevelFont((String)css, (FontData)fontData);
        }
        return css;
    }

    /*
     * Loose catch block
     */
    private static String loadStyleSheet() {
        Bundle bundle = Platform.getBundle((String)JavaPlugin.getPluginId());
        URL styleSheetURL = bundle.getEntry("/JavadocHoverStyleSheet.css");
        if (styleSheetURL != null) {
            BufferedReader reader = null;
            reader = new BufferedReader(new InputStreamReader(styleSheetURL.openStream()));
            StringBuffer buffer = new StringBuffer(1500);
            String line = reader.readLine();
            while (line != null) {
                buffer.append(line);
                buffer.append('\n');
                line = reader.readLine();
            }
            String string = buffer.toString();
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
            return string;
            catch (IOException ex) {
                try {
                    JavaPlugin.log(ex);
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException iOException) {}
                return "";
            }
        }
        return null;
    }

    public static void addImageAndLabel(StringBuffer buf, IJavaElement element, String imageSrcPath, int imageWidth, int imageHeight, String label, int labelLeft, int labelTop) {
        buf.append("<div style='word-wrap: break-word; position: relative; ");
        if (imageSrcPath != null) {
            buf.append("margin-left: ").append(labelLeft).append("px; ");
            buf.append("padding-top: ").append(labelTop).append("px; ");
        }
        buf.append("'>");
        if (imageSrcPath != null) {
            if (element != null) {
                try {
                    String uri = JavaElementLinks.createURI("eclipse-open", element);
                    buf.append("<a href='").append(uri).append("'>");
                }
                catch (URISyntaxException uRISyntaxException) {
                    element = null;
                }
            }
            StringBuffer imageStyle = new StringBuffer("border:none; position: absolute; ");
            imageStyle.append("width: ").append(imageWidth).append("px; ");
            imageStyle.append("height: ").append(imageHeight).append("px; ");
            imageStyle.append("left: ").append(-labelLeft - 1).append("px; ");
            buf.append("<!--[if lte IE 6]><![if gte IE 5.5]>\n");
            String tooltip = element == null ? "" : "alt='" + JavaHoverMessages.JavadocHover_openDeclaration + "' ";
            buf.append("<span ").append(tooltip).append("style=\"").append(imageStyle).append("filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='").append(imageSrcPath).append("')\"></span>\n");
            buf.append("<![endif]><![endif]-->\n");
            buf.append("<!--[if !IE]>-->\n");
            buf.append("<img ").append(tooltip).append("style='").append(imageStyle).append("' src='").append(imageSrcPath).append("'/>\n");
            buf.append("<!--<![endif]-->\n");
            buf.append("<!--[if gte IE 7]>\n");
            buf.append("<img ").append(tooltip).append("style='").append(imageStyle).append("' src='").append(imageSrcPath).append("'/>\n");
            buf.append("<![endif]-->\n");
            if (element != null) {
                buf.append("</a>");
            }
        }
        buf.append(label);
        buf.append("</div>");
    }

    public static void addAnnotations(StringBuffer buf, IJavaElement element, ITypeRoot editorInputElement, IRegion hoverRegion) {
        if (element instanceof IAnnotatable) {
            try {
                String annotationString = JavadocHover.getAnnotations(element, editorInputElement, hoverRegion);
                if (annotationString != null) {
                    buf.append("<div style='margin-bottom: 5px;'>");
                    buf.append(annotationString);
                    buf.append("</div>");
                }
            }
            catch (JavaModelException javaModelException) {
                buf.append("<br>");
            }
            catch (URISyntaxException uRISyntaxException) {
                buf.append("<br>");
            }
        }
    }

    private static String getAnnotations(IJavaElement element, ITypeRoot editorInputElement, IRegion hoverRegion) throws URISyntaxException, JavaModelException {
        IBinding binding;
        if (!(element instanceof IAnnotatable)) {
            return null;
        }
        if (((IAnnotatable)element).getAnnotations().length == 0) {
            return null;
        }
        ASTNode node = JavadocHover.getHoveredASTNode(editorInputElement, hoverRegion);
        if (node == null) {
            ASTParser p = ASTParser.newParser((int)3);
            p.setProject(element.getJavaProject());
            try {
                binding = p.createBindings(new IJavaElement[]{element}, null)[0];
            }
            catch (OperationCanceledException operationCanceledException) {
                return null;
            }
        } else {
            binding = JavadocHover.resolveBinding(node);
        }
        if (binding == null) {
            return null;
        }
        IAnnotationBinding[] annotations = binding.getAnnotations();
        if (annotations.length == 0) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < annotations.length) {
            JavadocHover.addAnnotation(buf, element, annotations[i]);
            buf.append("<br>");
            ++i;
        }
        return buf.toString();
    }

    private static IBinding resolveBinding(ASTNode node) {
        if (node instanceof SimpleName) {
            SimpleName simpleName = (SimpleName)node;
            StructuralPropertyDescriptor loc = simpleName.getLocationInParent();
            while (loc == QualifiedType.NAME_PROPERTY || loc == QualifiedName.NAME_PROPERTY || loc == SimpleType.NAME_PROPERTY || loc == ParameterizedType.TYPE_PROPERTY) {
                node = node.getParent();
                loc = node.getLocationInParent();
            }
            if (loc == ClassInstanceCreation.TYPE_PROPERTY) {
                ClassInstanceCreation cic = (ClassInstanceCreation)node.getParent();
                IMethodBinding constructorBinding = cic.resolveConstructorBinding();
                if (constructorBinding == null) {
                    return null;
                }
                ITypeBinding declaringClass = constructorBinding.getDeclaringClass();
                if (!declaringClass.isAnonymous()) {
                    return constructorBinding;
                }
                ITypeBinding superTypeDeclaration = declaringClass.getSuperclass().getTypeDeclaration();
                return JavadocHover.resolveSuperclassConstructor(superTypeDeclaration, constructorBinding);
            }
            return simpleName.resolveBinding();
        }
        if (node instanceof SuperConstructorInvocation) {
            return ((SuperConstructorInvocation)node).resolveConstructorBinding();
        }
        if (node instanceof ConstructorInvocation) {
            return ((ConstructorInvocation)node).resolveConstructorBinding();
        }
        return null;
    }

    private static IBinding resolveSuperclassConstructor(ITypeBinding superClassDeclaration, IMethodBinding constructor) {
        IMethodBinding[] methods = superClassDeclaration.getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            IMethodBinding method = methods[i];
            if (method.isConstructor() && constructor.isSubsignature(method)) {
                return method;
            }
            ++i;
        }
        return null;
    }

    private static void addAnnotation(StringBuffer buf, IJavaElement element, IAnnotationBinding annotation) throws URISyntaxException {
        String uri = JavaElementLinks.createURI("eclipse-javadoc", annotation.getAnnotationType().getJavaElement());
        buf.append('@');
        JavadocHover.addLink(buf, uri, annotation.getName());
        IMemberValuePairBinding[] mvPairs = annotation.getDeclaredMemberValuePairs();
        if (mvPairs.length > 0) {
            buf.append('(');
            int j = 0;
            while (j < mvPairs.length) {
                if (j > 0) {
                    buf.append(JavaElementLabels.COMMA_STRING);
                }
                IMemberValuePairBinding mvPair = mvPairs[j];
                String memberURI = JavaElementLinks.createURI("eclipse-javadoc", mvPair.getMethodBinding().getJavaElement());
                JavadocHover.addLink(buf, memberURI, mvPair.getName());
                buf.append('=');
                JavadocHover.addValue(buf, element, mvPair.getValue());
                ++j;
            }
            buf.append(')');
        }
    }

    private static void addValue(StringBuffer buf, IJavaElement element, Object value) throws URISyntaxException {
        if (value instanceof ITypeBinding) {
            ITypeBinding typeBinding = (ITypeBinding)value;
            IJavaElement type = typeBinding.getJavaElement();
            if (type == null) {
                buf.append(typeBinding.getName());
            } else {
                String uri = JavaElementLinks.createURI("eclipse-javadoc", type);
                String name = type.getElementName();
                JavadocHover.addLink(buf, uri, name);
            }
            buf.append(".class");
        } else if (value instanceof IVariableBinding) {
            IVariableBinding variableBinding = (IVariableBinding)value;
            IJavaElement variable = variableBinding.getJavaElement();
            String uri = JavaElementLinks.createURI("eclipse-javadoc", variable);
            String name = variable.getElementName();
            JavadocHover.addLink(buf, uri, name);
        } else if (value instanceof IAnnotationBinding) {
            IAnnotationBinding annotationBinding = (IAnnotationBinding)value;
            JavadocHover.addAnnotation(buf, element, annotationBinding);
        } else if (value instanceof String) {
            buf.append(JavadocHover.getEscapedStringLiteral((String)value));
        } else if (value instanceof Character) {
            buf.append(JavadocHover.getEscapedCharacterLiteral(((Character)value).charValue()));
        } else if (value instanceof Object[]) {
            Object[] values = (Object[])value;
            buf.append('{');
            int i = 0;
            while (i < values.length) {
                if (i > 0) {
                    buf.append(JavaElementLabels.COMMA_STRING);
                }
                JavadocHover.addValue(buf, element, values[i]);
                ++i;
            }
            buf.append('}');
        } else {
            buf.append(String.valueOf(value));
        }
    }

    private static StringBuffer addLink(StringBuffer buf, String uri, String label) {
        return buf.append(JavaElementLinks.createLink(uri, label));
    }

    private static final class BackAction
    extends Action {
        private final BrowserInformationControl fInfoControl;

        public BackAction(BrowserInformationControl infoControl) {
            this.fInfoControl = infoControl;
            this.setText(JavaHoverMessages.JavadocHover_back);
            ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
            this.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_BACK"));
            this.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_BACK_DISABLED"));
            this.update();
        }

        public void run() {
            BrowserInformationControlInput previous = (BrowserInformationControlInput)this.fInfoControl.getInput().getPrevious();
            if (previous != null) {
                this.fInfoControl.setInput((Object)previous);
            }
        }

        public void update() {
            BrowserInformationControlInput current = this.fInfoControl.getInput();
            if (current != null && current.getPrevious() != null) {
                BrowserInput previous = current.getPrevious();
                this.setToolTipText(Messages.format(JavaHoverMessages.JavadocHover_back_toElement_toolTip, BasicElementLabels.getJavaElementName(previous.getInputName())));
                this.setEnabled(true);
            } else {
                this.setToolTipText(JavaHoverMessages.JavadocHover_back);
                this.setEnabled(false);
            }
        }
    }

    private static final class ForwardAction
    extends Action {
        private final BrowserInformationControl fInfoControl;

        public ForwardAction(BrowserInformationControl infoControl) {
            this.fInfoControl = infoControl;
            this.setText(JavaHoverMessages.JavadocHover_forward);
            ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
            this.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_FORWARD"));
            this.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_FORWARD_DISABLED"));
            this.update();
        }

        public void run() {
            BrowserInformationControlInput next = (BrowserInformationControlInput)this.fInfoControl.getInput().getNext();
            if (next != null) {
                this.fInfoControl.setInput((Object)next);
            }
        }

        public void update() {
            BrowserInformationControlInput current = this.fInfoControl.getInput();
            if (current != null && current.getNext() != null) {
                this.setToolTipText(Messages.format(JavaHoverMessages.JavadocHover_forward_toElement_toolTip, BasicElementLabels.getJavaElementName(current.getNext().getInputName())));
                this.setEnabled(true);
            } else {
                this.setToolTipText(JavaHoverMessages.JavadocHover_forward_toolTip);
                this.setEnabled(false);
            }
        }
    }

    public static final class HoverControlCreator
    extends AbstractReusableInformationControlCreator {
        private final IInformationControlCreator fInformationPresenterControlCreator;
        private final boolean fAdditionalInfoAffordance;

        public HoverControlCreator(IInformationControlCreator informationPresenterControlCreator) {
            this(informationPresenterControlCreator, false);
        }

        public HoverControlCreator(IInformationControlCreator informationPresenterControlCreator, boolean additionalInfoAffordance) {
            this.fInformationPresenterControlCreator = informationPresenterControlCreator;
            this.fAdditionalInfoAffordance = additionalInfoAffordance;
        }

        public IInformationControl doCreateInformationControl(Shell parent) {
            String tooltipAffordanceString;
            String string = tooltipAffordanceString = this.fAdditionalInfoAffordance ? JavaPlugin.getAdditionalInfoAffordanceString() : EditorsUI.getTooltipAffordanceString();
            if (BrowserInformationControl.isAvailable((Composite)parent)) {
                String font = "org.eclipse.jdt.ui.javadocfont";
                BrowserInformationControl iControl = new BrowserInformationControl(this, parent, font, tooltipAffordanceString){
                    final /* synthetic */ HoverControlCreator this$1;
                    {
                        this.this$1 = hoverControlCreator;
                    }

                    public IInformationControlCreator getInformationPresenterControlCreator() {
                        return HoverControlCreator.access$0(this.this$1);
                    }
                };
                JavadocHover.addLinkListener(iControl);
                return iControl;
            }
            return new DefaultInformationControl(parent, tooltipAffordanceString);
        }

        public boolean canReuse(IInformationControl control) {
            if (!super.canReuse(control)) {
                return false;
            }
            if (control instanceof IInformationControlExtension4) {
                String tooltipAffordanceString = this.fAdditionalInfoAffordance ? JavaPlugin.getAdditionalInfoAffordanceString() : EditorsUI.getTooltipAffordanceString();
                ((IInformationControlExtension4)control).setStatusText(tooltipAffordanceString);
            }
            return true;
        }

        static /* synthetic */ IInformationControlCreator access$0(HoverControlCreator hoverControlCreator) {
            return hoverControlCreator.fInformationPresenterControlCreator;
        }
    }

    private static final class OpenDeclarationAction
    extends Action {
        private final BrowserInformationControl fInfoControl;

        public OpenDeclarationAction(BrowserInformationControl infoControl) {
            this.fInfoControl = infoControl;
            this.setText(JavaHoverMessages.JavadocHover_openDeclaration);
            JavaPluginImages.setLocalImageDescriptors((IAction)this, "goto_input.gif");
        }

        public void run() {
            JavadocBrowserInformationControlInput infoInput = (JavadocBrowserInformationControlInput)this.fInfoControl.getInput();
            this.fInfoControl.notifyDelayedInputChange(null);
            this.fInfoControl.dispose();
            try {
                JavaUI.openInEditor(infoInput.getElement());
            }
            catch (PartInitException e) {
                JavaPlugin.log(e);
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
        }
    }

    public static final class PresenterControlCreator
    extends AbstractReusableInformationControlCreator {
        private IWorkbenchSite fSite;

        public PresenterControlCreator(IWorkbenchSite site) {
            this.fSite = site;
        }

        public IInformationControl doCreateInformationControl(Shell parent) {
            if (BrowserInformationControl.isAvailable((Composite)parent)) {
                ToolBarManager tbm = new ToolBarManager(0x800000);
                String font = "org.eclipse.jdt.ui.javadocfont";
                BrowserInformationControl iControl = new BrowserInformationControl(parent, font, tbm);
                BackAction backAction = new BackAction(iControl);
                backAction.setEnabled(false);
                tbm.add((IAction)backAction);
                ForwardAction forwardAction = new ForwardAction(iControl);
                tbm.add((IAction)forwardAction);
                forwardAction.setEnabled(false);
                ShowInJavadocViewAction showInJavadocViewAction = new ShowInJavadocViewAction(iControl);
                tbm.add((IAction)showInJavadocViewAction);
                OpenDeclarationAction openDeclarationAction = new OpenDeclarationAction(iControl);
                tbm.add((IAction)openDeclarationAction);
                SimpleSelectionProvider selectionProvider = new SimpleSelectionProvider();
                if (this.fSite != null) {
                    OpenAttachedJavadocAction openAttachedJavadocAction = new OpenAttachedJavadocAction(this.fSite);
                    openAttachedJavadocAction.setSpecialSelectionProvider(selectionProvider);
                    openAttachedJavadocAction.setImageDescriptor(JavaPluginImages.DESC_ELCL_OPEN_BROWSER);
                    openAttachedJavadocAction.setDisabledImageDescriptor(JavaPluginImages.DESC_DLCL_OPEN_BROWSER);
                    selectionProvider.addSelectionChangedListener(openAttachedJavadocAction);
                    selectionProvider.setSelection((ISelection)new StructuredSelection());
                    tbm.add((IAction)openAttachedJavadocAction);
                }
                IInputChangedListener inputChangeListener = new IInputChangedListener(this, backAction, forwardAction, selectionProvider, showInJavadocViewAction, openDeclarationAction){
                    final /* synthetic */ PresenterControlCreator this$1;
                    private final /* synthetic */ BackAction val$backAction;
                    private final /* synthetic */ ForwardAction val$forwardAction;
                    private final /* synthetic */ SimpleSelectionProvider val$selectionProvider;
                    private final /* synthetic */ ShowInJavadocViewAction val$showInJavadocViewAction;
                    private final /* synthetic */ OpenDeclarationAction val$openDeclarationAction;
                    {
                        this.this$1 = presenterControlCreator;
                        this.val$backAction = backAction;
                        this.val$forwardAction = forwardAction;
                        this.val$selectionProvider = simpleSelectionProvider;
                        this.val$showInJavadocViewAction = showInJavadocViewAction;
                        this.val$openDeclarationAction = openDeclarationAction;
                    }

                    public void inputChanged(Object newInput) {
                        this.val$backAction.update();
                        this.val$forwardAction.update();
                        if (newInput == null) {
                            this.val$selectionProvider.setSelection((ISelection)new StructuredSelection());
                        } else if (newInput instanceof BrowserInformationControlInput) {
                            BrowserInformationControlInput input = (BrowserInformationControlInput)newInput;
                            Object inputElement = input.getInputElement();
                            this.val$selectionProvider.setSelection((ISelection)new StructuredSelection(inputElement));
                            boolean isJavaElementInput = inputElement instanceof IJavaElement;
                            this.val$showInJavadocViewAction.setEnabled(isJavaElementInput);
                            this.val$openDeclarationAction.setEnabled(isJavaElementInput);
                        }
                    }
                };
                iControl.addInputChangeListener(inputChangeListener);
                tbm.update(true);
                JavadocHover.addLinkListener(iControl);
                return iControl;
            }
            return new DefaultInformationControl(parent, true);
        }
    }

    private static final class ShowInJavadocViewAction
    extends Action {
        private final BrowserInformationControl fInfoControl;

        public ShowInJavadocViewAction(BrowserInformationControl infoControl) {
            this.fInfoControl = infoControl;
            this.setText(JavaHoverMessages.JavadocHover_showInJavadoc);
            this.setImageDescriptor(JavaPluginImages.DESC_OBJS_JAVADOCTAG);
        }

        public void run() {
            JavadocBrowserInformationControlInput infoInput = (JavadocBrowserInformationControlInput)this.fInfoControl.getInput();
            this.fInfoControl.notifyDelayedInputChange(null);
            this.fInfoControl.dispose();
            try {
                JavadocView view = (JavadocView)JavaPlugin.getActivePage().showView("org.eclipse.jdt.ui.JavadocView");
                view.setInput((BrowserInput)infoInput);
            }
            catch (PartInitException e) {
                JavaPlugin.log(e);
            }
        }
    }
}

