/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.baseadaptor;

import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayMap<K, V> {
    private final List<K> keys;
    private final List<V> values;

    public ArrayMap(int initialCapacity) {
        this.keys = new ArrayList<K>(initialCapacity);
        this.values = new ArrayList<V>(0);
    }

    public V get(K key) {
        int index = this.keys.indexOf(key);
        if (index < 0) {
            return null;
        }
        return this.values.get(index);
    }

    public void put(K key, V value) {
        int index = this.keys.indexOf(key);
        if (index > 0) {
            this.values.add(index, value);
        } else {
            this.keys.add(key);
            this.values.add(value);
        }
    }

    public V remove(K key) {
        int index = this.keys.indexOf(key);
        if (index < 0) {
            return null;
        }
        this.keys.remove(index);
        return this.values.remove(index);
    }

    public void clear() {
        this.keys.clear();
        this.values.clear();
    }

    public List<K> getKeys() {
        return new ArrayList<K>(this.keys);
    }

    public List<V> getValues() {
        return new ArrayList<V>(this.values);
    }
}

