/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.framework.wiring.Capability;
import org.osgi.framework.wiring.WiredCapability;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class BaseDescriptionImpl
implements BaseDescription {
    protected final Object monitor = new Object();
    private volatile String name;
    private volatile Version version;

    BaseDescriptionImpl() {
    }

    @Override
    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Version getVersion() {
        Object object = this.monitor;
        synchronized (object) {
            if (this.version == null) {
                return Version.emptyVersion;
            }
            return this.version;
        }
    }

    protected void setName(String name) {
        this.name = name;
    }

    protected void setVersion(Version version) {
        this.version = version;
    }

    static String toString(Map<String, Object> map, boolean directives) {
        if (map.size() == 0) {
            return "";
        }
        String assignment = directives ? ":=" : "=";
        Set<Map.Entry<String, Object>> set = map.entrySet();
        StringBuffer sb = new StringBuffer();
        for (Map.Entry<String, Object> entry : set) {
            sb.append("; ");
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof List) {
                List list = (List)value;
                if (list.size() == 0) continue;
                Object component = list.get(0);
                String className = component.getClass().getName();
                String type = className.substring(className.lastIndexOf(46) + 1);
                sb.append(key).append(':').append("List<").append(type).append(">").append(assignment).append('\"');
                for (Object object : list) {
                    sb.append(object).append(',');
                }
                sb.setLength(sb.length() - 1);
                sb.append('\"');
                continue;
            }
            String type = "";
            if (!(value instanceof String)) {
                String className = value.getClass().getName();
                type = new StringBuffer(":").append(className.substring(className.lastIndexOf(46) + 1)).toString();
            }
            sb.append(key).append(type).append(assignment).append('\"').append(value).append('\"');
        }
        return sb.toString();
    }

    String getInternalNameSpace() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    WiredCapability getWiredCapability() {
        Object object = this.monitor;
        synchronized (object) {
            BundleWiring wiring;
            block4: {
                BundleDescription supplier = this.getSupplier();
                wiring = supplier.getBundleWiring();
                if (wiring != null) break block4;
                return null;
            }
            return new BaseWiredCapability(wiring);
        }
    }

    @Override
    public Capability getCapability() {
        return new BaseCapability();
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class BaseCapability
    implements Capability {
        BaseCapability() {
        }

        @Override
        public BundleRevision getProviderRevision() {
            return BaseDescriptionImpl.this.getSupplier();
        }

        @Override
        public String getNamespace() {
            return BaseDescriptionImpl.this.getInternalNameSpace();
        }

        @Override
        public Map<String, String> getDirectives() {
            return BaseDescriptionImpl.this.getDeclaredDirectives();
        }

        @Override
        public Map<String, Object> getAttributes() {
            return BaseDescriptionImpl.this.getDeclaredAttributes();
        }

        public int hashCode() {
            return System.identityHashCode(BaseDescriptionImpl.this);
        }

        private BaseDescriptionImpl getBaseDescription() {
            return BaseDescriptionImpl.this;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Capability)) {
                return false;
            }
            if (obj instanceof BaseCapability) {
                return ((BaseCapability)obj).getBaseDescription() == BaseDescriptionImpl.this;
            }
            Capability other = (Capability)obj;
            String otherName = other.getNamespace();
            if (!this.getProviderRevision().equals(other.getProviderRevision())) {
                return false;
            }
            if (otherName == null ? this.getNamespace() != null : !otherName.equals(this.getNamespace())) {
                return false;
            }
            if (!this.getAttributes().equals(other.getAttributes())) {
                return false;
            }
            return this.getDirectives().equals(other.getDirectives());
        }

        public String toString() {
            return new StringBuffer(String.valueOf(this.getNamespace())).append(BaseDescriptionImpl.toString(this.getAttributes(), false)).toString();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class BaseWiredCapability
    extends BaseCapability
    implements WiredCapability {
        private final BundleWiring originalWiring;

        public BaseWiredCapability(BundleWiring originalWiring) {
            this.originalWiring = originalWiring;
        }

        @Override
        public Collection<BundleWiring> getRequirerWirings() {
            BundleWiring wiring = this.getProviderWiring();
            if (wiring == null) {
                return null;
            }
            BundleDescription supplier = BaseDescriptionImpl.this.getSupplier();
            BundleDescription[] dependents = supplier.getDependents();
            ArrayList<BundleWiring> requirers = new ArrayList<BundleWiring>();
            BundleDescription[] bundleDescriptionArray = dependents;
            int n = dependents.length;
            int n2 = 0;
            while (n2 < n) {
                List<WiredCapability> namespace;
                BundleDescription dependent = bundleDescriptionArray[n2];
                BundleWiring dependentWiring = dependent.getBundleWiring();
                if (dependentWiring != null && (namespace = dependentWiring.getRequiredCapabilities(this.getNamespace())) != null && namespace.contains(this)) {
                    requirers.add(dependentWiring);
                }
                ++n2;
            }
            return requirers;
        }

        @Override
        public BundleWiring getProviderWiring() {
            return this.originalWiring.isInUse() ? this.originalWiring : null;
        }

        BaseDescriptionImpl getImpl() {
            return BaseDescriptionImpl.this;
        }

        @Override
        public int hashCode() {
            return System.identityHashCode(BaseDescriptionImpl.this) ^ System.identityHashCode(this.originalWiring);
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof BaseWiredCapability)) {
                return false;
            }
            BaseWiredCapability other = (BaseWiredCapability)obj;
            return other.originalWiring == this.originalWiring && this.getImpl() == other.getImpl();
        }
    }
}

