/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal.preferences;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.eclipse.pde.api.tools.ui.internal.ApiUIPlugin;
import org.eclipse.pde.api.tools.ui.internal.SWTFactory;
import org.eclipse.pde.api.tools.ui.internal.preferences.PreferenceMessages;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.ui.preferences.IWorkingCopyManager;
import org.eclipse.ui.preferences.WorkingCopyManager;
import org.osgi.service.prefs.BackingStoreException;

public class ApiUseScanPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "org.eclipse.pde.api.tools.ui.apiusescan.prefpage";
    public static final String NAME_REGEX = "^.* (.*)$";
    private IWorkingCopyManager fManager;
    CheckboxTableViewer fTableViewer;
    HashSet fLocationList = new HashSet();
    private Spinner fSpinner;
    Button remove = null;
    Button editbutton = null;
    FileFilter filter = new FileFilter(){

        public boolean accept(File pathname) {
            if (pathname.getName().matches(ApiUseScanPreferencePage.NAME_REGEX)) {
                throw new RuntimeException(pathname.getName());
            }
            return false;
        }
    };

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite comp = SWTFactory.createComposite(parent, 2, 1, 768, 0, 0);
        SWTFactory.createWrapLabel(comp, PreferenceMessages.ApiUseScanPreferencePage_0, 2, 200);
        SWTFactory.createVerticalSpacer(comp, 1);
        SWTFactory.createWrapLabel(comp, PreferenceMessages.ApiUseScanPreferencePage_2, 2);
        Table table = new Table(comp, 68130);
        table.setLayoutData((Object)new GridData(1808));
        GridData gd = (GridData)table.getLayoutData();
        gd.widthHint = 350;
        table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.stateMask == 0 && e.keyCode == 127) {
                    ApiUseScanPreferencePage.this.removeLocation();
                }
            }
        });
        this.fTableViewer = new CheckboxTableViewer(table);
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new TableColumnLabelProvider());
        this.fTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        Composite bcomp = SWTFactory.createComposite(comp, 1, 1, 1042, 0, 0);
        Button button = SWTFactory.createPushButton(bcomp, PreferenceMessages.ApiUseScanPreferencePage_3, null);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ApiUseScanPreferencePage.this.select(true);
            }
        });
        button = SWTFactory.createPushButton(bcomp, PreferenceMessages.ApiUseScanPreferencePage_10, null);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ApiUseScanPreferencePage.this.select(false);
            }
        });
        SWTFactory.createHorizontalSpacer(bcomp, 1);
        button = SWTFactory.createPushButton(bcomp, PreferenceMessages.ApiUseScanPreferencePage_4, null);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String loc = ApiUseScanPreferencePage.this.getDirectory(null);
                if (loc != null) {
                    ApiUseScanPreferencePage.this.addLocation(loc);
                }
            }
        });
        button = SWTFactory.createPushButton(bcomp, PreferenceMessages.ApiUseScanPreferencePage_5, null);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String loc = ApiUseScanPreferencePage.this.getArchive(null);
                if (loc != null) {
                    ApiUseScanPreferencePage.this.addLocation(loc);
                }
            }
        });
        this.editbutton = SWTFactory.createPushButton(bcomp, PreferenceMessages.ApiUseScanPreferencePage_1, null);
        this.editbutton.setEnabled(false);
        this.editbutton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ApiUseScanPreferencePage.this.edit();
            }
        });
        this.remove = SWTFactory.createPushButton(bcomp, PreferenceMessages.ApiUseScanPreferencePage_6, null);
        this.remove.setEnabled(false);
        this.remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ApiUseScanPreferencePage.this.removeLocation();
            }
        });
        Group optiongrp = SWTFactory.createGroup(comp, PreferenceMessages.options, 2, 2, 768);
        Label lbl = SWTFactory.createLabel((Composite)optiongrp, PreferenceMessages.ApiUseScanPreferencePage_9, 1);
        gd = (GridData)lbl.getLayoutData();
        gd.grabExcessHorizontalSpace = true;
        this.fSpinner = new Spinner((Composite)optiongrp, 2048);
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)ApiUseScanPreferencePage.this.fTableViewer.getSelection();
                ApiUseScanPreferencePage.this.remove.setEnabled(!selection.isEmpty());
                ApiUseScanPreferencePage.this.editbutton.setEnabled(selection.size() == 1);
            }
        });
        this.fTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ApiUseScanPreferencePage.this.edit();
            }
        });
        this.performInit(0, null);
        this.validateScans();
        Dialog.applyDialogFont((Control)comp);
        return comp;
    }

    void select(boolean checked) {
        this.fTableViewer.setAllChecked(checked);
        this.fTableViewer.refresh();
    }

    String getDirectory(String prevLocation) {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        dialog.setMessage(PreferenceMessages.ApiUseScanPreferencePage_7);
        if (prevLocation != null) {
            dialog.setFilterPath(prevLocation);
        }
        return dialog.open();
    }

    String getArchive(File file) {
        FileDialog dialog = new FileDialog(this.getShell(), 4096);
        dialog.setFilterNames(new String[]{PreferenceMessages.archives__zip, PreferenceMessages.jars__jar});
        dialog.setFilterExtensions(new String[]{"*.zip", "*.jar"});
        if (file != null) {
            dialog.setFilterPath(file.getParent());
            dialog.setFileName(file.getName());
        }
        return dialog.open();
    }

    void addLocation(String location) {
        this.fLocationList.add(location);
        this.fTableViewer.refresh();
        this.fTableViewer.setChecked((Object)location, true);
        this.validateScans();
    }

    void edit() {
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        String location = selection.getFirstElement().toString();
        File file = new File(location);
        String newloc = null;
        newloc = file.isDirectory() ? this.getDirectory(location) : this.getArchive(file);
        if (newloc != null) {
            this.fLocationList.remove(location);
            this.addLocation(newloc);
        }
    }

    void removeLocation() {
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        this.fLocationList.removeAll(selection.toList());
        this.fTableViewer.refresh();
        this.validateScans();
    }

    private void validateScans() {
        if (this.fLocationList.size() > 0) {
            String loc = null;
            Iterator iterator = this.fLocationList.iterator();
            while (iterator.hasNext()) {
                loc = (String)iterator.next();
                if (this.isValidScanLocation(loc)) continue;
                this.setErrorMessage(NLS.bind((String)PreferenceMessages.ApiUseScanPreferencePage_8, (Object)loc));
                this.setValid(false);
                return;
            }
        }
        this.setValid(true);
        this.setErrorMessage(null);
    }

    public boolean isValidScanLocation(String location) {
        if (location != null && location.length() > 0) {
            Path path = new Path(location);
            File file = path.toFile();
            return this.validDirectory(file) || this.validArchive(file);
        }
        return false;
    }

    boolean validDirectory(File file) {
        if (file.exists() && file.isDirectory()) {
            try {
                file.listFiles(this.filter);
            }
            catch (RuntimeException rte) {
                File f = new File(file, rte.getMessage());
                try {
                    if (f.exists() && f.isDirectory()) {
                        f.listFiles(this.filter);
                    }
                }
                catch (RuntimeException runtimeException) {
                    return true;
                }
            }
        }
        return false;
    }

    boolean validArchive(File file) {
        String fname = file.getName().toLowerCase();
        if (file.exists() && Util.isArchive((String)fname)) {
            Enumeration<ZipEntry> entries = null;
            if (fname.endsWith("jar")) {
                try {
                    JarFile jfile = new JarFile(file);
                    entries = jfile.entries();
                }
                catch (IOException iOException) {
                    return false;
                }
            }
            if (fname.endsWith("zip")) {
                try {
                    ZipFile zfile = new ZipFile(file);
                    entries = zfile.entries();
                }
                catch (IOException iOException) {
                    return false;
                }
            }
            if (entries != null) {
                while (entries.hasMoreElements()) {
                    Path path;
                    int count;
                    ZipEntry o = entries.nextElement();
                    if (!o.isDirectory() || !o.getName().toLowerCase().startsWith("xml") || (count = (path = new Path(o.getName())).segmentCount()) <= 2) continue;
                    return path.segment(count - 1).matches(NAME_REGEX) && path.segment(count - 2).matches(NAME_REGEX);
                }
            }
        }
        return false;
    }

    public boolean performOk() {
        this.applyChanges();
        return true;
    }

    protected void performApply() {
        this.applyChanges();
    }

    protected void performDefaults() {
        this.performInit(1000, "");
        this.applyChanges();
    }

    private void performInit(int cacheSizeValue, String locationValue) {
        int cacheSize = 0;
        try {
            cacheSize = cacheSizeValue != 0 ? cacheSizeValue : Integer.parseInt(this.getStoredValue("API_USE_SCAN_REFERENCE_CACHE_SIZE", String.valueOf(1000)));
        }
        catch (NumberFormatException numberFormatException) {}
        this.fSpinner.setValues(cacheSize, 0, Integer.MAX_VALUE, 0, 100, 1000);
        this.fManager = this.getContainer() == null ? new WorkingCopyManager() : ((IWorkbenchPreferenceContainer)this.getContainer()).getWorkingCopyManager();
        this.fLocationList.clear();
        String location = locationValue != null ? locationValue : this.getStoredValue("API_USE_SCAN_LOCATION", null);
        ArrayList<String> checkedLocations = new ArrayList<String>();
        if (location != null && location.length() > 0) {
            String[] locations = location.split("\\|");
            int i = 0;
            while (i < locations.length) {
                String[] values = locations[i].split("\\*");
                this.fLocationList.add(values[0]);
                if (Boolean.valueOf(values[1]).booleanValue()) {
                    checkedLocations.add(values[0]);
                }
                ++i;
            }
            this.fLocationList.remove("");
        }
        this.fTableViewer.setInput((Object)this.fLocationList);
        this.fTableViewer.setCheckedElements((Object[])checkedLocations.toArray(new String[checkedLocations.size()]));
        this.fTableViewer.refresh();
        this.setErrorMessage(null);
    }

    private void applyChanges() {
        IProject[] projects;
        StringBuffer locations = new StringBuffer();
        Iterator iterator = this.fLocationList.iterator();
        while (iterator.hasNext()) {
            Object location = iterator.next();
            locations.append(location);
            locations.append("*");
            locations.append(this.fTableViewer.getChecked(location));
            locations.append("|");
        }
        if (this.hasLocationsChanges(locations.toString()) && (projects = Util.getApiProjects()) != null && MessageDialog.openQuestion((Shell)this.getShell(), (String)PreferenceMessages.ApiUseScanPreferencePage_11, (String)PreferenceMessages.ApiUseScanPreferencePage_12)) {
            Util.getBuildJob((IProject[])projects).schedule();
        }
        this.setStoredValue("API_USE_SCAN_LOCATION", locations.toString());
        this.setStoredValue("API_USE_SCAN_REFERENCE_CACHE_SIZE", String.valueOf(this.fSpinner.getSelection()));
        try {
            this.fManager.applyChanges();
        }
        catch (BackingStoreException e) {
            ApiUIPlugin.log(e);
        }
    }

    private boolean hasLocationsChanges(String newLocations) {
        Object[] newCheckedLocations;
        int i;
        String oldLocations = this.getStoredValue("API_USE_SCAN_LOCATION", null);
        if (oldLocations != null && oldLocations.equalsIgnoreCase(newLocations)) {
            return false;
        }
        ArrayList<String> oldCheckedElements = new ArrayList<String>();
        if (oldLocations != null && oldLocations.length() > 0) {
            String[] locations = oldLocations.split("\\|");
            i = 0;
            while (i < locations.length) {
                String[] values = locations[i].split("\\*");
                if (Boolean.valueOf(values[1]).booleanValue()) {
                    oldCheckedElements.add(values[0]);
                }
                ++i;
            }
        }
        if ((newCheckedLocations = this.fTableViewer.getCheckedElements()).length != oldCheckedElements.size()) {
            return true;
        }
        i = 0;
        while (i < newCheckedLocations.length) {
            if (!oldCheckedElements.contains(newCheckedLocations[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setStoredValue(String key, String value) {
        IEclipsePreferences node = this.getNode();
        if (value != null) {
            node.put(key, value);
        } else {
            node.remove(key);
        }
    }

    public String getStoredValue(String key, String defaultValue) {
        IEclipsePreferences node = this.getNode();
        if (node != null) {
            return node.get(key, defaultValue);
        }
        return defaultValue;
    }

    private IEclipsePreferences getNode() {
        IEclipsePreferences node = new InstanceScope().getNode("org.eclipse.pde.api.tools");
        if (this.fManager != null) {
            return this.fManager.getWorkingCopy(node);
        }
        return node;
    }

    class TableColumnLabelProvider
    extends ColumnLabelProvider {
        Image archive = null;

        TableColumnLabelProvider() {
        }

        public void dispose() {
            if (this.archive != null) {
                this.archive.dispose();
            }
            super.dispose();
        }

        public Image getImage(Object element) {
            File file = new File(element.toString());
            if (file.isDirectory()) {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
            }
            if (this.archive == null) {
                ImageDescriptor image = PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(file.getName());
                this.archive = image.createImage();
            }
            return this.archive;
        }
    }
}

