/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.search;

import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.jdt.internal.core.OverflowingLRUCache;
import org.eclipse.jdt.internal.core.util.LRUCache;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.search.IReferenceCollection;
import org.eclipse.pde.api.tools.internal.search.IReferenceDescriptor;
import org.eclipse.pde.api.tools.internal.search.SearchMessages;
import org.eclipse.pde.api.tools.internal.search.UseScanParser;
import org.eclipse.pde.api.tools.internal.search.UseScanReferenceVisitor;
import org.eclipse.pde.api.tools.internal.util.FileManager;
import org.eclipse.pde.api.tools.internal.util.Util;

public class UseScanManager {
    private static UseScanCache fApiComponentCache;
    private static UseScanManager fUseScanProcessor;
    private static String tempLocation;
    public static final String STATE_DELIM = "*";
    public static final String LOCATION_DELIM = "|";
    public static final String ESCAPE_REGEX = "\\";
    private String[] fLocations = null;

    static {
        tempLocation = "${workspace_loc}/.metadata/.plugins/org.eclipse.pde.api.tools/ApiUseScans/";
    }

    private UseScanManager() {
    }

    public static synchronized UseScanManager getInstance() {
        if (fUseScanProcessor == null) {
            fUseScanProcessor = new UseScanManager();
            String cacheSize = UseScanManager.getCacheSize();
            fApiComponentCache = new UseScanCache(Integer.parseInt(cacheSize));
        }
        return fUseScanProcessor;
    }

    private static String getCacheSize() {
        IEclipsePreferences node = new InstanceScope().getNode("org.eclipse.pde.api.tools");
        String cacheSize = node.get("API_USE_SCAN_REFERENCE_CACHE_SIZE", String.valueOf(100));
        return cacheSize;
    }

    public IReferenceDescriptor[] getExternalDependenciesFor(IApiComponent apiComponent, String[] apiUseTypes, IProgressMonitor monitor) {
        IReferenceCollection references = (IReferenceCollection)fApiComponentCache.get(apiComponent);
        if (references == null) {
            references = apiComponent.getExternalDependencies();
        }
        SubMonitor localmonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)SearchMessages.collecting_external_dependencies, (int)10);
        try {
            ArrayList<String> unavailableMembers = new ArrayList<String>();
            if (apiUseTypes != null && apiUseTypes.length > 0) {
                int i = 0;
                while (i < apiUseTypes.length) {
                    if (!references.hasReferencesTo(apiUseTypes[i])) {
                        unavailableMembers.add(apiUseTypes[i]);
                    }
                    ++i;
                }
                if (unavailableMembers.size() > 0) {
                    this.fetch(apiComponent, unavailableMembers.toArray(new String[unavailableMembers.size()]), references, monitor);
                }
                Util.updateMonitor((IProgressMonitor)localmonitor, 1);
                IReferenceDescriptor[] iReferenceDescriptorArray = references.getExternalDependenciesTo(apiUseTypes);
                return iReferenceDescriptorArray;
            }
            this.fetch(apiComponent, null, references, (IProgressMonitor)localmonitor.newChild(8));
            Util.updateMonitor((IProgressMonitor)localmonitor, 1);
            IReferenceDescriptor[] iReferenceDescriptorArray = references.getAllExternalDependencies();
            return iReferenceDescriptorArray;
        }
        finally {
            localmonitor.done();
        }
    }

    private void fetch(IApiComponent apiComponent, String[] types, IReferenceCollection references, IProgressMonitor monitor) {
        block16: {
            UseScanParser parser = new UseScanParser();
            UseScanReferenceVisitor visitor = new UseScanReferenceVisitor(apiComponent, types, references);
            SubMonitor localmonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)SearchMessages.load_external_dependencies, (int)10);
            try {
                try {
                    String[] locations = this.fLocations == null ? this.getReportLocations() : this.fLocations;
                    if (locations == null) break block16;
                    IStringVariableManager stringManager = null;
                    localmonitor.setWorkRemaining(locations.length * 2);
                    int i = 0;
                    while (i < locations.length) {
                        block17: {
                            block18: {
                                Util.updateMonitor((IProgressMonitor)localmonitor, 1);
                                File file = new File(locations[i]);
                                if (!file.exists()) break block17;
                                if (!file.isFile()) break block18;
                                if (!Util.isArchive(file.getName())) break block17;
                                String destDirPath = String.valueOf(tempLocation) + file.getName();
                                if (stringManager == null) {
                                    stringManager = VariablesPlugin.getDefault().getStringVariableManager();
                                }
                                destDirPath = stringManager.performStringSubstitution(destDirPath);
                                locations[i] = String.valueOf(destDirPath) + '/' + file.lastModified();
                                File unzipDirLoc = new File(destDirPath);
                                if (unzipDirLoc.exists()) {
                                    String[] childDirs = unzipDirLoc.list();
                                    int j = 0;
                                    while (j < childDirs.length) {
                                        if (!childDirs[j].equals(String.valueOf(file.lastModified()))) {
                                            FileManager.getManager().recordTempFileRoot(String.valueOf(destDirPath) + '/' + childDirs[j]);
                                        }
                                        ++j;
                                    }
                                } else {
                                    Util.unzip(file.getPath(), locations[i]);
                                }
                            }
                            try {
                                locations[i] = this.getExactScanLocation(locations[i]);
                                parser.parse(locations[i], (IProgressMonitor)localmonitor.newChild(2), visitor);
                                Util.updateMonitor((IProgressMonitor)localmonitor);
                            }
                            catch (Exception e) {
                                ApiPlugin.log(e);
                            }
                        }
                        ++i;
                    }
                    fApiComponentCache.remove(apiComponent);
                    fApiComponentCache.put(apiComponent, references);
                }
                catch (Exception e) {
                    ApiPlugin.log(e);
                    localmonitor.done();
                }
            }
            finally {
                localmonitor.done();
            }
        }
    }

    public String getExactScanLocation(String location) {
        File[] reportDirChildren;
        Path path = new Path(location);
        if (path.lastSegment().equalsIgnoreCase("xml")) {
            return location;
        }
        File reportDir = path.append("xml").toFile();
        if (reportDir.exists() ? reportDir.isDirectory() : (reportDirChildren = (reportDir = path.toFile()).listFiles()) != null && reportDirChildren.length == 1 && (reportDir = path.append(reportDirChildren[0].getName()).append("xml").toFile()).isDirectory()) {
            return reportDir.getAbsolutePath();
        }
        return null;
    }

    public String[] getReportLocations() {
        IEclipsePreferences node = new InstanceScope().getNode("org.eclipse.pde.api.tools");
        String apiUseScanPaths = node.get("API_USE_SCAN_LOCATION", null);
        if (apiUseScanPaths == null || apiUseScanPaths.length() == 0) {
            return new String[0];
        }
        String[] locations = apiUseScanPaths.split("\\|");
        ArrayList<String> locationList = new ArrayList<String>(locations.length);
        int i = 0;
        while (i < locations.length) {
            String[] values = locations[i].split("\\*");
            if (Boolean.valueOf(values[1]).booleanValue()) {
                locationList.add(values[0]);
            }
            ++i;
        }
        return locationList.toArray(new String[locationList.size()]);
    }

    public void setReportLocations(String[] locations) {
        this.fLocations = locations;
    }

    public void setCacheSize(int size) {
        fApiComponentCache.setSpaceLimit(size);
    }

    public void clearCache() {
        Enumeration elementss = fApiComponentCache.elements();
        while (elementss.hasMoreElements()) {
            IReferenceCollection reference = (IReferenceCollection)elementss.nextElement();
            reference.clear();
        }
        fApiComponentCache.flush();
    }

    private static class UseScanCache
    extends OverflowingLRUCache {
        public UseScanCache(int size) {
            super(size);
        }

        public UseScanCache(int size, int overflow) {
            super(size, overflow);
        }

        protected boolean close(LRUCache.LRUCacheEntry entry) {
            IReferenceCollection references = (IReferenceCollection)entry.value;
            references.clear();
            return true;
        }

        protected LRUCache newInstance(int size, int newOverflow) {
            return new UseScanCache(size, newOverflow);
        }
    }
}

