/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.launching.PDEMessages;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.wizards.tools.OrganizeManifestsProcessor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;

public class LauncherUtilsStatusHandler
implements IStatusHandler {
    public Object handleStatus(IStatus status, Object source) throws CoreException {
        if (status.getCode() == 2000) {
            Object[] args = (Object[])source;
            this.handleWorkspaceLocked((String)args[0], (ILaunchConfiguration)args[1], (String)args[2]);
        } else {
            if (status.getCode() == 2001) {
                return this.clearLog();
            }
            if (status.getCode() == 2002) {
                return this.deleteWorkspace((String)source);
            }
            if (status.getCode() == 2003) {
                return this.generateConfigIni();
            }
            if (status.getCode() == 2004) {
                Object[] args = (Object[])source;
                this.organizeManifests((ArrayList)args[0], (IProgressMonitor)args[1], (Properties)args[2]);
            }
        }
        return null;
    }

    private Boolean generateConfigIni() {
        String message = PDEUIMessages.LauncherUtils_generateConfigIni;
        return LauncherUtilsStatusHandler.generateDialog(message) == 0;
    }

    private Integer deleteWorkspace(String path) {
        return LauncherUtilsStatusHandler.generateDialog(NLS.bind((String)PDEUIMessages.WorkbenchLauncherConfigurationDelegate_confirmDeleteWorkspace, (Object)path));
    }

    private Integer clearLog() {
        return LauncherUtilsStatusHandler.generateDialog(PDEUIMessages.LauncherUtils_clearLogFile);
    }

    private void handleWorkspaceLocked(String workspace, ILaunchConfiguration launchConfig, String mode) {
        String message = NLS.bind((String)PDEMessages.LauncherUtils_cannotLaunchApplication, (Object)workspace);
        LauncherUtilsStatusHandler.generateErrorDialog(PDEUIMessages.LauncherUtils_workspaceLocked, message, launchConfig, mode);
    }

    private void organizeManifests(final ArrayList projects, final IProgressMonitor monitor, final Properties lastRun) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                OrganizeManifestsProcessor processor = new OrganizeManifestsProcessor(projects);
                LauncherUtilsStatusHandler.initializeProcessor(processor);
                try {
                    Change change = processor.createChange(monitor);
                    change.perform(monitor);
                    Properties table = lastRun;
                    String ts = Long.toString(System.currentTimeMillis());
                    Iterator it = projects.iterator();
                    while (it.hasNext()) {
                        table.put(((IProject)it.next()).getName(), ts);
                    }
                }
                catch (OperationCanceledException operationCanceledException) {
                }
                catch (CoreException coreException) {}
            }
        });
    }

    public static Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static final Shell getActiveShell() {
        IWorkbenchWindow window = PDEPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            IWorkbenchWindow[] windows = PDEPlugin.getDefault().getWorkbench().getWorkbenchWindows();
            if (windows.length > 0) {
                return windows[0].getShell();
            }
        } else {
            return window.getShell();
        }
        return LauncherUtilsStatusHandler.getDisplay().getActiveShell();
    }

    private static void initializeProcessor(OrganizeManifestsProcessor processor) {
        processor.setAddMissing(false);
        processor.setRemoveUnresolved(false);
        processor.setModifyDep(false);
        processor.setRemoveLazy(false);
        processor.setRemoveUselessFiles(false);
        processor.setAddDependencies(true);
        processor.setCalculateUses(false);
        processor.setMarkInternal(false);
        processor.setPrefixIconNL(false);
        processor.setUnusedDependencies(false);
        processor.setUnusedKeys(false);
    }

    private static Integer generateDialog(final String message) {
        final int[] result = new int[1];
        LauncherUtilsStatusHandler.getDisplay().syncExec(new Runnable(){

            public void run() {
                String title = PDEUIMessages.LauncherUtils_title;
                MessageDialog dialog = new MessageDialog(LauncherUtilsStatusHandler.getActiveShell(), title, null, message, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
                result[0] = dialog.open();
            }
        });
        return new Integer(result[0]);
    }

    private static void generateErrorDialog(final String title, final String message, final ILaunchConfiguration launchConfig, final String mode) {
        LauncherUtilsStatusHandler.getDisplay().syncExec(new Runnable(){

            public void run() {
                Shell parentShell = LauncherUtilsStatusHandler.getActiveShell();
                if (launchConfig == null || mode == null) {
                    MessageDialog dialog = new MessageDialog(parentShell, title, null, message, 1, new String[]{IDialogConstants.OK_LABEL}, 0);
                    dialog.open();
                } else {
                    MessageDialog dialog = new MessageDialog(parentShell, title, null, message, 1, new String[]{PDEUIMessages.LauncherUtils_edit, IDialogConstants.OK_LABEL}, 1);
                    int res = dialog.open();
                    if (res == 0) {
                        StructuredSelection selection = new StructuredSelection((Object)launchConfig);
                        ILaunchGroup group = DebugUITools.getLaunchGroup((ILaunchConfiguration)launchConfig, (String)mode);
                        String groupIdentifier = group == null ? "org.eclipse.debug.ui.launchGroup.run" : group.getIdentifier();
                        DebugUITools.openLaunchConfigurationDialogOnGroup((Shell)parentShell, (IStructuredSelection)selection, (String)groupIdentifier);
                    }
                }
            }
        });
    }
}

