/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.io.InputStream;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.cocoa.NSAffineTransform;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSAutoreleasePool;
import org.eclipse.swt.internal.cocoa.NSBitmapImageRep;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSImage;
import org.eclipse.swt.internal.cocoa.NSImageRep;
import org.eclipse.swt.internal.cocoa.NSObject;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSThread;
import org.eclipse.swt.internal.cocoa.OS;

public final class Image
extends Resource
implements Drawable {
    public int type;
    public NSImage handle;
    int transparentPixel = -1;
    GC memGC;
    byte[] alphaData;
    int alpha = -1;
    int width = -1;
    int height = -1;
    static final int DEFAULT_SCANLINE_PAD = 4;

    Image(Device device) {
        super(device);
    }

    public Image(Device device, int width, int height) {
        super(device);
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.init(width, height);
            this.init();
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public Image(Device device, Image srcImage, int flag) {
        super(device);
        if (srcImage == null) {
            SWT.error(4);
        }
        if (srcImage.isDisposed()) {
            SWT.error(5);
        }
        switch (flag) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            device = this.device;
            this.type = srcImage.type;
            NSSize size = srcImage.handle.size();
            int width = (int)size.width;
            int height = (int)size.height;
            NSBitmapImageRep srcRep = srcImage.getRepresentation();
            long bpr = srcRep.bytesPerRow();
            this.transparentPixel = srcImage.transparentPixel;
            this.alpha = srcImage.alpha;
            if (srcImage.alphaData != null) {
                this.alphaData = new byte[srcImage.alphaData.length];
                System.arraycopy(srcImage.alphaData, 0, this.alphaData, 0, this.alphaData.length);
            }
            long srcData = srcRep.bitmapData();
            long format = srcRep.bitmapFormat();
            long bpp = srcRep.bitsPerPixel();
            this.handle = (NSImage)new NSImage().alloc();
            this.handle = this.handle.initWithSize(size);
            NSBitmapImageRep rep = (NSBitmapImageRep)new NSBitmapImageRep().alloc();
            rep = rep.initWithBitmapDataPlanes(0L, width, height, srcRep.bitsPerSample(), srcRep.samplesPerPixel(), srcRep.hasAlpha(), srcRep.isPlanar(), OS.NSCalibratedRGBColorSpace, format, srcRep.bytesPerRow(), bpp);
            this.handle.addRepresentation(rep);
            rep.release();
            this.handle.setCacheMode(3L);
            long data = rep.bitmapData();
            OS.memmove(data, srcData, (long)(width * height * 4));
            if (flag != 0) {
                int blueOffset;
                int greenOffset;
                int redOffset;
                if (bpp == 32L && (format & 1L) == 0L) {
                    redOffset = 0;
                    greenOffset = 1;
                    blueOffset = 2;
                } else {
                    redOffset = 1;
                    greenOffset = 2;
                    blueOffset = 3;
                }
                switch (flag) {
                    case 1: {
                        Color zeroColor = device.getSystemColor(18);
                        RGB zeroRGB = zeroColor.getRGB();
                        byte zeroRed = (byte)zeroRGB.red;
                        byte zeroGreen = (byte)zeroRGB.green;
                        byte zeroBlue = (byte)zeroRGB.blue;
                        Color oneColor = device.getSystemColor(22);
                        RGB oneRGB = oneColor.getRGB();
                        byte oneRed = (byte)oneRGB.red;
                        byte oneGreen = (byte)oneRGB.green;
                        byte oneBlue = (byte)oneRGB.blue;
                        byte[] line = new byte[(int)bpr];
                        int y = 0;
                        while (y < height) {
                            OS.memmove(line, data + (long)y * bpr, bpr);
                            int offset = 0;
                            int x = 0;
                            while (x < width) {
                                int red = line[offset + redOffset] & 0xFF;
                                int green = line[offset + greenOffset] & 0xFF;
                                int blue = line[offset + blueOffset] & 0xFF;
                                int intensity = red * red + green * green + blue * blue;
                                if (intensity < 98304) {
                                    line[offset + redOffset] = zeroRed;
                                    line[offset + greenOffset] = zeroGreen;
                                    line[offset + blueOffset] = zeroBlue;
                                } else {
                                    line[offset + redOffset] = oneRed;
                                    line[offset + greenOffset] = oneGreen;
                                    line[offset + blueOffset] = oneBlue;
                                }
                                offset += 4;
                                ++x;
                            }
                            OS.memmove(data + (long)y * bpr, line, bpr);
                            ++y;
                        }
                        break;
                    }
                    case 2: {
                        byte[] line = new byte[(int)bpr];
                        int y = 0;
                        while (y < height) {
                            OS.memmove(line, data + (long)y * bpr, bpr);
                            int offset = 0;
                            int x = 0;
                            while (x < width) {
                                byte intensity;
                                int red = line[offset + redOffset] & 0xFF;
                                int green = line[offset + greenOffset] & 0xFF;
                                int blue = line[offset + blueOffset] & 0xFF;
                                byte by = intensity = (byte)(red + red + green + green + green + green + green + blue >> 3);
                                line[offset + blueOffset] = by;
                                line[offset + greenOffset] = by;
                                line[offset + redOffset] = by;
                                offset += 4;
                                ++x;
                            }
                            OS.memmove(data + (long)y * bpr, line, bpr);
                            ++y;
                        }
                        break;
                    }
                }
            }
            this.init();
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public Image(Device device, Rectangle bounds) {
        super(device);
        if (bounds == null) {
            SWT.error(4);
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.init(bounds.width, bounds.height);
            this.init();
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public Image(Device device, ImageData data) {
        super(device);
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.init(data);
            this.init();
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public Image(Device device, ImageData source, ImageData mask) {
        super(device);
        if (source == null) {
            SWT.error(4);
        }
        if (mask == null) {
            SWT.error(4);
        }
        if (source.width != mask.width || source.height != mask.height) {
            SWT.error(5);
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            mask = ImageData.convertMask(mask);
            ImageData image = new ImageData(source.width, source.height, source.depth, source.palette, source.scanlinePad, source.data);
            image.maskPad = mask.scanlinePad;
            image.maskData = mask.data;
            this.init(image);
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public Image(Device device, InputStream stream) {
        super(device);
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.init(new ImageData(stream));
            this.init();
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public Image(Device device, String filename) {
        super(device);
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            if (filename == null) {
                SWT.error(4);
            }
            this.initNative(filename);
            if (this.handle == null) {
                this.init(new ImageData(filename));
            }
            this.init();
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    void createAlpha() {
        if (this.transparentPixel == -1 && this.alpha == -1 && this.alphaData == null) {
            return;
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            NSBitmapImageRep imageRep = this.getRepresentation();
            long height = imageRep.pixelsHigh();
            long bpr = imageRep.bytesPerRow();
            long bitmapData = imageRep.bitmapData();
            long format = imageRep.bitmapFormat();
            long dataSize = height * bpr;
            byte[] srcData = new byte[(int)dataSize];
            OS.memmove(srcData, bitmapData, dataSize);
            if (this.transparentPixel != -1) {
                if ((format & 1L) != 0L) {
                    int i = 0;
                    while ((long)i < dataSize) {
                        int pixel = (srcData[i + 1] & 0xFF) << 16 | (srcData[i + 2] & 0xFF) << 8 | srcData[i + 3] & 0xFF;
                        srcData[i] = (byte)(pixel == this.transparentPixel ? 0 : 255);
                        i += 4;
                    }
                } else {
                    int i = 0;
                    while ((long)i < dataSize) {
                        int pixel = (srcData[i + 0] & 0xFF) << 16 | (srcData[i + 1] & 0xFF) << 8 | srcData[i + 2] & 0xFF;
                        srcData[i] = (byte)(pixel == this.transparentPixel ? 0 : 255);
                        i += 4;
                    }
                }
            } else if (this.alpha != -1) {
                byte a = (byte)this.alpha;
                int i = (format & 1L) != 0L ? 0 : 3;
                while ((long)i < dataSize) {
                    srcData[i] = a;
                    i += 4;
                }
            } else {
                long width = imageRep.pixelsWide();
                int offset = 0;
                int alphaOffset = (format & 1L) != 0L ? 0 : 3;
                int y = 0;
                while ((long)y < height) {
                    int x = 0;
                    while ((long)x < width) {
                        srcData[offset] = this.alphaData[alphaOffset];
                        offset += 4;
                        ++alphaOffset;
                        ++x;
                    }
                    ++y;
                }
            }
            imageRep.setAlpha(true);
            OS.memmove(bitmapData, srcData, dataSize);
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    void destroy() {
        if (this.memGC != null) {
            this.memGC.dispose();
        }
        this.handle.release();
        this.handle = null;
        this.memGC = null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Image)) {
            return false;
        }
        Image image = (Image)object;
        return this.device == image.device && this.handle == image.handle && this.transparentPixel == image.transparentPixel;
    }

    public Color getBackground() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (this.transparentPixel == -1) {
            return null;
        }
        int red = this.transparentPixel >> 16 & 0xFF;
        int green = this.transparentPixel >> 8 & 0xFF;
        int blue = this.transparentPixel >> 0 & 0xFF;
        return Color.cocoa_new(this.device, new double[]{(float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f, 1.0});
    }

    public Rectangle getBounds() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            if (this.width != -1 && this.height != -1) {
                Rectangle rectangle = new Rectangle(0, 0, this.width, this.height);
                return rectangle;
            }
            NSSize size = this.handle.size();
            this.width = (int)size.width;
            this.height = (int)size.height;
            Rectangle rectangle = new Rectangle(0, 0, this.width, this.height);
            return rectangle;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public ImageData getImageData() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            NSBitmapImageRep imageRep = this.getRepresentation();
            long width = imageRep.pixelsWide();
            long height = imageRep.pixelsHigh();
            long bpr = imageRep.bytesPerRow();
            long bpp = imageRep.bitsPerPixel();
            long bitmapData = imageRep.bitmapData();
            long bitmapFormat = imageRep.bitmapFormat();
            long dataSize = height * bpr;
            byte[] srcData = new byte[(int)dataSize];
            OS.memmove(srcData, bitmapData, dataSize);
            PaletteData palette = bpp == 32L && (bitmapFormat & 1L) == 0L ? new PaletteData(-16777216, 0xFF0000, 65280) : new PaletteData(0xFF0000, 65280, 255);
            ImageData data = new ImageData((int)width, (int)height, (int)bpp, palette, 1, srcData);
            data.bytesPerLine = (int)bpr;
            if (imageRep.hasAlpha() && this.transparentPixel == -1 && this.alpha == -1 && this.alphaData == null) {
                byte[] alphaData = new byte[(int)(width * height)];
                int offset = (bitmapFormat & 1L) != 0L ? 0 : 3;
                int a = 0;
                int i = offset;
                while (i < srcData.length) {
                    alphaData[a++] = srcData[i];
                    i += 4;
                }
                data.alphaData = alphaData;
            } else {
                data.transparentPixel = this.transparentPixel;
                if (this.transparentPixel == -1 && this.type == 1) {
                    int maskPad = 2;
                    long maskBpl = ((width + 7L) / 8L + (long)(maskPad - 1)) / (long)maskPad * (long)maskPad;
                    byte[] maskData = new byte[(int)(height * maskBpl)];
                    int offset = 0;
                    int maskOffset = 0;
                    int y = 0;
                    while ((long)y < height) {
                        int x = 0;
                        while ((long)x < width) {
                            if (srcData[offset] != 0) {
                                int n = maskOffset + (x >> 3);
                                maskData[n] = (byte)(maskData[n] | 1 << 7 - (x & 7));
                            } else {
                                int n = maskOffset + (x >> 3);
                                maskData[n] = (byte)(maskData[n] & ~(1 << 7 - (x & 7)));
                            }
                            offset += 4;
                            ++x;
                        }
                        maskOffset = (int)((long)maskOffset + maskBpl);
                        ++y;
                    }
                    data.maskData = maskData;
                    data.maskPad = maskPad;
                }
                data.alpha = this.alpha;
                if (this.alpha == -1 && this.alphaData != null) {
                    data.alphaData = new byte[this.alphaData.length];
                    System.arraycopy(this.alphaData, 0, data.alphaData, 0, this.alphaData.length);
                }
            }
            if (bpp == 32L) {
                int offset;
                int i = offset = (bitmapFormat & 1L) != 0L ? 0 : 3;
                while (i < srcData.length) {
                    srcData[i] = 0;
                    i += 4;
                }
            }
            ImageData imageData = data;
            return imageData;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public static Image cocoa_new(Device device, int type, NSImage nsImage) {
        Image image = new Image(device);
        image.type = type;
        image.handle = nsImage;
        return image;
    }

    NSBitmapImageRep getRepresentation() {
        NSBitmapImageRep rep = new NSBitmapImageRep(this.handle.bestRepresentationForDevice(null));
        if (rep.isKindOfClass(OS.class_NSBitmapImageRep)) {
            return rep;
        }
        NSArray reps = this.handle.representations();
        NSSize size = this.handle.size();
        long count = reps.count();
        NSObject bestRep = null;
        int i = 0;
        while ((long)i < count) {
            rep = new NSBitmapImageRep(reps.objectAtIndex(i));
            if (rep.isKindOfClass(OS.class_NSBitmapImageRep)) {
                return rep;
            }
            if (bestRep == null || (long)((int)size.width) == rep.pixelsWide() && (long)((int)size.height) == rep.pixelsHigh()) {
                bestRep = rep;
            }
            ++i;
        }
        bestRep.retain();
        i = 0;
        while ((long)i < count) {
            this.handle.removeRepresentation(new NSImageRep(this.handle.representations().objectAtIndex(0L)));
            ++i;
        }
        this.handle.addRepresentation((NSImageRep)bestRep);
        NSBitmapImageRep newRep = (NSBitmapImageRep)new NSBitmapImageRep().alloc();
        newRep = newRep.initWithData(this.handle.TIFFRepresentation());
        this.handle.addRepresentation(newRep);
        this.handle.removeRepresentation((NSImageRep)bestRep);
        bestRep.release();
        newRep.release();
        return newRep;
    }

    public int hashCode() {
        return this.handle != null ? (int)this.handle.id : 0;
    }

    void init(int width, int height) {
        if (width <= 0 || height <= 0) {
            SWT.error(5);
        }
        this.type = 0;
        this.width = width;
        this.height = height;
        this.handle = (NSImage)new NSImage().alloc();
        NSSize size = new NSSize();
        size.width = width;
        size.height = height;
        this.handle = this.handle.initWithSize(size);
        NSBitmapImageRep rep = (NSBitmapImageRep)new NSBitmapImageRep().alloc();
        rep = rep.initWithBitmapDataPlanes(0L, width, height, 8L, 3L, false, false, OS.NSCalibratedRGBColorSpace, 3L, width * 4, 32L);
        OS.memset(rep.bitmapData(), 255, width * height * 4);
        this.handle.addRepresentation(rep);
        rep.release();
        this.handle.setCacheMode(3L);
    }

    void init(ImageData image) {
        boolean hasAlpha;
        RGB rgb;
        if (image == null) {
            SWT.error(4);
        }
        this.width = image.width;
        this.height = image.height;
        PaletteData palette = image.palette;
        if ((image.depth != 1 && image.depth != 2 && image.depth != 4 && image.depth != 8 || palette.isDirect) && image.depth != 8 && (image.depth != 16 && image.depth != 24 && image.depth != 32 || !palette.isDirect)) {
            SWT.error(38);
        }
        int dataSize = this.width * this.height * 4;
        int bpr = this.width * 4;
        byte[] buffer = new byte[dataSize];
        if (palette.isDirect) {
            ImageData.blit(1, image.data, image.depth, image.bytesPerLine, image.getByteOrder(), 0, 0, this.width, this.height, palette.redMask, palette.greenMask, palette.blueMask, 255, null, 0, 0, 0, buffer, 32, bpr, 1, 0, 0, this.width, this.height, 0xFF0000, 65280, 255, false, false);
        } else {
            RGB[] rgbs = palette.getRGBs();
            int length = rgbs.length;
            byte[] srcReds = new byte[length];
            byte[] srcGreens = new byte[length];
            byte[] srcBlues = new byte[length];
            int i = 0;
            while (i < rgbs.length) {
                rgb = rgbs[i];
                if (rgb != null) {
                    srcReds[i] = (byte)rgb.red;
                    srcGreens[i] = (byte)rgb.green;
                    srcBlues[i] = (byte)rgb.blue;
                }
                ++i;
            }
            ImageData.blit(1, image.data, image.depth, image.bytesPerLine, image.getByteOrder(), 0, 0, this.width, this.height, srcReds, srcGreens, srcBlues, 255, null, 0, 0, 0, buffer, 32, bpr, 1, 0, 0, this.width, this.height, 0xFF0000, 65280, 255, false, false);
        }
        int transparency = image.getTransparencyType();
        boolean bl = hasAlpha = transparency != 0;
        if (transparency == 2 || image.transparentPixel != -1) {
            int n = this.type = image.transparentPixel != -1 ? 0 : 1;
            if (image.transparentPixel != -1) {
                int transRed = 0;
                int transGreen = 0;
                int transBlue = 0;
                if (palette.isDirect) {
                    RGB rgb2 = palette.getRGB(image.transparentPixel);
                    transRed = rgb2.red;
                    transGreen = rgb2.green;
                    transBlue = rgb2.blue;
                } else {
                    RGB[] rgbs = palette.getRGBs();
                    if (image.transparentPixel < rgbs.length) {
                        rgb = rgbs[image.transparentPixel];
                        transRed = rgb.red;
                        transGreen = rgb.green;
                        transBlue = rgb.blue;
                    }
                }
                this.transparentPixel = transRed << 16 | transGreen << 8 | transBlue;
            }
            ImageData maskImage = image.getTransparencyMask();
            byte[] maskData = maskImage.data;
            int maskBpl = maskImage.bytesPerLine;
            int offset = 0;
            int maskOffset = 0;
            int y = 0;
            while (y < this.height) {
                int x = 0;
                while (x < this.width) {
                    buffer[offset] = (maskData[maskOffset + (x >> 3)] & 1 << 7 - (x & 7)) != 0 ? -1 : 0;
                    offset += 4;
                    ++x;
                }
                maskOffset += maskBpl;
                ++y;
            }
        } else {
            this.type = 0;
            if (image.alpha != -1) {
                hasAlpha = true;
                this.alpha = image.alpha;
                byte a = (byte)this.alpha;
                int dataIndex = 0;
                while (dataIndex < buffer.length) {
                    buffer[dataIndex] = a;
                    dataIndex += 4;
                }
            } else if (image.alphaData != null) {
                hasAlpha = true;
                this.alphaData = new byte[image.alphaData.length];
                System.arraycopy(image.alphaData, 0, this.alphaData, 0, this.alphaData.length);
                int offset = 0;
                int alphaOffset = 0;
                int y = 0;
                while (y < this.height) {
                    int x = 0;
                    while (x < this.width) {
                        buffer[offset] = this.alphaData[alphaOffset];
                        offset += 4;
                        ++alphaOffset;
                        ++x;
                    }
                    ++y;
                }
            }
        }
        if (this.handle != null) {
            this.handle.release();
        }
        this.handle = (NSImage)new NSImage().alloc();
        NSSize size = new NSSize();
        size.width = this.width;
        size.height = this.height;
        this.handle = this.handle.initWithSize(size);
        NSBitmapImageRep rep = (NSBitmapImageRep)new NSBitmapImageRep().alloc();
        rep = rep.initWithBitmapDataPlanes(0L, this.width, this.height, 8L, hasAlpha ? 4 : 3, hasAlpha, false, OS.NSCalibratedRGBColorSpace, 3L, bpr, 32L);
        OS.memmove(rep.bitmapData(), buffer, (long)dataSize);
        this.handle.addRepresentation(rep);
        rep.release();
        this.handle.setCacheMode(3L);
    }

    void initNative(String filename) {
        NSAutoreleasePool pool = null;
        NSImage nativeImage = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            nativeImage = new NSImage();
            nativeImage.alloc();
            nativeImage = nativeImage.initWithContentsOfFile(NSString.stringWith(filename));
            if (nativeImage == null) {
                return;
            }
            NSImageRep nativeRep = nativeImage.bestRepresentationForDevice(null);
            if (!nativeRep.isKindOfClass(OS.class_NSBitmapImageRep)) {
                return;
            }
            this.width = (int)nativeRep.pixelsWide();
            this.height = (int)nativeRep.pixelsHigh();
            boolean hasAlpha = nativeRep.hasAlpha();
            int bpr = this.width * 4;
            this.handle = (NSImage)new NSImage().alloc();
            NSSize size = new NSSize();
            size.width = this.width;
            size.height = this.height;
            this.handle = this.handle.initWithSize(size);
            NSBitmapImageRep rep = (NSBitmapImageRep)new NSBitmapImageRep().alloc();
            rep = rep.initWithBitmapDataPlanes(0L, this.width, this.height, 8L, hasAlpha ? 4 : 3, hasAlpha, false, OS.NSCalibratedRGBColorSpace, 3L, bpr, 32L);
            this.handle.addRepresentation(rep);
            rep.release();
            this.handle.setCacheMode(3L);
            NSRect rect = new NSRect();
            rect.width = this.width;
            rect.height = this.height;
            long colorspace = OS.CGColorSpaceCreateDeviceRGB();
            long ctx = OS.CGBitmapContextCreate(rep.bitmapData(), this.width, this.height, 8L, bpr, colorspace, 6);
            OS.CGColorSpaceRelease(colorspace);
            NSGraphicsContext.static_saveGraphicsState();
            NSGraphicsContext.setCurrentContext(NSGraphicsContext.graphicsContextWithGraphicsPort(ctx, false));
            if (hasAlpha) {
                OS.objc_msgSend(nativeRep.id, OS.sel_setAlpha_, 0);
            }
            nativeRep.drawInRect(rect);
            if (hasAlpha) {
                OS.objc_msgSend(nativeRep.id, OS.sel_setAlpha_, 1);
            }
            NSGraphicsContext.static_restoreGraphicsState();
            OS.CGContextRelease(ctx);
            if (hasAlpha) {
                long bitmapBytesPerRow = this.width;
                long bitmapByteCount = bitmapBytesPerRow * (long)this.height;
                long alphaBitmapData = OS.malloc(bitmapByteCount);
                long alphaBitmapCtx = OS.CGBitmapContextCreate(alphaBitmapData, this.width, this.height, 8L, bitmapBytesPerRow, 0L, 7);
                NSGraphicsContext.static_saveGraphicsState();
                NSGraphicsContext.setCurrentContext(NSGraphicsContext.graphicsContextWithGraphicsPort(alphaBitmapCtx, false));
                nativeRep.drawInRect(rect);
                NSGraphicsContext.static_restoreGraphicsState();
                byte[] alphaData = new byte[(int)bitmapByteCount];
                OS.memmove(alphaData, alphaBitmapData, bitmapByteCount);
                OS.free(alphaBitmapData);
                OS.CGContextRelease(alphaBitmapCtx);
                byte[] srcData = new byte[this.height * bpr];
                OS.memmove(srcData, rep.bitmapData(), (long)srcData.length);
                int a = 0;
                int p = 0;
                while (a < alphaData.length) {
                    srcData[p] = alphaData[a];
                    ++a;
                    p += 4;
                }
                OS.memmove(rep.bitmapData(), srcData, (long)srcData.length);
                int transparentOffset = -1;
                int i = 0;
                i = 0;
                while (i < alphaData.length) {
                    byte alpha = alphaData[i];
                    if (transparentOffset == -1 && alpha == 0) {
                        transparentOffset = i;
                    }
                    if (alpha != 0 && alpha != -1) break;
                    ++i;
                }
                this.alpha = -1;
                if (i == alphaData.length && transparentOffset != -1) {
                    NSColor color = rep.colorAtX(transparentOffset % this.width, transparentOffset / this.width);
                    int red = (int)(color.redComponent() * 255.0);
                    int green = (int)(color.greenComponent() * 255.0);
                    int blue = (int)(color.blueComponent() * 255.0);
                    this.transparentPixel = (red << 16) + (green << 8) + blue;
                    int j = 0;
                    while (j < srcData.length) {
                        int pixel;
                        if (srcData[j] != 0 && (pixel = (srcData[j + 1] << 16) + (srcData[j + 2] << 8) + srcData[j + 3]) == this.transparentPixel) {
                            this.transparentPixel = -1;
                            break;
                        }
                        j += 4;
                    }
                }
                if (this.transparentPixel == -1) {
                    this.alphaData = alphaData;
                }
            }
            this.type = filename.toLowerCase().endsWith(".ico") ? 1 : 0;
        }
        finally {
            if (nativeImage != null) {
                nativeImage.release();
            }
            if (pool != null) {
                pool.release();
            }
        }
    }

    public long internal_new_GC(GCData data) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (this.type != 0 || this.memGC != null) {
            SWT.error(5);
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            NSGraphicsContext flippedContext;
            NSBitmapImageRep imageRep = this.getRepresentation();
            imageRep.setAlpha(false);
            NSGraphicsContext context = NSGraphicsContext.graphicsContextWithBitmapImageRep(imageRep);
            context = flippedContext = NSGraphicsContext.graphicsContextWithGraphicsPort(context.graphicsPort(), true);
            context.retain();
            if (data != null) {
                data.flippedContext = flippedContext;
            }
            NSGraphicsContext.static_saveGraphicsState();
            NSGraphicsContext.setCurrentContext(context);
            NSAffineTransform transform = NSAffineTransform.transform();
            NSSize size = this.handle.size();
            transform.translateXBy(0.0, size.height);
            transform.scaleXBy(1.0, -1.0);
            transform.set();
            NSGraphicsContext.static_restoreGraphicsState();
            if (data != null) {
                int mask = 0x6000000;
                if ((data.style & mask) == 0) {
                    data.style |= 0x2000000;
                }
                data.device = this.device;
                data.background = this.device.COLOR_WHITE.handle;
                data.foreground = this.device.COLOR_BLACK.handle;
                data.font = this.device.systemFont;
                data.image = this;
            }
            long l = context.id;
            return l;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public void internal_dispose_GC(long context, GCData data) {
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            if (context != 0L) {
                NSGraphicsContext contextObj = new NSGraphicsContext(context);
                contextObj.release();
            }
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public boolean isDisposed() {
        return this.handle == null;
    }

    public void setBackground(Color color) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        if (this.transparentPixel == -1) {
            return;
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            int blueOffset;
            int greenOffset;
            int redOffset;
            byte red = (byte)(this.transparentPixel >> 16 & 0xFF);
            byte green = (byte)(this.transparentPixel >> 8 & 0xFF);
            byte blue = (byte)(this.transparentPixel >> 0 & 0xFF);
            byte newRed = (byte)((int)(color.handle[0] * 255.0) & 0xFF);
            byte newGreen = (byte)((int)(color.handle[1] * 255.0) & 0xFF);
            byte newBlue = (byte)((int)(color.handle[2] * 255.0) & 0xFF);
            NSBitmapImageRep imageRep = this.getRepresentation();
            long bpr = imageRep.bytesPerRow();
            long data = imageRep.bitmapData();
            long format = imageRep.bitmapFormat();
            long bpp = imageRep.bitsPerPixel();
            if (bpp == 32L && (format & 1L) == 0L) {
                redOffset = 0;
                greenOffset = 1;
                blueOffset = 2;
            } else {
                redOffset = 1;
                greenOffset = 2;
                blueOffset = 3;
            }
            byte[] line = new byte[(int)bpr];
            int i = 0;
            int offset = 0;
            while (i < this.height) {
                OS.memmove(line, data + (long)offset, bpr);
                int j = 0;
                while (j < line.length) {
                    if (line[j + redOffset] == red && line[j + greenOffset] == green && line[j + blueOffset] == blue) {
                        line[j + redOffset] = newRed;
                        line[j + greenOffset] = newGreen;
                        line[j + blueOffset] = newBlue;
                    }
                    j += 4;
                }
                OS.memmove(data + (long)offset, line, bpr);
                ++i;
                offset = (int)((long)offset + bpr);
            }
            this.transparentPixel = (newRed & 0xFF) << 16 | (newGreen & 0xFF) << 8 | newBlue & 0xFF;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Image {*DISPOSED*}";
        }
        return "Image {" + this.handle + "}";
    }
}

