/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.GtkBorder;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.ImageList;
import org.eclipse.swt.widgets.TypedListener;

public class Button
extends Control {
    int boxHandle;
    int labelHandle;
    int imageHandle;
    int arrowHandle;
    int groupHandle;
    boolean selected;
    boolean grayed;
    ImageList imageList;
    Image image;
    String text;
    static final int INNER_BORDER = 1;
    static final int DEFAULT_BORDER = 1;

    public Button(Composite parent, int style) {
        super(parent, Button.checkStyle(style));
    }

    static int checkStyle(int style) {
        if (((style = Button.checkBits(style, 8, 4, 32, 16, 2, 0)) & 0xA) != 0) {
            return Button.checkBits(style, 0x1000000, 16384, 131072, 0, 0, 0);
        }
        if ((style & 0x30) != 0) {
            return Button.checkBits(style, 16384, 131072, 0x1000000, 0, 0, 0);
        }
        if ((style & 4) != 0) {
            return Button.checkBits(style |= 0x80000, 128, 1024, 16384, 131072, 0, 0);
        }
        return style;
    }

    static GtkBorder getBorder(byte[] border, int handle, int defaultBorder) {
        GtkBorder gtkBorder = new GtkBorder();
        int[] borderPtr = new int[1];
        OS.gtk_widget_style_get(handle, border, borderPtr, 0);
        if (borderPtr[0] != 0) {
            OS.memmove(gtkBorder, borderPtr[0], GtkBorder.sizeof);
            OS.gtk_border_free(borderPtr[0]);
            return gtkBorder;
        }
        gtkBorder.left = defaultBorder;
        gtkBorder.top = defaultBorder;
        gtkBorder.right = defaultBorder;
        gtkBorder.bottom = defaultBorder;
        return gtkBorder;
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point size;
        boolean wrap;
        this.checkWidget();
        if (wHint != -1 && wHint < 0) {
            wHint = 0;
        }
        if (hHint != -1 && hHint < 0) {
            hHint = 0;
        }
        this.forceResize();
        int[] reqWidth = null;
        int[] reqHeight = null;
        if ((this.style & 0x30) != 0) {
            reqWidth = new int[1];
            reqHeight = new int[1];
            OS.gtk_widget_get_size_request(this.boxHandle, reqWidth, reqHeight);
            OS.gtk_widget_set_size_request(this.boxHandle, -1, -1);
        }
        boolean bl = wrap = this.labelHandle != 0 && (this.style & 0x40) != 0 && (OS.GTK_WIDGET_FLAGS(this.labelHandle) & 0x100) != 0;
        if (wrap) {
            int trimWidth;
            int borderWidth = OS.gtk_container_get_border_width(this.handle);
            int[] focusWidth = new int[1];
            OS.gtk_widget_style_get(this.handle, OS.focus_line_width, focusWidth, 0);
            int[] focusPadding = new int[1];
            OS.gtk_widget_style_get(this.handle, OS.focus_padding, focusPadding, 0);
            int trimHeight = trimWidth = 2 * (borderWidth + focusWidth[0] + focusPadding[0]);
            int indicatorHeight = 0;
            if ((this.style & 0x30) != 0) {
                int[] indicatorSize = new int[1];
                OS.gtk_widget_style_get(this.handle, OS.indicator_size, indicatorSize, 0);
                int[] indicatorSpacing = new int[1];
                OS.gtk_widget_style_get(this.handle, OS.indicator_spacing, indicatorSpacing, 0);
                indicatorHeight = indicatorSize[0] + 2 * indicatorSpacing[0];
                trimWidth += indicatorHeight + indicatorSpacing[0];
            } else {
                int style = OS.gtk_widget_get_style(this.handle);
                trimWidth += OS.gtk_style_get_xthickness(style) * 2;
                trimHeight += OS.gtk_style_get_ythickness(style) * 2;
                GtkBorder innerBorder = Button.getBorder(OS.inner_border, this.handle, 1);
                trimWidth += innerBorder.left + innerBorder.right;
                trimHeight += innerBorder.top + innerBorder.bottom;
                if ((OS.GTK_WIDGET_FLAGS(this.handle) & 0x2000) != 0) {
                    GtkBorder defaultBorder = Button.getBorder(OS.default_border, this.handle, 1);
                    trimWidth += defaultBorder.left + defaultBorder.right;
                    trimHeight += defaultBorder.top + defaultBorder.bottom;
                }
            }
            int imageWidth = 0;
            int imageHeight = 0;
            if (OS.GTK_WIDGET_VISIBLE(this.imageHandle)) {
                GtkRequisition requisition = new GtkRequisition();
                OS.gtk_widget_size_request(this.imageHandle, requisition);
                imageWidth = requisition.width;
                imageHeight = requisition.height;
                int[] spacing = new int[1];
                OS.g_object_get(this.boxHandle, OS.spacing, spacing, 0);
                imageWidth += spacing[0];
            }
            int labelLayout = OS.gtk_label_get_layout(this.labelHandle);
            int pangoWidth = OS.pango_layout_get_width(labelLayout);
            if (wHint != -1) {
                OS.pango_layout_set_width(labelLayout, Math.max(1, wHint - imageWidth - trimWidth) * 1024);
            } else {
                OS.pango_layout_set_width(labelLayout, -1);
            }
            int[] w = new int[1];
            int[] h = new int[1];
            OS.pango_layout_get_size(labelLayout, w, h);
            OS.pango_layout_set_width(labelLayout, pangoWidth);
            size = new Point(0, 0);
            size.x = size.x + (wHint == -1 ? OS.PANGO_PIXELS(w[0]) + imageWidth + trimWidth : wHint);
            size.y = size.y + (hHint == -1 ? Math.max(Math.max(imageHeight, indicatorHeight), OS.PANGO_PIXELS(h[0])) + trimHeight : hHint);
        } else {
            size = this.computeNativeSize(this.handle, wHint, hHint, changed);
        }
        if ((this.style & 0x30) != 0) {
            OS.gtk_widget_set_size_request(this.boxHandle, reqWidth[0], reqHeight[0]);
        }
        if ((wHint != -1 || hHint != -1) && (OS.GTK_WIDGET_FLAGS(this.handle) & 0x2000) != 0) {
            GtkBorder border = Button.getBorder(OS.default_border, this.handle, 1);
            if (wHint != -1) {
                size.x += border.left + border.right;
            }
            if (hHint != -1) {
                size.y += border.top + border.bottom;
            }
        }
        return size;
    }

    void createHandle(int index) {
        this.state |= 8;
        if ((this.style & 0xA) == 0) {
            this.state |= 0x10000;
        }
        int bits = 62;
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0);
        if (this.fixedHandle == 0) {
            this.error(2);
        }
        OS.gtk_fixed_set_has_window(this.fixedHandle, true);
        switch (this.style & bits) {
            case 4: {
                int arrow_type = 0;
                if ((this.style & 0x80) != 0) {
                    arrow_type = 0;
                }
                if ((this.style & 0x400) != 0) {
                    arrow_type = 1;
                }
                if ((this.style & 0x4000) != 0) {
                    arrow_type = 2;
                }
                if ((this.style & 0x20000) != 0) {
                    arrow_type = 3;
                }
                this.handle = OS.gtk_button_new();
                if (this.handle == 0) {
                    this.error(2);
                }
                this.arrowHandle = OS.gtk_arrow_new(arrow_type, 2);
                if (this.arrowHandle != 0) break;
                this.error(2);
                break;
            }
            case 2: {
                this.handle = OS.gtk_toggle_button_new();
                if (this.handle != 0) break;
                this.error(2);
                break;
            }
            case 32: {
                this.handle = OS.gtk_check_button_new();
                if (this.handle != 0) break;
                this.error(2);
                break;
            }
            case 16: {
                this.groupHandle = OS.gtk_radio_button_new(0);
                if (this.groupHandle == 0) {
                    this.error(2);
                }
                OS.g_object_ref(this.groupHandle);
                OS.gtk_object_sink(this.groupHandle);
                this.handle = OS.gtk_radio_button_new(OS.gtk_radio_button_get_group(this.groupHandle));
                if (this.handle != 0) break;
                this.error(2);
                break;
            }
            default: {
                this.handle = OS.gtk_button_new();
                if (this.handle == 0) {
                    this.error(2);
                }
                OS.GTK_WIDGET_SET_FLAGS(this.handle, 8192);
            }
        }
        if ((this.style & 4) != 0) {
            OS.gtk_container_add(this.handle, this.arrowHandle);
        } else {
            this.boxHandle = OS.gtk_hbox_new(false, 4);
            if (this.boxHandle == 0) {
                this.error(2);
            }
            this.labelHandle = OS.gtk_label_new_with_mnemonic(null);
            if (this.labelHandle == 0) {
                this.error(2);
            }
            this.imageHandle = OS.gtk_image_new();
            if (this.imageHandle == 0) {
                this.error(2);
            }
            OS.gtk_container_add(this.handle, this.boxHandle);
            OS.gtk_container_add(this.boxHandle, this.imageHandle);
            OS.gtk_container_add(this.boxHandle, this.labelHandle);
            if ((this.style & 0x40) != 0) {
                OS.gtk_label_set_line_wrap(this.labelHandle, true);
                if (OS.GTK_VERSION >= OS.VERSION(2, 10, 0)) {
                    OS.gtk_label_set_line_wrap_mode(this.labelHandle, 2);
                }
            }
        }
        OS.gtk_container_add(this.fixedHandle, this.handle);
        if ((this.style & 4) != 0) {
            return;
        }
        this._setAlignment(this.style & 0x1024000);
    }

    void createWidget(int index) {
        super.createWidget(index);
        this.text = "";
    }

    void deregister() {
        super.deregister();
        if (this.boxHandle != 0) {
            this.display.removeWidget(this.boxHandle);
        }
        if (this.labelHandle != 0) {
            this.display.removeWidget(this.labelHandle);
        }
        if (this.imageHandle != 0) {
            this.display.removeWidget(this.imageHandle);
        }
        if (this.arrowHandle != 0) {
            this.display.removeWidget(this.arrowHandle);
        }
    }

    int fontHandle() {
        if (this.labelHandle != 0) {
            return this.labelHandle;
        }
        return super.fontHandle();
    }

    public int getAlignment() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            if ((this.style & 0x80) != 0) {
                return 128;
            }
            if ((this.style & 0x400) != 0) {
                return 1024;
            }
            if ((this.style & 0x4000) != 0) {
                return 16384;
            }
            if ((this.style & 0x20000) != 0) {
                return 131072;
            }
            return 128;
        }
        if ((this.style & 0x4000) != 0) {
            return 16384;
        }
        if ((this.style & 0x1000000) != 0) {
            return 0x1000000;
        }
        if ((this.style & 0x20000) != 0) {
            return 131072;
        }
        return 16384;
    }

    public boolean getGrayed() {
        this.checkWidget();
        if ((this.style & 0x20) == 0) {
            return false;
        }
        return this.grayed;
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    String getNameText() {
        return this.getText();
    }

    public boolean getSelection() {
        this.checkWidget();
        if ((this.style & 0x32) == 0) {
            return false;
        }
        return OS.gtk_toggle_button_get_active(this.handle);
    }

    public String getText() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return "";
        }
        return this.text;
    }

    int gtk_button_press_event(int widget, int event) {
        int result = super.gtk_button_press_event(widget, event);
        if (result != 0) {
            return result;
        }
        if ((this.style & 0x10) != 0) {
            this.selected = this.getSelection();
        }
        return result;
    }

    int gtk_clicked(int widget) {
        if ((this.style & 0x10) != 0) {
            if ((this.parent.getStyle() & 0x400000) != 0) {
                this.setSelection(!this.selected);
            } else {
                this.selectRadio();
            }
        } else if ((this.style & 0x20) != 0 && this.grayed) {
            if (OS.gtk_toggle_button_get_active(this.handle)) {
                OS.gtk_toggle_button_set_inconsistent(this.handle, true);
            } else {
                OS.gtk_toggle_button_set_inconsistent(this.handle, false);
            }
        }
        this.sendSelectionEvent(13);
        return 0;
    }

    int gtk_focus_in_event(int widget, int event) {
        int result = super.gtk_focus_in_event(widget, event);
        if (this.handle == 0) {
            return 0;
        }
        if ((this.style & 8) != 0 && OS.GTK_WIDGET_HAS_DEFAULT(this.handle)) {
            Decorations menuShell = this.menuShell();
            menuShell.defaultButton = this;
        }
        return result;
    }

    int gtk_focus_out_event(int widget, int event) {
        int result = super.gtk_focus_out_event(widget, event);
        if (this.handle == 0) {
            return 0;
        }
        if ((this.style & 8) != 0 && !OS.GTK_WIDGET_HAS_DEFAULT(this.handle)) {
            Decorations menuShell = this.menuShell();
            if (menuShell.defaultButton == this) {
                menuShell.defaultButton = null;
            }
        }
        return result;
    }

    int gtk_key_press_event(int widget, int event) {
        int result = super.gtk_key_press_event(widget, event);
        if (result != 0) {
            return result;
        }
        if ((this.style & 0x10) != 0) {
            this.selected = this.getSelection();
        }
        return result;
    }

    void hookEvents() {
        super.hookEvents();
        OS.g_signal_connect_closure(this.handle, OS.clicked, this.display.closures[8], false);
        if (this.labelHandle != 0) {
            OS.g_signal_connect_closure_by_id(this.labelHandle, this.display.signalIds[32], 0, this.display.closures[32], false);
        }
    }

    boolean isDescribedByLabel() {
        return false;
    }

    boolean mnemonicHit(char key) {
        if (this.labelHandle == 0) {
            return false;
        }
        boolean result = super.mnemonicHit(this.labelHandle, key);
        if (result) {
            this.setFocus();
        }
        return result;
    }

    boolean mnemonicMatch(char key) {
        if (this.labelHandle == 0) {
            return false;
        }
        return this.mnemonicMatch(this.labelHandle, key);
    }

    void register() {
        super.register();
        if (this.boxHandle != 0) {
            this.display.addWidget(this.boxHandle, this);
        }
        if (this.labelHandle != 0) {
            this.display.addWidget(this.labelHandle, this);
        }
        if (this.imageHandle != 0) {
            this.display.addWidget(this.imageHandle, this);
        }
        if (this.arrowHandle != 0) {
            this.display.addWidget(this.arrowHandle, this);
        }
    }

    void releaseHandle() {
        super.releaseHandle();
        this.arrowHandle = 0;
        this.labelHandle = 0;
        this.imageHandle = 0;
        this.boxHandle = 0;
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.groupHandle != 0) {
            OS.g_object_unref(this.groupHandle);
        }
        this.groupHandle = 0;
        if (this.imageList != null) {
            this.imageList.dispose();
        }
        this.imageList = null;
        this.image = null;
        this.text = null;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    void resizeHandle(int width, int height) {
        super.resizeHandle(width, height);
        if ((this.style & 0x30) != 0) {
            OS.gtk_widget_set_size_request(this.boxHandle, width, -1);
        }
    }

    void selectRadio() {
        Control[] children = this.parent._getChildren();
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            if (this != child) {
                child.setRadioSelection(false);
            }
            ++i;
        }
        this.setSelection(true);
    }

    public void setAlignment(int alignment) {
        this.checkWidget();
        this._setAlignment(alignment);
    }

    void _setAlignment(int alignment) {
        boolean bothVisible;
        if ((this.style & 4) != 0) {
            if ((this.style & 0x24480) == 0) {
                return;
            }
            this.style &= 0xFFFDBB7F;
            this.style |= alignment & 0x24480;
            int arrow_type = 0;
            boolean isRTL = (this.style & 0x4000000) != 0;
            switch (alignment) {
                case 128: {
                    arrow_type = 0;
                    break;
                }
                case 1024: {
                    arrow_type = 1;
                    break;
                }
                case 16384: {
                    arrow_type = isRTL ? 3 : 2;
                    break;
                }
                case 131072: {
                    arrow_type = isRTL ? 2 : 3;
                }
            }
            OS.gtk_arrow_set(this.arrowHandle, arrow_type, 2);
            return;
        }
        if ((alignment & 0x1024000) == 0) {
            return;
        }
        this.style &= 0xFEFDBFFF;
        this.style |= alignment & 0x1024000;
        boolean bl = bothVisible = OS.GTK_WIDGET_VISIBLE(this.labelHandle) && OS.GTK_WIDGET_VISIBLE(this.imageHandle);
        if (bothVisible) {
            if ((this.style & 0x30) != 0) {
                alignment = 16384;
            }
            if ((this.style & 0xA) != 0) {
                alignment = 0x1000000;
            }
        }
        if ((alignment & 0x4000) != 0) {
            if (bothVisible) {
                OS.gtk_box_set_child_packing(this.boxHandle, this.labelHandle, false, false, 0, 0);
                OS.gtk_box_set_child_packing(this.boxHandle, this.imageHandle, false, false, 0, 0);
            }
            OS.gtk_misc_set_alignment(this.labelHandle, 0.0f, 0.5f);
            OS.gtk_label_set_justify(this.labelHandle, 0);
            OS.gtk_misc_set_alignment(this.imageHandle, 0.0f, 0.5f);
            return;
        }
        if ((alignment & 0x1000000) != 0) {
            if (bothVisible) {
                OS.gtk_box_set_child_packing(this.boxHandle, this.labelHandle, true, true, 0, 1);
                OS.gtk_box_set_child_packing(this.boxHandle, this.imageHandle, true, true, 0, 0);
                OS.gtk_misc_set_alignment(this.labelHandle, 0.0f, 0.5f);
                OS.gtk_misc_set_alignment(this.imageHandle, 1.0f, 0.5f);
            } else {
                OS.gtk_misc_set_alignment(this.labelHandle, 0.5f, 0.5f);
                OS.gtk_label_set_justify(this.labelHandle, 2);
                OS.gtk_misc_set_alignment(this.imageHandle, 0.5f, 0.5f);
            }
            return;
        }
        if ((alignment & 0x20000) != 0) {
            if (bothVisible) {
                OS.gtk_box_set_child_packing(this.boxHandle, this.labelHandle, false, false, 0, 1);
                OS.gtk_box_set_child_packing(this.boxHandle, this.imageHandle, false, false, 0, 1);
            }
            OS.gtk_misc_set_alignment(this.labelHandle, 1.0f, 0.5f);
            OS.gtk_label_set_justify(this.labelHandle, 1);
            OS.gtk_misc_set_alignment(this.imageHandle, 1.0f, 0.5f);
            return;
        }
    }

    void setBackgroundColor(GdkColor color) {
        super.setBackgroundColor(color);
        this.setBackgroundColor(this.fixedHandle, color);
        if (this.labelHandle != 0) {
            this.setBackgroundColor(this.labelHandle, color);
        }
        if (this.imageHandle != 0) {
            this.setBackgroundColor(this.imageHandle, color);
        }
    }

    int setBounds(int x, int y, int width, int height, boolean move, boolean resize) {
        boolean wrap;
        boolean bl = wrap = this.labelHandle != 0 && (this.style & 0x40) != 0 && (OS.GTK_WIDGET_FLAGS(this.labelHandle) & 0x100) != 0;
        if (wrap) {
            OS.gtk_widget_set_size_request(this.boxHandle, -1, -1);
        }
        int result = super.setBounds(x, y, width, height, move, resize);
        if (wrap) {
            GtkRequisition requisition;
            int boxWidth = OS.GTK_WIDGET_WIDTH(this.boxHandle);
            int boxHeight = OS.GTK_WIDGET_HEIGHT(this.boxHandle);
            int labelLayout = OS.gtk_label_get_layout(this.labelHandle);
            int pangoWidth = OS.pango_layout_get_width(labelLayout);
            OS.pango_layout_set_width(labelLayout, -1);
            int[] w = new int[1];
            int[] h = new int[1];
            OS.pango_layout_get_size(labelLayout, w, h);
            OS.pango_layout_set_width(labelLayout, pangoWidth);
            int imageWidth = 0;
            if (OS.GTK_WIDGET_VISIBLE(this.imageHandle)) {
                requisition = new GtkRequisition();
                OS.gtk_widget_size_request(this.imageHandle, requisition);
                imageWidth = requisition.width;
                int[] spacing = new int[1];
                OS.g_object_get(this.boxHandle, OS.spacing, spacing, 0);
                imageWidth += spacing[0];
            }
            OS.gtk_widget_set_size_request(this.labelHandle, Math.min(OS.PANGO_PIXELS(w[0]), boxWidth - imageWidth), -1);
            requisition = new GtkRequisition();
            OS.gtk_widget_size_request(this.boxHandle, requisition);
            GtkAllocation allocation = new GtkAllocation();
            allocation.x = OS.GTK_WIDGET_X(this.boxHandle);
            allocation.y = OS.GTK_WIDGET_Y(this.boxHandle);
            allocation.width = boxWidth;
            allocation.height = boxHeight;
            OS.gtk_widget_size_allocate(this.boxHandle, allocation);
        }
        return result;
    }

    void setFontDescription(int font) {
        super.setFontDescription(font);
        if (this.labelHandle != 0) {
            OS.gtk_widget_modify_font(this.labelHandle, font);
        }
        if (this.imageHandle != 0) {
            OS.gtk_widget_modify_font(this.imageHandle, font);
        }
    }

    boolean setRadioSelection(boolean value) {
        if ((this.style & 0x10) == 0) {
            return false;
        }
        if (this.getSelection() != value) {
            this.setSelection(value);
            this.sendSelectionEvent(13);
        }
        return true;
    }

    void setForegroundColor(GdkColor color) {
        super.setForegroundColor(color);
        this.setForegroundColor(this.fixedHandle, color);
        if (this.labelHandle != 0) {
            this.setForegroundColor(this.labelHandle, color);
        }
        if (this.imageHandle != 0) {
            this.setForegroundColor(this.imageHandle, color);
        }
    }

    public void setGrayed(boolean grayed) {
        this.checkWidget();
        if ((this.style & 0x20) == 0) {
            return;
        }
        this.grayed = grayed;
        if (grayed && OS.gtk_toggle_button_get_active(this.handle)) {
            OS.gtk_toggle_button_set_inconsistent(this.handle, true);
        } else {
            OS.gtk_toggle_button_set_inconsistent(this.handle, false);
        }
    }

    public void setImage(Image image) {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        if (this.imageList != null) {
            this.imageList.dispose();
        }
        this.imageList = null;
        if (image != null) {
            if (image.isDisposed()) {
                this.error(5);
            }
            this.imageList = new ImageList();
            int imageIndex = this.imageList.add(image);
            int pixbuf = this.imageList.getPixbuf(imageIndex);
            OS.gtk_image_set_from_pixbuf(this.imageHandle, pixbuf);
            if (this.text.length() == 0) {
                OS.gtk_widget_hide(this.labelHandle);
            }
            OS.gtk_widget_show(this.imageHandle);
        } else {
            OS.gtk_image_set_from_pixbuf(this.imageHandle, 0);
            OS.gtk_widget_show(this.labelHandle);
            OS.gtk_widget_hide(this.imageHandle);
        }
        this.image = image;
        this._setAlignment(this.style);
    }

    void setOrientation() {
        super.setOrientation();
        if ((this.style & 0x4000000) != 0) {
            if (this.boxHandle != 0) {
                OS.gtk_widget_set_direction(this.boxHandle, 2);
            }
            if (this.labelHandle != 0) {
                OS.gtk_widget_set_direction(this.labelHandle, 2);
            }
            if (this.imageHandle != 0) {
                OS.gtk_widget_set_direction(this.imageHandle, 2);
            }
            if (this.arrowHandle != 0) {
                switch (this.style & 0x24000) {
                    case 16384: {
                        OS.gtk_arrow_set(this.arrowHandle, 3, 2);
                        break;
                    }
                    case 131072: {
                        OS.gtk_arrow_set(this.arrowHandle, 2, 2);
                    }
                }
            }
        }
    }

    public void setSelection(boolean selected) {
        this.checkWidget();
        if ((this.style & 0x32) == 0) {
            return;
        }
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 8);
        OS.gtk_toggle_button_set_active(this.handle, selected);
        if ((this.style & 0x20) != 0) {
            if (selected && this.grayed) {
                OS.gtk_toggle_button_set_inconsistent(this.handle, true);
            } else {
                OS.gtk_toggle_button_set_inconsistent(this.handle, false);
            }
        }
        if ((this.style & 0x10) != 0) {
            OS.gtk_toggle_button_set_active(this.groupHandle, !selected);
        }
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 8);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 4) != 0) {
            return;
        }
        this.text = string;
        char[] chars = this.fixMnemonic(string);
        byte[] buffer = Converter.wcsToMbcs(null, chars, true);
        OS.gtk_label_set_text_with_mnemonic(this.labelHandle, buffer);
        if (this.image == null) {
            OS.gtk_widget_hide(this.imageHandle);
        }
        OS.gtk_widget_show(this.labelHandle);
        this._setAlignment(this.style);
    }

    void showWidget() {
        super.showWidget();
        if (this.boxHandle != 0) {
            OS.gtk_widget_show(this.boxHandle);
        }
        if (this.labelHandle != 0) {
            OS.gtk_widget_show(this.labelHandle);
        }
        if (this.arrowHandle != 0) {
            OS.gtk_widget_show(this.arrowHandle);
        }
    }

    int traversalCode(int key, GdkEventKey event) {
        int code = super.traversalCode(key, event);
        if ((this.style & 4) != 0) {
            code &= 0xFFFFFFE7;
        }
        if ((this.style & 0x10) != 0) {
            code |= 0x60;
        }
        return code;
    }
}

