/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.browser;

import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.program.Program;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.browser.AbstractWebBrowser;
import org.eclipse.ui.internal.browser.Messages;
import org.eclipse.ui.internal.browser.Trace;

public class SystemBrowserInstance
extends AbstractWebBrowser {
    public SystemBrowserInstance(String id) {
        super(id);
    }

    public void openURL(URL url) throws PartInitException {
        String urlText = null;
        if (url != null) {
            try {
                urlText = URIUtil.toURI((URL)url).toASCIIString();
            }
            catch (URISyntaxException uRISyntaxException) {
                urlText = url.toExternalForm();
            }
        }
        Trace.trace(Trace.FINEST, "Launching system Web browser: " + urlText);
        Program program = Program.findProgram((String)"html");
        if (program != null && program.execute(urlText)) {
            return;
        }
        if (!Program.launch((String)urlText)) {
            throw new PartInitException(NLS.bind((String)Messages.errorCouldNotLaunchWebBrowser, (Object)url.toExternalForm()));
        }
    }
}

