/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Random;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.internal.views.markers.ViewerSettingsAndStatusDialog;
import org.eclipse.ui.views.markers.internal.MarkerMessages;

abstract class ViewerColumnsDialog
extends ViewerSettingsAndStatusDialog {
    private List visible;
    private List nonVisible;
    private TableViewer visibleViewer;
    private TableViewer nonVisibleViewer;
    private Button upButton;
    private Button downButton;
    private Button toVisibleBtt;
    private Button toNonVisibleBtt;
    private Text widthText;
    Listener postiveIntTextListener = new Listener(){
        private String intialValue;

        public void handleEvent(Event event) {
            this.intialValue = this.intialValue != null ? this.intialValue : Integer.toString(0);
            this.intialValue = ViewerColumnsDialog.this.handleIntegerFieldChange(event, this.intialValue);
        }
    };

    ViewerColumnsDialog(Shell parentShell) {
        super(parentShell);
    }

    void setColumnsObjs(Object[] columnObjs) {
        IColumnInfoProvider columnInfo = this.doGetColumnInfoProvider();
        IColumnUpdater updater = this.doGetColumnUpdater();
        List visible = this.getVisible();
        List nonVisible = this.getNonVisible();
        visible.clear();
        nonVisible.clear();
        Object data = null;
        int i = 0;
        while (i < columnObjs.length) {
            data = columnObjs[i];
            if (columnInfo.isColumnVisible(data)) {
                updater.setColumnVisible(data, true);
                updater.setColumnIndex(data, visible.size());
                visible.add(data);
            } else {
                updater.setColumnVisible(data, false);
                updater.setColumnIndex(data, nonVisible.size());
                nonVisible.add(data);
            }
            ++i;
        }
    }

    protected Control createDialogContentArea(Composite dialogArea) {
        return this.createColumnsArea(dialogArea);
    }

    Control createColumnsArea(Composite dialogArea) {
        Group columnArea = new Group(dialogArea, 0);
        columnArea.setLayout((Layout)new GridLayout(4, false));
        GridData gData = new GridData(1808);
        columnArea.setLayoutData((Object)gData);
        columnArea.setText(MarkerMessages.MarkerPreferences_ColumnGroupTitle);
        this.createInvisibleTable((Composite)columnArea);
        this.createMoveButtons((Composite)columnArea);
        this.createVisibleTable((Composite)columnArea);
        this.createUpDownBtt((Composite)columnArea);
        this.createWidthArea((Composite)columnArea);
        return columnArea;
    }

    Control createUpDownBtt(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.horizontalSpacing = 0;
        layout.marginRight = -1;
        layout.marginLeft = -1;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(264));
        this.upButton = new Button(composite, 8);
        this.upButton.setText(JFaceResources.getString((String)"ConfigureColumnsDialog_up"));
        this.upButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ViewerColumnsDialog.this.handleUpButton(event);
            }
        });
        this.upButton.setLayoutData((Object)new GridData(768));
        this.upButton.setEnabled(false);
        this.downButton = new Button(composite, 8);
        this.downButton.setText(JFaceResources.getString((String)"ConfigureColumnsDialog_down"));
        this.downButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ViewerColumnsDialog.this.handleDownButton(event);
            }
        });
        this.downButton.setLayoutData((Object)new GridData(768));
        this.downButton.setEnabled(false);
        return composite;
    }

    Control createWidthArea(Composite parent) {
        Label widthLabel = new Label(parent, 0);
        widthLabel.setText(JFaceResources.getString((String)"ConfigureColumnsDialog_WidthOfSelectedColumn"));
        GridData gridData = new GridData(896);
        gridData.horizontalSpan = 3;
        widthLabel.setLayoutData((Object)gridData);
        this.widthText = new Text(parent, 2052);
        this.widthText.setText(Integer.toString(0));
        gridData = new GridData(832);
        gridData.widthHint = this.convertWidthInCharsToPixels(5);
        this.widthText.setLayoutData((Object)gridData);
        this.widthText.addListener(24, this.postiveIntTextListener);
        this.widthText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                if (ViewerColumnsDialog.this.widthText.isEnabled()) {
                    try {
                        int width = Integer.parseInt(ViewerColumnsDialog.this.widthText.getText().trim());
                        Object data = ((IStructuredSelection)ViewerColumnsDialog.this.visibleViewer.getSelection()).getFirstElement();
                        if (data != null) {
                            IColumnUpdater updater = ViewerColumnsDialog.this.getColumnUpdater();
                            updater.setColumnWidth(data, width);
                        }
                    }
                    catch (Exception exception) {
                        return;
                    }
                }
            }
        });
        this.widthText.setText("");
        this.widthText.setEditable(false);
        return this.widthText;
    }

    Control createVisibleTable(Composite parent) {
        final Table table = new Table(parent, 2050);
        GridData data = new GridData(4, 4, true, true);
        data.widthHint = this.convertWidthInCharsToPixels(30);
        data.heightHint = table.getItemHeight() * 15;
        table.setLayoutData((Object)data);
        table.setHeaderVisible(true);
        final TableColumn column = new TableColumn(table, 0);
        column.setText(MarkerMessages.MarkerPreferences_VisibleColumnsTitle);
        Listener columnResize = new Listener(){

            public void handleEvent(Event event) {
                column.setWidth(table.getClientArea().width);
            }
        };
        table.addListener(11, columnResize);
        this.visibleViewer = new TableViewer(table);
        this.visibleViewer.setLabelProvider((IBaseLabelProvider)this.doGetLabelProvider());
        this.visibleViewer.setContentProvider((IContentProvider)new ContentProviderAdapter(){

            public Object[] getElements(Object inputElement) {
                return ViewerColumnsDialog.this.getVisible().toArray();
            }
        });
        this.visibleViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ViewerColumnsDialog.this.handleVisibleSelection(event.getSelection());
            }
        });
        table.addListener(8, new Listener(){

            public void handleEvent(Event event) {
                ViewerColumnsDialog.this.handleToNonVisibleButton(event);
            }
        });
        this.visibleViewer.setInput((Object)this);
        return table;
    }

    Control createInvisibleTable(Composite parent) {
        final Table table = new Table(parent, 2050);
        GridData data = new GridData(4, 4, true, true);
        data.widthHint = this.convertWidthInCharsToPixels(30);
        data.heightHint = table.getItemHeight() * 15;
        table.setLayoutData((Object)data);
        table.setHeaderVisible(true);
        final TableColumn column = new TableColumn(table, 0);
        column.setText(MarkerMessages.MarkerPreferences_HiddenColumnsTitle);
        Listener columnResize = new Listener(){

            public void handleEvent(Event event) {
                column.setWidth(table.getClientArea().width);
            }
        };
        table.addListener(11, columnResize);
        this.nonVisibleViewer = new TableViewer(table);
        this.nonVisibleViewer.setLabelProvider((IBaseLabelProvider)this.doGetLabelProvider());
        this.nonVisibleViewer.setContentProvider((IContentProvider)new ContentProviderAdapter(){

            public Object[] getElements(Object inputElement) {
                return ViewerColumnsDialog.this.getNonVisible().toArray();
            }
        });
        this.nonVisibleViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ViewerColumnsDialog.this.handleNonVisibleSelection(event.getSelection());
            }
        });
        table.addListener(8, new Listener(){

            public void handleEvent(Event event) {
                ViewerColumnsDialog.this.handleToVisibleButton(event);
            }
        });
        this.nonVisibleViewer.setInput((Object)this);
        return table;
    }

    Control createMoveButtons(Composite parent) {
        Composite bttArea = new Composite(parent, 0);
        bttArea.setLayout((Layout)new GridLayout(1, true));
        bttArea.setLayoutData((Object)new GridData(1040));
        this.toNonVisibleBtt = new Button(bttArea, 8);
        this.toNonVisibleBtt.setText(ViewerColumnsDialog.getDefaultOrientation() == 0x4000000 ? MarkerMessages.MarkerPreferences_MoveRight : MarkerMessages.MarkerPreferences_MoveLeft);
        this.toNonVisibleBtt.setLayoutData((Object)new GridData());
        this.toNonVisibleBtt.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ViewerColumnsDialog.this.handleToNonVisibleButton(event);
            }
        });
        this.toNonVisibleBtt.setEnabled(false);
        this.toVisibleBtt = new Button(bttArea, 8);
        this.toVisibleBtt.setText(ViewerColumnsDialog.getDefaultOrientation() == 0x4000000 ? MarkerMessages.MarkerPreferences_MoveLeft : MarkerMessages.MarkerPreferences_MoveRight);
        this.toVisibleBtt.setLayoutData((Object)new GridData());
        this.toVisibleBtt.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ViewerColumnsDialog.this.handleToVisibleButton(event);
            }
        });
        this.toVisibleBtt.setEnabled(false);
        return bttArea;
    }

    String handleIntegerFieldChange(Event event, String intialvalue) {
        String value = ((Text)event.widget).getText().trim();
        boolean editable = ((Text)event.widget).getEditable();
        switch (event.type) {
            case 1: 
            case 16: 
            case 24: {
                if (!editable) {
                    this.handleStatusUdpate(1, null);
                    break;
                }
                if (value.length() == 0) {
                    this.handleStatusUdpate(4, null);
                    break;
                }
                try {
                    int number = Integer.parseInt(value);
                    if (number > 0) {
                        this.handleStatusUdpate(1, null);
                        break;
                    }
                    value = intialvalue;
                    ((Text)event.widget).selectAll();
                    this.handleStatusUdpate(4, this.getErrorMessage());
                    break;
                }
                catch (Exception exception) {
                    value = intialvalue;
                    ((Text)event.widget).selectAll();
                    this.handleStatusUdpate(4, this.getErrorMessage());
                }
            }
        }
        return value;
    }

    void handleNonVisibleSelection(ISelection selection) {
        Object[] nvKeys = ((IStructuredSelection)selection).toArray();
        this.toVisibleBtt.setEnabled(nvKeys.length > 0);
        if (this.visibleViewer.getControl().isFocusControl() && this.getVisible().size() <= 1) {
            this.handleStatusUdpate(1, MarkerMessages.MarkerPreferences_AtLeastOneVisibleColumn);
        } else {
            this.handleStatusUdpate(1, this.getDefaultMessage());
        }
    }

    void handleVisibleSelection(ISelection selection) {
        List selVCols = ((IStructuredSelection)selection).toList();
        List allVCols = this.getVisible();
        this.toNonVisibleBtt.setEnabled(selVCols.size() > 0 && allVCols.size() > selVCols.size());
        IColumnInfoProvider infoProvider = this.doGetColumnInfoProvider();
        boolean moveDown = !selVCols.isEmpty();
        boolean moveUp = !selVCols.isEmpty();
        Iterator iterator = selVCols.iterator();
        while (iterator.hasNext()) {
            Object columnObj = iterator.next();
            if (!infoProvider.isColumnMovable(columnObj)) {
                moveUp = false;
                moveDown = false;
                break;
            }
            int i = allVCols.indexOf(columnObj);
            if (i == 0) {
                moveUp = false;
                if (!moveDown) break;
            }
            if (i != allVCols.size() - 1) continue;
            moveDown = false;
            if (!moveUp) break;
        }
        this.upButton.setEnabled(moveUp);
        this.downButton.setEnabled(moveDown);
        boolean edit = selVCols.size() == 1 ? infoProvider.isColumnResizable(selVCols.get(0)) : false;
        this.widthText.setEditable(edit);
        if (edit) {
            this.widthText.setText(Integer.toString(infoProvider.getColumnWidth(selVCols.get(0))));
        } else {
            this.widthText.setText("");
        }
    }

    void handleDownButton(Event e) {
        IStructuredSelection selection = (IStructuredSelection)this.visibleViewer.getSelection();
        Object[] selVCols = selection.toArray();
        List allVCols = this.getVisible();
        IColumnUpdater updater = this.doGetColumnUpdater();
        int i = selVCols.length - 1;
        while (i >= 0) {
            Object colObj = selVCols[i];
            int index = allVCols.indexOf(colObj);
            updater.setColumnIndex(colObj, index + 1);
            allVCols.remove(index);
            allVCols.add(index + 1, colObj);
            --i;
        }
        this.visibleViewer.refresh();
        this.handleVisibleSelection((ISelection)selection);
    }

    void handleUpButton(Event e) {
        IStructuredSelection selection = (IStructuredSelection)this.visibleViewer.getSelection();
        Object[] selVCols = selection.toArray();
        List allVCols = this.getVisible();
        IColumnUpdater updater = this.doGetColumnUpdater();
        int i = 0;
        while (i < selVCols.length) {
            Object colObj = selVCols[i];
            int index = allVCols.indexOf(colObj);
            updater.setColumnIndex(colObj, index - 1);
            allVCols.remove(index);
            allVCols.add(index - 1, colObj);
            ++i;
        }
        this.visibleViewer.refresh();
        this.handleVisibleSelection((ISelection)selection);
    }

    void handleToVisibleButton(Event e) {
        IStructuredSelection selection = (IStructuredSelection)this.nonVisibleViewer.getSelection();
        List selVCols = selection.toList();
        List nonVisible = this.getNonVisible();
        nonVisible.removeAll(selVCols);
        List list = this.getVisible();
        list.addAll(selVCols);
        this.updateVisibility(selVCols, true);
        this.updateIndices(this.getVisible());
        this.updateIndices(this.getNonVisible());
        this.visibleViewer.refresh();
        this.visibleViewer.setSelection((ISelection)selection);
        this.nonVisibleViewer.refresh();
        this.handleVisibleSelection((ISelection)selection);
        this.handleNonVisibleSelection(this.nonVisibleViewer.getSelection());
    }

    protected void handleToNonVisibleButton(Event e) {
        if (this.visibleViewer.getControl().isFocusControl() && this.getVisible().size() <= 1) {
            this.handleStatusUdpate(1, MarkerMessages.MarkerPreferences_AtLeastOneVisibleColumn);
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)this.visibleViewer.getSelection();
        List selVCols = selection.toList();
        this.getVisible().removeAll(selVCols);
        this.getNonVisible().addAll(selVCols);
        this.updateVisibility(selVCols, false);
        this.updateIndices(this.getVisible());
        this.updateIndices(this.getNonVisible());
        this.nonVisibleViewer.refresh();
        this.nonVisibleViewer.setSelection((ISelection)selection);
        this.visibleViewer.refresh();
        this.handleVisibleSelection(this.visibleViewer.getSelection());
        this.handleNonVisibleSelection(this.nonVisibleViewer.getSelection());
    }

    void updateIndices(List list) {
        ListIterator iterator = list.listIterator();
        IColumnUpdater updater = this.doGetColumnUpdater();
        while (iterator.hasNext()) {
            updater.setColumnIndex(iterator.next(), iterator.previousIndex());
        }
    }

    void updateVisibility(List list, boolean visibility) {
        IColumnUpdater updater = this.doGetColumnUpdater();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            updater.setColumnVisible(iterator.next(), visibility);
        }
    }

    protected void performDefaults() {
        this.refreshViewers();
        super.performDefaults();
    }

    void refreshViewers() {
        if (this.nonVisibleViewer != null) {
            this.nonVisibleViewer.refresh();
        }
        if (this.visibleViewer != null) {
            this.visibleViewer.refresh();
        }
    }

    public List getVisible() {
        if (this.visible == null) {
            this.visible = new ArrayList();
        }
        return this.visible;
    }

    public List getNonVisible() {
        if (this.nonVisible == null) {
            this.nonVisible = new ArrayList();
        }
        return this.nonVisible;
    }

    ITableLabelProvider doGetLabelProvider() {
        return this.getLabelProvider();
    }

    protected abstract ITableLabelProvider getLabelProvider();

    IColumnInfoProvider doGetColumnInfoProvider() {
        return this.getColumnInfoProvider();
    }

    protected abstract IColumnInfoProvider getColumnInfoProvider();

    IColumnUpdater doGetColumnUpdater() {
        return this.getColumnUpdater();
    }

    protected abstract IColumnUpdater getColumnUpdater();

    abstract class ContentProviderAdapter
    implements IStructuredContentProvider {
        ContentProviderAdapter() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public static interface IColumnInfoProvider {
        public int getColumnIndex(Object var1);

        public int getColumnWidth(Object var1);

        public boolean isColumnVisible(Object var1);

        public boolean isColumnMovable(Object var1);

        public boolean isColumnResizable(Object var1);
    }

    public static interface IColumnUpdater {
        public void setColumnVisible(Object var1, boolean var2);

        public void setColumnMovable(Object var1, boolean var2);

        public void setColumnIndex(Object var1, int var2);

        public void setColumnResizable(Object var1, boolean var2);

        public void setColumnWidth(Object var1, int var2);
    }

    class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        TableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            return this.getText(element);
        }
    }

    static class TestData {
        final Object key;
        final int keyIndex;
        int newIndex;
        int width;
        boolean visibility;
        boolean movable;
        boolean resizable;

        TestData(Object key, int currIndex) {
            this.key = key;
            this.keyIndex = currIndex;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
            result = 31 * result + this.keyIndex;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof TestData)) {
                return false;
            }
            TestData other = (TestData)obj;
            if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
                return false;
            }
            return this.keyIndex == other.keyIndex;
        }

        public String toString() {
            return this.key.toString();
        }

        private static ViewerColumnsDialog getColumnsDialog(Shell shell, TestData[] colums) {
            ViewerColumnsDialog dialog = new ViewerColumnsDialog(shell, colums){
                private final /* synthetic */ TestData[] val$colums;
                {
                    this.val$colums = testDataArray;
                }

                protected IColumnInfoProvider getColumnInfoProvider() {
                    return TestData.access$0(this.val$colums);
                }

                protected ITableLabelProvider getLabelProvider() {
                    return new TableLabelProvider();
                }

                protected IColumnUpdater getColumnUpdater() {
                    return TestData.access$1(this.val$colums);
                }
            };
            dialog.setColumnsObjs(colums);
            return dialog;
        }

        private static IColumnUpdater getUpdater(TestData[] data) {
            return new IColumnUpdater(){

                public void setColumnWidth(Object columnObj, int newWidth) {
                    ((TestData)columnObj).width = newWidth;
                }

                public void setColumnVisible(Object columnObj, boolean visible) {
                    ((TestData)columnObj).visibility = visible;
                }

                public void setColumnResizable(Object columnObj, boolean resizable) {
                }

                public void setColumnMovable(Object columnObj, boolean movable) {
                    ((TestData)columnObj).movable = movable;
                }

                public void setColumnIndex(Object columnObj, int index) {
                    ((TestData)columnObj).newIndex = index;
                }
            };
        }

        private static IColumnInfoProvider getInfoProvider(TestData[] colData) {
            return new IColumnInfoProvider(){

                public boolean isColumnVisible(Object columnObj) {
                    return ((TestData)columnObj).visibility;
                }

                public boolean isColumnResizable(Object columnObj) {
                    return ((TestData)columnObj).resizable;
                }

                public boolean isColumnMovable(Object columnObj) {
                    return ((TestData)columnObj).movable;
                }

                public int getColumnWidth(Object columnObj) {
                    return ((TestData)columnObj).width;
                }

                public int getColumnIndex(Object columnObj) {
                    return ((TestData)columnObj).newIndex;
                }
            };
        }

        private static TestData[] genData(int count) {
            Object[] cols = new String[count];
            int i = 0;
            while (i < cols.length) {
                cols[i] = new String("Column-" + (i + 1));
                ++i;
            }
            Random random = new Random();
            boolean[] visibility = new boolean[cols.length];
            Arrays.fill(visibility, true);
            int ranInt = random.nextInt() % cols.length;
            int i2 = 0;
            while (i2 < ranInt) {
                visibility[random.nextInt((int)ranInt)] = false;
                ++i2;
            }
            boolean[] resizable = new boolean[cols.length];
            Arrays.fill(resizable, true);
            ranInt = random.nextInt() % cols.length;
            int i3 = 0;
            while (i3 < ranInt) {
                resizable[random.nextInt((int)ranInt)] = false;
                ++i3;
            }
            boolean[] movable = new boolean[cols.length];
            Arrays.fill(movable, true);
            ranInt = random.nextInt() % cols.length;
            int i4 = 0;
            while (i4 < ranInt) {
                movable[random.nextInt((int)ranInt)] = false;
                ++i4;
            }
            int[] widths = new int[cols.length];
            Arrays.fill(widths, 100);
            return TestData.generateColumnsData(cols, visibility, resizable, movable, widths);
        }

        public static TestData[] generateColumnsData(Object[] keys, boolean[] visibility, boolean[] resizable, boolean[] movable, int[] widths) {
            TestData[] colData = new TestData[keys.length];
            int m = 0;
            int n = 0;
            int i = 0;
            while (i < colData.length) {
                TestData data = new TestData(keys[i], i);
                data.visibility = visibility[i];
                data.resizable = resizable[i];
                data.movable = movable[i];
                data.width = widths[i];
                data.newIndex = data.visibility ? m++ : n++;
                colData[i] = data;
                ++i;
            }
            return colData;
        }

        public static void main(String[] args) {
            Display display = new Display();
            Shell shell = new Shell(display);
            shell.setLayout((Layout)new FillLayout());
            ViewerColumnsDialog dialog = TestData.getColumnsDialog(shell, TestData.genData(100));
            dialog.open();
            shell.dispose();
            while (!shell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            display.dispose();
        }

        static /* synthetic */ IColumnInfoProvider access$0(TestData[] testDataArray) {
            return TestData.getInfoProvider(testDataArray);
        }

        static /* synthetic */ IColumnUpdater access$1(TestData[] testDataArray) {
            return TestData.getUpdater(testDataArray);
        }
    }
}

