/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.CommandManager;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.contexts.ContextManager;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.commands.MBindingContext;
import org.eclipse.e4.ui.model.application.commands.MBindingTable;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.commands.MKeyBinding;
import org.eclipse.e4.ui.model.application.commands.MParameter;
import org.eclipse.e4.ui.model.application.commands.impl.CommandsFactoryImpl;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.BindingManager;
import org.eclipse.ui.internal.commands.CommandPersistence;
import org.eclipse.ui.internal.contexts.ContextPersistence;
import org.eclipse.ui.internal.keys.BindingPersistence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindingToModelProcessor {
    private Map<String, MBindingContext> contexts = new HashMap<String, MBindingContext>();
    private Map<String, MCommand> commands = new HashMap<String, MCommand>();
    private Map<String, MBindingTable> tables = new HashMap<String, MBindingTable>();

    @Execute
    void process(MApplication application) {
        this.gatherContexts(application.getRootContext());
        this.gatherCommands(application.getCommands());
        this.gatherTables(application.getBindingTables());
        CommandManager commandManager = new CommandManager();
        CommandPersistence commandPersistence = new CommandPersistence(commandManager);
        commandPersistence.reRead();
        ContextManager contextManager = new ContextManager();
        ContextPersistence contextPersistence = new ContextPersistence(contextManager);
        contextPersistence.reRead();
        BindingManager bindingManager = new BindingManager(contextManager, commandManager);
        BindingPersistence persistence = new BindingPersistence(bindingManager, commandManager);
        persistence.read();
        for (Binding binding : bindingManager.getActiveBindingsDisregardingContextFlat()) {
            this.addBinding(application, binding);
        }
        persistence.dispose();
    }

    private void gatherTables(List<MBindingTable> bindingTables) {
        for (MBindingTable table : bindingTables) {
            this.tables.put(table.getBindingContextId(), table);
        }
    }

    public final void addBinding(MApplication application, Binding binding) {
        MBindingTable table = this.tables.get(binding.getContextId());
        if (table == null) {
            table = this.createTable(application, binding.getContextId());
        }
        MKeyBinding keyBinding = CommandsFactoryImpl.eINSTANCE.createKeyBinding();
        ParameterizedCommand parmCmd = binding.getParameterizedCommand();
        MCommand cmd = this.commands.get(parmCmd.getId());
        if (cmd == null) {
            return;
        }
        keyBinding.setCommand(cmd);
        keyBinding.setKeySequence(binding.getTriggerSequence().format());
        Iterator iterator = parmCmd.getParameterMap().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry obj;
            Map.Entry entry = obj = iterator.next();
            MParameter p = CommandsFactoryImpl.eINSTANCE.createParameter();
            p.setElementId((String)entry.getKey());
            p.setName((String)entry.getKey());
            p.setValue((String)entry.getValue());
            keyBinding.getParameters().add(p);
        }
        table.getBindings().add(keyBinding);
    }

    private MBindingTable createTable(MApplication application, String contextId) {
        MBindingTable table = CommandsFactoryImpl.eINSTANCE.createBindingTable();
        table.setBindingContextId(contextId);
        table.setElementId(contextId);
        application.getBindingTables().add(table);
        this.tables.put(table.getBindingContextId(), table);
        return table;
    }

    private void gatherCommands(List<MCommand> commandList) {
        for (MCommand cmd : commandList) {
            this.commands.put(cmd.getElementId(), cmd);
        }
    }

    private void gatherContexts(List<MBindingContext> contextList) {
        for (MBindingContext ctx : contextList) {
            this.gatherContexts(ctx);
        }
    }

    private void gatherContexts(MBindingContext ctx) {
        if (ctx == null) {
            return;
        }
        this.contexts.put(ctx.getElementId(), ctx);
        this.gatherContexts(ctx.getChildren());
    }
}

