/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.internal.provisional.action.ICoolBarManager2;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableEditor;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.internal.EditorActionBars;
import org.eclipse.ui.internal.EditorActionBuilder;
import org.eclipse.ui.internal.EditorSite;
import org.eclipse.ui.internal.ErrorEditorPart;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPartReference;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.editorsupport.ComponentSupport;
import org.eclipse.ui.internal.part.NullEditorInput;
import org.eclipse.ui.internal.registry.EditorDescriptor;
import org.eclipse.ui.internal.util.Util;

public class EditorReference
extends WorkbenchPartReference
implements IEditorReference {
    private IEditorInput input;
    private EditorDescriptor descriptor;
    private EditorSite editorSite;
    private String descriptorId;
    private IMemento editorState;
    private static HashMap<String, Set<EditorActionBars>> actionCache = new HashMap();

    EditorReference(IEclipseContext windowContext, IWorkbenchPage page, MPart part, IEditorInput input, EditorDescriptor descriptor, IMemento editorState) {
        block7: {
            super(windowContext, page, part);
            this.input = input;
            this.descriptor = descriptor;
            this.editorState = editorState;
            if (descriptor == null) {
                try {
                    String memento = (String)this.getModel().getPersistedState().get(MEMENTO_KEY);
                    if (memento == null) {
                        this.descriptorId = "org.eclipse.ui.internal.emptyEditorTab";
                    } else {
                        XMLMemento createReadRoot = XMLMemento.createReadRoot(new StringReader(memento));
                        IEditorRegistry registry = this.getPage().getWorkbenchWindow().getWorkbench().getEditorRegistry();
                        this.descriptorId = createReadRoot.getString("id");
                        this.descriptor = (EditorDescriptor)registry.findEditor(this.descriptorId);
                    }
                    if (this.descriptor == null) {
                        this.setImageDescriptor(ImageDescriptor.getMissingImageDescriptor());
                        break block7;
                    }
                    this.setImageDescriptor(this.descriptor.getImageDescriptor());
                }
                catch (WorkbenchException e) {
                    WorkbenchPlugin.log((Throwable)((Object)e));
                }
            } else {
                this.descriptorId = this.descriptor.getId();
                this.setImageDescriptor(this.descriptor.getImageDescriptor());
            }
        }
    }

    boolean persist() {
        IEditorInput input;
        IEditorPart editor = this.getEditor(false);
        IEditorInput iEditorInput = input = editor == null ? this.input : editor.getEditorInput();
        if (input == null) {
            return false;
        }
        IPersistableElement persistable = input.getPersistable();
        if (persistable == null) {
            return false;
        }
        XMLMemento root = XMLMemento.createWriteRoot("editor");
        root.putString("id", this.descriptor.getId());
        IMemento inputMem = root.createChild("input");
        inputMem.putString("factoryID", persistable.getFactoryId());
        persistable.saveState(inputMem);
        if (editor instanceof IPersistableEditor) {
            IMemento editorStateMem = root.createChild("editorState");
            ((IPersistableEditor)((Object)editor)).saveState(editorStateMem);
        }
        StringWriter writer = new StringWriter();
        try {
            root.save(writer);
            this.getModel().getPersistedState().put(MEMENTO_KEY, writer.toString());
        }
        catch (IOException e) {
            WorkbenchPlugin.log(e);
            return false;
        }
        return true;
    }

    public EditorDescriptor getDescriptor() {
        return this.descriptor;
    }

    public String getId() {
        return this.descriptorId;
    }

    public String getFactoryId() {
        IEditorPart editor = this.getEditor(false);
        if (editor == null) {
            if (this.input == null) {
                String memento = (String)this.getModel().getPersistedState().get(MEMENTO_KEY);
                if (memento != null) {
                    try {
                        XMLMemento createReadRoot = XMLMemento.createReadRoot(new StringReader(memento));
                        IMemento inputMem = createReadRoot.getChild("input");
                        if (inputMem != null) {
                            return inputMem.getString("factoryID");
                        }
                    }
                    catch (WorkbenchException workbenchException) {
                        return null;
                    }
                }
                return null;
            }
            IPersistableElement persistable = this.input.getPersistable();
            return persistable == null ? null : persistable.getFactoryId();
        }
        IPersistableElement persistable = editor.getEditorInput().getPersistable();
        return persistable == null ? null : persistable.getFactoryId();
    }

    public String getName() {
        IEditorPart editor = this.getEditor(false);
        if (this.input == null) {
            return editor == null ? this.getModel().getLabel() : editor.getEditorInput().getName();
        }
        return editor == null ? this.input.getName() : editor.getEditorInput().getName();
    }

    public String getTitle() {
        String label = Util.safeString(this.getModel().getLabel());
        if (label.length() == 0) {
            if (this.input == null) {
                if (this.descriptor != null) {
                    return this.descriptor.getLabel();
                }
            } else {
                return Util.safeString(this.input.getName());
            }
        }
        return label;
    }

    private IEditorInput restoreInput(IMemento editorMem) throws PartInitException {
        IMemento inputMem = editorMem.getChild("input");
        String factoryID = null;
        if (inputMem != null) {
            factoryID = inputMem.getString("factoryID");
        }
        if (factoryID == null) {
            throw new PartInitException(NLS.bind((String)WorkbenchMessages.EditorManager_no_input_factory_ID, (Object)this.getId(), (Object)this.getName()));
        }
        IAdaptable input = null;
        IElementFactory factory = PlatformUI.getWorkbench().getElementFactory(factoryID);
        if (factory == null) {
            throw new PartInitException(NLS.bind((String)WorkbenchMessages.EditorManager_bad_element_factory, (Object[])new Object[]{factoryID, this.getId(), this.getName()}));
        }
        input = factory.createElement(inputMem);
        if (input == null) {
            throw new PartInitException(NLS.bind((String)WorkbenchMessages.EditorManager_create_element_returned_null, (Object[])new Object[]{factoryID, this.getId(), this.getName()}));
        }
        if (!(input instanceof IEditorInput)) {
            throw new PartInitException(NLS.bind((String)WorkbenchMessages.EditorManager_wrong_createElement_result, (Object[])new Object[]{factoryID, this.getId(), this.getName()}));
        }
        return (IEditorInput)input;
    }

    public IEditorPart getEditor(boolean restore) {
        return (IEditorPart)this.getPart(restore);
    }

    public boolean isPinned() {
        return false;
    }

    public IEditorInput getEditorInput() throws PartInitException {
        IEditorPart editor = this.getEditor(false);
        if (editor != null) {
            return editor.getEditorInput();
        }
        if (this.input == null) {
            String memento = (String)this.getModel().getPersistedState().get(MEMENTO_KEY);
            if (memento == null) {
                this.input = new NullEditorInput();
            } else {
                try {
                    XMLMemento createReadRoot = XMLMemento.createReadRoot(new StringReader(memento));
                    this.input = this.restoreInput(createReadRoot);
                }
                catch (WorkbenchException e) {
                    throw new PartInitException(e.getStatus());
                }
            }
        }
        return this.input;
    }

    public IWorkbenchPart createPart() throws PartInitException {
        try {
            if (this.descriptor == null) {
                return this.createErrorPart();
            }
            if (this.descriptor.getId().equals("org.eclipse.ui.systemInPlaceEditor")) {
                IEditorPart part = ComponentSupport.getSystemInPlaceEditor();
                if (part == null) {
                    throw new PartInitException(WorkbenchMessages.EditorManager_no_in_place_support);
                }
                return part;
            }
            return this.descriptor.createEditor();
        }
        catch (CoreException e) {
            IStatus status = e.getStatus();
            throw new PartInitException((IStatus)new Status(4, WorkbenchPlugin.PI_WORKBENCH, status.getCode(), status.getMessage(), status.getException()));
        }
    }

    IWorkbenchPart createErrorPart() {
        Status status = new Status(4, WorkbenchPlugin.PI_WORKBENCH, NLS.bind((String)WorkbenchMessages.EditorManager_missing_editor_descriptor, (Object)this.descriptorId));
        IEditorRegistry registry = this.getPage().getWorkbenchWindow().getWorkbench().getEditorRegistry();
        this.descriptor = (EditorDescriptor)registry.findEditor("org.eclipse.ui.internal.emptyEditorTab");
        return this.createErrorPart((IStatus)status);
    }

    public IWorkbenchPart createErrorPart(IStatus status) {
        return new ErrorEditorPart(status);
    }

    public void initialize(IWorkbenchPart part) throws PartInitException {
        IConfigurationElement element = this.descriptor.getConfigurationElement();
        this.editorSite = new EditorSite(this.getModel(), part, this, element);
        if (element == null) {
            this.editorSite.setExtensionId(this.descriptor.getId());
        }
        this.editorSite.setActionBars(EditorReference.createEditorActionBars((WorkbenchPage)this.getPage(), this.descriptor, this.editorSite));
        ((IEditorPart)part).init(this.editorSite, this.getEditorInput());
        if (part instanceof IPersistableEditor) {
            String mementoString;
            if (this.editorState != null) {
                ((IPersistableEditor)((Object)part)).restoreState(this.editorState);
            } else if (EditorReference.useIPersistableEditor() && (mementoString = (String)this.getModel().getPersistedState().get(MEMENTO_KEY)) != null) {
                try {
                    XMLMemento createReadRoot = XMLMemento.createReadRoot(new StringReader(mementoString));
                    IMemento editorStateMemento = createReadRoot.getChild("editorState");
                    if (editorStateMemento != null) {
                        ((IPersistableEditor)((Object)part)).restoreState(editorStateMemento);
                    }
                }
                catch (WorkbenchException e) {
                    throw new PartInitException(e.getStatus());
                }
            }
        }
    }

    public PartSite getSite() {
        return this.editorSite;
    }

    private static EditorActionBars createEditorActionBars(WorkbenchPage page, EditorDescriptor desc, IEditorSite site) {
        EditorActionBuilder builder;
        String type = desc.getId();
        Set<EditorActionBars> candidates = actionCache.get(type);
        if (candidates != null) {
            for (EditorActionBars candidate : candidates) {
                if (candidate.getPage() != page) continue;
                candidate.addRef();
                return candidate;
            }
        }
        EditorActionBars actionBars = new EditorActionBars(page, page.getWorkbenchWindow(), type);
        actionBars.addRef();
        if (candidates == null) {
            candidates = new HashSet<EditorActionBars>(3);
            candidates.add(actionBars);
            actionCache.put(type, candidates);
        } else {
            candidates.add(actionBars);
        }
        IEditorActionBarContributor contr = desc.createActionBarContributor();
        if (contr != null) {
            actionBars.setEditorContributor(contr);
            contr.init(actionBars, page);
        }
        if ((contr = (builder = new EditorActionBuilder()).readActionExtensions(desc)) != null) {
            actionBars.setExtensionContributor(contr);
            contr.init(actionBars, page);
        }
        return actionBars;
    }

    public static void disposeEditorActionBars(EditorActionBars actionBars) {
        actionBars.removeRef();
        if (actionBars.getRef() <= 0) {
            ICoolBarManager2 coolBar;
            String type = actionBars.getEditorType();
            Set<EditorActionBars> set = actionCache.get(type);
            if (set != null) {
                set.remove(actionBars);
            }
            if ((coolBar = (ICoolBarManager2)((WorkbenchWindow)actionBars.getPage().getWorkbenchWindow()).getCoolBarManager2()) != null) {
                coolBar.refresh();
            }
            actionBars.dispose();
        }
    }

    private static boolean useIPersistableEditor() {
        IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
        return store.getBoolean("USE_IPERSISTABLE_EDITORS");
    }
}

