/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.e4.compatibility;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPart2;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.internal.SaveableHelper;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPartReference;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.util.Util;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public abstract class CompatibilityPart {
    public static final String COMPATIBILITY_EDITOR_URI = "platform:/plugin/org.eclipse.ui.workbench/org.eclipse.ui.internal.e4.compatibility.CompatibilityEditor";
    public static final String COMPATIBILITY_VIEW_URI = "platform:/plugin/org.eclipse.ui.workbench/org.eclipse.ui.internal.e4.compatibility.CompatibilityView";
    @Inject
    Composite composite;
    @Inject
    Logger logger;
    IWorkbenchPart wrapped;
    MPart part;
    @Inject
    private IEventBroker eventBroker;
    private boolean beingDisposed = false;
    private boolean alreadyDisposed = false;
    private EventHandler widgetSetHandler = new EventHandler(){

        public void handleEvent(Event event) {
            if (event.getProperty("ChangedElement") == CompatibilityPart.this.part && event.getProperty("NewValue") == null) {
                Assert.isTrue((!CompatibilityPart.this.composite.isDisposed() ? 1 : 0) != 0, (String)"The widget should not have been disposed at this point");
                CompatibilityPart.this.beingDisposed = true;
                WorkbenchPartReference reference = CompatibilityPart.this.getReference();
                ((WorkbenchPage)reference.getPage()).firePartClosed(CompatibilityPart.this);
            }
        }
    };

    CompatibilityPart(MPart part) {
        this.part = part;
    }

    public abstract WorkbenchPartReference getReference();

    protected void createPartControl(IWorkbenchPart legacyPart, Composite parent) {
        try {
            legacyPart.createPartControl(parent);
        }
        catch (RuntimeException e) {
            this.logger.error((Throwable)e);
        }
    }

    @Focus
    void delegateSetFocus() {
        block2: {
            try {
                this.wrapped.setFocus();
            }
            catch (Exception e) {
                if (this.logger == null) break block2;
                String msg = "Error setting focus to : " + this.part.getClass().getName();
                msg = String.valueOf(msg) + ' ' + this.part.getLabel();
                this.logger.error((Throwable)e, msg);
            }
        }
    }

    private void invalidate() {
        WorkbenchPartReference reference = this.getReference();
        reference.invalidate();
        if (this.wrapped != null) {
            try {
                this.wrapped.dispose();
            }
            catch (Exception e) {
                this.logger.error((Throwable)e);
            }
        }
        this.disposeSite();
        this.alreadyDisposed = true;
    }

    private String computeLabel() {
        if (this.wrapped instanceof IWorkbenchPart2) {
            String label = ((IWorkbenchPart2)this.wrapped).getPartName();
            return Util.safeString(label);
        }
        IWorkbenchPartSite site = this.wrapped.getSite();
        if (site != null) {
            return Util.safeString(site.getRegisteredName());
        }
        return Util.safeString(this.wrapped.getTitle());
    }

    public boolean isBeingDisposed() {
        return this.beingDisposed;
    }

    @PostConstruct
    public void create() {
        this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/ui/UIElement", (String)"widget"), this.widgetSetHandler);
        WorkbenchPartReference reference = this.getReference();
        try {
            this.wrapped = reference.createPart();
            reference.initialize(this.wrapped);
        }
        catch (PartInitException e) {
            reference.invalidate();
            if (this.wrapped instanceof IEditorPart) {
                try {
                    this.wrapped.dispose();
                }
                catch (Exception ex) {
                    this.logger.error((Throwable)ex);
                }
            }
            this.disposeSite();
            this.alreadyDisposed = false;
            WorkbenchPlugin.log("Unable to create part", e.getStatus());
            this.wrapped = reference.createErrorPart(e.getStatus());
            try {
                reference.initialize(this.wrapped);
            }
            catch (PartInitException ex) {
                WorkbenchPlugin.log("Unable to initialize error part", ex.getStatus());
                return;
            }
        }
        Composite parent = new Composite(this.composite, 0);
        parent.setLayout((Layout)new FillLayout());
        this.createPartControl(this.wrapped, parent);
        this.part.setLabel(this.computeLabel());
        this.part.setTooltip(this.wrapped.getTitleToolTip());
        this.wrapped.addPropertyListener(new IPropertyListener(){

            public void propertyChanged(Object source, int propId) {
                switch (propId) {
                    case 1: {
                        CompatibilityPart.this.part.setLabel(CompatibilityPart.this.computeLabel());
                        CompatibilityPart.this.part.setTooltip(CompatibilityPart.this.wrapped.getTitleToolTip());
                        break;
                    }
                    case 257: {
                        if (!(CompatibilityPart.this.wrapped instanceof ISaveablePart)) break;
                        CompatibilityPart.this.part.setDirty(((ISaveablePart)((Object)CompatibilityPart.this.wrapped)).isDirty());
                    }
                }
            }
        });
        ((WorkbenchPage)reference.getPage()).firePartOpened(this);
    }

    @PreDestroy
    void destroy() {
        if (!this.alreadyDisposed) {
            this.invalidate();
        }
        this.eventBroker.unsubscribe(this.widgetSetHandler);
    }

    void disposeSite() {
        PartSite site = this.getReference().getSite();
        if (site != null) {
            site.dispose();
        }
    }

    @Persist
    void doSave() {
        if (this.wrapped instanceof ISaveablePart) {
            SaveableHelper.savePart((ISaveablePart)((Object)this.wrapped), this.wrapped, this.getReference().getSite().getWorkbenchWindow(), false);
        }
    }

    public IWorkbenchPart getPart() {
        return this.wrapped;
    }

    public MPart getModel() {
        return this.part;
    }
}

