/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.e4.compatibility;

import javax.inject.Inject;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.internal.workbench.swt.AbstractPartRenderer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MRenderedToolBar;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.model.application.ui.menu.impl.MenuFactoryImpl;
import org.eclipse.e4.ui.workbench.renderers.swt.MenuManagerRenderer;
import org.eclipse.e4.ui.workbench.swt.factories.IRendererFactory;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.ViewReference;
import org.eclipse.ui.internal.WorkbenchPartReference;
import org.eclipse.ui.internal.e4.compatibility.CompatibilityPart;

public class CompatibilityView
extends CompatibilityPart {
    private ViewReference reference;

    @Inject
    CompatibilityView(MPart part, ViewReference ref) {
        super(part);
        this.reference = ref;
    }

    public IViewPart getView() {
        return (IViewPart)this.getPart();
    }

    public WorkbenchPartReference getReference() {
        return this.reference;
    }

    protected void createPartControl(IWorkbenchPart legacyPart, Composite parent) {
        MToolBar toolbar;
        AbstractPartRenderer apr;
        IActionBars actionBars = ((IViewPart)legacyPart).getViewSite().getActionBars();
        ToolBarManager tbm = (ToolBarManager)actionBars.getToolBarManager();
        ToolBar tb = tbm.createControl(parent);
        super.createPartControl(legacyPart, parent);
        tb.dispose();
        IEclipseContext context = this.getModel().getContext();
        IRendererFactory rendererFactory = (IRendererFactory)context.get(IRendererFactory.class);
        MenuManager mm = (MenuManager)actionBars.getMenuManager();
        MMenu menu = null;
        for (MMenu me : this.part.getMenus()) {
            if (!me.getTags().contains("ViewMenu")) continue;
            menu = me;
            break;
        }
        if (menu == null) {
            menu = MenuFactoryImpl.eINSTANCE.createMenu();
            menu.setElementId(this.part.getElementId());
            menu.getTags().add("ViewMenu");
            menu.getTags().add("menuContribution:menu");
            this.part.getMenus().add(menu);
        }
        if ((apr = rendererFactory.getRenderer((MUIElement)menu, (Object)parent)) instanceof MenuManagerRenderer) {
            ((MenuManagerRenderer)apr).linkModelToManager(menu, mm);
        }
        if ((toolbar = this.part.getToolbar()) == null) {
            toolbar = MenuFactoryImpl.eINSTANCE.createRenderedToolBar();
            toolbar.setElementId(this.part.getElementId());
            this.part.setToolbar(toolbar);
        }
        if (toolbar instanceof MRenderedToolBar) {
            ((MRenderedToolBar)toolbar).setContributionManager((Object)tbm);
        }
    }
}

