/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.e4.compatibility;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.descriptor.basic.MPartDescriptor;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MArea;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.advanced.impl.AdvancedFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainer;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainerElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.basic.impl.BasicFactoryImpl;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPlaceholderFolderLayout;
import org.eclipse.ui.IViewLayout;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.e4.compatibility.E4Util;
import org.eclipse.ui.internal.e4.compatibility.ModeledFolderLayout;
import org.eclipse.ui.internal.e4.compatibility.ModeledPlaceholderFolderLayout;
import org.eclipse.ui.internal.e4.compatibility.ModeledViewLayout;
import org.eclipse.ui.internal.registry.ActionSetRegistry;
import org.eclipse.ui.internal.registry.IActionSetDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModeledPageLayout
implements IPageLayout {
    public static final String ACTION_SET_TAG = "persp.actionSet:";
    public static final String NEW_WIZARD_TAG = "persp.newWizSC:";
    public static final String PERSP_SHORTCUT_TAG = "persp.perspSC:";
    public static final String SHOW_IN_PART_TAG = "persp.showIn:";
    public static final String SHOW_VIEW_TAG = "persp.viewSC:";
    private MApplication application;
    private EModelService modelService;
    EPartService partService;
    WorkbenchPage page;
    MPerspective perspModel;
    private IPerspectiveDescriptor descriptor;
    private MPlaceholder eaRef;
    private MPartStack editorStack;
    boolean createReferences;

    public static List<String> getIds(MPerspective model, String tagPrefix) {
        if (model == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String tag : model.getTags()) {
            if (!tag.startsWith(tagPrefix)) continue;
            result.add(tag.substring(tagPrefix.length()));
        }
        return result;
    }

    public ModeledPageLayout(MWindow window, EModelService modelService, EPartService partService, MPerspective perspModel, IPerspectiveDescriptor descriptor, WorkbenchPage page, boolean createReferences) {
        MElementContainer winParent = window.getParent();
        this.application = (MApplication)winParent;
        this.modelService = modelService;
        this.partService = partService;
        this.page = page;
        this.perspModel = perspModel;
        this.descriptor = descriptor;
        this.createReferences = createReferences;
        MArea sharedArea = null;
        List sharedElements = window.getSharedElements();
        for (MUIElement element : sharedElements) {
            if (!element.getElementId().equals(this.getEditorArea())) continue;
            sharedArea = (MArea)element;
            break;
        }
        if (sharedArea == null) {
            sharedArea = AdvancedFactoryImpl.eINSTANCE.createArea();
            this.editorStack = BasicFactoryImpl.eINSTANCE.createPartStack();
            this.editorStack.getTags().add("newtablook");
            this.editorStack.getTags().add("org.eclipse.e4.primaryDataStack");
            this.editorStack.getTags().add("EditorStack");
            this.editorStack.setElementId("org.eclipse.e4.primaryDataStack");
            sharedArea.getChildren().add(this.editorStack);
            sharedArea.setElementId(this.getEditorArea());
            window.getSharedElements().add(sharedArea);
        }
        this.eaRef = AdvancedFactoryImpl.eINSTANCE.createPlaceholder();
        this.eaRef.setElementId(this.getEditorArea());
        this.eaRef.setRef((MUIElement)sharedArea);
        perspModel.getChildren().add(this.eaRef);
        ActionSetRegistry registry = (ActionSetRegistry)this.application.getContext().get(ActionSetRegistry.class);
        IActionSetDescriptor[] iActionSetDescriptorArray = registry.getActionSets();
        int n = iActionSetDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IActionSetDescriptor actionSetDescriptor = iActionSetDescriptorArray[n2];
            if (actionSetDescriptor.isInitiallyVisible()) {
                this.addActionSet(actionSetDescriptor.getId());
            }
            ++n2;
        }
    }

    public MPerspective getModel() {
        return this.perspModel;
    }

    @Override
    public void addActionSet(String actionSetId) {
        this.perspModel.getTags().add(ACTION_SET_TAG + actionSetId);
    }

    @Override
    public void addFastView(String viewId) {
        E4Util.unsupported("addFastView: " + viewId);
    }

    @Override
    public void addFastView(String viewId, float ratio) {
        E4Util.unsupported("addFastView: " + viewId);
    }

    @Override
    public void addNewWizardShortcut(String id) {
        this.perspModel.getTags().add(NEW_WIZARD_TAG + id);
    }

    @Override
    public void addPerspectiveShortcut(String id) {
        this.perspModel.getTags().add(PERSP_SHORTCUT_TAG + id);
    }

    @Override
    public void addPlaceholder(String viewId, int relationship, float ratio, String refId) {
        this.insertView(viewId, relationship, ratio, refId, false, true);
    }

    @Override
    public void addShowInPart(String id) {
        this.perspModel.getTags().add(SHOW_IN_PART_TAG + id);
    }

    @Override
    public void addShowViewShortcut(String id) {
        this.perspModel.getTags().add(SHOW_VIEW_TAG + id);
    }

    @Override
    public void addStandaloneView(String viewId, boolean showTitle, int relationship, float ratio, String refId) {
        this.insertView(viewId, relationship, ratio, refId, true, false);
    }

    @Override
    public void addStandaloneViewPlaceholder(String viewId, int relationship, float ratio, String refId, boolean showTitle) {
        this.insertView(viewId, relationship, ratio, refId, false, false);
    }

    @Override
    public void addView(String viewId, int relationship, float ratio, String refId) {
        this.insertView(viewId, relationship, ratio, refId, true, true);
    }

    public void addView(String viewId, int relationship, float ratio, String refId, boolean minimized) {
        if (minimized) {
            E4Util.unsupported("addView: use of minimized for " + viewId + " ref " + refId);
        }
        this.insertView(viewId, relationship, ratio, refId, true, true);
    }

    @Override
    public IFolderLayout createFolder(String folderId, int relationship, float ratio, String refId) {
        MPartStack stack = this.insertStack(folderId, relationship, ratio, refId, true);
        return new ModeledFolderLayout(this, this.application, stack);
    }

    @Override
    public IPlaceholderFolderLayout createPlaceholderFolder(String folderId, int relationship, float ratio, String refId) {
        MPartStack Stack = this.insertStack(folderId, relationship, ratio, refId, false);
        return new ModeledPlaceholderFolderLayout(this, this.application, Stack);
    }

    @Override
    public IPerspectiveDescriptor getDescriptor() {
        return this.descriptor;
    }

    public static String internalGetEditorArea() {
        return "org.eclipse.ui.editorss";
    }

    @Override
    public String getEditorArea() {
        return ModeledPageLayout.internalGetEditorArea();
    }

    @Override
    public int getEditorReuseThreshold() {
        return -1;
    }

    @Override
    public IPlaceholderFolderLayout getFolderForView(String id) {
        MPart view = this.findPart((MUIElement)this.perspModel, id);
        if (view == null) {
            return null;
        }
        MElementContainer stack = view.getParent();
        if (stack == null || !(stack instanceof MPartStack)) {
            return null;
        }
        return new ModeledPlaceholderFolderLayout(this, this.application, (MPartStack)stack);
    }

    @Override
    public IViewLayout getViewLayout(String id) {
        MPart view = this.findPart((MUIElement)this.perspModel, id);
        if (view != null) {
            return new ModeledViewLayout(view);
        }
        MPlaceholder placeholder = this.findPlaceholder((MUIElement)this.perspModel, id);
        if (placeholder != null) {
            return new ModeledViewLayout(placeholder);
        }
        return null;
    }

    @Override
    public boolean isEditorAreaVisible() {
        return true;
    }

    @Override
    public boolean isFixed() {
        return false;
    }

    @Override
    public void setEditorAreaVisible(boolean showEditorArea) {
        this.eaRef.setToBeRendered(showEditorArea);
    }

    @Override
    public void setEditorReuseThreshold(int openEditors) {
    }

    @Override
    public void setFixed(boolean isFixed) {
    }

    private static int plRelToSwt(int rel) {
        switch (rel) {
            case 4: {
                return 1024;
            }
            case 1: {
                return 16384;
            }
            case 2: {
                return 131072;
            }
            case 3: {
                return 128;
            }
        }
        return 0;
    }

    public static MStackElement createViewModel(MApplication application, String id, boolean visible, WorkbenchPage page, EPartService partService, boolean createReferences) {
        for (MPartDescriptor descriptor : application.getDescriptors()) {
            if (!descriptor.getElementId().equals(id)) continue;
            MPlaceholder ph = partService.createSharedPart(id);
            ph.setToBeRendered(visible);
            MPart part = (MPart)ph.getRef();
            part.setToBeRendered(true);
            if (visible && createReferences) {
                page.createViewReferenceForPart(part, id);
            }
            return ph;
        }
        return null;
    }

    public static MPartStack createStack(String id, boolean visible) {
        MPartStack newStack = BasicFactoryImpl.eINSTANCE.createPartStack();
        newStack.getTags().add("newtablook");
        newStack.setElementId(id);
        newStack.setToBeRendered(visible);
        return newStack;
    }

    private void insertView(String viewId, int relationship, float ratio, String refId, boolean visible, boolean withStack) {
        MUIElement ref;
        MUIElement refModel = this.findElement((MUIElement)this.perspModel, refId);
        if (refModel instanceof MPart) {
            refModel = refModel.getParent();
        } else if (refModel instanceof MPlaceholder && (ref = ((MPlaceholder)refModel).getRef()) instanceof MPart) {
            refModel = refModel.getParent();
        }
        MStackElement viewModel = ModeledPageLayout.createViewModel(this.application, viewId, visible, this.page, this.partService, this.createReferences);
        if (viewModel != null) {
            if (withStack) {
                String stackId = String.valueOf(viewId) + "MStack";
                MPartStack stack = this.insertStack(stackId, relationship, ratio, refId, visible);
                stack.getChildren().add(viewModel);
            } else {
                ModeledPageLayout.insert((MUIElement)viewModel, refModel, ModeledPageLayout.plRelToSwt(relationship), ratio);
            }
        }
    }

    private MUIElement getLastContainer(MUIElement element) {
        if (element instanceof MElementContainer) {
            MElementContainer container = (MElementContainer)element;
            List children = container.getChildren();
            return children.isEmpty() ? container : this.getLastContainer((MUIElement)children.get(children.size() - 1));
        }
        return element.getParent();
    }

    private MElementContainer<?> getLastContainer() {
        List children = this.perspModel.getChildren();
        if (children.isEmpty()) {
            return this.perspModel;
        }
        MUIElement element = this.getLastContainer((MUIElement)children.get(children.size() - 1));
        return element instanceof MElementContainer ? (MElementContainer)element : this.perspModel;
    }

    private MPartStack insertStack(String stackId, int relationship, float ratio, String refId, boolean visible) {
        MUIElement refModel = this.findElement((MUIElement)this.perspModel, refId);
        if (refModel == null) {
            WorkbenchPlugin.log(NLS.bind((String)WorkbenchMessages.PageLayout_missingRefPart, (Object)refId));
            MPartStack stack = ModeledPageLayout.createStack(stackId, visible);
            ModeledPageLayout.insert((MUIElement)stack, this.getLastContainer(), ModeledPageLayout.plRelToSwt(relationship), ratio);
            return stack;
        }
        MPartStack stack = ModeledPageLayout.createStack(stackId, visible);
        MElementContainer parent = refModel.getParent();
        if (parent instanceof MPartStack) {
            refModel = parent;
        }
        ModeledPageLayout.insert((MUIElement)stack, refModel, ModeledPageLayout.plRelToSwt(relationship), ratio);
        return stack;
    }

    public static void replace(MUIElement relTo, MElementContainer<MUIElement> newParent) {
        if (relTo == null || newParent == null) {
            return;
        }
        MElementContainer parent = relTo.getParent();
        if (parent == null) {
            return;
        }
        List kids = parent.getChildren();
        if (kids == null) {
            return;
        }
        kids.add(kids.indexOf(relTo), newParent);
        kids.remove(relTo);
    }

    public static void insertParent(MElementContainer<MUIElement> newParent, MUIElement relTo) {
        if (newParent == null || relTo == null) {
            return;
        }
        MPart curParent = (MPart)relTo.getParent();
        if (curParent != null) {
            ModeledPageLayout.replace(relTo, newParent);
        }
        newParent.getChildren().add(relTo);
    }

    public static void insert(MUIElement toInsert, MUIElement relTo, int swtSide, int ratio) {
        String label;
        if (toInsert == null || relTo == null) {
            return;
        }
        MElementContainer relParent = relTo.getParent();
        if (relParent != null) {
            List children = relParent.getChildren();
            int index = children.indexOf(relTo);
            MPartSashContainer psc = BasicFactoryImpl.eINSTANCE.createPartSashContainer();
            psc.setContainerData(relTo.getContainerData());
            relParent.getChildren().add(index + 1, psc);
            switch (swtSide) {
                case 16384: {
                    psc.getChildren().add((MPartSashContainerElement)toInsert);
                    psc.getChildren().add((MPartSashContainerElement)relTo);
                    toInsert.setContainerData("" + ratio);
                    relTo.setContainerData("" + (10000 - ratio));
                    psc.setHorizontal(true);
                    break;
                }
                case 131072: {
                    psc.getChildren().add((MPartSashContainerElement)relTo);
                    psc.getChildren().add((MPartSashContainerElement)toInsert);
                    relTo.setContainerData("" + ratio);
                    toInsert.setContainerData("" + (10000 - ratio));
                    psc.setHorizontal(true);
                    break;
                }
                case 128: {
                    psc.getChildren().add((MPartSashContainerElement)toInsert);
                    psc.getChildren().add((MPartSashContainerElement)relTo);
                    toInsert.setContainerData("" + ratio);
                    relTo.setContainerData("" + (10000 - ratio));
                    psc.setHorizontal(false);
                    break;
                }
                case 1024: {
                    psc.getChildren().add((MPartSashContainerElement)relTo);
                    psc.getChildren().add((MPartSashContainerElement)toInsert);
                    relTo.setContainerData("" + ratio);
                    toInsert.setContainerData("" + (10000 - ratio));
                    psc.setHorizontal(false);
                }
            }
            return;
        }
        boolean isStack = true;
        MPartSashContainer newSash = null;
        if (!(swtSide != 128 && swtSide != 1024 || isStack)) {
            newSash = BasicFactoryImpl.eINSTANCE.createPartSashContainer();
            label = "Vertical Sash[" + toInsert.getElementId() + "]";
            newSash.setElementId(label);
            newSash.setHorizontal(false);
        } else if (!(swtSide != 16384 && swtSide != 131072 || isStack)) {
            newSash = BasicFactoryImpl.eINSTANCE.createPartSashContainer();
            label = "Horizontal Sash[" + toInsert.getElementId() + "]";
            newSash.setElementId(label);
            newSash.setHorizontal(true);
        }
        if (newSash != null || relParent != null) {
            // empty if block
        }
        MPartSashContainer vscElement = newSash;
        MElementContainer container = (MElementContainer)vscElement;
        ModeledPageLayout.insertParent((MElementContainer<MUIElement>)container, relTo);
        List parts = newSash.getChildren();
        int index = parts.indexOf(relTo);
        if (swtSide == 1024 || swtSide == 131072) {
            ++index;
        }
        parts.add(index, toInsert);
    }

    public static void insert(MUIElement toInsert, MUIElement relTo, int swtSide, float ratio) {
        int pct = (int)(ratio * 10000.0f);
        ModeledPageLayout.insert(toInsert, relTo, swtSide, pct);
    }

    MUIElement findElement(MUIElement toSearch, String id) {
        List found = this.modelService.findElements(toSearch, id, null, null, 4);
        if (found.size() > 0) {
            return (MUIElement)found.get(0);
        }
        MUIElement foundElement = this.modelService.find(id, toSearch);
        return foundElement;
    }

    private MPart findPart(MUIElement toSearch, String id) {
        MUIElement element = this.modelService.find(id, toSearch);
        return element instanceof MPart ? (MPart)element : null;
    }

    private MPlaceholder findPlaceholder(MUIElement toSearch, String id) {
        MUIElement element = this.modelService.find(id, toSearch);
        return element instanceof MPlaceholder ? (MPlaceholder)element : null;
    }

    public void addHiddenMenuItemId(String id) {
        E4Util.unsupported("addHiddenMenuItemId: " + id);
    }

    public void addHiddenToolBarItemId(String id) {
        E4Util.unsupported("addHiddenToolBarItemId: " + id);
    }

    public void removePlaceholder(String id) {
        MUIElement refModel = this.findElement((MUIElement)this.perspModel, id);
        if (!(refModel instanceof MPlaceholder)) {
            E4Util.unsupported("removePlaceholder: failed to find " + id + ": " + refModel);
            return;
        }
        MElementContainer parent = refModel.getParent();
        if (parent != null) {
            parent.getChildren().remove(refModel);
        }
    }

    public void stackView(String id, String refId, boolean visible) {
        MUIElement refModel = this.findElement((MUIElement)this.perspModel, refId);
        if (refModel instanceof MPart || refModel instanceof MPlaceholder) {
            refModel = refModel.getParent();
        }
        if (!(refModel instanceof MPartStack)) {
            E4Util.unsupported("stackView: failed to find " + refId + " for " + id);
            return;
        }
        MStackElement viewModel = ModeledPageLayout.createViewModel(this.application, id, visible, this.page, this.partService, this.createReferences);
        if (viewModel != null) {
            ((MPartStack)refModel).getChildren().add(viewModel);
            if (visible) {
                refModel.setToBeRendered(true);
            }
        }
    }
}

