/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.e4.compatibility;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.e4.compatibility.CompatibilityPart;

public class SelectionService
implements ISelectionChangedListener,
ISelectionService {
    @Inject
    private IEclipseContext context;
    @Inject
    private MApplication application;
    private ESelectionService selectionService;
    @Inject
    @Named(value="org.eclipse.ui.IWorkbenchPage")
    private WorkbenchPage page;
    private IWorkbenchPart activePart;
    private ListenerList listeners = new ListenerList();
    private Map<String, Set<ISelectionListener>> targetedListeners = new HashMap<String, Set<ISelectionListener>>();
    private org.eclipse.e4.ui.workbench.modeling.ISelectionListener listener = new org.eclipse.e4.ui.workbench.modeling.ISelectionListener(){

        public void selectionChanged(MPart part, Object selection) {
            Object client;
            selection = SelectionService.createCompatibilitySelection(selection);
            SelectionService.this.context.set("selection", selection);
            IEclipseContext applicationContext = SelectionService.this.application.getContext();
            if (applicationContext.getActiveChild() == SelectionService.this.context) {
                SelectionService.this.application.getContext().set("selection", selection);
            }
            if ((client = part.getObject()) instanceof CompatibilityPart) {
                IWorkbenchPart workbenchPart = ((CompatibilityPart)client).getPart();
                SelectionService.this.notifyListeners(part.getElementId(), workbenchPart, (ISelection)selection);
            }
        }
    };

    private static ISelection createCompatibilitySelection(Object selection) {
        if (selection instanceof ISelection) {
            return (ISelection)selection;
        }
        return selection == null ? StructuredSelection.EMPTY : new StructuredSelection(selection);
    }

    @Inject
    void setPart(@Optional @Named(value="e4ActivePart") MPart part) {
        Object client;
        ISelectionProvider selectionProvider;
        if (this.activePart != null && (selectionProvider = this.activePart.getSite().getSelectionProvider()) != null) {
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
            if (selectionProvider instanceof IPostSelectionProvider) {
                ((IPostSelectionProvider)selectionProvider).removePostSelectionChangedListener((ISelectionChangedListener)this);
            }
        }
        if (part != null && (client = part.getObject()) instanceof CompatibilityPart) {
            IWorkbenchPart workbenchPart = ((CompatibilityPart)client).getPart();
            ISelectionProvider selectionProvider2 = workbenchPart.getSite().getSelectionProvider();
            if (selectionProvider2 != null) {
                selectionProvider2.addSelectionChangedListener((ISelectionChangedListener)this);
                if (selectionProvider2 instanceof IPostSelectionProvider) {
                    ((IPostSelectionProvider)selectionProvider2).addPostSelectionChangedListener((ISelectionChangedListener)this);
                }
            }
            this.activePart = workbenchPart;
        }
    }

    @Inject
    void setSelectionService(@Optional ESelectionService selectionService) {
        if (this.selectionService != null) {
            this.selectionService.removeSelectionListener(this.listener);
        }
        if (selectionService != null) {
            selectionService.addSelectionListener(this.listener);
            this.selectionService = selectionService;
        }
    }

    private void notifyListeners(String id, IWorkbenchPart workbenchPart, ISelection selection) {
        Set<ISelectionListener> listeners;
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ISelectionListener)listener).selectionChanged(workbenchPart, selection);
            ++n2;
        }
        if (id != null && (listeners = this.targetedListeners.get(id)) != null) {
            for (ISelectionListener listener : listeners) {
                listener.selectionChanged(workbenchPart, selection);
            }
        }
    }

    public void addSelectionListener(ISelectionListener listener) {
        this.listeners.add((Object)listener);
    }

    public void addSelectionListener(String partId, ISelectionListener listener) {
        Set<ISelectionListener> listeners = this.targetedListeners.get(partId);
        if (listeners == null) {
            listeners = new HashSet<ISelectionListener>();
            this.targetedListeners.put(partId, listeners);
        }
        listeners.add(listener);
    }

    public void addPostSelectionListener(ISelectionListener listener) {
        this.addSelectionListener(listener);
    }

    public void addPostSelectionListener(String partId, ISelectionListener listener) {
        this.addSelectionListener(partId, listener);
    }

    public ISelection getSelection() {
        Object selection = this.selectionService.getSelection();
        if (selection == null || selection instanceof ISelection) {
            return (ISelection)selection;
        }
        return new StructuredSelection(selection);
    }

    public ISelection getSelection(String partId) {
        Object selection = this.selectionService.getSelection(partId);
        if (selection == null || selection instanceof ISelection) {
            return (ISelection)selection;
        }
        return new StructuredSelection(selection);
    }

    public void removeSelectionListener(ISelectionListener listener) {
        this.listeners.remove((Object)listener);
    }

    public void removeSelectionListener(String partId, ISelectionListener listener) {
        Set<ISelectionListener> listeners = this.targetedListeners.get(partId);
        if (listeners != null) {
            listeners.remove(listener);
        }
    }

    public void removePostSelectionListener(ISelectionListener listener) {
        this.removeSelectionListener(listener);
    }

    public void removePostSelectionListener(String partId, ISelectionListener listener) {
        this.removeSelectionListener(partId, listener);
    }

    public void selectionChanged(SelectionChangedEvent e) {
        MPart part = this.page.findPart(this.activePart);
        ESelectionService selectionService = (ESelectionService)part.getContext().get(ESelectionService.class.getName());
        selectionService.setSelection((Object)e.getSelection());
    }
}

