/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.menus;

import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.contexts.ContextFunction;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.internal.workbench.ContributionsAnalyzer;
import org.eclipse.e4.ui.internal.workbench.swt.WorkbenchSWTActivator;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.commands.impl.CommandsFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.MCoreExpression;
import org.eclipse.e4.ui.model.application.ui.MExpression;
import org.eclipse.e4.ui.model.application.ui.impl.UiFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.menu.ItemType;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectToolItem;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledToolItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MRenderedMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MRenderedMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarElement;
import org.eclipse.e4.ui.model.application.ui.menu.MToolItem;
import org.eclipse.e4.ui.model.application.ui.menu.impl.MenuFactoryImpl;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate2;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandImageService;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.internal.ActionDescriptor;
import org.eclipse.ui.internal.OpenPreferencesAction;
import org.eclipse.ui.internal.PluginAction;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.handlers.ActionDelegateHandlerProxy;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MenuHelper {
    public static final String MAIN_MENU_ID = "org.eclipse.ui.main.menu";
    private static Field urlField;

    public static void trace(String msg, Throwable error) {
        WorkbenchSWTActivator.trace((String)"/trace/menus", (String)msg, (Throwable)error);
    }

    public static String getActionSetCommandId(IConfigurationElement element) {
        String id = MenuHelper.getDefinitionId(element);
        if (id != null) {
            return id;
        }
        id = MenuHelper.getId(element);
        String actionSetId = null;
        Object obj = element.getParent();
        while (obj instanceof IConfigurationElement && actionSetId == null) {
            IConfigurationElement parent = (IConfigurationElement)obj;
            String parentName = parent.getName();
            if (parentName.equals("actionSet") || parentName.equals("viewContribution") || parentName.equals("editorContribution")) {
                actionSetId = MenuHelper.getId(parent);
            }
            obj = parent.getParent();
        }
        return "AUTOGEN:::" + actionSetId + '/' + id;
    }

    public static String getImageUrl(ImageDescriptor imageDescriptor) {
        if (imageDescriptor == null) {
            return null;
        }
        Class<?> idc = imageDescriptor.getClass();
        if (idc.getName().endsWith("URLImageDescriptor")) {
            URL url = MenuHelper.getUrl(idc, imageDescriptor);
            return url.toExternalForm();
        }
        return null;
    }

    private static URL getUrl(Class idc, ImageDescriptor imageDescriptor) {
        try {
            if (urlField == null) {
                urlField = idc.getDeclaredField("url");
                urlField.setAccessible(true);
            }
            return (URL)urlField.get(imageDescriptor);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    static boolean getVisibleEnabled(IConfigurationElement element) {
        IConfigurationElement[] children = element.getChildren("visibleWhen");
        String checkEnabled = null;
        if (children.length > 0) {
            checkEnabled = children[0].getAttribute("checkEnabled");
        }
        return checkEnabled != null && checkEnabled.equalsIgnoreCase("true");
    }

    static MExpression getVisibleWhen(IConfigurationElement commandAddition) {
        try {
            IConfigurationElement[] visibleChild;
            IConfigurationElement[] visibleConfig = commandAddition.getChildren("visibleWhen");
            if (visibleConfig.length > 0 && visibleConfig.length < 2 && (visibleChild = visibleConfig[0].getChildren()).length > 0) {
                Expression visWhen = ExpressionConverter.getDefault().perform(visibleChild[0]);
                MCoreExpression exp = UiFactoryImpl.eINSTANCE.createCoreExpression();
                exp.setCoreExpressionId("programmatic.value");
                exp.setCoreExpression((Object)visWhen);
                return exp;
            }
        }
        catch (InvalidRegistryObjectException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String getId(IConfigurationElement element) {
        String id = element.getAttribute("id");
        if (id == null || id.length() == 0) {
            id = MenuHelper.getCommandId(element);
        }
        if (id == null || id.length() == 0) {
            id = element.toString();
        }
        return id;
    }

    static String getName(IConfigurationElement element) {
        return element.getAttribute("name");
    }

    static int getMode(IConfigurationElement element) {
        if ("FORCE_TEXT".equals(element.getAttribute("mode"))) {
            return CommandContributionItem.MODE_FORCE_TEXT;
        }
        return 0;
    }

    static String getLabel(IConfigurationElement element) {
        return element.getAttribute("label");
    }

    static String getPath(IConfigurationElement element) {
        return element.getAttribute("path");
    }

    static String getMenuBarPath(IConfigurationElement element) {
        return element.getAttribute("menubarPath");
    }

    static String getToolBarPath(IConfigurationElement element) {
        return element.getAttribute("toolbarPath");
    }

    static String getMnemonic(IConfigurationElement element) {
        return element.getAttribute("mnemonic");
    }

    static String getTooltip(IConfigurationElement element) {
        return element.getAttribute("tooltip");
    }

    static String getIconPath(IConfigurationElement element) {
        return element.getAttribute("icon");
    }

    static String getDisabledIconPath(IConfigurationElement element) {
        return element.getAttribute("disabledIcon");
    }

    static String getHoverIconPath(IConfigurationElement element) {
        return element.getAttribute("hoverIcon");
    }

    static String getIconUrl(IConfigurationElement element, String attr) {
        String extendingPluginId = element.getDeclaringExtension().getContributor().getName();
        String iconPath = element.getAttribute(attr);
        if (iconPath == null) {
            return null;
        }
        if (!iconPath.startsWith("platform:")) {
            iconPath = "platform:/plugin/" + extendingPluginId + "/" + iconPath;
        }
        URL url = null;
        try {
            url = FileLocator.find((URL)new URL(iconPath));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return url == null ? null : url.toString();
    }

    static String getHelpContextId(IConfigurationElement element) {
        return element.getAttribute("helpContextId");
    }

    public static boolean isSeparatorVisible(IConfigurationElement element) {
        String val = element.getAttribute("visible");
        return Boolean.valueOf(val);
    }

    public static String getClassSpec(IConfigurationElement element) {
        return element.getAttribute("class");
    }

    public static String getCommandId(IConfigurationElement element) {
        return element.getAttribute("commandId");
    }

    public static ItemType getStyle(IConfigurationElement element) {
        String style = element.getAttribute("style");
        if (style == null || style.length() == 0) {
            return ItemType.PUSH;
        }
        if ("toggle".equals(style)) {
            return ItemType.CHECK;
        }
        if ("radio".equals(style)) {
            return ItemType.RADIO;
        }
        if ("pulldown".equals(style)) {
            MenuHelper.trace("Failed to get style for pulldown", null);
        }
        return ItemType.PUSH;
    }

    public static boolean getRetarget(IConfigurationElement element) {
        String r = element.getAttribute("retarget");
        return Boolean.valueOf(r);
    }

    public static String getDefinitionId(IConfigurationElement element) {
        return element.getAttribute("definitionId");
    }

    public static Map<String, String> getParameters(IConfigurationElement element) {
        HashMap<String, String> map = new HashMap<String, String>();
        IConfigurationElement[] parameters = element.getChildren("parameter");
        int i = 0;
        while (i < parameters.length) {
            String name = parameters[i].getAttribute("name");
            String value = parameters[i].getAttribute("value");
            if (name != null && value != null) {
                map.put(name, value);
            }
            ++i;
        }
        return map;
    }

    public static MMenu createMenuAddition(IConfigurationElement menuAddition) {
        int idx;
        MMenu element = MenuFactoryImpl.eINSTANCE.createMenu();
        String id = MenuHelper.getId(menuAddition);
        element.setElementId(id);
        String text = MenuHelper.getLabel(menuAddition);
        String mnemonic = MenuHelper.getMnemonic(menuAddition);
        if (text != null && mnemonic != null && (idx = text.indexOf(mnemonic)) != -1) {
            text = String.valueOf(text.substring(0, idx)) + '&' + text.substring(idx);
        }
        element.setIconURI(MenuHelper.getIconUrl(menuAddition, "icon"));
        element.setLabel(Util.safeString(text));
        return element;
    }

    public static MMenuElement createLegacyMenuActionAdditions(MApplication app, final IConfigurationElement element) {
        int idx;
        String id = MenuHelper.getId(element);
        String text = MenuHelper.getLabel(element);
        String mnemonic = MenuHelper.getMnemonic(element);
        if (text != null && mnemonic != null && (idx = text.indexOf(mnemonic)) != -1) {
            text = String.valueOf(text.substring(0, idx)) + '&' + text.substring(idx);
        }
        String iconUri = MenuHelper.getIconUrl(element, "icon");
        String cmdId = MenuHelper.getActionSetCommandId(element);
        MCommand cmd = ContributionsAnalyzer.getCommandById((MApplication)app, (String)cmdId);
        if (cmd == null) {
            ECommandService commandService = (ECommandService)app.getContext().get(ECommandService.class);
            Command command = commandService.getCommand(cmdId);
            if (command == null) {
                ICommandService ics = (ICommandService)app.getContext().get(ICommandService.class);
                command = commandService.defineCommand(cmdId, text, null, ics.getCategory(null), null);
            }
            cmd = CommandsFactoryImpl.eINSTANCE.createCommand();
            cmd.setCommandName(text);
            cmd.setElementId(cmdId);
            app.getCommands().add(cmd);
        }
        String style = element.getAttribute("style");
        String pulldown = element.getAttribute("pulldown");
        if ("pulldown".equals(style) || pulldown != null && pulldown.equals("true")) {
            MRenderedMenuItem item = MenuFactoryImpl.eINSTANCE.createRenderedMenuItem();
            item.setLabel(text);
            if (iconUri != null) {
                item.setIconURI(iconUri);
            }
            ContextFunction generator = new ContextFunction(){

                public Object compute(IEclipseContext context) {
                    IWorkbenchWindow window = (IWorkbenchWindow)context.get(IWorkbenchWindow.class);
                    if (window == null) {
                        return null;
                    }
                    ActionDescriptor desc = new ActionDescriptor(element, 5, window);
                    final PluginAction action = desc.getAction();
                    return new ActionContributionItem((IAction)action){

                        public void dispose() {
                            super.dispose();
                            action.disposeDelegate();
                        }
                    };
                }
            };
            item.setContributionItem((Object)generator);
            return item;
        }
        ItemType type = ItemType.PUSH;
        if ("toggle".equals(style)) {
            type = ItemType.CHECK;
        } else if ("radio".equals(style)) {
            type = ItemType.RADIO;
        }
        MHandledMenuItem item = MenuFactoryImpl.eINSTANCE.createHandledMenuItem();
        item.setElementId(id);
        item.setLabel(text);
        item.setType(type);
        item.setCommand(cmd);
        if (iconUri != null) {
            item.setIconURI(iconUri);
        }
        return item;
    }

    public static String getDescription(IConfigurationElement configElement) {
        return configElement.getAttribute("description");
    }

    public static MToolBarElement createLegacyToolBarActionAdditions(MApplication app, final IConfigurationElement element) {
        int idx;
        String cmdId = MenuHelper.getActionSetCommandId(element);
        final String id = MenuHelper.getId(element);
        String text = MenuHelper.getLabel(element);
        String mnemonic = MenuHelper.getMnemonic(element);
        if (text != null && mnemonic != null && (idx = text.indexOf(mnemonic)) != -1) {
            text = String.valueOf(text.substring(0, idx)) + '&' + text.substring(idx);
        }
        String iconUri = MenuHelper.getIconUrl(element, "icon");
        MCommand cmd = ContributionsAnalyzer.getCommandById((MApplication)app, (String)cmdId);
        if (cmd == null) {
            ECommandService commandService = (ECommandService)app.getContext().get(ECommandService.class);
            Command command = commandService.getCommand(cmdId);
            if (command == null) {
                ICommandService ics = (ICommandService)app.getContext().get(ICommandService.class);
                command = commandService.defineCommand(cmdId, text, null, ics.getCategory(null), null);
            }
            cmd = CommandsFactoryImpl.eINSTANCE.createCommand();
            cmd.setCommandName(text);
            cmd.setElementId(cmdId);
            app.getCommands().add(cmd);
        }
        MHandledToolItem item = MenuFactoryImpl.eINSTANCE.createHandledToolItem();
        String style = element.getAttribute("style");
        if (style == null || style.length() == 0) {
            item.setType(ItemType.PUSH);
        } else if ("toggle".equals(style)) {
            item.setType(ItemType.CHECK);
        } else if ("radio".equals(style)) {
            item.setType(ItemType.RADIO);
        } else if ("pulldown".equals(style)) {
            MRenderedMenu menu = MenuFactoryImpl.eINSTANCE.createRenderedMenu();
            ECommandService cs = (ECommandService)app.getContext().get(ECommandService.class);
            final ParameterizedCommand parmCmd = cs.createCommand(cmdId, null);
            ContextFunction generator = new ContextFunction(){

                public Object compute(IEclipseContext context) {
                    return new IMenuCreator(){
                        private ActionDelegateHandlerProxy handlerProxy;

                        private ActionDelegateHandlerProxy getProxy() {
                            if (this.handlerProxy == null) {
                                this.handlerProxy = new ActionDelegateHandlerProxy(element, "class", id, parmCmd, PlatformUI.getWorkbench().getActiveWorkbenchWindow(), null, null, null);
                            }
                            return this.handlerProxy;
                        }

                        private IWorkbenchWindowPulldownDelegate getDelegate() {
                            this.getProxy();
                            if (this.handlerProxy == null) {
                                return null;
                            }
                            if (this.handlerProxy.getDelegate() == null) {
                                this.handlerProxy.loadDelegate();
                                ISelectionService service = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService();
                                IActionDelegate delegate = this.handlerProxy.getDelegate();
                                delegate.selectionChanged((IAction)this.handlerProxy.getAction(), service.getSelection());
                            }
                            return (IWorkbenchWindowPulldownDelegate)this.handlerProxy.getDelegate();
                        }

                        public Menu getMenu(Menu parent) {
                            IWorkbenchWindowPulldownDelegate2 delegate = (IWorkbenchWindowPulldownDelegate2)this.getDelegate();
                            if (delegate == null) {
                                return null;
                            }
                            return delegate.getMenu(parent);
                        }

                        public Menu getMenu(Control parent) {
                            return this.getDelegate() == null ? null : this.getDelegate().getMenu(parent);
                        }

                        public void dispose() {
                            if (this.handlerProxy != null) {
                                this.handlerProxy.dispose();
                                this.handlerProxy = null;
                            }
                        }
                    };
                }
            };
            menu.setContributionManager((Object)generator);
            item.setMenu((MMenu)menu);
        } else {
            item.setType(ItemType.PUSH);
        }
        item.setElementId(id);
        item.setCommand(cmd);
        if (iconUri == null) {
            item.setLabel(text);
        } else {
            item.setIconURI(iconUri);
        }
        item.setTooltip(MenuHelper.getTooltip(element));
        return item;
    }

    public static MMenu createMenu(MenuManager manager) {
        MMenu subMenu = MenuFactoryImpl.eINSTANCE.createMenu();
        subMenu.setLabel(manager.getMenuText());
        subMenu.setElementId(manager.getId());
        return subMenu;
    }

    public static MMenuItem createItem(MApplication application, CommandContributionItem cci) {
        if (cci.getCommand() == null) {
            return null;
        }
        String id = cci.getCommand().getId();
        for (MCommand command : application.getCommands()) {
            if (!id.equals(command.getElementId())) continue;
            CommandContributionItemParameter data = cci.getData();
            MHandledMenuItem menuItem = MenuFactoryImpl.eINSTANCE.createHandledMenuItem();
            menuItem.setCommand(command);
            if (data.label != null) {
                menuItem.setLabel(data.label);
            } else {
                menuItem.setLabel(command.getCommandName());
            }
            if (data.mnemonic != null) {
                menuItem.setMnemonics(data.mnemonic);
            }
            if (data.icon != null) {
                menuItem.setIconURI(MenuHelper.getIconURI(data.icon));
            } else {
                menuItem.setIconURI(MenuHelper.getIconURI(id, application.getContext()));
            }
            String itemId = cci.getId();
            menuItem.setElementId(itemId == null ? id : itemId);
            return menuItem;
        }
        return null;
    }

    public static MToolItem createToolItem(MApplication application, CommandContributionItem cci) {
        String id = cci.getCommand().getId();
        for (MCommand command : application.getCommands()) {
            if (!id.equals(command.getElementId())) continue;
            CommandContributionItemParameter data = cci.getData();
            MHandledToolItem toolItem = MenuFactoryImpl.eINSTANCE.createHandledToolItem();
            toolItem.setCommand(command);
            String iconURI = null;
            if (data.icon != null) {
                iconURI = MenuHelper.getIconURI(data.icon);
            }
            if (iconURI == null) {
                iconURI = MenuHelper.getIconURI(id, application.getContext());
            }
            if (iconURI == null) {
                toolItem.setLabel(command.getCommandName());
            } else {
                toolItem.setIconURI(iconURI);
            }
            if (data.tooltip != null) {
                toolItem.setTooltip(data.tooltip);
            } else if (data.label != null) {
                toolItem.setTooltip(data.label);
            } else {
                toolItem.setTooltip(command.getDescription());
            }
            return toolItem;
        }
        return null;
    }

    public static MToolItem createToolItem(MApplication application, ActionContributionItem item) {
        IAction action = item.getAction();
        String id = action.getActionDefinitionId();
        if (id != null) {
            for (MCommand command : application.getCommands()) {
                if (!id.equals(command.getElementId())) continue;
                MHandledToolItem toolItem = MenuFactoryImpl.eINSTANCE.createHandledToolItem();
                toolItem.setCommand(command);
                String iconURI = MenuHelper.getIconURI(action.getImageDescriptor());
                if (iconURI == null) {
                    iconURI = MenuHelper.getIconURI(id, application.getContext());
                    if (iconURI == null) {
                        toolItem.setLabel(command.getCommandName());
                    } else {
                        toolItem.setIconURI(iconURI);
                    }
                } else {
                    toolItem.setIconURI(iconURI);
                }
                if (action.getToolTipText() != null) {
                    toolItem.setTooltip(action.getToolTipText());
                }
                switch (action.getStyle()) {
                    case 2: {
                        toolItem.setType(ItemType.CHECK);
                        toolItem.setSelected(action.isChecked());
                        break;
                    }
                    case 8: {
                        toolItem.setType(ItemType.RADIO);
                        toolItem.setSelected(action.isChecked());
                        break;
                    }
                    default: {
                        toolItem.setType(ItemType.PUSH);
                    }
                }
                String itemId = item.getId();
                toolItem.setElementId(itemId == null ? id : itemId);
                return toolItem;
            }
        } else {
            MDirectToolItem toolItem = MenuFactoryImpl.eINSTANCE.createDirectToolItem();
            String itemId = item.getId();
            toolItem.setElementId(itemId == null ? id : itemId);
            String iconURI = MenuHelper.getIconURI(action.getImageDescriptor());
            if (iconURI == null) {
                iconURI = MenuHelper.getIconURI(id, application.getContext());
                if (iconURI == null) {
                    if (action.getText() != null) {
                        toolItem.setLabel(action.getText());
                    }
                } else {
                    toolItem.setIconURI(iconURI);
                }
            } else {
                toolItem.setIconURI(iconURI);
            }
            switch (action.getStyle()) {
                case 2: {
                    toolItem.setType(ItemType.CHECK);
                    toolItem.setSelected(action.isChecked());
                    break;
                }
                case 8: {
                    toolItem.setType(ItemType.RADIO);
                    toolItem.setSelected(action.isChecked());
                    break;
                }
                default: {
                    toolItem.setType(ItemType.PUSH);
                }
            }
            toolItem.setContributionURI("platform:/plugin/org.eclipse.ui.workbench/programmic.contribution");
            toolItem.setObject((Object)new DirectProxy(action));
            return toolItem;
        }
        return null;
    }

    public static MMenuItem createItem(MApplication application, ActionContributionItem item) {
        IAction action = item.getAction();
        String id = action.getActionDefinitionId();
        if (action instanceof OpenPreferencesAction) {
            for (MCommand command : application.getCommands()) {
                if (!"org.eclipse.ui.window.preferences".equals(command.getElementId())) continue;
                MHandledMenuItem menuItem = MenuFactoryImpl.eINSTANCE.createHandledMenuItem();
                menuItem.setCommand(command);
                menuItem.setLabel(command.getCommandName());
                menuItem.setIconURI(MenuHelper.getIconURI(action.getImageDescriptor()));
                switch (action.getStyle()) {
                    case 2: {
                        menuItem.setType(ItemType.CHECK);
                        menuItem.setSelected(action.isChecked());
                        break;
                    }
                    case 8: {
                        menuItem.setType(ItemType.RADIO);
                        menuItem.setSelected(action.isChecked());
                        break;
                    }
                    default: {
                        menuItem.setType(ItemType.PUSH);
                    }
                }
                String itemId = item.getId();
                menuItem.setElementId(itemId == null ? id : itemId);
                return menuItem;
            }
        } else if (id != null) {
            if (id.equals("org.eclipse.ui.window.savePerspective") || id.equals("org.eclipse.ui.window.customizePerspective")) {
                return null;
            }
            for (MCommand command : application.getCommands()) {
                if (!id.equals(command.getElementId())) continue;
                MHandledMenuItem menuItem = MenuFactoryImpl.eINSTANCE.createHandledMenuItem();
                menuItem.setCommand(command);
                if (action.getText() != null) {
                    menuItem.setLabel(action.getText());
                } else {
                    menuItem.setLabel(command.getCommandName());
                }
                menuItem.setIconURI(MenuHelper.getIconURI(action.getImageDescriptor()));
                switch (action.getStyle()) {
                    case 2: {
                        menuItem.setType(ItemType.CHECK);
                        menuItem.setSelected(action.isChecked());
                        break;
                    }
                    case 8: {
                        menuItem.setType(ItemType.RADIO);
                        menuItem.setSelected(action.isChecked());
                        break;
                    }
                    default: {
                        menuItem.setType(ItemType.PUSH);
                    }
                }
                String itemId = item.getId();
                menuItem.setElementId(itemId == null ? id : itemId);
                return menuItem;
            }
        } else {
            String itemId;
            MDirectMenuItem menuItem = MenuFactoryImpl.eINSTANCE.createDirectMenuItem();
            if (action.getText() != null) {
                menuItem.setLabel(action.getText());
            }
            menuItem.setElementId((itemId = item.getId()) == null ? id : itemId);
            menuItem.setIconURI(MenuHelper.getIconURI(action.getImageDescriptor()));
            switch (action.getStyle()) {
                case 2: {
                    menuItem.setType(ItemType.CHECK);
                    menuItem.setSelected(action.isChecked());
                    break;
                }
                case 8: {
                    menuItem.setType(ItemType.RADIO);
                    menuItem.setSelected(action.isChecked());
                    break;
                }
                default: {
                    menuItem.setType(ItemType.PUSH);
                }
            }
            menuItem.setContributionURI("platform:/plugin/org.eclipse.ui.workbench/programmic.contribution");
            menuItem.setObject((Object)new DirectProxy(action));
            return menuItem;
        }
        return null;
    }

    private static String getIconURI(ImageDescriptor descriptor) {
        if (descriptor == null) {
            return null;
        }
        String string = descriptor.toString();
        if (string.startsWith("URLImageDescriptor(")) {
            string = string.substring("URLImageDescriptor(".length());
            string = string.substring(0, string.length() - 1);
            BundleContext ctxt = FrameworkUtil.getBundle(WorkbenchWindow.class).getBundleContext();
            try {
                URI uri = new URI(string);
                String host = uri.getHost();
                String bundleId = host.substring(0, host.indexOf(46));
                Bundle bundle = ctxt.getBundle(Long.parseLong(bundleId));
                StringBuilder builder = new StringBuilder("platform:/plugin/");
                builder.append(bundle.getSymbolicName());
                builder.append(uri.getPath());
                return builder.toString();
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
        return null;
    }

    private static String getIconURI(String commandId, IEclipseContext workbench) {
        ICommandImageService imageService = (ICommandImageService)workbench.get(ICommandImageService.class);
        ImageDescriptor descriptor = imageService.getImageDescriptor(commandId);
        return MenuHelper.getIconURI(descriptor);
    }

    static class DirectProxy {
        private IAction action;

        public DirectProxy(IAction action) {
            this.action = action;
        }

        @CanExecute
        public boolean canExecute(IEclipseContext context) {
            return this.action.isEnabled();
        }

        @Execute
        public void execute(IEclipseContext context) {
            this.action.run();
        }
    }
}

